/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util.json;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.json.JsonProvider;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.json.BsonJsonProvider;
import org.apache.phoenix.util.json.JsonDataFormat;
import org.bson.BsonBinaryReader;
import org.bson.BsonDocument;
import org.bson.BsonDocumentReader;
import org.bson.BsonReader;
import org.bson.BsonValue;
import org.bson.RawBsonDocument;
import org.bson.codecs.BsonDocumentCodec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.RawBsonDocumentCodec;
import org.bson.io.BsonInput;
import org.bson.io.ByteBufferBsonInput;

public class BsonDataFormat
implements JsonDataFormat {
    @Override
    public byte[] toBytes(Object object) {
        return ByteUtil.toBytes(((RawBsonDocument)object).getByteBuffer().asNIO());
    }

    @Override
    public Object toObject(String value) {
        return RawBsonDocument.parse((String)value);
    }

    @Override
    public Object toObject(byte[] bytes, int offset, int length) {
        return new RawBsonDocument(bytes, offset, length);
    }

    @Override
    public int estimateByteSize(Object o) {
        RawBsonDocument rawBSON = (RawBsonDocument)o;
        return rawBSON.size();
    }

    @Override
    public int getValueType(Object obj, String jsonPathExprStr) {
        BsonValue value = this.getBsonValue(jsonPathExprStr, (RawBsonDocument)obj);
        return this.getSqlType(value);
    }

    @Override
    public Object getValue(Object obj, String jsonPathExprStr) {
        BsonValue value = this.getBsonValue(jsonPathExprStr, (RawBsonDocument)obj);
        return this.getValue(value);
    }

    private Object getValue(BsonValue value) {
        if (value != null) {
            switch (value.getBsonType()) {
                case INT32: {
                    return value.asInt32().getValue();
                }
                case INT64: {
                    return value.asInt64().getValue();
                }
                case STRING: 
                case SYMBOL: {
                    return value.asString().getValue();
                }
                case DECIMAL128: {
                    return value.asDecimal128().doubleValue();
                }
                case DOUBLE: {
                    return value.asDouble().getValue();
                }
                case BOOLEAN: {
                    return value.asBoolean().getValue();
                }
                case BINARY: {
                    return value.asBinary().getData();
                }
                case DATE_TIME: {
                    return value.asDateTime().getValue();
                }
                case DOCUMENT: {
                    return value.asDocument().toJson();
                }
                case ARRAY: {
                    return this.readArray(value).toString();
                }
            }
            return null;
        }
        return null;
    }

    @Override
    public ByteBuffer updateValue(Object top, String jsonPathExprStr, String newVal) {
        Configuration conf = Configuration.builder().jsonProvider((JsonProvider)new BsonJsonProvider()).build();
        BsonValue newValue = (BsonValue)JsonPath.using((Configuration)conf).parse(newVal).json();
        BsonDocument root = this.fromRaw((RawBsonDocument)top);
        JsonPath.using((Configuration)conf).parse((Object)root).set(jsonPathExprStr, (Object)newValue, new Predicate[0]);
        RawBsonDocument updated = new RawBsonDocumentCodec().decode((BsonReader)new BsonDocumentReader(root), DecoderContext.builder().build());
        return updated.getByteBuffer().asNIO();
    }

    @Override
    public boolean isPathValid(Object top, String path) {
        try {
            Configuration conf = Configuration.builder().jsonProvider((JsonProvider)new BsonJsonProvider()).build();
            BsonDocument root = this.fromRaw((RawBsonDocument)top);
            JsonPath.using((Configuration)conf).parse((Object)root).read(path, new Predicate[0]);
            return true;
        }
        catch (PathNotFoundException e) {
            return false;
        }
    }

    private BsonValue getBsonValue(String jsonPathExprStr, RawBsonDocument top) {
        Configuration conf = this.getConfiguration();
        BsonValue value = (BsonValue)JsonPath.using((Configuration)conf).parse((Object)top).read(jsonPathExprStr, BsonValue.class, new Predicate[0]);
        return value;
    }

    private List<Object> readArray(BsonValue value) {
        return value.asArray().stream().map(e -> {
            if (e.isString() || e.isSymbol()) {
                return "\"" + this.getValue((BsonValue)e) + "\"";
            }
            return String.valueOf(this.getValue((BsonValue)e));
        }).collect(Collectors.toList());
    }

    private Configuration getConfiguration() {
        Configuration conf = Configuration.builder().jsonProvider((JsonProvider)new BsonJsonProvider()).build();
        conf = conf.addOptions(new Option[]{Option.SUPPRESS_EXCEPTIONS});
        return conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BsonDocument fromRaw(RawBsonDocument rawDocument) {
        try (BsonBinaryReader bsonReader = new BsonBinaryReader((BsonInput)new ByteBufferBsonInput(rawDocument.getByteBuffer()));){
            BsonDocument bsonDocument = new BsonDocumentCodec().decode((BsonReader)bsonReader, DecoderContext.builder().build());
            return bsonDocument;
        }
    }

    private int getSqlType(BsonValue value) {
        if (value == null) {
            return 0;
        }
        switch (value.getBsonType()) {
            case INT32: {
                return 4;
            }
            case INT64: {
                return -5;
            }
            case DECIMAL128: 
            case DOUBLE: {
                return 8;
            }
            case STRING: 
            case SYMBOL: {
                return 12;
            }
            case BOOLEAN: {
                return 16;
            }
            case BINARY: {
                return -2;
            }
            case DATE_TIME: {
                return 91;
            }
            case ARRAY: {
                return 2003;
            }
            case DOCUMENT: {
                return -9;
            }
        }
        return 1111;
    }
}

