/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import com.google.protobuf.BlockingRpcChannel;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.phoenix.compat.hbase.ByteStringer;
import org.apache.phoenix.coprocessor.generated.RegionServerEndpointProtos;
import org.apache.phoenix.exception.StaleMetadataCacheException;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.schema.ConnectionProperty;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.schema.PTableRef;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.TableNotFoundException;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.util.ClientUtil;
import org.apache.phoenix.util.MetaDataUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidateLastDDLTimestampUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ValidateLastDDLTimestampUtil.class);
    private static final List<PTableType> ALLOWED_PTABLE_TYPES = Arrays.asList(PTableType.TABLE, PTableType.VIEW, PTableType.INDEX, PTableType.SYSTEM);

    private ValidateLastDDLTimestampUtil() {
    }

    public static String getInfoString(PName tenantId, List<TableRef> tableRefs) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("Tenant: %s, ", tenantId));
        for (TableRef tableRef : tableRefs) {
            sb.append(String.format("{Schema: %s, Table: %s},", tableRef.getTable().getSchemaName(), tableRef.getTable().getTableName()));
        }
        return sb.toString();
    }

    public static boolean getValidateLastDdlTimestampEnabled(PhoenixConnection connection) {
        return connection.getQueryServices().getProps().getBoolean("phoenix.ddl.timestamp.validation.enabled", false);
    }

    public static boolean getValidateLastDdlTimestampEnabled(Configuration config) {
        return config.getBoolean("phoenix.ddl.timestamp.validation.enabled", false);
    }

    public static void validateLastDDLTimestamp(PhoenixConnection conn, List<TableRef> allTableRefs, boolean doRetry) throws SQLException {
        List<TableRef> tableRefs = ValidateLastDDLTimestampUtil.filterTableRefs(conn, allTableRefs);
        if (tableRefs.isEmpty()) {
            return;
        }
        String infoString = ValidateLastDDLTimestampUtil.getInfoString(conn.getTenantId(), tableRefs);
        try (Admin admin = conn.getQueryServices().getAdmin();){
            List<ServerName> regionServers = conn.getQueryServices().getLiveRegionServers();
            ServerName regionServer = regionServers.get(ThreadLocalRandom.current().nextInt(regionServers.size()));
            RegionServerEndpointProtos.RegionServerEndpointService.BlockingInterface service = RegionServerEndpointProtos.RegionServerEndpointService.newBlockingStub((BlockingRpcChannel)admin.coprocessorService(regionServer));
            RegionServerEndpointProtos.ValidateLastDDLTimestampRequest request = ValidateLastDDLTimestampUtil.getValidateDDLTimestampRequest(tableRefs);
            service.validateLastDDLTimestamp(null, request);
        }
        catch (Exception e) {
            if (e instanceof StaleMetadataCacheException) {
                throw (StaleMetadataCacheException)e;
            }
            SQLException parsedException = ClientUtil.parseServerException(e);
            if (parsedException instanceof StaleMetadataCacheException) {
                throw parsedException;
            }
            LOGGER.error("Error in validating DDL timestamp for {}", (Object)infoString, (Object)parsedException);
            if (doRetry) {
                conn.getQueryServices().refreshLiveRegionServers();
                ValidateLastDDLTimestampUtil.validateLastDDLTimestamp(conn, tableRefs, false);
                return;
            }
            throw parsedException;
        }
    }

    private static RegionServerEndpointProtos.ValidateLastDDLTimestampRequest getValidateDDLTimestampRequest(List<TableRef> tableRefs) throws StaleMetadataCacheException {
        RegionServerEndpointProtos.ValidateLastDDLTimestampRequest.Builder requestBuilder = RegionServerEndpointProtos.ValidateLastDDLTimestampRequest.newBuilder();
        for (TableRef tableRef : tableRefs) {
            RegionServerEndpointProtos.LastDDLTimestampRequest.Builder innerBuilder;
            for (Map.Entry<PTableKey, Long> entry : tableRef.getTable().getAncestorLastDDLTimestampMap().entrySet()) {
                innerBuilder = RegionServerEndpointProtos.LastDDLTimestampRequest.newBuilder();
                PTableKey ancestorKey = entry.getKey();
                if (entry.getValue() == null) {
                    throw new StaleMetadataCacheException("LAST_DDL_TIMESTAMP set to null in client cache for {}" + ancestorKey);
                }
                ValidateLastDDLTimestampUtil.setLastDDLTimestampRequestParameters(innerBuilder, ancestorKey, entry.getValue());
                requestBuilder.addLastDDLTimestampRequests(innerBuilder);
            }
            PTable ptable = tableRef.getTable();
            if (ptable.getLastDDLTimestamp() == null) {
                throw new StaleMetadataCacheException("LAST_DDL_TIMESTAMP set to null in client cache for {}" + ptable.getKey());
            }
            innerBuilder = RegionServerEndpointProtos.LastDDLTimestampRequest.newBuilder();
            ValidateLastDDLTimestampUtil.setLastDDLTimestampRequestParameters(innerBuilder, ptable.getKey(), ptable.getLastDDLTimestamp());
            requestBuilder.addLastDDLTimestampRequests(innerBuilder);
            for (PTable idxPTable : tableRef.getTable().getIndexes()) {
                if (idxPTable.getLastDDLTimestamp() == null) {
                    throw new StaleMetadataCacheException("LAST_DDL_TIMESTAMP set to null in client cache for {}" + idxPTable.getKey());
                }
                innerBuilder = RegionServerEndpointProtos.LastDDLTimestampRequest.newBuilder();
                ValidateLastDDLTimestampUtil.setLastDDLTimestampRequestParameters(innerBuilder, idxPTable.getKey(), idxPTable.getLastDDLTimestamp());
                requestBuilder.addLastDDLTimestampRequests(innerBuilder);
            }
        }
        return requestBuilder.build();
    }

    private static void setLastDDLTimestampRequestParameters(RegionServerEndpointProtos.LastDDLTimestampRequest.Builder builder, PTableKey key, long lastDDLTimestamp) {
        String tableName = key.getTableName();
        String schemaName = key.getSchemaName();
        if (tableName.contains("#")) {
            int lastIndexOf = tableName.lastIndexOf("#");
            String indexFullName = tableName.substring(lastIndexOf + 1);
            tableName = SchemaUtil.getTableNameFromFullName(indexFullName);
            schemaName = SchemaUtil.getSchemaNameFromFullName(indexFullName);
        }
        byte[] tenantIDBytes = key.getTenantId() == null ? HConstants.EMPTY_BYTE_ARRAY : key.getTenantId().getBytes();
        byte[] schemaBytes = schemaName == null || schemaName.isEmpty() ? HConstants.EMPTY_BYTE_ARRAY : key.getSchemaName().getBytes();
        builder.setTenantId(ByteStringer.wrap((byte[])tenantIDBytes));
        builder.setSchemaName(ByteStringer.wrap((byte[])schemaBytes));
        builder.setTableName(ByteStringer.wrap((byte[])tableName.getBytes()));
        builder.setLastDDLTimestamp(lastDDLTimestamp);
    }

    private static List<TableRef> filterTableRefs(PhoenixConnection conn, List<TableRef> tableRefs) {
        List<TableRef> filteredTableRefs = tableRefs.stream().filter(tableRef -> ALLOWED_PTABLE_TYPES.contains((Object)tableRef.getTable().getType()) && !ValidateLastDDLTimestampUtil.avoidRpc(conn, tableRef.getTable())).collect(Collectors.toList());
        return filteredTableRefs;
    }

    private static boolean avoidRpc(PhoenixConnection conn, PTable table) {
        try {
            PTableRef ptr = conn.getTableRef(table.getKey());
            long tableUCF = table.getUpdateCacheFrequency();
            return tableUCF > (Long)ConnectionProperty.UPDATE_CACHE_FREQUENCY.getValue("ALWAYS") && tableUCF < (Long)ConnectionProperty.UPDATE_CACHE_FREQUENCY.getValue("NEVER") && MetaDataUtil.avoidMetadataRPC(conn, table, ptr, tableUCF);
        }
        catch (TableNotFoundException e) {
            return false;
        }
    }
}

