/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.apache.phoenix.coprocessorclient.HashJoinCacheNotFoundException;
import org.apache.phoenix.exception.PhoenixIOException;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.schema.StaleRegionBoundaryCacheException;

public class ClientUtil {
    private static final String FORMAT = "ERROR %d (%s): %s";
    private static final Pattern PATTERN = Pattern.compile("ERROR (\\d+) \\((\\w+)\\): (.*)");
    private static final Pattern HASH_JOIN_EXCEPTION_PATTERN = Pattern.compile("joinId: (-?\\d+)");
    private static final Pattern PATTERN_FOR_TS = Pattern.compile(",serverTimestamp=(\\d+),");
    private static final Map<Class<? extends Exception>, SQLExceptionCode> errorcodeMap = new HashMap<Class<? extends Exception>, SQLExceptionCode>();

    private static String constructSQLErrorMessage(SQLExceptionCode code, Throwable e, String message) {
        return ClientUtil.constructSQLErrorMessage(code.getErrorCode(), code.getSQLState(), code.getMessage() + " " + e.getMessage() + " " + message);
    }

    private static String constructSQLErrorMessage(SQLException e, String message) {
        return ClientUtil.constructSQLErrorMessage(e.getErrorCode(), e.getSQLState(), e.getMessage() + " " + message);
    }

    private static String constructSQLErrorMessage(int errorCode, String SQLState, String message) {
        return String.format(FORMAT, errorCode, SQLState, message);
    }

    public static SQLException parseServerException(Throwable t) {
        SQLException e = ClientUtil.parseServerExceptionOrNull(t);
        if (e != null) {
            return e;
        }
        return new PhoenixIOException(t);
    }

    public static SQLException parseServerExceptionOrNull(Throwable t) {
        while (t.getCause() != null) {
            if (t instanceof NotServingRegionException) {
                return ClientUtil.parseRemoteException(new StaleRegionBoundaryCacheException());
            }
            t = t.getCause();
        }
        return ClientUtil.parseRemoteException(t);
    }

    public static SQLException parseLocalOrRemoteServerException(Throwable t) {
        while (t.getCause() != null) {
            if (t instanceof NotServingRegionException) {
                return ClientUtil.parseRemoteException(new StaleRegionBoundaryCacheException());
            }
            if (t instanceof SQLException) {
                return (SQLException)t;
            }
            t = t.getCause();
        }
        return ClientUtil.parseRemoteException(t);
    }

    public static SQLException parseRemoteException(Throwable t) {
        Matcher matcher;
        String message = t.getLocalizedMessage();
        if (message != null && (matcher = PATTERN.matcher(t.getLocalizedMessage())).find()) {
            Matcher m;
            int statusCode = Integer.parseInt(matcher.group(1));
            SQLExceptionCode code = SQLExceptionCode.fromErrorCode(statusCode);
            if (code.equals((Object)SQLExceptionCode.HASH_JOIN_CACHE_NOT_FOUND) && (m = HASH_JOIN_EXCEPTION_PATTERN.matcher(t.getLocalizedMessage())).find()) {
                return new HashJoinCacheNotFoundException(Long.parseLong(m.group(1)));
            }
            return new SQLExceptionInfo.Builder(code).setMessage(matcher.group()).setRootCause(t).build().buildException();
        }
        return null;
    }

    public static long parseServerTimestamp(Throwable t) {
        while (t.getCause() != null) {
            t = t.getCause();
        }
        return ClientUtil.parseTimestampFromRemoteException(t);
    }

    public static long parseTimestampFromRemoteException(Throwable t) {
        String tsString;
        Matcher matcher;
        String message = t.getLocalizedMessage();
        if (message != null && (matcher = PATTERN_FOR_TS.matcher(t.getLocalizedMessage())).find() && (tsString = matcher.group(1)) != null) {
            return Long.parseLong(tsString);
        }
        return Long.MAX_VALUE;
    }

    public static IOException createIOException(String msg, Throwable t) {
        Throwable cause;
        if (t instanceof SQLException && (cause = t.getCause()) instanceof IOException) {
            t = cause;
        }
        if (t instanceof DoNotRetryIOException) {
            return (DoNotRetryIOException)t;
        }
        if (t instanceof IOException) {
            cause = t.getCause();
            if (cause instanceof RetriesExhaustedWithDetailsException) {
                return new DoNotRetryIOException(t.getMessage(), cause);
            }
            if (cause == null || cause instanceof IOException) {
                return (IOException)t;
            }
            return new DoNotRetryIOException(t.getMessage(), cause);
        }
        if (t instanceof SQLException) {
            return new DoNotRetryIOException(ClientUtil.constructSQLErrorMessage((SQLException)t, msg), t);
        }
        SQLExceptionCode code = errorcodeMap.get(t.getClass());
        if (code == null) {
            return new DoNotRetryIOException(msg + ": " + t.getMessage(), t);
        }
        return new DoNotRetryIOException(ClientUtil.constructSQLErrorMessage(code, t, msg), t);
    }

    public static void throwIOException(String msg, Throwable t) throws IOException {
        throw ClientUtil.createIOException(msg, t);
    }

    public static boolean isHBaseNamespaceAvailable(Admin admin, String schemaName) throws IOException {
        String[] hbaseNamespaces = admin.listNamespaces();
        return Arrays.asList(hbaseNamespaces).contains(schemaName);
    }

    public static IOException parseServiceException(ServiceException se) {
        Throwable cause = se.getCause();
        if (cause != null && cause instanceof IOException) {
            return (IOException)cause;
        }
        return new IOException(se);
    }

    static {
        errorcodeMap.put(ArithmeticException.class, SQLExceptionCode.SERVER_ARITHMETIC_ERROR);
    }
}

