/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hbase.Cell;
import org.apache.phoenix.index.CDCTableInfo;
import org.apache.phoenix.schema.PTable;

public class CDCChangeBuilder {
    private final boolean isChangeImageInScope;
    private final boolean isPreImageInScope;
    private final boolean isPostImageInScope;
    private final CDCTableInfo cdcDataTableInfo;
    private String changeType;
    private long lastDeletedTimestamp;
    private long changeTimestamp;
    private Map<String, Object> preImage = null;
    private Map<String, Object> changeImage = null;

    public CDCChangeBuilder(CDCTableInfo cdcDataTableInfo) {
        this.cdcDataTableInfo = cdcDataTableInfo;
        Set<PTable.CDCChangeScope> changeScopes = cdcDataTableInfo.getIncludeScopes();
        this.isChangeImageInScope = changeScopes.contains((Object)PTable.CDCChangeScope.CHANGE);
        this.isPreImageInScope = changeScopes.contains((Object)PTable.CDCChangeScope.PRE);
        this.isPostImageInScope = changeScopes.contains((Object)PTable.CDCChangeScope.POST);
    }

    public void initChange(long ts) {
        this.changeTimestamp = ts;
        this.changeType = null;
        this.lastDeletedTimestamp = 0L;
        if (this.isPreImageInScope || this.isPostImageInScope) {
            this.preImage = new HashMap<String, Object>();
        }
        if (this.isChangeImageInScope || this.isPostImageInScope) {
            this.changeImage = new HashMap<String, Object>();
        }
    }

    public long getChangeTimestamp() {
        return this.changeTimestamp;
    }

    public boolean isDeletionEvent() {
        return this.changeType == "delete" || this.changeType == "ttl_delete";
    }

    public boolean isNonEmptyEvent() {
        return this.changeType != null;
    }

    public void markAsDeletionEvent() {
        this.changeType = "delete";
    }

    public long getLastDeletedTimestamp() {
        return this.lastDeletedTimestamp;
    }

    public void setLastDeletedTimestamp(long lastDeletedTimestamp) {
        this.lastDeletedTimestamp = lastDeletedTimestamp;
    }

    public boolean isChangeRelevant(Cell cell) {
        if (cell.getTimestamp() > this.changeTimestamp) {
            return false;
        }
        return cell.getType() == Cell.Type.DeleteFamily || this.isOlderThanChange(cell) || !this.isDeletionEvent();
    }

    public void registerChange(Cell cell, int columnNum, Object value) {
        if (!this.isChangeRelevant(cell)) {
            return;
        }
        CDCTableInfo.CDCColumnInfo columnInfo = this.cdcDataTableInfo.getColumnInfoList().get(columnNum);
        String cdcColumnName = columnInfo.getColumnDisplayName(this.cdcDataTableInfo);
        if (this.isOlderThanChange(cell)) {
            if ((this.isPreImageInScope || this.isPostImageInScope) && !this.preImage.containsKey(cdcColumnName)) {
                this.preImage.put(cdcColumnName, value);
            }
        } else if (cell.getTimestamp() == this.changeTimestamp) {
            assert (!this.isDeletionEvent()) : "Not expected to find a change for delete event";
            this.changeType = "upsert";
            if (this.isChangeImageInScope || this.isPostImageInScope) {
                this.changeImage.put(cdcColumnName, value);
            }
        }
    }

    public Map<String, Object> buildCDCEvent() {
        assert (this.changeType != null) : "Not expected when no event was detected";
        HashMap<String, Object> cdcChange = new HashMap<String, Object>();
        if (this.isPreImageInScope) {
            cdcChange.put("pre_image", this.preImage);
        }
        if (this.changeType == "upsert") {
            if (this.isChangeImageInScope) {
                cdcChange.put("change_image", this.changeImage);
            }
            if (this.isPostImageInScope) {
                HashMap<String, Object> postImage = new HashMap<String, Object>();
                if (!this.isDeletionEvent()) {
                    postImage.putAll(this.preImage);
                    postImage.putAll(this.changeImage);
                }
                cdcChange.put("post_image", postImage);
            }
        }
        cdcChange.put("event_type", this.changeType);
        return cdcChange;
    }

    public boolean isOlderThanChange(Cell cell) {
        return cell.getTimestamp() < this.changeTimestamp && cell.getTimestamp() > this.lastDeletedTimestamp;
    }

    public boolean isPreImageInScope() {
        return this.isPreImageInScope;
    }
}

