/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.transaction;

import java.io.IOException;
import org.apache.phoenix.transaction.NotAvailableTransactionProvider;
import org.apache.phoenix.transaction.OmidTransactionProvider;
import org.apache.phoenix.transaction.PhoenixTransactionContext;
import org.apache.phoenix.transaction.PhoenixTransactionProvider;

public class TransactionFactory {
    public static PhoenixTransactionProvider getTransactionProvider(Provider provider) {
        return provider.getTransactionProvider();
    }

    public static PhoenixTransactionProvider getTransactionProvider(byte[] txState, int clientVersion) {
        if (txState == null || txState.length == 0) {
            return null;
        }
        Provider provider = (long)clientVersion < 28L ? Provider.NOTAVAILABLE : Provider.fromCode(txState[txState.length - 1]);
        return provider.getTransactionProvider();
    }

    public static PhoenixTransactionContext getTransactionContext(byte[] txState, int clientVersion) throws IOException {
        PhoenixTransactionProvider provider = TransactionFactory.getTransactionProvider(txState, clientVersion);
        if (provider == null) {
            return null;
        }
        return provider.getTransactionContext(txState);
    }

    public static enum Provider {
        NOTAVAILABLE(1, NotAvailableTransactionProvider.getInstance()),
        OMID(2, OmidTransactionProvider.getInstance());

        private final byte code;
        private final PhoenixTransactionProvider provider;

        private Provider(byte code, PhoenixTransactionProvider provider) {
            this.code = code;
            this.provider = provider;
        }

        public static Provider[] available() {
            return new Provider[]{OMID};
        }

        public byte getCode() {
            return this.code;
        }

        public static Provider fromCode(int code) {
            if (code < 1 || code > Provider.values().length) {
                throw new IllegalArgumentException("Invalid TransactionFactory.Provider " + code);
            }
            return Provider.values()[code - 1];
        }

        public static Provider getDefault() {
            return OMID;
        }

        public PhoenixTransactionProvider getTransactionProvider() {
            return this.provider;
        }
    }
}

