/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.types;

import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PBinary;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.util.ByteUtil;

public class PVarbinaryEncoded
extends PVarbinary {
    public static final PVarbinaryEncoded INSTANCE = new PVarbinaryEncoded();

    private PVarbinaryEncoded() {
        super("VARBINARY_ENCODED", 9000, byte[].class, null, 50);
    }

    private byte[] encodeBytesAscOrder(byte[] bytes) {
        int countZeros = 0;
        for (byte b : bytes) {
            if (b != 0) continue;
            ++countZeros;
        }
        if (countZeros == 0) {
            return bytes;
        }
        byte[] encodedBytes = new byte[bytes.length + countZeros];
        int pos = 0;
        for (byte b : bytes) {
            if (b != 0) {
                encodedBytes[pos++] = b;
                continue;
            }
            encodedBytes[pos++] = 0;
            encodedBytes[pos++] = -1;
        }
        return encodedBytes;
    }

    private byte[] decodeBytesAscOrder(byte[] bytes) {
        int i;
        int countZeros = 0;
        for (int i2 = 0; i2 < bytes.length - 1; ++i2) {
            if (bytes[i2] != 0 || bytes[i2 + 1] != -1) continue;
            ++countZeros;
        }
        if (countZeros == 0) {
            return bytes;
        }
        byte[] decodedBytes = new byte[bytes.length - countZeros];
        int pos = 0;
        for (i = 0; i < bytes.length - 1; ++i) {
            if (bytes[i] == 0 && bytes[i + 1] == -1) {
                decodedBytes[pos++] = 0;
                ++i;
                continue;
            }
            decodedBytes[pos++] = bytes[i];
        }
        if (i == bytes.length - 1) {
            decodedBytes[pos] = bytes[bytes.length - 1];
        }
        return decodedBytes;
    }

    private byte[] encodeBytesDescOrder(byte[] bytes) {
        int countZeros = 0;
        for (byte b : bytes) {
            if (b != SortOrder.invert((byte)0)) continue;
            ++countZeros;
        }
        if (countZeros == 0) {
            return bytes;
        }
        byte[] encodedBytes = new byte[bytes.length + countZeros];
        int pos = 0;
        for (byte b : bytes) {
            if (b != SortOrder.invert((byte)0)) {
                encodedBytes[pos++] = b;
                continue;
            }
            encodedBytes[pos++] = SortOrder.invert((byte)0);
            encodedBytes[pos++] = SortOrder.invert((byte)-1);
        }
        return encodedBytes;
    }

    private byte[] decodeBytesDescOrder(byte[] bytes) {
        int i;
        int countZeros = 0;
        for (int i2 = 0; i2 < bytes.length - 1; ++i2) {
            if (bytes[i2] != SortOrder.invert((byte)0) || bytes[i2 + 1] != SortOrder.invert((byte)-1)) continue;
            ++countZeros;
        }
        if (countZeros == 0) {
            return bytes;
        }
        byte[] decodedBytes = new byte[bytes.length - countZeros];
        int pos = 0;
        for (i = 0; i < bytes.length - 1; ++i) {
            if (bytes[i] == SortOrder.invert((byte)0) && bytes[i + 1] == SortOrder.invert((byte)-1)) {
                decodedBytes[pos++] = SortOrder.invert((byte)0);
                ++i;
                continue;
            }
            decodedBytes[pos++] = bytes[i];
        }
        if (i == bytes.length - 1) {
            decodedBytes[pos] = bytes[bytes.length - 1];
        }
        return decodedBytes;
    }

    @Override
    public byte[] toBytes(Object object) {
        return this.encodeBytesAscOrder(super.toBytes(object));
    }

    @Override
    public int toBytes(Object object, byte[] bytes, int offset) {
        if (object == null) {
            return 0;
        }
        byte[] o = (byte[])object;
        System.arraycopy(bytes, offset, o, 0, o.length);
        byte[] result = this.encodeBytesAscOrder(o);
        return result.length;
    }

    @Override
    public byte[] toBytes(Object object, SortOrder sortOrder) {
        byte[] bytes = object == null ? ByteUtil.EMPTY_BYTE_ARRAY : (byte[])object;
        if (sortOrder == SortOrder.DESC) {
            byte[] result = SortOrder.invert(bytes, 0, new byte[bytes.length], 0, bytes.length);
            return this.encodeBytesDescOrder(result);
        }
        return this.encodeBytesAscOrder(bytes);
    }

    @Override
    public Object toObject(byte[] bytes, int offset, int length, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
        if (length == 0) {
            return null;
        }
        if (offset == 0 && bytes.length == length && sortOrder == SortOrder.ASC) {
            return this.decodeBytesAscOrder(bytes);
        }
        byte[] bytesCopy = new byte[length];
        System.arraycopy(bytes, offset, bytesCopy, 0, length);
        if (sortOrder == SortOrder.DESC) {
            bytesCopy = SortOrder.invert(bytes, offset, bytesCopy, 0, length);
        }
        return this.decodeBytesAscOrder(bytesCopy);
    }

    @Override
    public boolean isCoercibleTo(PDataType targetType) {
        return PVarbinaryEncoded.equalsAny(targetType, this, PBinary.INSTANCE, PVarbinary.INSTANCE);
    }
}

