/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.types;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.Format;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.IllegalDataException;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PBinary;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDate;
import org.apache.phoenix.schema.types.PDecimal;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PTime;
import org.apache.phoenix.schema.types.PUnsignedDate;
import org.apache.phoenix.schema.types.PUnsignedInt;
import org.apache.phoenix.schema.types.PUnsignedLong;
import org.apache.phoenix.schema.types.PUnsignedTime;
import org.apache.phoenix.schema.types.PUnsignedTimestamp;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.DateUtil;

public class PTimestamp
extends PDataType<Timestamp> {
    public static final int MAX_NANOS_VALUE_EXCLUSIVE = 1000000;
    public static final PTimestamp INSTANCE = new PTimestamp();

    protected PTimestamp(String sqlTypeName, int sqlType, int ordinal) {
        super(sqlTypeName, sqlType, Timestamp.class, null, ordinal);
    }

    private PTimestamp() {
        super("TIMESTAMP", 93, Timestamp.class, null, 9);
    }

    @Override
    public byte[] toBytes(Object object) {
        byte[] bytes = new byte[this.getByteSize().intValue()];
        this.toBytes(object, bytes, 0);
        return bytes;
    }

    @Override
    public void coerceBytes(ImmutableBytesWritable ptr, Object o, PDataType actualType, Integer actualMaxLength, Integer actualScale, SortOrder actualModifier, Integer desiredMaxLength, Integer desiredScale, SortOrder expectedModifier) {
        Preconditions.checkNotNull((Object)((Object)actualModifier));
        Preconditions.checkNotNull((Object)((Object)expectedModifier));
        if (ptr.getLength() == 0) {
            return;
        }
        if (this.isBytesComparableWith(actualType)) {
            if (actualModifier != expectedModifier || actualType.isFixedWidth() && actualType.getByteSize() < this.getByteSize()) {
                byte[] b = new byte[this.getByteSize().intValue()];
                System.arraycopy(ptr.get(), ptr.getOffset(), b, 0, actualType.getByteSize());
                ptr.set(b);
                if (actualModifier != expectedModifier) {
                    SortOrder.invert(b, 0, b, 0, b.length);
                }
            }
            return;
        }
        super.coerceBytes(ptr, o, actualType, actualMaxLength, actualScale, actualModifier, desiredMaxLength, desiredScale, expectedModifier);
    }

    @Override
    public int toBytes(Object object, byte[] bytes, int offset) {
        if (object == null) {
            if (bytes.length != this.getByteSize()) {
                bytes = Bytes.padTail((byte[])bytes, (int)(this.getByteSize() - bytes.length));
            }
            PDate.INSTANCE.getCodec().encodeLong(0L, bytes, offset);
            Bytes.putInt((byte[])bytes, (int)(offset + 8), (int)0);
            return this.getByteSize();
        }
        Timestamp value = (Timestamp)object;
        DateUtil.getCodecFor(this).encodeLong(value.getTime(), bytes, offset);
        Bytes.putInt((byte[])bytes, (int)(offset + 8), (int)(value.getNanos() % 1000000));
        return this.getByteSize();
    }

    @Override
    public boolean isBytesComparableWith(PDataType otherType) {
        return super.isBytesComparableWith(otherType) || otherType == PTime.INSTANCE || otherType == PDate.INSTANCE || otherType == PLong.INSTANCE;
    }

    @Override
    public Object toObject(Object object, PDataType actualType) {
        if (object == null) {
            return null;
        }
        if (PTimestamp.equalsAny(actualType, PDate.INSTANCE, PUnsignedDate.INSTANCE, PTime.INSTANCE, PUnsignedTime.INSTANCE)) {
            return new Timestamp(((java.util.Date)object).getTime());
        }
        if (PTimestamp.equalsAny(actualType, INSTANCE, PUnsignedTimestamp.INSTANCE)) {
            return object;
        }
        if (PTimestamp.equalsAny(actualType, PLong.INSTANCE, PUnsignedLong.INSTANCE)) {
            return new Timestamp((Long)object);
        }
        if (actualType == PDecimal.INSTANCE) {
            BigDecimal bd = (BigDecimal)object;
            long ms = bd.longValue();
            int nanos = bd.remainder(BigDecimal.ONE).multiply(QueryConstants.BD_MILLIS_NANOS_CONVERSION).intValue();
            return DateUtil.getTimestamp(ms, nanos);
        }
        if (actualType == PVarchar.INSTANCE) {
            return DateUtil.parseTimestamp((String)object);
        }
        return PTimestamp.throwConstraintViolationException(actualType, this);
    }

    @Override
    public Timestamp toObject(byte[] b, int o, int l, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
        if (actualType == null || l == 0) {
            return null;
        }
        if (PTimestamp.equalsAny(actualType, INSTANCE, PUnsignedTimestamp.INSTANCE)) {
            long millisDeserialized = DateUtil.getCodecFor(actualType).decodeLong(b, o, sortOrder);
            Timestamp v = new Timestamp(millisDeserialized);
            int nanosDeserialized = PUnsignedInt.INSTANCE.getCodec().decodeInt(b, o + 8, sortOrder);
            v.setNanos(nanosDeserialized < 1000000 ? v.getNanos() + nanosDeserialized : nanosDeserialized);
            return v;
        }
        if (PTimestamp.equalsAny(actualType, PDate.INSTANCE, PUnsignedDate.INSTANCE, PTime.INSTANCE, PUnsignedTime.INSTANCE, PLong.INSTANCE, PUnsignedLong.INSTANCE)) {
            return new Timestamp(actualType.getCodec().decodeLong(b, o, sortOrder));
        }
        if (actualType == PDecimal.INSTANCE) {
            BigDecimal bd = (BigDecimal)actualType.toObject(b, o, l, actualType, sortOrder);
            long ms = bd.longValue();
            int nanos = bd.remainder(BigDecimal.ONE).multiply(QueryConstants.BD_MILLIS_NANOS_CONVERSION).intValue();
            Timestamp v = DateUtil.getTimestamp(ms, nanos);
            return v;
        }
        PTimestamp.throwConstraintViolationException(actualType, this);
        return null;
    }

    @Override
    public Object toObject(byte[] bytes, int offset, int length, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale, Class jdbcType) throws SQLException {
        Timestamp sqlTs = this.toObject(bytes, offset, length, actualType, sortOrder, maxLength, scale);
        return this.dateToClass(sqlTs, actualType, jdbcType);
    }

    Object dateToClass(Timestamp sqlTs, PDataType actualType, Class jdbcType) throws SQLException {
        if (jdbcType == LocalDateTime.class) {
            return LocalDateTime.ofInstant(sqlTs.toInstant(), ZoneOffset.UTC);
        }
        if (jdbcType == LocalTime.class) {
            return LocalDateTime.ofInstant(sqlTs.toInstant(), ZoneOffset.UTC).toLocalTime();
        }
        if (jdbcType == LocalDate.class) {
            return LocalDateTime.ofInstant(sqlTs.toInstant(), ZoneOffset.UTC).toLocalDate();
        }
        if (jdbcType == Timestamp.class) {
            return sqlTs;
        }
        if (jdbcType == Date.class) {
            return new Date(sqlTs.getTime());
        }
        if (jdbcType == java.util.Date.class) {
            return new java.util.Date(sqlTs.getTime());
        }
        if (jdbcType == Time.class) {
            return new Time(sqlTs.getTime());
        }
        throw PTimestamp.newMismatchException(actualType, jdbcType);
    }

    @Override
    public boolean isCastableTo(PDataType targetType) {
        return PDate.INSTANCE.isCastableTo(targetType);
    }

    @Override
    public boolean isCoercibleTo(PDataType targetType) {
        return PTimestamp.equalsAny(targetType, this, PVarbinary.INSTANCE, PBinary.INSTANCE);
    }

    @Override
    public boolean isCoercibleTo(PDataType targetType, Object value) {
        if (value != null) {
            if (targetType.equals(PUnsignedTimestamp.INSTANCE)) {
                return ((java.util.Date)value).getTime() >= 0L;
            }
            if (PTimestamp.equalsAny(targetType, PUnsignedDate.INSTANCE, PUnsignedTime.INSTANCE)) {
                return ((java.util.Date)value).getTime() >= 0L && ((Timestamp)value).getNanos() == 0;
            }
            if (PTimestamp.equalsAny(targetType, PDate.INSTANCE, PTime.INSTANCE)) {
                return ((Timestamp)value).getNanos() == 0;
            }
        }
        return super.isCoercibleTo(targetType, value);
    }

    @Override
    public boolean isFixedWidth() {
        return true;
    }

    @Override
    public Integer getByteSize() {
        return MAX_TIMESTAMP_BYTES;
    }

    @Override
    public int compareTo(Object lhs, Object rhs, PDataType rhsType) {
        if (lhs == rhs) {
            return 0;
        }
        if (lhs == null) {
            return -1;
        }
        if (rhs == null) {
            return 1;
        }
        if (PTimestamp.equalsAny(rhsType, INSTANCE, PUnsignedTimestamp.INSTANCE)) {
            return ((Timestamp)lhs).compareTo((Timestamp)rhs);
        }
        int c = ((java.util.Date)lhs).compareTo((java.util.Date)rhs);
        if (c != 0) {
            return c;
        }
        return ((Timestamp)lhs).getNanos();
    }

    @Override
    public Object toObject(String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        return DateUtil.parseTimestamp(value);
    }

    @Override
    public String toStringLiteral(Object o, Format formatter) {
        if (formatter == null) {
            formatter = DateUtil.DEFAULT_TIMESTAMP_FORMATTER;
        }
        return "'" + super.toStringLiteral(o, formatter) + "'";
    }

    @Override
    public int getNanos(ImmutableBytesWritable ptr, SortOrder sortOrder) {
        int nanos = PUnsignedInt.INSTANCE.getCodec().decodeInt(ptr.get(), ptr.getOffset() + PLong.INSTANCE.getByteSize(), sortOrder);
        return nanos;
    }

    @Override
    public long getMillis(ImmutableBytesWritable ptr, SortOrder sortOrder) {
        long millis = DateUtil.getCodecFor(this).decodeLong(ptr.get(), ptr.getOffset(), sortOrder);
        return millis;
    }

    @Override
    public Object getSampleValue(Integer maxLength, Integer arrayLength) {
        return new Timestamp((Long)PLong.INSTANCE.getSampleValue(maxLength, arrayLength));
    }

    @Override
    public KeyRange getKeyRange(byte[] lowerRange, boolean lowerInclusive, byte[] upperRange, boolean upperInclusive, SortOrder sortOrder) {
        if (lowerRange != KeyRange.UNBOUND && !lowerInclusive && this.isFixedWidth()) {
            if (lowerRange.length != MAX_TIMESTAMP_BYTES) {
                throw new IllegalDataException("Unexpected size of " + lowerRange.length + " for " + this);
            }
            int nanos = PUnsignedInt.INSTANCE.getCodec().decodeInt(lowerRange, 8, sortOrder);
            if (sortOrder == SortOrder.DESC && nanos == 0 || sortOrder == SortOrder.ASC && nanos == 999999) {
                byte[] newLowerRange = new byte[MAX_TIMESTAMP_BYTES.intValue()];
                if (sortOrder == SortOrder.DESC) {
                    System.arraycopy(lowerRange, 0, newLowerRange, 0, 8);
                    PUnsignedInt.INSTANCE.getCodec().encodeInt(999999, newLowerRange, 8);
                    SortOrder.invert(newLowerRange, 8, newLowerRange, 8, 4);
                } else {
                    System.arraycopy(lowerRange, 0, newLowerRange, 0, 8);
                }
                lowerRange = ByteUtil.nextKey(newLowerRange, 8) ? newLowerRange : KeyRange.UNBOUND;
                return KeyRange.getKeyRange(lowerRange, true, upperRange, upperInclusive);
            }
        }
        return super.getKeyRange(lowerRange, lowerInclusive, upperRange, upperInclusive, sortOrder);
    }
}

