/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.types;

import java.sql.Time;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PArrayDataType;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PTime;
import org.apache.phoenix.schema.types.PhoenixArray;

public class PTimeArray
extends PArrayDataType<Time[]> {
    public static final PTimeArray INSTANCE = new PTimeArray();

    private PTimeArray() {
        super("TIME ARRAY", 3000 + PTime.INSTANCE.getSqlType(), PhoenixArray.class, null, 38);
    }

    @Override
    public boolean isArrayType() {
        return true;
    }

    @Override
    public boolean isFixedWidth() {
        return false;
    }

    @Override
    public int compareTo(Object lhs, Object rhs, PDataType rhsType) {
        return this.compareTo(lhs, rhs);
    }

    @Override
    public Integer getByteSize() {
        return null;
    }

    @Override
    public byte[] toBytes(Object object) {
        return this.toBytes(object, SortOrder.ASC);
    }

    @Override
    public byte[] toBytes(Object object, SortOrder sortOrder) {
        return this.toBytes(object, PTime.INSTANCE, sortOrder);
    }

    @Override
    public Object toObject(byte[] bytes, int offset, int length, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
        return this.toObject(bytes, offset, length, (PDataType)PTime.INSTANCE, sortOrder, maxLength, scale, PTime.INSTANCE);
    }

    @Override
    public boolean isCoercibleTo(PDataType targetType) {
        return this.isCoercibleTo(targetType, this);
    }

    @Override
    public boolean isCoercibleTo(PDataType targetType, Object value) {
        Object[] timeArr;
        if (value == null) {
            return true;
        }
        PhoenixArray pArr = (PhoenixArray)value;
        for (Object i : timeArr = (Object[])pArr.array) {
            if (super.isCoercibleTo((PDataType)PTime.INSTANCE, i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object getSampleValue(Integer maxLength, Integer arrayLength) {
        return this.getSampleValue(PTime.INSTANCE, arrayLength, maxLength);
    }
}

