/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.types;

import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PBinary;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.json.JsonDataFormat;
import org.apache.phoenix.util.json.JsonDataFormatFactory;

public class PJson
extends PVarbinary {
    public static final PJson INSTANCE = new PJson();
    private JsonDataFormat jsonDataFormat = JsonDataFormatFactory.getJsonDataFormat(JsonDataFormatFactory.DataFormat.BSON);

    private PJson() {
        super("JSON", 5000, byte[].class, null, 48);
    }

    @Override
    public boolean canBePrimaryKey() {
        return false;
    }

    @Override
    public boolean isComparisonSupported() {
        return false;
    }

    @Override
    public int toBytes(Object object, byte[] bytes, int offset) {
        if (object == null) {
            return 0;
        }
        byte[] b = this.toBytes(object);
        System.arraycopy(b, 0, bytes, offset, b.length);
        return b.length;
    }

    @Override
    public byte[] toBytes(Object object) {
        if (object == null) {
            return ByteUtil.EMPTY_BYTE_ARRAY;
        }
        return this.jsonDataFormat.toBytes(object);
    }

    @Override
    public Object toObject(byte[] bytes, int offset, int length, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
        if (length == 0) {
            return null;
        }
        return this.jsonDataFormat.toObject(bytes, offset, length);
    }

    @Override
    public Object toObject(Object object, PDataType actualType) {
        if (object == null) {
            return null;
        }
        if (PJson.equalsAny(actualType, PVarchar.INSTANCE)) {
            return this.toObject((String)object);
        }
        return object;
    }

    @Override
    public Object toObject(String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        return this.jsonDataFormat.toObject(value);
    }

    @Override
    public boolean isCoercibleTo(PDataType targetType) {
        return PJson.equalsAny(targetType, this, PBinary.INSTANCE, PVarbinary.INSTANCE);
    }

    @Override
    public int estimateByteSize(Object o) {
        return this.jsonDataFormat.estimateByteSize(o);
    }

    @Override
    public Integer getByteSize() {
        return null;
    }

    @Override
    public boolean isBytesComparableWith(PDataType otherType) {
        return otherType == PVarbinary.INSTANCE || otherType == INSTANCE;
    }

    @Override
    public Object getSampleValue(Integer maxLength, Integer arrayLength) {
        String json = "{a : 1}";
        return this.toObject(json);
    }
}

