/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.types;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.Format;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PBinary;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDecimal;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PTime;
import org.apache.phoenix.schema.types.PTimestamp;
import org.apache.phoenix.schema.types.PUnsignedDate;
import org.apache.phoenix.schema.types.PUnsignedLong;
import org.apache.phoenix.schema.types.PUnsignedTime;
import org.apache.phoenix.schema.types.PUnsignedTimestamp;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.schema.types.PhoenixArray;
import org.apache.phoenix.util.DateUtil;
import org.apache.phoenix.util.StringUtil;

public class PDate
extends PDataType<Date> {
    public static final PDate INSTANCE = new PDate();

    private PDate() {
        super("DATE", 91, Date.class, new DateCodec(), 11);
    }

    @Override
    public byte[] toBytes(Object object) {
        byte[] bytes = new byte[this.getByteSize().intValue()];
        this.toBytes(object, bytes, 0);
        return bytes;
    }

    @Override
    public int toBytes(Object object, byte[] bytes, int offset) {
        if (object == null) {
            this.getCodec().encodeLong(0L, bytes, offset);
            return this.getByteSize();
        }
        this.getCodec().encodeLong(((java.util.Date)object).getTime(), bytes, offset);
        return this.getByteSize();
    }

    @Override
    public Object toObject(Object object, PDataType actualType) {
        if (object == null) {
            return null;
        }
        if (PDate.equalsAny(actualType, PTime.INSTANCE, PUnsignedTime.INSTANCE)) {
            return new Date(((Time)object).getTime());
        }
        if (PDate.equalsAny(actualType, PTimestamp.INSTANCE, PUnsignedTimestamp.INSTANCE)) {
            return new Date(((Timestamp)object).getTime());
        }
        if (PDate.equalsAny(actualType, INSTANCE, PUnsignedDate.INSTANCE)) {
            return object;
        }
        if (PDate.equalsAny(actualType, PLong.INSTANCE, PUnsignedLong.INSTANCE)) {
            return new Date((Long)object);
        }
        if (actualType == PDecimal.INSTANCE) {
            return new Date(((BigDecimal)object).longValueExact());
        }
        if (actualType == PVarchar.INSTANCE) {
            return DateUtil.parseDate((String)object);
        }
        return PDate.throwConstraintViolationException(actualType, this);
    }

    @Override
    public Date toObject(byte[] b, int o, int l, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
        if (l == 0) {
            return null;
        }
        if (actualType.getCodec() != null) {
            return new Date(actualType.getCodec().decodeLong(b, o, sortOrder));
        }
        if (actualType == PTimestamp.INSTANCE) {
            return new Date(INSTANCE.getCodec().decodeLong(b, o, sortOrder));
        }
        if (actualType == PUnsignedTimestamp.INSTANCE) {
            return new Date(PUnsignedDate.INSTANCE.getCodec().decodeLong(b, o, sortOrder));
        }
        if (actualType == PDecimal.INSTANCE) {
            BigDecimal bd = (BigDecimal)actualType.toObject(b, o, l, actualType, sortOrder);
            return new Date(bd.longValueExact());
        }
        PDate.throwConstraintViolationException(actualType, this);
        return null;
    }

    @Override
    public Object toObject(byte[] bytes, int offset, int length, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale, Class jdbcType) throws SQLException {
        Date sqlDate = this.toObject(bytes, offset, length, actualType, sortOrder, maxLength, scale);
        return this.dateToClass(sqlDate, actualType, jdbcType);
    }

    Object dateToClass(Date sqlDate, PDataType actualType, Class jdbcType) throws SQLException {
        if (jdbcType == LocalDate.class) {
            return LocalDateTime.ofInstant(Instant.ofEpochMilli(sqlDate.getTime()), ZoneOffset.UTC).toLocalDate();
        }
        if (jdbcType == LocalDateTime.class) {
            return LocalDateTime.ofInstant(Instant.ofEpochMilli(sqlDate.getTime()), ZoneOffset.UTC);
        }
        if (jdbcType == LocalTime.class) {
            return LocalDateTime.ofInstant(Instant.ofEpochMilli(sqlDate.getTime()), ZoneOffset.UTC).toLocalTime();
        }
        if (jdbcType == Date.class) {
            return sqlDate;
        }
        if (jdbcType == Time.class) {
            return new Time(sqlDate.getTime());
        }
        if (jdbcType == Timestamp.class) {
            return new Timestamp(sqlDate.getTime());
        }
        if (jdbcType == java.util.Date.class) {
            return new java.util.Date(sqlDate.getTime());
        }
        throw PDate.newMismatchException(actualType, jdbcType);
    }

    @Override
    public boolean isCastableTo(PDataType targetType) {
        return super.isCastableTo(targetType) || PDate.equalsAny(targetType, PDecimal.INSTANCE, PLong.INSTANCE, PUnsignedLong.INSTANCE);
    }

    @Override
    public boolean isCoercibleTo(PDataType targetType) {
        return PDate.equalsAny(targetType, INSTANCE, PTime.INSTANCE, PTimestamp.INSTANCE, PVarbinary.INSTANCE, PBinary.INSTANCE);
    }

    @Override
    public boolean isCoercibleTo(PDataType targetType, Object value) {
        if (value != null && PDate.equalsAny(targetType, PUnsignedTimestamp.INSTANCE, PUnsignedDate.INSTANCE, PUnsignedTime.INSTANCE)) {
            return ((java.util.Date)value).getTime() >= 0L;
        }
        return super.isCoercibleTo(targetType, value);
    }

    @Override
    public boolean isFixedWidth() {
        return true;
    }

    @Override
    public Integer getByteSize() {
        return 8;
    }

    @Override
    public int compareTo(Object lhs, Object rhs, PDataType rhsType) {
        if (lhs == rhs) {
            return 0;
        }
        if (lhs == null) {
            return -1;
        }
        if (rhs == null) {
            return 1;
        }
        if (rhsType == PTimestamp.INSTANCE || rhsType == PUnsignedTimestamp.INSTANCE) {
            return -rhsType.compareTo(rhs, lhs, PTime.INSTANCE);
        }
        return ((java.util.Date)lhs).compareTo((java.util.Date)rhs);
    }

    @Override
    public Object toObject(String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        return DateUtil.parseDate(value);
    }

    @Override
    public boolean isBytesComparableWith(PDataType otherType) {
        return super.isBytesComparableWith(otherType) || otherType == PTime.INSTANCE || otherType == PTimestamp.INSTANCE || otherType == PLong.INSTANCE;
    }

    @Override
    public String toStringLiteral(Object o, Format formatter) {
        if (formatter == null) {
            formatter = DateUtil.DEFAULT_DATE_FORMATTER;
        }
        return null == o ? String.valueOf(o) : "'" + StringUtil.escapeStringConstant(super.toStringLiteral(o, formatter)) + "'";
    }

    @Override
    public void coerceBytes(ImmutableBytesWritable ptr, Object object, PDataType actualType, Integer maxLength, Integer scale, SortOrder actualModifier, Integer desiredMaxLength, Integer desiredScale, SortOrder expectedModifier) {
        if (ptr.getLength() > this.getByteSize()) {
            ptr.set(ptr.get(), ptr.getOffset(), this.getByteSize().intValue());
        }
        super.coerceBytes(ptr, object, actualType, maxLength, scale, actualModifier, desiredMaxLength, desiredScale, expectedModifier);
    }

    @Override
    public Object getSampleValue(Integer maxLength, Integer arrayLength) {
        return new Date((Long)PLong.INSTANCE.getSampleValue(maxLength, arrayLength));
    }

    static class DateCodec
    extends PLong.LongCodec {
        DateCodec() {
        }

        @Override
        public int decodeInt(byte[] b, int o, SortOrder sortOrder) {
            throw new UnsupportedOperationException();
        }

        @Override
        public PDataType.PhoenixArrayFactory getPhoenixArrayFactory() {
            return new PDataType.PhoenixArrayFactory(){

                @Override
                public PhoenixArray newArray(PDataType type, Object[] elements) {
                    return new PhoenixArray(type, elements);
                }
            };
        }
    }
}

