/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.tuple;

import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.schema.tuple.BaseTuple;
import org.apache.phoenix.schema.tuple.EncodedColumnQualiferCellsList;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;

public class PositionBasedResultTuple
extends BaseTuple {
    private final EncodedColumnQualiferCellsList cells;

    public PositionBasedResultTuple(List<Cell> list) {
        Preconditions.checkArgument((boolean)(list instanceof EncodedColumnQualiferCellsList), (Object)"Invalid list type");
        this.cells = (EncodedColumnQualiferCellsList)list;
    }

    @Override
    public void getKey(ImmutableBytesWritable ptr) {
        Cell value = this.cells.getFirstCell();
        ptr.set(value.getRowArray(), value.getRowOffset(), (int)value.getRowLength());
    }

    @Override
    public boolean isImmutable() {
        return true;
    }

    @Override
    public Cell getValue(byte[] family, byte[] qualifier) {
        return this.cells.getCellForColumnQualifier(qualifier);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("keyvalues=");
        if (this.cells == null || this.cells.isEmpty()) {
            sb.append("NONE");
            return sb.toString();
        }
        sb.append("{");
        boolean moreThanOne = false;
        for (Cell kv : this.cells) {
            if (moreThanOne) {
                sb.append(", \n");
            } else {
                moreThanOne = true;
            }
            sb.append(kv.toString() + "/value=" + Bytes.toString((byte[])kv.getValueArray(), (int)kv.getValueOffset(), (int)kv.getValueLength()));
        }
        sb.append("}\n");
        return sb.toString();
    }

    @Override
    public int size() {
        return this.cells.size();
    }

    @Override
    public Cell getValue(int index) {
        return index == 0 ? this.cells.getFirstCell() : this.cells.get(index);
    }

    @Override
    public boolean getValue(byte[] family, byte[] qualifier, ImmutableBytesWritable ptr) {
        Cell kv = this.getValue(family, qualifier);
        if (kv == null) {
            return false;
        }
        ptr.set(kv.getValueArray(), kv.getValueOffset(), kv.getValueLength());
        return true;
    }

    public Iterator<Cell> getTupleIterator() {
        return new TupleIterator(this.cells.iterator());
    }

    @Override
    public long getSerializedSize() {
        if (this.cells == null || this.cells.isEmpty()) {
            return 0L;
        }
        long totalSize = 0L;
        for (Cell cell : this.cells) {
            totalSize += (long)cell.getSerializedSize();
        }
        return totalSize;
    }

    private static class TupleIterator
    implements Iterator<Cell> {
        private final Iterator<Cell> delegate;

        private TupleIterator(Iterator<Cell> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public Cell next() {
            return this.delegate.next();
        }

        @Override
        public void remove() {
            this.delegate.remove();
        }
    }
}

