/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.transform;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.coprocessorclient.MetaDataProtocol;
import org.apache.phoenix.coprocessorclient.TableInfo;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.jdbc.PhoenixPreparedStatement;
import org.apache.phoenix.query.QueryServicesOptions;
import org.apache.phoenix.schema.MetaDataClient;
import org.apache.phoenix.schema.PIndexState;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PNameFactory;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableImpl;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.task.SystemTaskParams;
import org.apache.phoenix.schema.task.Task;
import org.apache.phoenix.schema.tool.SchemaExtractionProcessor;
import org.apache.phoenix.schema.transform.SystemTransformRecord;
import org.apache.phoenix.thirdparty.com.google.common.base.Strings;
import org.apache.phoenix.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.JacksonUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TableViewFinderResult;
import org.apache.phoenix.util.TaskMetaDataServiceCallBack;
import org.apache.phoenix.util.ViewUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransformClient.class);
    private static final String TRANSFORM_SELECT = "SELECT TENANT_ID, TABLE_SCHEM, LOGICAL_TABLE_NAME, NEW_PHYS_TABLE_NAME, TRANSFORM_TYPE, LOGICAL_PARENT_NAME, STATUS, JOB_ID, RETRY_COUNT, START_TS, END_TS, OLD_METADATA , NEW_METADATA , TRANSFORM_FUNCTION FROM " + PhoenixDatabaseMetaData.SYSTEM_TRANSFORM_NAME;

    public static SystemTransformRecord getTransformRecord(PName schema, PName logicalTableName, PName logicalParentName, PName tenantId, PhoenixConnection connection) throws SQLException {
        return TransformClient.getTransformRecordFromDB(schema == null ? null : schema.getString(), logicalTableName == null ? null : logicalTableName.getString(), logicalParentName == null ? null : logicalParentName.getString(), tenantId == null ? null : tenantId.getString(), connection);
    }

    public static SystemTransformRecord getTransformRecord(String schema, String logicalTableName, String logicalParentName, String tenantId, PhoenixConnection connection) throws SQLException {
        return TransformClient.getTransformRecordFromDB(schema, logicalTableName, logicalParentName, tenantId, connection);
    }

    public static SystemTransformRecord getTransformRecordFromDB(String schema, String logicalTableName, String logicalParentName, String tenantId, PhoenixConnection connection) throws SQLException {
        if (PhoenixDatabaseMetaData.SYSTEM_TRANSFORM_NAME.equals(SchemaUtil.getTableName(schema, logicalTableName))) {
            return null;
        }
        String sql = TRANSFORM_SELECT + " WHERE  " + (Strings.isNullOrEmpty((String)tenantId) ? "" : "TENANT_ID ='" + tenantId + "' AND ") + (Strings.isNullOrEmpty((String)schema) ? "" : "TABLE_SCHEM ='" + schema + "' AND ") + "LOGICAL_TABLE_NAME" + " ='" + logicalTableName + "'" + (Strings.isNullOrEmpty((String)logicalParentName) ? "" : " AND LOGICAL_PARENT_NAME='" + logicalParentName + "'");
        try (ResultSet resultSet = ((PhoenixPreparedStatement)connection.prepareStatement(sql)).executeQuery();){
            if (resultSet.next()) {
                SystemTransformRecord systemTransformRecord = SystemTransformRecord.SystemTransformBuilder.build(resultSet);
                return systemTransformRecord;
            }
            LOGGER.info("Could not find System.Transform record with " + sql);
            SystemTransformRecord systemTransformRecord = null;
            return systemTransformRecord;
        }
    }

    private static boolean isTransformNeeded(MetaDataClient.MetaProperties metaProperties, PTable table) {
        if (metaProperties.getImmutableStorageSchemeProp() != null && metaProperties.getImmutableStorageSchemeProp() != table.getImmutableStorageScheme()) {
            return true;
        }
        return metaProperties.getColumnEncodedBytesProp() != null && metaProperties.getColumnEncodedBytesProp() != table.getEncodingScheme();
    }

    public static boolean checkIsTransformNeeded(MetaDataClient.MetaProperties metaProperties, String schemaName, PTable table, String logicalTableName, String parentTableName, String tenantId, PhoenixConnection connection) throws SQLException {
        SystemTransformRecord existingTransform;
        boolean isTransformNeeded = TransformClient.isTransformNeeded(metaProperties, table);
        if (isTransformNeeded && (existingTransform = TransformClient.getTransformRecord(schemaName, logicalTableName, parentTableName, tenantId, connection)) != null && existingTransform.isActive()) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_TRANSFORM_ALREADY_TRANSFORMING_TABLE).setMessage(" Only one transform at a time is allowed ").setSchemaName(schemaName).setTableName(logicalTableName).build().buildException();
        }
        return isTransformNeeded;
    }

    protected static SystemTransformRecord getTransformRecord(PhoenixConnection connection, PTableType tableType, PName schemaName, PName tableName, PName dataTableName, PName tenantId, PName parentLogicalName) throws SQLException {
        if (tableType == PTableType.TABLE) {
            return TransformClient.getTransformRecord(schemaName, tableName, null, tenantId, connection);
        }
        if (tableType == PTableType.INDEX) {
            return TransformClient.getTransformRecord(schemaName, tableName, dataTableName, tenantId, connection);
        }
        if (tableType == PTableType.VIEW) {
            if (parentLogicalName == null) {
                LOGGER.warn("View doesn't seem to have a parent");
                return null;
            }
            return TransformClient.getTransformRecord(SchemaUtil.getSchemaNameFromFullName(parentLogicalName.getString()), SchemaUtil.getTableNameFromFullName(parentLogicalName.getString()), null, tenantId == null ? null : tenantId.getString(), connection);
        }
        return null;
    }

    private static String generateNewTableName(String schema, String logicalTableName, long seqNum) {
        String newName = String.format("%s_%d", SchemaUtil.getTableName(schema, logicalTableName), seqNum);
        return newName;
    }

    public static PTable addTransform(PhoenixConnection connection, String tenantId, PTable table, MetaDataClient.MetaProperties changingProperties, long sequenceNum, PTable.TransformType transformType) throws SQLException {
        try {
            String newMetadata = JacksonUtil.getObjectWriter().writeValueAsString((Object)changingProperties);
            byte[] oldMetadata = PTableImpl.toProto(table).toByteArray();
            String newPhysicalTableName = "";
            SystemTransformRecord.SystemTransformBuilder transformBuilder = new SystemTransformRecord.SystemTransformBuilder();
            String schema = table.getSchemaName() != null ? table.getSchemaName().getString() : null;
            String logicalTableName = table.getTableName().getString();
            transformBuilder.setSchemaName(schema);
            transformBuilder.setLogicalTableName(logicalTableName);
            transformBuilder.setTenantId(tenantId);
            if (table.getType() == PTableType.INDEX) {
                transformBuilder.setLogicalParentName(table.getParentName().getString());
            }
            transformBuilder.setTransformType(transformType);
            transformBuilder.setNewMetadata(newMetadata);
            transformBuilder.setOldMetadata(oldMetadata);
            PIndexState defaultCreateState = PIndexState.valueOf(connection.getQueryServices().getConfiguration().get("phoenix.index.create.default.state", QueryServicesOptions.DEFAULT_CREATE_INDEX_STATE));
            if (defaultCreateState == PIndexState.CREATE_DISABLE) {
                transformBuilder.setTransformStatus(PTable.TransformStatus.PAUSED.name());
            }
            if (Strings.isNullOrEmpty((String)newPhysicalTableName)) {
                newPhysicalTableName = TransformClient.generateNewTableName(schema, logicalTableName, sequenceNum);
            }
            transformBuilder.setNewPhysicalTableName(newPhysicalTableName);
            return TransformClient.addTransform(table, changingProperties, transformBuilder.build(), sequenceNum, connection);
        }
        catch (JsonProcessingException ex) {
            LOGGER.error("addTransform failed", (Throwable)ex);
            throw new SQLException("Adding transform failed with JsonProcessingException");
        }
        catch (SQLException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.valueOf("CANNOT_MUTATE_TABLE")).setSchemaName(table.getSchemaName() == null ? null : table.getSchemaName().getString()).setRootCause(ex).setTableName(table.getName().getString()).build().buildException();
        }
    }

    protected static PTable addTransform(PTable table, MetaDataClient.MetaProperties changedProps, SystemTransformRecord systemTransformParams, long sequenceNum, PhoenixConnection connection) throws Exception {
        PName newTableName = PNameFactory.newName(systemTransformParams.getNewPhysicalTableName());
        PName newTableNameWithoutSchema = PNameFactory.newName(SchemaUtil.getTableNameFromFullName(systemTransformParams.getNewPhysicalTableName()));
        PIndexState defaultCreateState = PIndexState.valueOf(connection.getQueryServices().getConfiguration().get("phoenix.index.create.default.state", QueryServicesOptions.DEFAULT_CREATE_INDEX_STATE));
        PTableImpl newTable = new PTableImpl.Builder().setTableName(newTableNameWithoutSchema).setParentTableName(table.getParentTableName()).setBaseTableLogicalName(table.getBaseTableLogicalName()).setPhysicalTableName(newTableNameWithoutSchema).setState(defaultCreateState).setAllColumns(table.getColumns()).setAppendOnlySchema(table.isAppendOnlySchema()).setAutoPartitionSeqName(table.getAutoPartitionSeqName()).setBaseColumnCount(table.getBaseColumnCount()).setBucketNum(table.getBucketNum()).setDefaultFamilyName(table.getDefaultFamilyName()).setDisableWAL(table.isWALDisabled()).setEstimatedSize(table.getEstimatedSize()).setFamilies(table.getColumnFamilies()).setImmutableRows(table.isImmutableRows()).setIsChangeDetectionEnabled(table.isChangeDetectionEnabled()).setIndexType(table.getIndexType()).setIndexes(Collections.emptyList()).setName(newTableName).setMultiTenant(table.isMultiTenant()).setParentName(table.getParentName()).setParentSchemaName(table.getParentSchemaName()).setNamespaceMapped(table.isNamespaceMapped()).setSchemaName(table.getSchemaName()).setPkColumns(table.getPKColumns()).setPkName(table.getPKName()).setRowKeySchema(table.getRowKeySchema()).setStoreNulls(table.getStoreNulls()).setTenantId(table.getTenantId()).setType(table.getType()).setPhysicalNames((List<PName>)ImmutableList.copyOf(table.getPhysicalNames())).setUpdateCacheFrequency(table.getUpdateCacheFrequency()).setTransactionProvider(table.getTransactionProvider()).setUseStatsForParallelization(table.useStatsForParallelization()).setSchemaVersion(table.getSchemaVersion()).setIsChangeDetectionEnabled(table.isChangeDetectionEnabled()).setIsStrictTTL(table.isStrictTTL()).setStreamingTopicName(table.getStreamingTopicName()).setImmutableStorageScheme(changedProps.getImmutableStorageSchemeProp() != null ? changedProps.getImmutableStorageSchemeProp() : table.getImmutableStorageScheme()).setQualifierEncodingScheme(changedProps.getColumnEncodedBytesProp() != null ? changedProps.getColumnEncodedBytesProp() : table.getEncodingScheme()).build();
        SchemaExtractionProcessor schemaExtractionProcessor = new SchemaExtractionProcessor(systemTransformParams.getTenantId(), connection.getQueryServices().getConfiguration(), newTable, true);
        String ddl = schemaExtractionProcessor.process();
        LOGGER.info("Creating transforming table via " + ddl);
        connection.createStatement().execute(ddl);
        TransformClient.upsertTransform(systemTransformParams, connection);
        TransformClient.addTransformTableLink(connection, systemTransformParams.getTenantId(), systemTransformParams.getSchemaName(), systemTransformParams.getLogicalTableName(), newTableName, sequenceNum);
        TableViewFinderResult childViewsResult = ViewUtil.findChildViews(connection, systemTransformParams.getTenantId(), systemTransformParams.getSchemaName(), systemTransformParams.getLogicalTableName());
        for (TableInfo view : childViewsResult.getLinks()) {
            TransformClient.addTransformTableLink(connection, view.getTenantId() == null ? null : Bytes.toString((byte[])view.getTenantId()), view.getSchemaName() == null ? null : Bytes.toString((byte[])view.getSchemaName()), Bytes.toString((byte[])view.getTableName()), newTableName, sequenceNum);
        }
        if (defaultCreateState != PIndexState.CREATE_DISABLE) {
            TransformClient.addTransformMonitorTask(connection, connection.getQueryServices().getConfiguration(), systemTransformParams, PTable.TaskStatus.CREATED, new Timestamp(EnvironmentEdgeManager.currentTimeMillis()), null);
        } else {
            LOGGER.info("Transform will not be monitored until it is resumed again.");
        }
        return newTable;
    }

    public static void upsertTransform(SystemTransformRecord systemTransformParams, PhoenixConnection connection) throws SQLException {
        try (PreparedStatement stmt = connection.prepareStatement("UPSERT INTO " + PhoenixDatabaseMetaData.SYSTEM_TRANSFORM_NAME + " ( " + "TABLE_SCHEM" + ", " + "LOGICAL_TABLE_NAME" + ", " + "TENANT_ID" + "," + "NEW_PHYS_TABLE_NAME" + ", " + "TRANSFORM_TYPE" + ", " + "LOGICAL_PARENT_NAME" + ", " + "STATUS" + ", " + "JOB_ID" + ", " + "RETRY_COUNT" + ", " + "START_TS" + ", " + "END_TS" + ", " + "OLD_METADATA" + " , " + "NEW_METADATA" + " , " + "TRANSFORM_FUNCTION" + " ) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?)");){
            int colNum = 1;
            if (systemTransformParams.getSchemaName() != null) {
                stmt.setString(colNum++, systemTransformParams.getSchemaName());
            } else {
                stmt.setNull(colNum++, 12);
            }
            stmt.setString(colNum++, systemTransformParams.getLogicalTableName());
            if (systemTransformParams.getTenantId() != null) {
                stmt.setString(colNum++, systemTransformParams.getTenantId());
            } else {
                stmt.setNull(colNum++, 12);
            }
            stmt.setString(colNum++, systemTransformParams.getNewPhysicalTableName());
            stmt.setInt(colNum++, systemTransformParams.getTransformType().getSerializedValue());
            if (systemTransformParams.getLogicalParentName() != null) {
                stmt.setString(colNum++, systemTransformParams.getLogicalParentName());
            } else {
                stmt.setNull(colNum++, 12);
            }
            stmt.setString(colNum++, systemTransformParams.getTransformStatus());
            if (systemTransformParams.getTransformJobId() != null) {
                stmt.setString(colNum++, systemTransformParams.getTransformJobId());
            } else {
                stmt.setNull(colNum++, 12);
            }
            stmt.setInt(colNum++, systemTransformParams.getTransformRetryCount());
            stmt.setTimestamp(colNum++, systemTransformParams.getTransformStartTs());
            if (systemTransformParams.getTransformLastStateTs() != null) {
                stmt.setTimestamp(colNum++, systemTransformParams.getTransformLastStateTs());
            } else {
                stmt.setNull(colNum++, 93);
            }
            if (systemTransformParams.getOldMetadata() != null) {
                stmt.setBytes(colNum++, systemTransformParams.getOldMetadata());
            } else {
                stmt.setNull(colNum++, -3);
            }
            if (systemTransformParams.getNewMetadata() != null) {
                stmt.setString(colNum++, systemTransformParams.getNewMetadata());
            } else {
                stmt.setNull(colNum++, 12);
            }
            if (systemTransformParams.getTransformFunction() != null) {
                stmt.setString(colNum++, systemTransformParams.getTransformFunction());
            } else {
                stmt.setNull(colNum++, 12);
            }
            LOGGER.info("Adding transform type: " + systemTransformParams.getString());
            stmt.execute();
        }
    }

    private static void addTransformTableLink(Connection connection, String tenantId, String schemaName, String tableName, PName newTableName, long sequenceNum) throws SQLException {
        PreparedStatement linkStatement = connection.prepareStatement("UPSERT INTO SYSTEM.\"CATALOG\"( TENANT_ID,TABLE_SCHEM,TABLE_NAME,COLUMN_FAMILY,LINK_TYPE,TABLE_SEQ_NUM,TABLE_TYPE) VALUES (?, ?, ?, ?, ?, ?, ?)");
        linkStatement.setString(1, tenantId);
        linkStatement.setString(2, schemaName);
        linkStatement.setString(3, tableName);
        linkStatement.setString(4, newTableName.getString());
        linkStatement.setByte(5, PTable.LinkType.TRANSFORMING_NEW_TABLE.getSerializedValue());
        linkStatement.setLong(6, sequenceNum);
        linkStatement.setString(7, PTableType.TABLE.getSerializedValue());
        linkStatement.execute();
    }

    public static void addTransformMonitorTask(PhoenixConnection connection, Configuration configuration, SystemTransformRecord systemTransformRecord, PTable.TaskStatus taskStatus, Timestamp startTimestamp, Timestamp endTimestamp) throws IOException, SQLException {
        boolean transformMonitorEnabled = configuration.getBoolean("phoenix.transform.monitor.enabled", true);
        if (!transformMonitorEnabled) {
            LOGGER.warn("TransformMonitor is not enabled. Monitoring/retrying TransformTool and doing cutover will not be done automatically");
            return;
        }
        List<Mutation> sysTaskUpsertMutations = Task.getMutationsForAddTask(new SystemTaskParams.SystemTaskParamsBuilder().setConn(connection).setTaskType(PTable.TaskType.TRANSFORM_MONITOR).setTenantId(systemTransformRecord.getTenantId()).setSchemaName(systemTransformRecord.getSchemaName()).setTableName(systemTransformRecord.getLogicalTableName()).setTaskStatus(taskStatus.toString()).setStartTs(startTimestamp).setEndTs(endTimestamp).setAccessCheckEnabled(true).build());
        byte[] rowKey = sysTaskUpsertMutations.get(0).getRow();
        MetaDataProtocol.MetaDataMutationResult metaDataMutationResult = Task.taskMetaDataCoprocessorExec(connection, rowKey, new TaskMetaDataServiceCallBack(sysTaskUpsertMutations));
        if (MetaDataProtocol.MutationCode.UNABLE_TO_UPSERT_TASK.equals((Object)metaDataMutationResult.getMutationCode())) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.UNABLE_TO_UPSERT_TASK).setSchemaName("SYSTEM").setTableName("TASK").build().buildException();
        }
    }
}

