/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.metrics;

import org.apache.hadoop.hbase.metrics.BaseSourceImpl;
import org.apache.hadoop.metrics2.MetricHistogram;
import org.apache.hadoop.metrics2.lib.MutableFastCounter;
import org.apache.phoenix.schema.metrics.MetricsMetadataSource;

public class MetricsMetadataSourceImpl
extends BaseSourceImpl
implements MetricsMetadataSource {
    private final MutableFastCounter createExportCount = this.getMetricsRegistry().newCounter("createExportCount", "Count of CREATE DDL statements exported to schema registry", 0L);
    private final MetricHistogram createExportTimeHisto = this.getMetricsRegistry().newHistogram("createExportTime", "Time taken while exporting CREATE DDL statements to schema registry");
    private final MutableFastCounter createExportFailureCount = this.getMetricsRegistry().newCounter("createExportFailureCount", "Count of create DDL that failed on export to schema registry", 0L);
    private final MetricHistogram createExportFailureTimeHisto = this.getMetricsRegistry().newHistogram("createExportFailureTime", "Time taken while failing to export CREATE DDL to schema registry");
    private final MutableFastCounter alterExportCount = this.getMetricsRegistry().newCounter("alterExportCount", "Count of ALTER DDL statements exported to schema registry", 0L);
    private final MetricHistogram alterExportTimeHisto = this.getMetricsRegistry().newHistogram("alterExportTime", "Time taken while exporting ALTER DDL statements to schema registry");
    private final MutableFastCounter alterExportFailureCount = this.getMetricsRegistry().newCounter("alterExportFailureCount", "Count of ALTER DDL that failed on export to schema registry", 0L);
    private final MetricHistogram alterExportFailureTimeHisto = this.getMetricsRegistry().newHistogram("alterExportFailureTime", "Time taken while failing to export ALTER DDL to schema registry");
    private final MutableFastCounter createTableCount = this.getMetricsRegistry().newCounter("createTableCount", "Count of CREATE TABLE DDL statements", 0L);
    private final MutableFastCounter createViewCount = this.getMetricsRegistry().newCounter("createViewCount", "Count of CREATE VIEW DDL statements", 0L);
    private final MutableFastCounter createIndexCount = this.getMetricsRegistry().newCounter("createIndexCount", "Count of CREATE INDEX DDL statements", 0L);
    private final MutableFastCounter createSchemaCount;
    private final MutableFastCounter createFunctionCount = this.getMetricsRegistry().newCounter("createFunctionCount", "Count of CREATE FUNCTION DDL statements", 0L);
    private final MutableFastCounter alterAddColumnCount;
    private final MutableFastCounter alterDropColumnCount;
    private final MutableFastCounter dropTableCount;
    private final MutableFastCounter dropViewCount;
    private final MutableFastCounter dropIndexCount;
    private final MutableFastCounter dropSchemaCount;
    private final MutableFastCounter dropFunctionCount;
    private final MutableFastCounter metadataCacheUsedSize;
    private final MutableFastCounter metadataCacheHitCount;
    private final MutableFastCounter metadataCacheMissCount;
    private final MutableFastCounter metadataCacheEvictionCount;
    private final MutableFastCounter metadataCacheRemovalCount;
    private final MutableFastCounter metadataCacheAddCount;

    public MetricsMetadataSourceImpl() {
        this("PhoenixMetadata", "Metrics about the Phoenix MetadataEndpoint", "phoenix", "RegionServer,sub=PhoenixMetadata");
    }

    public MetricsMetadataSourceImpl(String metricsName, String metricsDescription, String metricsContext, String metricsJmxContext) {
        super(metricsName, metricsDescription, metricsContext, metricsJmxContext);
        this.createSchemaCount = this.getMetricsRegistry().newCounter("createSchemaCount", "Count of CREATE SCHEMA DDL statements", 0L);
        this.alterAddColumnCount = this.getMetricsRegistry().newCounter("alterAddColumnCount", "Count of ALTER statements that add columns", 0L);
        this.alterDropColumnCount = this.getMetricsRegistry().newCounter("alterDropColumnCount", "Count of ALTER statements that drop columns", 0L);
        this.dropTableCount = this.getMetricsRegistry().newCounter("dropTableCount", "Count of DROP TABLE DDL statements", 0L);
        this.dropViewCount = this.getMetricsRegistry().newCounter("dropViewCount", "Count of DROP VIEW DDL statements", 0L);
        this.dropIndexCount = this.getMetricsRegistry().newCounter("dropIndexCount", "Count of DROP INDEX DDL statements", 0L);
        this.dropSchemaCount = this.getMetricsRegistry().newCounter("dropSchemaCount", "Count of DROP SCHEMA DDL statements", 0L);
        this.dropFunctionCount = this.getMetricsRegistry().newCounter("dropFunctionCount", "Count of DROP FUNCTION DDL statements", 0L);
        this.metadataCacheUsedSize = this.getMetricsRegistry().newCounter("metadataCacheEstimatedUsedSize", "Estimated used size of the metadata cache", 0L);
        this.metadataCacheHitCount = this.getMetricsRegistry().newCounter("metadataCacheHitCount", "Hit count of the metadata cache", 0L);
        this.metadataCacheMissCount = this.getMetricsRegistry().newCounter("metadataCacheMissCount", "Miss count of the metadata cache", 0L);
        this.metadataCacheEvictionCount = this.getMetricsRegistry().newCounter("metadataCacheEvictionCount", "Eviction count of the metadata cache", 0L);
        this.metadataCacheRemovalCount = this.getMetricsRegistry().newCounter("metadataCacheRemovalCount", "Removal count of the metadata cache", 0L);
        this.metadataCacheAddCount = this.getMetricsRegistry().newCounter("metadataCacheAddCount", "Add count of the metadata cache", 0L);
    }

    @Override
    public void incrementCreateExportCount() {
        this.createExportCount.incr();
    }

    @Override
    public void updateCreateExportTime(long t) {
        this.createExportTimeHisto.add(t);
    }

    @Override
    public void incrementCreateExportFailureCount() {
        this.createExportFailureCount.incr();
    }

    @Override
    public void updateCreateExportFailureTime(long t) {
        this.createExportFailureTimeHisto.add(t);
    }

    @Override
    public void incrementAlterExportCount() {
        this.alterExportCount.incr();
    }

    @Override
    public void updateAlterExportTime(long t) {
        this.alterExportTimeHisto.add(t);
    }

    @Override
    public void incrementAlterExportFailureCount() {
        this.alterExportFailureCount.incr();
    }

    @Override
    public void updateAlterExportFailureTime(long t) {
        this.alterExportFailureTimeHisto.add(t);
    }

    @Override
    public void incrementCreateTableCount() {
        this.createTableCount.incr();
    }

    @Override
    public void incrementCreateViewCount() {
        this.createViewCount.incr();
    }

    @Override
    public void incrementCreateIndexCount() {
        this.createIndexCount.incr();
    }

    @Override
    public void incrementCreateSchemaCount() {
        this.createSchemaCount.incr();
    }

    @Override
    public void incrementCreateFunctionCount() {
        this.createFunctionCount.incr();
    }

    @Override
    public void incrementAlterAddColumnCount() {
        this.alterAddColumnCount.incr();
    }

    @Override
    public void incrementAlterDropColumnCount() {
        this.alterDropColumnCount.incr();
    }

    @Override
    public void incrementDropTableCount() {
        this.dropTableCount.incr();
    }

    @Override
    public void incrementDropViewCount() {
        this.dropViewCount.incr();
    }

    @Override
    public void incrementDropIndexCount() {
        this.dropIndexCount.incr();
    }

    @Override
    public void incrementDropSchemaCount() {
        this.dropSchemaCount.incr();
    }

    @Override
    public void incrementDropFunctionCount() {
        this.dropFunctionCount.incr();
    }

    @Override
    public void incrementMetadataCacheUsedSize(long estimatedSize) {
        this.metadataCacheUsedSize.incr(estimatedSize);
    }

    @Override
    public void decrementMetadataCacheUsedSize(long estimatedSize) {
        this.metadataCacheUsedSize.incr(-estimatedSize);
    }

    @Override
    public void incrementMetadataCacheHitCount() {
        this.metadataCacheHitCount.incr();
    }

    @Override
    public void incrementMetadataCacheMissCount() {
        this.metadataCacheMissCount.incr();
    }

    @Override
    public void incrementMetadataCacheEvictionCount() {
        this.metadataCacheEvictionCount.incr();
    }

    @Override
    public void incrementMetadataCacheRemovalCount() {
        this.metadataCacheRemovalCount.incr();
    }

    @Override
    public void incrementMetadataCacheAddCount() {
        this.metadataCacheAddCount.incr();
    }
}

