/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.export;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.phoenix.schema.export.DefaultSchemaRegistryRepository;
import org.apache.phoenix.schema.export.SchemaRegistryRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SchemaRegistryRepositoryFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchemaRegistryRepository.class);
    private static SchemaRegistryRepository exporter;

    public static synchronized SchemaRegistryRepository getSchemaRegistryRepository(Configuration conf) throws IOException {
        if (exporter != null) {
            return exporter;
        }
        try {
            String className = conf.get("org.apache.phoenix.export.schemaregistry.impl");
            if (className == null) {
                exporter = new DefaultSchemaRegistryRepository();
            } else {
                Class<?> clazz = Class.forName(className);
                exporter = (SchemaRegistryRepository)clazz.newInstance();
            }
            exporter.init(conf);
            return exporter;
        }
        catch (Exception e) {
            LOGGER.error("Error constructing SchemaRegistryExporter object", (Throwable)e);
            if (exporter != null) {
                try {
                    exporter.close();
                    exporter = null;
                }
                catch (IOException innerE) {
                    LOGGER.error("Error closing incorrectly constructed SchemaRegistryExporter", (Throwable)e);
                }
            }
            throw new IOException(e);
        }
    }

    public static synchronized void close() throws IOException {
        if (exporter != null) {
            exporter.close();
            exporter = null;
        }
    }
}

