/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.export;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.export.SchemaRegistryRepository;
import org.apache.phoenix.schema.export.SchemaWriter;
import org.apache.phoenix.util.EnvironmentEdgeManager;

public class DefaultSchemaRegistryRepository
implements SchemaRegistryRepository {
    public static final String DEFAULT_SCHEMA_NAME = "default_schema";
    public static final String DEFAULT_TENANT_ID = "global";
    private static final String SEPARATOR = "*";
    Map<String, String> schemaMap = new HashMap<String, String>();

    @Override
    public void init(Configuration conf) throws IOException {
    }

    @Override
    public String exportSchema(SchemaWriter writer, PTable table) throws IOException {
        String schemaId = DefaultSchemaRegistryRepository.getSchemaId(table);
        this.schemaMap.put(schemaId, writer.exportSchema(table));
        return schemaId;
    }

    @Override
    public String getSchemaById(String schemaId) throws IOException {
        return this.schemaMap.get(schemaId);
    }

    @Override
    public String getSchemaByTable(PTable table) throws IOException {
        return this.schemaMap.get(DefaultSchemaRegistryRepository.getSchemaId(table));
    }

    @Override
    public void close() throws IOException {
        this.schemaMap.clear();
    }

    public static String getSchemaId(PTable table) {
        String schemaMetadataName = DefaultSchemaRegistryRepository.getSchemaMetadataName(table);
        String version = table.getSchemaVersion() != null ? table.getSchemaVersion() : (table.getLastDDLTimestamp() != null ? table.getLastDDLTimestamp().toString() : Long.toString(EnvironmentEdgeManager.currentTimeMillis()));
        return String.format("%s*%s", schemaMetadataName, version);
    }

    private static String getSchemaMetadataName(PTable table) {
        String schemaGroup = DefaultSchemaRegistryRepository.getSchemaGroup(table);
        return schemaGroup + SEPARATOR + table.getTableName().getString();
    }

    private static String getSchemaGroup(PTable table) {
        String tenantId = table.getTenantId() != null ? table.getTenantId().getString() : DEFAULT_TENANT_ID;
        String schemaName = table.getSchemaName().getString();
        if (schemaName == null) {
            schemaName = DEFAULT_SCHEMA_NAME;
        }
        return tenantId + SEPARATOR + schemaName;
    }
}

