/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema;

import java.sql.SQLException;
import java.util.Map;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.TTLExpressionFactory;
import org.apache.phoenix.transaction.TransactionFactory;
import org.apache.phoenix.util.SchemaUtil;

public enum TableProperty {
    IMMUTABLE_ROWS("IMMUTABLE_ROWS", true, true, false){

        @Override
        public Object getPTableValue(PTable table) {
            return table.isImmutableRows();
        }
    }
    ,
    MULTI_TENANT("MULTI_TENANT", true, false, false){

        @Override
        public Object getPTableValue(PTable table) {
            return table.isMultiTenant();
        }
    }
    ,
    DISABLE_WAL("DISABLE_WAL", true, false, false){

        @Override
        public Object getPTableValue(PTable table) {
            return table.isWALDisabled();
        }
    }
    ,
    SALT_BUCKETS("SALT_BUCKETS", SQLExceptionCode.COLUMN_FAMILY_NOT_ALLOWED_TABLE_PROPERTY, false, SQLExceptionCode.SALT_ONLY_ON_CREATE_TABLE, false, false){

        @Override
        public Object getPTableValue(PTable table) {
            return table.getBucketNum();
        }
    }
    ,
    DEFAULT_COLUMN_FAMILY("DEFAULT_COLUMN_FAMILY", SQLExceptionCode.COLUMN_FAMILY_NOT_ALLOWED_TABLE_PROPERTY, false, SQLExceptionCode.DEFAULT_COLUMN_FAMILY_ONLY_ON_CREATE_TABLE, false, false){

        @Override
        public Object getPTableValue(PTable table) {
            return table.getDefaultFamilyName();
        }
    }
    ,
    STORE_NULLS("STORE_NULLS", SQLExceptionCode.COLUMN_FAMILY_NOT_ALLOWED_TABLE_PROPERTY, true, false, false){

        @Override
        public Object getPTableValue(PTable table) {
            return table.getStoreNulls();
        }
    }
    ,
    TRANSACTIONAL("TRANSACTIONAL", SQLExceptionCode.COLUMN_FAMILY_NOT_ALLOWED_TABLE_PROPERTY, true, false, false){

        @Override
        public Object getPTableValue(PTable table) {
            return table.isTransactional();
        }
    }
    ,
    TRANSACTION_PROVIDER("TRANSACTION_PROVIDER", SQLExceptionCode.COLUMN_FAMILY_NOT_ALLOWED_TABLE_PROPERTY, true, false, false){

        @Override
        public Object getPTableValue(PTable table) {
            return table.getTransactionProvider();
        }

        @Override
        public Object getValue(Object value) {
            try {
                return value == null ? null : TransactionFactory.Provider.valueOf(value.toString());
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(new SQLExceptionInfo.Builder(SQLExceptionCode.UNKNOWN_TRANSACTION_PROVIDER).setMessage(value.toString()).build().buildException());
            }
        }
    }
    ,
    UPDATE_CACHE_FREQUENCY("UPDATE_CACHE_FREQUENCY", true, true, true){

        @Override
        public Object getValue(Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof String) {
                String strValue = (String)value;
                if ("ALWAYS".equalsIgnoreCase(strValue)) {
                    return 0L;
                }
                if ("NEVER".equalsIgnoreCase(strValue)) {
                    return Long.MAX_VALUE;
                }
                throw new IllegalArgumentException("Table's UPDATE_CACHE_FREQUENCY can only be set to 'ALWAYS', 'NEVER' or a millisecond numeric value.");
            }
            if (value instanceof Integer || value instanceof Long) {
                return ((Number)value).longValue();
            }
            throw new IllegalArgumentException("Table's UPDATE_CACHE_FREQUENCY can only be set to 'ALWAYS', 'NEVER' or a millisecond numeric value.");
        }

        @Override
        public Object getPTableValue(PTable table) {
            return table.getUpdateCacheFrequency();
        }
    }
    ,
    AUTO_PARTITION_SEQ("AUTO_PARTITION_SEQ", SQLExceptionCode.COLUMN_FAMILY_NOT_ALLOWED_TABLE_PROPERTY, false, false, false){

        @Override
        public Object getValue(Object value) {
            return value == null ? null : SchemaUtil.normalizeIdentifier(value.toString());
        }

        @Override
        public Object getPTableValue(PTable table) {
            return table.getAutoPartitionSeqName();
        }
    }
    ,
    APPEND_ONLY_SCHEMA("APPEND_ONLY_SCHEMA", SQLExceptionCode.COLUMN_FAMILY_NOT_ALLOWED_TABLE_PROPERTY, true, true, false){

        @Override
        public Object getPTableValue(PTable table) {
            return table.isAppendOnlySchema();
        }
    }
    ,
    GUIDE_POSTS_WIDTH("GUIDE_POSTS_WIDTH", true, false, false){

        @Override
        public Object getValue(Object value) {
            return value == null ? null : Long.valueOf(((Number)value).longValue());
        }

        @Override
        public Object getPTableValue(PTable table) {
            return null;
        }
    }
    ,
    COLUMN_ENCODED_BYTES("ENCODING_SCHEME", SQLExceptionCode.COLUMN_FAMILY_NOT_ALLOWED_TABLE_PROPERTY, true, false, false){

        @Override
        public Object getValue(Object value) {
            if (value instanceof String) {
                String strValue = (String)value;
                if ("NONE".equalsIgnoreCase(strValue)) {
                    return (byte)0;
                }
            } else {
                return value == null ? null : Byte.valueOf(((Number)value).byteValue());
            }
            return value;
        }

        @Override
        public Object getPTableValue(PTable table) {
            return table.getEncodingScheme();
        }
    }
    ,
    ENCODING_SCHEME("ENCODING_SCHEME", SQLExceptionCode.COLUMN_FAMILY_NOT_ALLOWED_TABLE_PROPERTY, true, false, false){

        @Override
        public Object getValue(Object value) {
            return COLUMN_ENCODED_BYTES.getValue(value);
        }

        @Override
        public Object getPTableValue(PTable table) {
            return table.getEncodingScheme();
        }
    }
    ,
    IMMUTABLE_STORAGE_SCHEME("IMMUTABLE_STORAGE_SCHEME", SQLExceptionCode.COLUMN_FAMILY_NOT_ALLOWED_TABLE_PROPERTY, true, false, false){

        @Override
        public PTable.ImmutableStorageScheme getValue(Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof String) {
                String strValue = (String)value;
                return PTable.ImmutableStorageScheme.valueOf(strValue.toUpperCase());
            }
            throw new IllegalArgumentException("Immutable storage scheme table property must be a string");
        }

        @Override
        public Object getPTableValue(PTable table) {
            return table.getImmutableStorageScheme();
        }
    }
    ,
    USE_STATS_FOR_PARALLELIZATION("USE_STATS_FOR_PARALLELIZATION", true, true, true){

        @Override
        public Object getValue(Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof Boolean) {
                return value;
            }
            throw new IllegalArgumentException("Use stats for parallelization property can only be either true or false");
        }

        @Override
        public Object getPTableValue(PTable table) {
            return table.useStatsForParallelization();
        }
    }
    ,
    TTL("TTL", SQLExceptionCode.COLUMN_FAMILY_NOT_ALLOWED_FOR_PROPERTY, true, true, true){

        @Override
        public Object getValue(Object value) {
            if (value instanceof String) {
                return TTLExpressionFactory.create((String)value);
            }
            if (value != null) {
                int ttlValue = ((Number)value).intValue();
                return TTLExpressionFactory.create(ttlValue);
            }
            return value;
        }

        @Override
        public Object getPTableValue(PTable table) {
            return table.getTTLExpression();
        }
    }
    ,
    CHANGE_DETECTION_ENABLED("CHANGE_DETECTION_ENABLED", true, true, true){

        @Override
        public Object getValue(Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof Boolean) {
                return value;
            }
            throw new IllegalArgumentException("CHANGE_DETECTION_ENABLED property can only be either true or false");
        }

        @Override
        public Object getPTableValue(PTable table) {
            return table.isChangeDetectionEnabled();
        }
    }
    ,
    PHYSICAL_TABLE_NAME("PHYSICAL_TABLE_NAME", SQLExceptionCode.COLUMN_FAMILY_NOT_ALLOWED_TABLE_PROPERTY, true, false, false){

        @Override
        public Object getPTableValue(PTable table) {
            return table.getPhysicalName(true);
        }
    }
    ,
    SCHEMA_VERSION("SCHEMA_VERSION", SQLExceptionCode.COLUMN_FAMILY_NOT_ALLOWED_TABLE_PROPERTY, true, true, true){

        @Override
        public Object getValue(Object value) {
            return value == null ? null : SchemaUtil.normalizeIdentifier(value.toString());
        }

        @Override
        public Object getPTableValue(PTable table) {
            return table.getSchemaVersion();
        }
    }
    ,
    STREAMING_TOPIC_NAME("STREAMING_TOPIC_NAME", SQLExceptionCode.COLUMN_FAMILY_NOT_ALLOWED_TABLE_PROPERTY, true, true, true){

        @Override
        public Object getValue(Object value) {
            return value == null ? null : value.toString();
        }

        @Override
        public Object getPTableValue(PTable table) {
            return table.getStreamingTopicName();
        }
    }
    ,
    INCLUDE("INCLUDE", SQLExceptionCode.COLUMN_FAMILY_NOT_ALLOWED_FOR_PROPERTY, true, false, false){

        @Override
        public Object getPTableValue(PTable table) {
            return table.getCDCIncludeScopes();
        }
    }
    ,
    IS_STRICT_TTL("IS_STRICT_TTL", true, true, true){

        @Override
        public Object getValue(Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof Boolean) {
                return value;
            }
            throw new IllegalArgumentException("IS_STRICT_TTL property can only be of type Boolean");
        }

        @Override
        public Object getPTableValue(PTable table) {
            return table.isStrictTTL();
        }
    };

    private final String propertyName;
    private final SQLExceptionCode colFamSpecifiedException;
    private final boolean isMutable;
    private final SQLExceptionCode mutatingImmutablePropException;
    private final boolean isValidOnView;
    private final boolean isMutableOnView;

    private TableProperty(String propertyName, boolean isMutable, boolean isValidOnView, boolean isMutableOnView) {
        this(propertyName, SQLExceptionCode.COLUMN_FAMILY_NOT_ALLOWED_TABLE_PROPERTY, isMutable, SQLExceptionCode.CANNOT_ALTER_PROPERTY, isValidOnView, isMutableOnView);
    }

    private TableProperty(String propertyName, SQLExceptionCode colFamilySpecifiedException, boolean isMutable, boolean isValidOnView, boolean isMutableOnView) {
        this(propertyName, colFamilySpecifiedException, isMutable, SQLExceptionCode.CANNOT_ALTER_PROPERTY, isValidOnView, isMutableOnView);
    }

    private TableProperty(String propertyName, boolean isMutable, boolean isValidOnView, boolean isMutableOnView, SQLExceptionCode isMutatingException) {
        this(propertyName, SQLExceptionCode.COLUMN_FAMILY_NOT_ALLOWED_TABLE_PROPERTY, isMutable, isMutatingException, isValidOnView, isMutableOnView);
    }

    private TableProperty(String propertyName, SQLExceptionCode colFamSpecifiedException, boolean isMutable, SQLExceptionCode mutatingException, boolean isValidOnView, boolean isMutableOnView) {
        this.propertyName = propertyName;
        this.colFamSpecifiedException = colFamSpecifiedException;
        this.isMutable = isMutable;
        this.mutatingImmutablePropException = mutatingException;
        this.isValidOnView = isValidOnView;
        this.isMutableOnView = isMutableOnView;
    }

    public static boolean isPhoenixTableProperty(String property) {
        try {
            TableProperty.valueOf(property);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    public Object getValue(Object value) {
        return value;
    }

    public Object getValue(Map<String, Object> props) {
        return this.getValue(props.get(this.toString()));
    }

    public void validate(boolean isMutating, boolean isQualified, PTableType tableType) throws SQLException {
        this.checkForColumnFamily(isQualified);
        this.checkIfApplicableForView(tableType);
        this.checkForMutability(isMutating, tableType);
    }

    private void checkForColumnFamily(boolean isQualified) throws SQLException {
        if (isQualified) {
            throw new SQLExceptionInfo.Builder(this.colFamSpecifiedException).setMessage(". Property: " + this.propertyName).build().buildException();
        }
    }

    private void checkForMutability(boolean isMutating, PTableType tableType) throws SQLException {
        if (isMutating && !this.isMutable) {
            throw new SQLExceptionInfo.Builder(this.mutatingImmutablePropException).setMessage(". Property: " + this.propertyName).build().buildException();
        }
        if (isMutating && tableType == PTableType.VIEW && !this.isMutableOnView) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_ALTER_TABLE_PROPERTY_ON_VIEW).setMessage(". Property: " + this.propertyName).build().buildException();
        }
    }

    private void checkIfApplicableForView(PTableType tableType) throws SQLException {
        if (tableType == PTableType.VIEW && !this.isValidOnView) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.VIEW_WITH_PROPERTIES).setMessage("Property: " + this.propertyName).build().buildException();
        }
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public boolean isValidOnView() {
        return this.isValidOnView;
    }

    public boolean isMutable() {
        return this.isMutable;
    }

    public boolean isMutableOnView() {
        return this.isMutableOnView;
    }

    public abstract Object getPTableValue(PTable var1);
}

