/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema;

import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.schema.MetaDataEntityNotFoundException;
import org.apache.phoenix.util.SchemaUtil;

public class TableNotFoundException
extends MetaDataEntityNotFoundException {
    private static final long serialVersionUID = 1L;
    private static SQLExceptionCode code = SQLExceptionCode.TABLE_UNDEFINED;
    private boolean thrownToForceReReadForTransformingTable = false;
    private final long timestamp;

    public TableNotFoundException(TableNotFoundException e, long timestamp) {
        this(e.getSchemaName(), e.getTableName(), timestamp);
    }

    public TableNotFoundException(String tableName) {
        this(SchemaUtil.getSchemaNameFromFullName(tableName), SchemaUtil.getTableNameFromFullName(tableName));
    }

    public TableNotFoundException(String tableName, boolean thrownForForce) {
        this(SchemaUtil.getSchemaNameFromFullName(tableName), SchemaUtil.getTableNameFromFullName(tableName), Long.MAX_VALUE, code, thrownForForce);
    }

    public TableNotFoundException(String schemaName, String tableName) {
        this(schemaName, tableName, Long.MAX_VALUE);
    }

    public TableNotFoundException(String schemaName, String tableName, long timestamp) {
        this(schemaName, tableName, timestamp, code, false);
    }

    public TableNotFoundException(String schemaName, String tableName, long timestamp, SQLExceptionCode code, boolean thrownForForceReRead) {
        super(new SQLExceptionInfo.Builder(code).setSchemaName(schemaName).setTableName(tableName).build().toString(), code.getSQLState(), code.getErrorCode(), schemaName, tableName, null);
        this.timestamp = timestamp;
        this.thrownToForceReReadForTransformingTable = thrownForForceReRead;
    }

    public long getTimeStamp() {
        return this.timestamp;
    }

    public boolean isThrownToForceReReadForTransformingTable() {
        return this.thrownToForceReReadForTransformingTable;
    }
}

