/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema;

import org.apache.hadoop.hbase.CompareOperator;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;

public enum SortOrder {
    ASC(2){

        @Override
        public CompareOperator transform(CompareOperator op) {
            return op;
        }

        @Override
        public byte normalize(byte b) {
            return b;
        }
    }
    ,
    DESC(1){

        @Override
        public CompareOperator transform(CompareOperator op) {
            switch (op) {
                case EQUAL: {
                    return op;
                }
                case NOT_EQUAL: {
                    return op;
                }
                case NO_OP: {
                    return op;
                }
                case GREATER: {
                    return CompareOperator.LESS;
                }
                case GREATER_OR_EQUAL: {
                    return CompareOperator.LESS_OR_EQUAL;
                }
                case LESS: {
                    return CompareOperator.GREATER;
                }
                case LESS_OR_EQUAL: {
                    return CompareOperator.GREATER_OR_EQUAL;
                }
            }
            throw new IllegalArgumentException("Add the missing case statement!");
        }

        @Override
        public byte normalize(byte b) {
            return SortOrder.invert(b);
        }
    };

    private final int serializationId;

    public static SortOrder getDefault() {
        return ASC;
    }

    public static byte[] invert(byte[] src, int srcOffset, byte[] dest, int dstOffset, int length) {
        Preconditions.checkNotNull((Object)src);
        Preconditions.checkNotNull((Object)dest);
        for (int i = 0; i < length; ++i) {
            dest[dstOffset + i] = (byte)(src[srcOffset + i] ^ 0xFF);
        }
        return dest;
    }

    public static byte[] invert(byte[] src, int srcOffset, int length) {
        return SortOrder.invert(src, srcOffset, new byte[length], 0, length);
    }

    public static byte invert(byte b) {
        return (byte)(b ^ 0xFF);
    }

    public static SortOrder fromDDLValue(String sortOrder) {
        Preconditions.checkArgument((sortOrder != null ? 1 : 0) != 0);
        if (sortOrder.equalsIgnoreCase("ASC")) {
            return ASC;
        }
        if (sortOrder.equalsIgnoreCase("DESC")) {
            return DESC;
        }
        throw new IllegalArgumentException("Unknown SortOrder: " + sortOrder);
    }

    public static SortOrder fromSystemValue(int value) {
        for (SortOrder mod : SortOrder.values()) {
            if (mod.getSystemValue() != value) continue;
            return mod;
        }
        return SortOrder.getDefault();
    }

    private SortOrder(int serializationId) {
        this.serializationId = serializationId;
    }

    public int getSystemValue() {
        return this.serializationId;
    }

    public abstract CompareOperator transform(CompareOperator var1);

    public abstract byte normalize(byte var1);
}

