/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.PDatum;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PVarbinaryEncoded;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.JacksonUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RowKeyValueAccessor
implements Writable {
    private static final Logger LOGGER = LoggerFactory.getLogger(RowKeyValueAccessor.class);
    private int index = -1;
    private int[] offsets;
    private ListOfEncodedTypeFlags[] listOfEncodedTypesLists;
    private SortOrderList[] sortOrderLists;
    private boolean isFixedLength;
    private boolean hasSeparator;

    public RowKeyValueAccessor() {
    }

    public RowKeyValueAccessor(List<? extends PDatum> data, int index) {
        this.index = index;
        int[] offsets = new int[data.size()];
        ListOfEncodedTypeFlags[] listOfEncodedTypesLists = new ListOfEncodedTypeFlags[data.size()];
        SortOrderList[] sortOrderLists = new SortOrderList[data.size()];
        int nOffsets = 0;
        Iterator<? extends PDatum> iterator = data.iterator();
        PDatum datum = iterator.next();
        int pos = 0;
        while (pos < index) {
            SortOrderList sortOrders;
            ListOfEncodedTypeFlags encodedTypesLists;
            int offset = 0;
            if (datum.getDataType().isFixedWidth()) {
                encodedTypesLists = new ListOfEncodedTypeFlags();
                sortOrders = new SortOrderList();
                do {
                    encodedTypesLists.addBinaryEncodedDataTypes(false);
                    sortOrders.addSortOrderAsc(datum.getSortOrder() == SortOrder.ASC);
                    Integer maxLength = datum.getDataType().getByteSize();
                    offset += (maxLength == null ? datum.getMaxLength() : maxLength).intValue();
                    datum = iterator.next();
                } while (++pos < index && datum.getDataType().isFixedWidth());
                offsets[nOffsets] = offset;
                listOfEncodedTypesLists[nOffsets] = encodedTypesLists;
                sortOrderLists[nOffsets++] = sortOrders;
                continue;
            }
            encodedTypesLists = new ListOfEncodedTypeFlags();
            sortOrders = new SortOrderList();
            do {
                encodedTypesLists.addBinaryEncodedDataTypes(datum.getDataType() == PVarbinaryEncoded.INSTANCE);
                sortOrders.addSortOrderAsc(datum.getSortOrder() == SortOrder.ASC);
                ++offset;
                datum = iterator.next();
            } while (++pos < index && !datum.getDataType().isFixedWidth());
            offsets[nOffsets] = -offset;
            listOfEncodedTypesLists[nOffsets] = encodedTypesLists;
            sortOrderLists[nOffsets++] = sortOrders;
        }
        if (nOffsets < offsets.length) {
            this.offsets = Arrays.copyOf(offsets, nOffsets);
            this.listOfEncodedTypesLists = Arrays.copyOf(listOfEncodedTypesLists, nOffsets);
            this.sortOrderLists = Arrays.copyOf(sortOrderLists, nOffsets);
        } else {
            this.offsets = offsets;
            this.listOfEncodedTypesLists = listOfEncodedTypesLists;
            this.sortOrderLists = sortOrderLists;
        }
        this.isFixedLength = datum.getDataType().isFixedWidth();
        this.hasSeparator = !this.isFixedLength && iterator.hasNext();
    }

    RowKeyValueAccessor(int[] offsets, boolean isFixedLength, boolean hasSeparator) {
        this.offsets = offsets;
        this.isFixedLength = isFixedLength;
        this.hasSeparator = hasSeparator;
    }

    public int getIndex() {
        return this.index;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.hasSeparator ? 1231 : 1237);
        result = 31 * result + (this.isFixedLength ? 1231 : 1237);
        result = 31 * result + Arrays.hashCode(this.offsets);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RowKeyValueAccessor other = (RowKeyValueAccessor)obj;
        if (this.hasSeparator != other.hasSeparator) {
            return false;
        }
        if (this.isFixedLength != other.isFixedLength) {
            return false;
        }
        return Arrays.equals(this.offsets, other.offsets);
    }

    public String toString() {
        return "RowKeyValueAccessor [offsets=" + Arrays.toString(this.offsets) + ", isFixedLength=" + this.isFixedLength + ", hasSeparator=" + this.hasSeparator + "]";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void readFields(DataInput input) throws IOException {
        int length = WritableUtils.readVInt((DataInput)input);
        this.hasSeparator = (length & 2) != 0;
        this.isFixedLength = (length & 1) != 0;
        this.offsets = ByteUtil.deserializeVIntArray(input, length >>= 2);
        this.listOfEncodedTypesLists = null;
        this.sortOrderLists = null;
        if (input instanceof DataInputBuffer) {
            int len;
            DataInputBuffer dataInputBuffer = (DataInputBuffer)input;
            int offset = dataInputBuffer.getPosition();
            if (offset + QueryConstants.ROW_KEY_VAL_ACCESSOR_NEW_FIELDS_SEPARATOR.length > (len = dataInputBuffer.getLength())) {
                return;
            }
            byte[] data = dataInputBuffer.getData();
            if (!Bytes.equals((byte[])data, (int)offset, (int)QueryConstants.ROW_KEY_VAL_ACCESSOR_NEW_FIELDS_SEPARATOR.length, (byte[])QueryConstants.ROW_KEY_VAL_ACCESSOR_NEW_FIELDS_SEPARATOR, (int)0, (int)QueryConstants.ROW_KEY_VAL_ACCESSOR_NEW_FIELDS_SEPARATOR.length)) {
                return;
            }
        } else {
            if (!(input instanceof DataInputStream)) {
                LOGGER.error("Type of DataInput is neither DataInputBuffer nor DataInputStream. This is not expected. Do not attempt deserialization of binaryEncodedTypesLists and sortOrderLists for compatibility purpose. input: {}", (Object)input);
                return;
            }
            DataInputStream dataInputStream = (DataInputStream)input;
            if (!dataInputStream.markSupported()) {
                LOGGER.warn("DataInputStream {} does not support mark.", (Object)dataInputStream);
                return;
            }
            dataInputStream.mark(QueryConstants.ROW_KEY_VAL_ACCESSOR_NEW_FIELDS_SEPARATOR.length * 1000);
            byte[] data = new byte[QueryConstants.ROW_KEY_VAL_ACCESSOR_NEW_FIELDS_SEPARATOR.length];
            try {
                int bytesRead = dataInputStream.read(data);
                if (bytesRead != QueryConstants.ROW_KEY_VAL_ACCESSOR_NEW_FIELDS_SEPARATOR.length) {
                    dataInputStream.reset();
                    return;
                }
            }
            catch (IOException e) {
                dataInputStream.reset();
                return;
            }
            if (!Bytes.equals((byte[])data, (int)0, (int)QueryConstants.ROW_KEY_VAL_ACCESSOR_NEW_FIELDS_SEPARATOR.length, (byte[])QueryConstants.ROW_KEY_VAL_ACCESSOR_NEW_FIELDS_SEPARATOR, (int)0, (int)QueryConstants.ROW_KEY_VAL_ACCESSOR_NEW_FIELDS_SEPARATOR.length)) {
                dataInputStream.reset();
                return;
            }
            dataInputStream.reset();
        }
        byte[] bytes = new byte[QueryConstants.ROW_KEY_VAL_ACCESSOR_NEW_FIELDS_SEPARATOR.length];
        input.readFully(bytes, 0, bytes.length);
        int binaryEncodedTypesListsLen = WritableUtils.readVInt((DataInput)input);
        if (binaryEncodedTypesListsLen == 0) {
            this.listOfEncodedTypesLists = new ListOfEncodedTypeFlags[0];
        } else {
            byte[] binaryEncodedTypesListsBytes = new byte[binaryEncodedTypesListsLen];
            input.readFully(binaryEncodedTypesListsBytes, 0, binaryEncodedTypesListsLen);
            this.listOfEncodedTypesLists = (ListOfEncodedTypeFlags[])JacksonUtil.getObjectReader().readValue(binaryEncodedTypesListsBytes, ListOfEncodedTypeFlags[].class);
        }
        int sortOrderListsLen = WritableUtils.readVInt((DataInput)input);
        if (sortOrderListsLen == 0) {
            this.sortOrderLists = new SortOrderList[0];
            return;
        }
        byte[] sortOrdersListsBytes = new byte[sortOrderListsLen];
        input.readFully(sortOrdersListsBytes, 0, sortOrderListsLen);
        this.sortOrderLists = (SortOrderList[])JacksonUtil.getObjectReader().readValue(sortOrdersListsBytes, SortOrderList[].class);
    }

    public void write(DataOutput output) throws IOException {
        int length = this.offsets.length << 2;
        ByteUtil.serializeVIntArray(output, this.offsets, length |= (this.hasSeparator ? 2 : 0) | (this.isFixedLength ? 1 : 0));
        output.write(QueryConstants.ROW_KEY_VAL_ACCESSOR_NEW_FIELDS_SEPARATOR);
        if (this.listOfEncodedTypesLists.length == 0) {
            WritableUtils.writeVInt((DataOutput)output, (int)0);
        } else {
            byte[] binaryEncodedTypesListsBytes = JacksonUtil.getObjectWriter().writeValueAsBytes((Object)this.listOfEncodedTypesLists);
            WritableUtils.writeVInt((DataOutput)output, (int)binaryEncodedTypesListsBytes.length);
            if (binaryEncodedTypesListsBytes.length > 0) {
                output.write(binaryEncodedTypesListsBytes);
            }
        }
        if (this.sortOrderLists.length == 0) {
            WritableUtils.writeVInt((DataOutput)output, (int)0);
        } else {
            byte[] sortOrdersListsBytes = JacksonUtil.getObjectWriter().writeValueAsBytes((Object)this.sortOrderLists);
            WritableUtils.writeVInt((DataOutput)output, (int)sortOrdersListsBytes.length);
            if (sortOrdersListsBytes.length > 0) {
                output.write(sortOrdersListsBytes);
            }
        }
    }

    private static boolean isSeparatorByte(byte b) {
        return b == 0 || b == QueryConstants.DESC_SEPARATOR_BYTE;
    }

    public int getOffset(byte[] keyBuffer, int keyOffset) {
        if (this.listOfEncodedTypesLists == null && this.sortOrderLists == null) {
            return this.getOffsetWithNullTypeAndOrderInfo(keyBuffer, keyOffset);
        }
        for (int i = 0; i < this.offsets.length; ++i) {
            int offset = this.offsets[i];
            ListOfEncodedTypeFlags binaryEncodedTypesList = this.listOfEncodedTypesLists[i];
            SortOrderList sortOrderList = this.sortOrderLists[i];
            if (offset >= 0) {
                keyOffset += offset;
                continue;
            }
            int pos = 0;
            while (offset++ < 0) {
                boolean isVarBinaryEncoded = binaryEncodedTypesList.getBinaryEncodedDataTypes().get(pos);
                boolean sortOrderAsc = sortOrderList.getSortOrderAsc().get(pos++);
                if (!isVarBinaryEncoded) {
                    while (keyOffset < keyBuffer.length && !RowKeyValueAccessor.isSeparatorByte(keyBuffer[keyOffset++])) {
                    }
                    continue;
                }
                while (keyOffset < keyBuffer.length && !SchemaUtil.areSeparatorBytesForVarBinaryEncoded(keyBuffer, keyOffset++, sortOrderAsc ? SortOrder.ASC : SortOrder.DESC)) {
                }
                if (keyOffset >= keyBuffer.length) continue;
                ++keyOffset;
            }
        }
        return keyOffset;
    }

    public int getOffsetWithNullTypeAndOrderInfo(byte[] keyBuffer, int keyOffset) {
        for (int offset : this.offsets) {
            if (offset >= 0) {
                keyOffset += offset;
                continue;
            }
            while (offset++ < 0) {
                while (keyOffset < keyBuffer.length && !RowKeyValueAccessor.isSeparatorByte(keyBuffer[keyOffset++])) {
                }
            }
        }
        return keyOffset;
    }

    public int getLength(byte[] keyBuffer, int keyOffset, int maxOffset, PDataType type, SortOrder sortOrder) {
        int offset;
        if (!this.hasSeparator) {
            if (type == PVarbinaryEncoded.INSTANCE) {
                if (sortOrder == null || sortOrder == SortOrder.ASC) {
                    return maxOffset - keyOffset;
                }
                if (sortOrder == SortOrder.DESC) {
                    return maxOffset - keyOffset - 2;
                }
            } else {
                return maxOffset - keyOffset - (keyBuffer[maxOffset - 1] == QueryConstants.DESC_SEPARATOR_BYTE ? 1 : 0);
            }
        }
        if (type == PVarbinaryEncoded.INSTANCE) {
            for (offset = keyOffset; offset < maxOffset && !SchemaUtil.areSeparatorBytesForVarBinaryEncoded(keyBuffer, offset, sortOrder); ++offset) {
            }
        } else {
            while (offset < maxOffset && !RowKeyValueAccessor.isSeparatorByte(keyBuffer[offset])) {
                ++offset;
            }
        }
        return offset - keyOffset;
    }

    static class SortOrderList {
        private final List<Boolean> sortOrderAsc = new ArrayList<Boolean>();

        SortOrderList() {
        }

        public void addSortOrderAsc(boolean val) {
            this.sortOrderAsc.add(val);
        }

        public List<Boolean> getSortOrderAsc() {
            return this.sortOrderAsc;
        }
    }

    static class ListOfEncodedTypeFlags {
        private final List<Boolean> binaryEncodedDataTypes = new ArrayList<Boolean>();

        ListOfEncodedTypeFlags() {
        }

        public void addBinaryEncodedDataTypes(boolean val) {
            this.binaryEncodedDataTypes.add(val);
        }

        public List<Boolean> getBinaryEncodedDataTypes() {
            return this.binaryEncodedDataTypes;
        }
    }
}

