/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema;

import java.io.DataOutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.hbase.index.covered.update.ColumnReference;
import org.apache.phoenix.hbase.index.util.KeyValueBuilder;
import org.apache.phoenix.index.IndexMaintainer;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.schema.AmbiguousColumnException;
import org.apache.phoenix.schema.ColumnFamilyNotFoundException;
import org.apache.phoenix.schema.ColumnNotFoundException;
import org.apache.phoenix.schema.ColumnValueDecoder;
import org.apache.phoenix.schema.ColumnValueEncoder;
import org.apache.phoenix.schema.CompiledTTLExpression;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PColumnFamily;
import org.apache.phoenix.schema.PIndexState;
import org.apache.phoenix.schema.PMetaDataEntity;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PRow;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.RowKeySchema;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.TTLExpression;
import org.apache.phoenix.schema.transform.TransformMaintainer;
import org.apache.phoenix.schema.types.PArrayDataType;
import org.apache.phoenix.schema.types.PArrayDataTypeDecoder;
import org.apache.phoenix.schema.types.PArrayDataTypeEncoder;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;
import org.apache.phoenix.transaction.TransactionFactory;
import org.apache.phoenix.util.EncodedColumnsUtil;
import org.apache.phoenix.util.TrustedByteArrayOutputStream;

public interface PTable
extends PMetaDataEntity {
    public static final long INITIAL_SEQ_NUM = 0L;
    public static final String IS_IMMUTABLE_ROWS_PROP_NAME = "IMMUTABLE_ROWS";
    public static final boolean DEFAULT_DISABLE_WAL = false;
    public static final boolean DEFAULT_IMMUTABLE_ROWS = false;
    public static final Integer NO_SALTING = -1;
    public static final boolean DEFAULT_IS_STRICT_TTL = true;

    public long getTimeStamp();

    public long getSequenceNumber();

    public long getIndexDisableTimestamp();

    public boolean isIndexStateDisabled();

    public PName getName();

    public PName getSchemaName();

    public PName getTableName();

    public PName getTenantId();

    public PTableType getType();

    public PName getPKName();

    public List<PColumn> getPKColumns();

    public List<PColumn> getColumns();

    public List<PColumn> getExcludedColumns();

    public List<PColumnFamily> getColumnFamilies();

    public boolean hasOnlyPkColumns();

    public PColumnFamily getColumnFamily(byte[] var1) throws ColumnFamilyNotFoundException;

    public PColumnFamily getColumnFamily(String var1) throws ColumnFamilyNotFoundException;

    public PColumn getColumnForColumnName(String var1) throws ColumnNotFoundException, AmbiguousColumnException;

    public PColumn getColumnForColumnQualifier(byte[] var1, byte[] var2) throws ColumnNotFoundException, AmbiguousColumnException;

    public PColumn getPKColumn(String var1) throws ColumnNotFoundException;

    public PRow newRow(KeyValueBuilder var1, long var2, ImmutableBytesWritable var4, boolean var5, byte[] ... var6);

    public PRow newRow(KeyValueBuilder var1, ImmutableBytesWritable var2, boolean var3, byte[] ... var4);

    public int newKey(ImmutableBytesWritable var1, byte[][] var2);

    public RowKeySchema getRowKeySchema();

    public Integer getBucketNum();

    public List<PTable> getIndexes();

    public PTable getTransformingNewTable();

    public PIndexState getIndexState();

    public PName getParentName();

    public PName getParentTableName();

    public PName getBaseTableLogicalName();

    public PName getParentSchemaName();

    public List<PName> getPhysicalNames();

    public PName getPhysicalName();

    public PName getPhysicalName(boolean var1);

    public boolean isImmutableRows();

    public boolean getIndexMaintainers(ImmutableBytesWritable var1, PhoenixConnection var2) throws SQLException;

    public IndexMaintainer getIndexMaintainer(PTable var1, PhoenixConnection var2) throws SQLException;

    public IndexMaintainer getIndexMaintainer(PTable var1, PTable var2, PhoenixConnection var3) throws SQLException;

    public TransformMaintainer getTransformMaintainer(PTable var1, PhoenixConnection var2);

    public PName getDefaultFamilyName();

    public boolean isWALDisabled();

    public boolean isMultiTenant();

    public boolean getStoreNulls();

    public boolean isTransactional();

    public TransactionFactory.Provider getTransactionProvider();

    public ViewType getViewType();

    public String getViewStatement();

    public Long getViewIndexId();

    public PDataType getviewIndexIdType();

    public PTableKey getKey();

    public IndexType getIndexType();

    public int getBaseColumnCount();

    public boolean rowKeyOrderOptimizable();

    public int getRowTimestampColPos();

    public long getUpdateCacheFrequency();

    public boolean isNamespaceMapped();

    public String getAutoPartitionSeqName();

    public boolean isAppendOnlySchema();

    public ImmutableStorageScheme getImmutableStorageScheme();

    public QualifierEncodingScheme getEncodingScheme();

    public EncodedCQCounter getEncodedCQCounter();

    public Boolean useStatsForParallelization();

    public boolean hasViewModifiedUpdateCacheFrequency();

    public boolean hasViewModifiedUseStatsForParallelization();

    public Map<String, String> getPropertyValues();

    public Map<String, String> getDefaultPropertyValues();

    public TTLExpression getTTLExpression();

    public CompiledTTLExpression getCompiledTTLExpression(PhoenixConnection var1) throws SQLException;

    public boolean hasConditionalTTL();

    public Long getLastDDLTimestamp();

    public boolean isChangeDetectionEnabled();

    public boolean isStrictTTL();

    public String getSchemaVersion();

    public String getExternalSchemaId();

    public String getStreamingTopicName();

    public Set<CDCChangeScope> getCDCIncludeScopes();

    public String getIndexWhere();

    public Map<PTableKey, Long> getAncestorLastDDLTimestampMap();

    public Expression getIndexWhereExpression(PhoenixConnection var1) throws SQLException;

    public Set<ColumnReference> getIndexWhereColumns(PhoenixConnection var1) throws SQLException;

    public byte[] getRowKeyMatcher();

    public static enum CDCChangeScope {
        CHANGE,
        PRE,
        POST;

    }

    public static class EncodedCQCounter {
        private final Map<String, Integer> familyCounters = new HashMap<String, Integer>();
        public static final EncodedCQCounter NULL_COUNTER = new EncodedCQCounter(){

            @Override
            public Integer getNextQualifier(String columnFamily) {
                return null;
            }

            @Override
            public void setValue(String columnFamily, Integer value) {
            }

            @Override
            public boolean increment(String columnFamily) {
                return false;
            }

            @Override
            public Map<String, Integer> values() {
                return Collections.emptyMap();
            }
        };

        public static EncodedCQCounter copy(EncodedCQCounter counterToCopy) {
            EncodedCQCounter cqCounter = new EncodedCQCounter();
            for (Map.Entry<String, Integer> e : counterToCopy.values().entrySet()) {
                cqCounter.setValue(e.getKey(), e.getValue());
            }
            return cqCounter;
        }

        @Nullable
        public Integer getNextQualifier(String columnFamily) {
            Integer counter = this.familyCounters.get(columnFamily);
            if (counter == null) {
                counter = 11;
                this.familyCounters.put(columnFamily, counter);
            }
            return counter;
        }

        public void setValue(String columnFamily, Integer value) {
            this.familyCounters.put(columnFamily, value);
        }

        public boolean increment(String columnFamily) {
            if (columnFamily == null) {
                return false;
            }
            Integer counter = this.familyCounters.get(columnFamily);
            if (counter == null) {
                counter = 11;
            }
            Integer n = counter;
            Integer n2 = counter = Integer.valueOf(counter + 1);
            this.familyCounters.put(columnFamily, counter);
            return true;
        }

        public Map<String, Integer> values() {
            return Collections.unmodifiableMap(this.familyCounters);
        }
    }

    public static interface QualifierEncoderDecoder {
        public byte[] encode(int var1);

        public int decode(byte[] var1);

        public int decode(byte[] var1, int var2, int var3);

        public Integer getMaxQualifier();
    }

    public static enum QualifierEncodingScheme implements QualifierEncoderDecoder
    {
        NON_ENCODED_QUALIFIERS(0, null){

            @Override
            public byte[] encode(int value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int decode(byte[] bytes) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int decode(byte[] bytes, int offset, int length) {
                throw new UnsupportedOperationException();
            }

            public String toString() {
                return this.name();
            }
        }
        ,
        ONE_BYTE_QUALIFIERS(1, 255){
            private final int c = Math.abs(-128);

            @Override
            public byte[] encode(int value) {
                if (EncodedColumnsUtil.isReservedColumnQualifier(value)) {
                    return FOUR_BYTE_QUALIFIERS.encode(value);
                }
                if (value < 0 || value > this.maxQualifier) {
                    throw new QualifierOutOfRangeException(0, this.maxQualifier);
                }
                return new byte[]{(byte)(value - this.c)};
            }

            @Override
            public int decode(byte[] bytes) {
                if (bytes.length == 4) {
                    return QualifierEncodingScheme.getReservedQualifier(bytes);
                }
                if (bytes.length != 1) {
                    throw new InvalidQualifierBytesException(1, bytes.length);
                }
                return bytes[0] + this.c;
            }

            @Override
            public int decode(byte[] bytes, int offset, int length) {
                if (length == 4) {
                    return QualifierEncodingScheme.getReservedQualifier(bytes, offset, length);
                }
                if (length != 1) {
                    throw new InvalidQualifierBytesException(1, length);
                }
                return bytes[offset] + this.c;
            }

            public String toString() {
                return this.name();
            }
        }
        ,
        TWO_BYTE_QUALIFIERS(2, 65535){
            private final int c = Math.abs(Short.MIN_VALUE);

            @Override
            public byte[] encode(int value) {
                if (EncodedColumnsUtil.isReservedColumnQualifier(value)) {
                    return FOUR_BYTE_QUALIFIERS.encode(value);
                }
                if (value < 0 || value > this.maxQualifier) {
                    throw new QualifierOutOfRangeException(0, this.maxQualifier);
                }
                return Bytes.toBytes((short)((short)(value - this.c)));
            }

            @Override
            public int decode(byte[] bytes) {
                if (bytes.length == 4) {
                    return QualifierEncodingScheme.getReservedQualifier(bytes);
                }
                if (bytes.length != 2) {
                    throw new InvalidQualifierBytesException(2, bytes.length);
                }
                return Bytes.toShort((byte[])bytes) + this.c;
            }

            @Override
            public int decode(byte[] bytes, int offset, int length) {
                if (length == 4) {
                    return QualifierEncodingScheme.getReservedQualifier(bytes, offset, length);
                }
                if (length != 2) {
                    throw new InvalidQualifierBytesException(2, length);
                }
                return Bytes.toShort((byte[])bytes, (int)offset, (int)length) + this.c;
            }

            public String toString() {
                return this.name();
            }
        }
        ,
        THREE_BYTE_QUALIFIERS(3, 0xFFFFFF){

            @Override
            public byte[] encode(int value) {
                if (EncodedColumnsUtil.isReservedColumnQualifier(value)) {
                    return FOUR_BYTE_QUALIFIERS.encode(value);
                }
                if (value < 0 || value > this.maxQualifier) {
                    throw new QualifierOutOfRangeException(0, this.maxQualifier);
                }
                byte[] arr = Bytes.toBytes((int)value);
                return new byte[]{arr[1], arr[2], arr[3]};
            }

            @Override
            public int decode(byte[] bytes) {
                if (bytes.length == 4) {
                    return QualifierEncodingScheme.getReservedQualifier(bytes);
                }
                if (bytes.length != 3) {
                    throw new InvalidQualifierBytesException(2, bytes.length);
                }
                byte[] toReturn = new byte[4];
                toReturn[1] = bytes[0];
                toReturn[2] = bytes[1];
                toReturn[3] = bytes[2];
                return Bytes.toInt((byte[])toReturn);
            }

            @Override
            public int decode(byte[] bytes, int offset, int length) {
                if (length == 4) {
                    return QualifierEncodingScheme.getReservedQualifier(bytes, offset, length);
                }
                if (length != 3) {
                    throw new InvalidQualifierBytesException(3, length);
                }
                byte[] toReturn = new byte[4];
                toReturn[1] = bytes[offset];
                toReturn[2] = bytes[offset + 1];
                toReturn[3] = bytes[offset + 2];
                return Bytes.toInt((byte[])toReturn);
            }

            public String toString() {
                return this.name();
            }
        }
        ,
        FOUR_BYTE_QUALIFIERS(4, Integer.MAX_VALUE){

            @Override
            public byte[] encode(int value) {
                if (value < 0) {
                    throw new QualifierOutOfRangeException(0, this.maxQualifier);
                }
                return Bytes.toBytes((int)value);
            }

            @Override
            public int decode(byte[] bytes) {
                if (bytes.length != 4) {
                    throw new InvalidQualifierBytesException(4, bytes.length);
                }
                return Bytes.toInt((byte[])bytes);
            }

            @Override
            public int decode(byte[] bytes, int offset, int length) {
                if (length != 4) {
                    throw new InvalidQualifierBytesException(4, length);
                }
                return Bytes.toInt((byte[])bytes, (int)offset, (int)length);
            }

            public String toString() {
                return this.name();
            }
        };

        final byte metadataValue;
        final Integer maxQualifier;

        public byte getSerializedMetadataValue() {
            return this.metadataValue;
        }

        public static QualifierEncodingScheme fromSerializedValue(byte serializedValue) {
            if (serializedValue < 0 || serializedValue >= QualifierEncodingScheme.values().length) {
                return null;
            }
            return QualifierEncodingScheme.values()[serializedValue];
        }

        @Override
        public Integer getMaxQualifier() {
            return this.maxQualifier;
        }

        private QualifierEncodingScheme(byte serializedMetadataValue, Integer maxQualifier) {
            this.metadataValue = serializedMetadataValue;
            this.maxQualifier = maxQualifier;
        }

        private static int getReservedQualifier(byte[] bytes) {
            Preconditions.checkArgument((bytes.length == 4 ? 1 : 0) != 0);
            int number = FOUR_BYTE_QUALIFIERS.decode(bytes);
            if (!EncodedColumnsUtil.isReservedColumnQualifier(number)) {
                throw new InvalidQualifierBytesException(4, bytes.length);
            }
            return number;
        }

        private static int getReservedQualifier(byte[] bytes, int offset, int length) {
            Preconditions.checkArgument((length == 4 ? 1 : 0) != 0);
            int number = FOUR_BYTE_QUALIFIERS.decode(bytes, offset, length);
            if (!EncodedColumnsUtil.isReservedColumnQualifier(number)) {
                throw new InvalidQualifierBytesException(4, length);
            }
            return number;
        }

        @VisibleForTesting
        public static class InvalidQualifierBytesException
        extends RuntimeException {
            public InvalidQualifierBytesException(int expectedLength, int actualLength) {
                super("Invalid number of qualifier bytes. Expected length: " + expectedLength + ". Actual: " + actualLength);
            }
        }

        @VisibleForTesting
        public static class QualifierOutOfRangeException
        extends RuntimeException {
            public QualifierOutOfRangeException(int minQualifier, int maxQualifier) {
                super("Qualifier out of range (" + minQualifier + ", " + maxQualifier + ")");
            }
        }
    }

    public static interface ColumnValueEncoderDecoderSupplier {
        public ColumnValueEncoder getEncoder(int var1);

        public ColumnValueDecoder getDecoder();
    }

    public static enum ImmutableStorageScheme implements ColumnValueEncoderDecoderSupplier
    {
        ONE_CELL_PER_COLUMN(1){

            @Override
            public ColumnValueEncoder getEncoder(int numElements) {
                throw new UnsupportedOperationException();
            }

            @Override
            public ColumnValueDecoder getDecoder() {
                throw new UnsupportedOperationException();
            }
        }
        ,
        SINGLE_CELL_ARRAY_WITH_OFFSETS(2, 3){

            @Override
            public ColumnValueEncoder getEncoder(int numElements) {
                PVarbinary type = PVarbinary.INSTANCE;
                int estimatedSize = PArrayDataType.estimateSize(numElements, type);
                TrustedByteArrayOutputStream byteStream = new TrustedByteArrayOutputStream(estimatedSize);
                DataOutputStream oStream = new DataOutputStream(byteStream);
                return new PArrayDataTypeEncoder(byteStream, oStream, numElements, (PDataType)type, SortOrder.ASC, false, this.getSerializationVersion());
            }

            @Override
            public ColumnValueDecoder getDecoder() {
                return new PArrayDataTypeDecoder();
            }
        };

        private final byte serializedValue;
        private byte serializationVersion;

        private ImmutableStorageScheme(byte serializedValue) {
            this.serializedValue = serializedValue;
        }

        private ImmutableStorageScheme(byte serializedValue, byte serializationVersion) {
            this.serializedValue = serializedValue;
            this.serializationVersion = serializationVersion;
        }

        public byte getSerializedMetadataValue() {
            return this.serializedValue;
        }

        public byte getSerializationVersion() {
            return this.serializationVersion;
        }

        @VisibleForTesting
        void setSerializationVersion(byte serializationVersion) {
            this.serializationVersion = serializationVersion;
        }

        public static ImmutableStorageScheme fromSerializedValue(byte serializedValue) {
            if (serializedValue < 1 || serializedValue > ImmutableStorageScheme.values().length) {
                return null;
            }
            return ImmutableStorageScheme.values()[serializedValue - 1];
        }
    }

    public static enum TransformStatus {
        CREATED{

            public String toString() {
                return "CREATED";
            }
        }
        ,
        STARTED{

            public String toString() {
                return "STARTED";
            }
        }
        ,
        PENDING_CUTOVER{

            public String toString() {
                return "PENDING_CUTOVER";
            }
        }
        ,
        COMPLETED{

            public String toString() {
                return "COMPLETED";
            }
        }
        ,
        FAILED{

            public String toString() {
                return "FAILED";
            }
        }
        ,
        PAUSED{

            public String toString() {
                return "PAUSED";
            }
        };

    }

    public static enum TransformType {
        METADATA_TRANSFORM(1),
        METADATA_TRANSFORM_PARTIAL(2);

        private final byte[] byteValue;
        private final int serializedValue;

        private TransformType(int serializedValue) {
            this.serializedValue = serializedValue;
            this.byteValue = Bytes.toBytes((String)this.name());
        }

        public byte[] getBytes() {
            return this.byteValue;
        }

        public int getSerializedValue() {
            return this.serializedValue;
        }

        public static TransformType getDefault() {
            return METADATA_TRANSFORM;
        }

        public static TransformType fromSerializedValue(int serializedValue) {
            if (serializedValue < 1 || serializedValue > TransformType.values().length) {
                throw new IllegalArgumentException("Invalid TransformType " + serializedValue);
            }
            return TransformType.values()[serializedValue - 1];
        }

        public static TransformType getPartialTransform(TransformType transformType) {
            if (transformType == METADATA_TRANSFORM) {
                return METADATA_TRANSFORM_PARTIAL;
            }
            return null;
        }

        public static boolean isPartialTransform(TransformType transformType) {
            ArrayList<TransformType> partials = new ArrayList<TransformType>();
            partials.add(METADATA_TRANSFORM_PARTIAL);
            return partials.contains((Object)transformType);
        }
    }

    public static enum TaskStatus {
        CREATED{

            public String toString() {
                return "CREATED";
            }
        }
        ,
        STARTED{

            public String toString() {
                return "STARTED";
            }
        }
        ,
        COMPLETED{

            public String toString() {
                return "COMPLETED";
            }
        }
        ,
        FAILED{

            public String toString() {
                return "FAILED";
            }
        }
        ,
        RETRY{

            public String toString() {
                return "RETRY";
            }
        };

    }

    public static enum TaskType {
        DROP_CHILD_VIEWS(1),
        INDEX_REBUILD(2),
        TRANSFORM_MONITOR(3),
        CDC_STREAM_PARTITION(4);

        private final byte[] byteValue;
        private final byte serializedValue;

        private TaskType(byte serializedValue) {
            this.serializedValue = serializedValue;
            this.byteValue = Bytes.toBytes((String)this.name());
        }

        public byte[] getBytes() {
            return this.byteValue;
        }

        public byte getSerializedValue() {
            return this.serializedValue;
        }

        public static TaskType getDefault() {
            return DROP_CHILD_VIEWS;
        }

        public static TaskType fromSerializedValue(byte serializedValue) {
            if (serializedValue < 1 || serializedValue > TaskType.values().length) {
                throw new IllegalArgumentException("Invalid TaskType " + serializedValue);
            }
            return TaskType.values()[serializedValue - 1];
        }
    }

    public static enum LinkType {
        INDEX_TABLE(1),
        PHYSICAL_TABLE(2),
        PARENT_TABLE(3),
        CHILD_TABLE(4),
        EXCLUDED_COLUMN(5),
        VIEW_INDEX_PARENT_TABLE(6),
        TRANSFORMING_NEW_TABLE(7);

        private final byte[] byteValue;
        private final byte serializedValue;
        private final byte[] serializedByteArrayValue;

        private LinkType(byte serializedValue) {
            this.serializedValue = serializedValue;
            this.byteValue = Bytes.toBytes((String)this.name());
            this.serializedByteArrayValue = new byte[]{serializedValue};
        }

        public byte[] getBytes() {
            return this.byteValue;
        }

        public byte getSerializedValue() {
            return this.serializedValue;
        }

        public byte[] getSerializedValueAsByteArray() {
            return this.serializedByteArrayValue;
        }

        public static LinkType fromSerializedValue(byte serializedValue) {
            if (serializedValue < 1 || serializedValue > LinkType.values().length) {
                return null;
            }
            return LinkType.values()[serializedValue - 1];
        }
    }

    public static enum IndexType {
        GLOBAL(1),
        LOCAL(2),
        UNCOVERED_GLOBAL(3);

        private final byte[] byteValue;
        private final byte serializedValue;

        private IndexType(byte serializedValue) {
            this.serializedValue = serializedValue;
            this.byteValue = Bytes.toBytes((String)this.name());
        }

        public byte[] getBytes() {
            return this.byteValue;
        }

        public byte getSerializedValue() {
            return this.serializedValue;
        }

        public static IndexType getDefault() {
            return GLOBAL;
        }

        public static IndexType fromToken(String token) {
            return IndexType.valueOf(token.trim().toUpperCase());
        }

        public static IndexType fromSerializedValue(byte serializedValue) {
            if (serializedValue < 1 || serializedValue > IndexType.values().length) {
                throw new IllegalArgumentException("Invalid IndexType " + serializedValue);
            }
            return IndexType.values()[serializedValue - 1];
        }
    }

    public static enum ViewType {
        MAPPED(1),
        READ_ONLY(2),
        UPDATABLE(3);

        private final byte[] byteValue;
        private final byte serializedValue;

        private ViewType(byte serializedValue) {
            this.serializedValue = serializedValue;
            this.byteValue = Bytes.toBytes((String)this.name());
        }

        public byte[] getBytes() {
            return this.byteValue;
        }

        public boolean isReadOnly() {
            return this != UPDATABLE;
        }

        public byte getSerializedValue() {
            return this.serializedValue;
        }

        public static ViewType fromSerializedValue(byte serializedValue) {
            if (serializedValue < 1 || serializedValue > ViewType.values().length) {
                throw new IllegalArgumentException("Invalid ViewType " + serializedValue);
            }
            return ViewType.values()[serializedValue - 1];
        }

        public ViewType combine(ViewType otherType) {
            if (otherType == null) {
                return this;
            }
            if (this == UPDATABLE && otherType == UPDATABLE) {
                return UPDATABLE;
            }
            return READ_ONLY;
        }
    }
}

