/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.security.AccessDeniedException;
import org.apache.hadoop.hbase.security.access.AccessControlClient;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.util.StringUtils;
import org.apache.phoenix.compile.ColumnResolver;
import org.apache.phoenix.compile.FromCompiler;
import org.apache.phoenix.compile.IndexExpressionCompiler;
import org.apache.phoenix.compile.MutationPlan;
import org.apache.phoenix.compile.PostDDLCompiler;
import org.apache.phoenix.compile.PostIndexDDLCompiler;
import org.apache.phoenix.compile.PostLocalIndexDDLCompiler;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.compile.ServerBuildIndexCompiler;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.compile.StatementNormalizer;
import org.apache.phoenix.coprocessorclient.MetaDataProtocol;
import org.apache.phoenix.coprocessorclient.TableInfo;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.execute.MutationState;
import org.apache.phoenix.expression.Determinism;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.RowKeyColumnExpression;
import org.apache.phoenix.index.IndexMaintainer;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.monitoring.MetricType;
import org.apache.phoenix.monitoring.TableMetricsManager;
import org.apache.phoenix.parse.AddColumnStatement;
import org.apache.phoenix.parse.AlterIndexStatement;
import org.apache.phoenix.parse.ChangePermsStatement;
import org.apache.phoenix.parse.CloseStatement;
import org.apache.phoenix.parse.ColumnDef;
import org.apache.phoenix.parse.ColumnDefInPkConstraint;
import org.apache.phoenix.parse.ColumnName;
import org.apache.phoenix.parse.CreateCDCStatement;
import org.apache.phoenix.parse.CreateFunctionStatement;
import org.apache.phoenix.parse.CreateIndexStatement;
import org.apache.phoenix.parse.CreateSchemaStatement;
import org.apache.phoenix.parse.CreateSequenceStatement;
import org.apache.phoenix.parse.CreateTableStatement;
import org.apache.phoenix.parse.DeclareCursorStatement;
import org.apache.phoenix.parse.DropCDCStatement;
import org.apache.phoenix.parse.DropColumnStatement;
import org.apache.phoenix.parse.DropFunctionStatement;
import org.apache.phoenix.parse.DropIndexStatement;
import org.apache.phoenix.parse.DropSchemaStatement;
import org.apache.phoenix.parse.DropSequenceStatement;
import org.apache.phoenix.parse.DropTableStatement;
import org.apache.phoenix.parse.IndexKeyConstraint;
import org.apache.phoenix.parse.NamedNode;
import org.apache.phoenix.parse.NamedTableNode;
import org.apache.phoenix.parse.OpenStatement;
import org.apache.phoenix.parse.PFunction;
import org.apache.phoenix.parse.PSchema;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.ParseNodeFactory;
import org.apache.phoenix.parse.PrimaryKeyConstraint;
import org.apache.phoenix.parse.UpdateStatisticsStatement;
import org.apache.phoenix.parse.UseSchemaStatement;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.query.ConnectionlessQueryServicesImpl;
import org.apache.phoenix.query.DelegateQueryServices;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.query.QueryServicesOptions;
import org.apache.phoenix.schema.ColumnAlreadyExistsException;
import org.apache.phoenix.schema.ColumnFamilyNotFoundException;
import org.apache.phoenix.schema.ColumnMetaDataOps;
import org.apache.phoenix.schema.ColumnNotFoundException;
import org.apache.phoenix.schema.ColumnRef;
import org.apache.phoenix.schema.ConcurrentTableMutationException;
import org.apache.phoenix.schema.ConnectionProperty;
import org.apache.phoenix.schema.DelegateColumn;
import org.apache.phoenix.schema.DelegateTable;
import org.apache.phoenix.schema.FunctionAlreadyExistsException;
import org.apache.phoenix.schema.FunctionNotFoundException;
import org.apache.phoenix.schema.IndexNotFoundException;
import org.apache.phoenix.schema.LiteralTTLExpression;
import org.apache.phoenix.schema.NewerFunctionAlreadyExistsException;
import org.apache.phoenix.schema.NewerSchemaAlreadyExistsException;
import org.apache.phoenix.schema.NewerTableAlreadyExistsException;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PColumnFamily;
import org.apache.phoenix.schema.PDatum;
import org.apache.phoenix.schema.PIndexState;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PNameFactory;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableImpl;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.schema.PTableRef;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.RowKeySchema;
import org.apache.phoenix.schema.RowKeyValueAccessor;
import org.apache.phoenix.schema.SaltingUtil;
import org.apache.phoenix.schema.SchemaAlreadyExistsException;
import org.apache.phoenix.schema.SchemaNotFoundException;
import org.apache.phoenix.schema.SequenceAlreadyExistsException;
import org.apache.phoenix.schema.SequenceNotFoundException;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.TTLExpression;
import org.apache.phoenix.schema.TTLExpressionFactory;
import org.apache.phoenix.schema.TableAlreadyExistsException;
import org.apache.phoenix.schema.TableNotFoundException;
import org.apache.phoenix.schema.TableProperty;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.schema.TablesNotInSyncException;
import org.apache.phoenix.schema.stats.GuidePostsInfo;
import org.apache.phoenix.schema.stats.GuidePostsKey;
import org.apache.phoenix.schema.stats.StatisticsUtil;
import org.apache.phoenix.schema.task.SystemTaskParams;
import org.apache.phoenix.schema.task.Task;
import org.apache.phoenix.schema.transform.TransformClient;
import org.apache.phoenix.schema.types.PBson;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDate;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PTimestamp;
import org.apache.phoenix.schema.types.PUnsignedLong;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.phoenix.thirdparty.com.google.common.base.Strings;
import org.apache.phoenix.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.phoenix.thirdparty.com.google.common.collect.ListMultimap;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.thirdparty.com.google.common.collect.Sets;
import org.apache.phoenix.thirdparty.com.google.common.primitives.Ints;
import org.apache.phoenix.transaction.PhoenixTransactionProvider;
import org.apache.phoenix.transaction.TransactionFactory;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.CDCUtil;
import org.apache.phoenix.util.ClientUtil;
import org.apache.phoenix.util.CursorUtil;
import org.apache.phoenix.util.EncodedColumnsUtil;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.JacksonUtil;
import org.apache.phoenix.util.LogUtil;
import org.apache.phoenix.util.MetaDataUtil;
import org.apache.phoenix.util.PhoenixRuntime;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.ScanUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.StringUtil;
import org.apache.phoenix.util.TaskMetaDataServiceCallBack;
import org.apache.phoenix.util.TransactionUtil;
import org.apache.phoenix.util.UpgradeUtil;
import org.apache.phoenix.util.ValidateLastDDLTimestampUtil;
import org.apache.phoenix.util.ViewUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaDataClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetaDataClient.class);
    private static final ParseNodeFactory FACTORY = new ParseNodeFactory();
    private static final String SET_ASYNC_CREATED_DATE = "UPSERT INTO SYSTEM.\"CATALOG\"( TENANT_ID,TABLE_SCHEM,TABLE_NAME,ASYNC_CREATED_DATE " + PDate.INSTANCE.getSqlTypeName() + ") VALUES (?, ?, ?, ?)";
    private static final String SET_INDEX_SYNC_CREATED_DATE = "UPSERT INTO SYSTEM.\"CATALOG\"( TENANT_ID,TABLE_SCHEM,TABLE_NAME,SYNC_INDEX_CREATED_DATE " + PDate.INSTANCE.getSqlTypeName() + ") VALUES (?, ?, ?, ?)";
    private static final String CREATE_TABLE = "UPSERT INTO SYSTEM.\"CATALOG\"( TENANT_ID,TABLE_SCHEM,TABLE_NAME,TABLE_TYPE,TABLE_SEQ_NUM,COLUMN_COUNT,SALT_BUCKETS,PK_NAME,DATA_TABLE_NAME,INDEX_STATE,IMMUTABLE_ROWS,DEFAULT_COLUMN_FAMILY,VIEW_STATEMENT,DISABLE_WAL,MULTI_TENANT,VIEW_TYPE,INDEX_TYPE,STORE_NULLS,BASE_COLUMN_COUNT,TRANSACTION_PROVIDER,UPDATE_CACHE_FREQUENCY,IS_NAMESPACE_MAPPED,AUTO_PARTITION_SEQ,APPEND_ONLY_SCHEMA,GUIDE_POSTS_WIDTH,IMMUTABLE_STORAGE_SCHEME,ENCODING_SCHEME,USE_STATS_FOR_PARALLELIZATION,VIEW_INDEX_ID_DATA_TYPE,CHANGE_DETECTION_ENABLED,PHYSICAL_TABLE_NAME,SCHEMA_VERSION,STREAMING_TOPIC_NAME,INDEX_WHERE,CDC_INCLUDE,TTL,ROW_KEY_MATCHER,IS_STRICT_TTL) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String CREATE_SCHEMA = "UPSERT INTO SYSTEM.\"CATALOG\"( TABLE_SCHEM,TABLE_NAME) VALUES (?,?)";
    public static final String CREATE_LINK = "UPSERT INTO SYSTEM.\"CATALOG\"( TENANT_ID,TABLE_SCHEM,TABLE_NAME,COLUMN_FAMILY,LINK_TYPE,TABLE_SEQ_NUM,TABLE_TYPE) VALUES (?, ?, ?, ?, ?, ?, ?)";
    public static final String CREATE_VIEW_LINK = "UPSERT INTO SYSTEM.\"CATALOG\"( TENANT_ID,TABLE_SCHEM,TABLE_NAME,COLUMN_FAMILY,LINK_TYPE,PARENT_TENANT_ID " + PVarchar.INSTANCE.getSqlTypeName() + ") VALUES (?, ?, ?, ?, ?, ?)";
    public static final String UPDATE_ENCODED_COLUMN_COUNTER = "UPSERT INTO SYSTEM.\"CATALOG\"( TENANT_ID, TABLE_SCHEM,TABLE_NAME,COLUMN_FAMILY,QUALIFIER_COUNTER) VALUES (?, ?, ?, ?, ?)";
    private static final String CREATE_CHILD_LINK = "UPSERT INTO SYSTEM.\"CATALOG\"( TENANT_ID,TABLE_SCHEM,TABLE_NAME,COLUMN_NAME,COLUMN_FAMILY,LINK_TYPE) VALUES (?, ?, ?, ?, ?, ?)";
    private static final String CREATE_VIEW_INDEX_PARENT_LINK = "UPSERT INTO SYSTEM.\"CATALOG\"( TENANT_ID,TABLE_SCHEM,TABLE_NAME,COLUMN_FAMILY,LINK_TYPE) VALUES (?, ?, ?, ?, ?)";
    private static final String INCREMENT_SEQ_NUM = "UPSERT INTO SYSTEM.\"CATALOG\"( TENANT_ID,TABLE_SCHEM,TABLE_NAME,TABLE_SEQ_NUM) VALUES (?, ?, ?, ?)";
    public static final String MUTATE_TABLE = "UPSERT INTO SYSTEM.\"CATALOG\"( TENANT_ID,TABLE_SCHEM,TABLE_NAME,TABLE_TYPE,TABLE_SEQ_NUM,COLUMN_COUNT) VALUES (?, ?, ?, ?, ?, ?)";
    public static final String UPDATE_INDEX_STATE = "UPSERT INTO SYSTEM.\"CATALOG\"( TENANT_ID,TABLE_SCHEM,TABLE_NAME,INDEX_STATE,ASYNC_REBUILD_TIMESTAMP " + PLong.INSTANCE.getSqlTypeName() + ") VALUES (?, ?, ?, ?, ?)";
    private static final String UPDATE_INDEX_REBUILD_ASYNC_STATE = "UPSERT INTO SYSTEM.\"CATALOG\"( TENANT_ID,TABLE_SCHEM,TABLE_NAME,ASYNC_REBUILD_TIMESTAMP " + PLong.INSTANCE.getSqlTypeName() + ") VALUES (?, ?, ?, ?)";
    public static final String UPDATE_INDEX_STATE_TO_ACTIVE = "UPSERT INTO SYSTEM.\"CATALOG\"( TENANT_ID,TABLE_SCHEM,TABLE_NAME,INDEX_STATE,INDEX_DISABLE_TIMESTAMP,ASYNC_REBUILD_TIMESTAMP " + PLong.INSTANCE.getSqlTypeName() + ") VALUES (?, ?, ?, ?, ?, ?)";
    public static final String ALTER_SYSCATALOG_TABLE_UPGRADE = "UPSERT INTO SYSTEM.\"CATALOG\"( TENANT_ID,TABLE_SCHEM,TABLE_NAME,COLUMN_NAME,COLUMN_FAMILY,DATA_TYPE,NULLABLE,COLUMN_SIZE,DECIMAL_DIGITS,ORDINAL_POSITION,SORT_ORDER,DATA_TABLE_NAME,ARRAY_SIZE,VIEW_CONSTANT,IS_VIEW_REFERENCED,PK_NAME,KEY_SEQ,COLUMN_DEF) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String UPDATE_COLUMN_POSITION = "UPSERT INTO SYSTEM.\"CATALOG\" ( TENANT_ID,TABLE_SCHEM,TABLE_NAME,COLUMN_NAME,COLUMN_FAMILY,ORDINAL_POSITION) VALUES (?, ?, ?, ?, ?, ?)";
    private static final String CREATE_FUNCTION = "UPSERT INTO SYSTEM.\"FUNCTION\" ( TENANT_ID,FUNCTION_NAME,NUM_ARGS,CLASS_NAME,JAR_PATH,RETURN_TYPE) VALUES (?, ?, ?, ?, ?, ?)";
    private static final String INSERT_FUNCTION_ARGUMENT = "UPSERT INTO SYSTEM.\"FUNCTION\" ( TENANT_ID,FUNCTION_NAME,TYPE,ARG_POSITION,IS_ARRAY,IS_CONSTANT,DEFAULT_VALUE,MIN_VALUE,MAX_VALUE) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
    public static final String EMPTY_TABLE = " ";
    private final PhoenixConnection connection;

    public MetaDataClient(PhoenixConnection connection) {
        this.connection = connection;
    }

    public PhoenixConnection getConnection() {
        return this.connection;
    }

    public long getCurrentTime(String schemaName, String tableName) throws SQLException {
        MetaDataProtocol.MetaDataMutationResult result = this.updateCache(schemaName, tableName, true);
        return result.getMutationTime();
    }

    public MetaDataProtocol.MetaDataMutationResult updateCache(String schemaName, String tableName) throws SQLException {
        return this.updateCache(schemaName, tableName, false);
    }

    public MetaDataProtocol.MetaDataMutationResult updateCache(String schemaName, String tableName, boolean alwaysHitServer) throws SQLException {
        return this.updateCache(this.connection.getTenantId(), schemaName, tableName, alwaysHitServer);
    }

    public MetaDataProtocol.MetaDataMutationResult updateCache(PName tenantId, String schemaName, String tableName, boolean alwaysHitServer) throws SQLException {
        return this.updateCache(tenantId, schemaName, tableName, alwaysHitServer, null);
    }

    public MetaDataProtocol.MetaDataMutationResult updateCache(List<String> functionNames) throws SQLException {
        return this.updateCache(functionNames, false);
    }

    private MetaDataProtocol.MetaDataMutationResult updateCache(List<String> functionNames, boolean alwaysHitServer) throws SQLException {
        return this.updateCache(this.connection.getTenantId(), functionNames, alwaysHitServer);
    }

    public MetaDataProtocol.MetaDataMutationResult updateCache(PName tenantId, List<String> functionNames) throws SQLException {
        return this.updateCache(tenantId, functionNames, false);
    }

    private long getClientTimeStamp() {
        Long scn = this.connection.getSCN();
        long clientTimeStamp = scn == null ? Long.MAX_VALUE : scn;
        return clientTimeStamp;
    }

    private long getCurrentScn() {
        Long scn = this.connection.getSCN();
        long currentScn = scn == null ? Long.MAX_VALUE : scn;
        return currentScn;
    }

    public MetaDataProtocol.MetaDataMutationResult updateCache(PName origTenantId, String schemaName, String tableName, boolean alwaysHitServer, Long resolvedTimestamp) throws SQLException {
        MetaDataProtocol.MetaDataMutationResult result;
        boolean isTransactional;
        boolean systemTable = "SYSTEM".equals(schemaName);
        PName tenantId = systemTable ? null : origTenantId;
        PTable table = null;
        PTableRef tableRef = null;
        String fullTableName = SchemaUtil.getTableName(schemaName, tableName);
        long tableTimestamp = Long.MAX_VALUE;
        long tableResolvedTimestamp = Long.MAX_VALUE;
        int tryCount = 0;
        int maxTryCount = tenantId == null ? 1 : 2;
        while (true) {
            try {
                tableRef = this.connection.getTableRef(new PTableKey(tenantId, fullTableName));
                table = tableRef.getTable();
                tableTimestamp = table.getTimeStamp();
                tableResolvedTimestamp = table.getTimeStamp();
            }
            catch (TableNotFoundException e) {
                tenantId = null;
                if (++tryCount < maxTryCount) continue;
            }
            break;
        }
        if (table == null) {
            tenantId = systemTable ? null : origTenantId;
        }
        boolean bl = isTransactional = table != null && table.isTransactional();
        if (isTransactional) {
            this.connection.getMutationState().startTransaction(table.getTransactionProvider());
        }
        if (this.avoidRpcToGetTable(alwaysHitServer, resolvedTimestamp = this.connection.isRunningUpgrade() && systemTable && this.connection.getSCN() != null && this.connection.getSCN() <= 42L ? Long.valueOf(Long.MAX_VALUE) : Long.valueOf(resolvedTimestamp == null ? TransactionUtil.getResolvedTimestamp(this.connection, isTransactional, Long.MAX_VALUE) : resolvedTimestamp), systemTable, table, tableRef, tableResolvedTimestamp)) {
            return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.TABLE_ALREADY_EXISTS, -1L, table);
        }
        if (tableName.contains("#")) {
            String parentViewName = SchemaUtil.getSchemaNameFromFullName(tableName, "#");
            result = this.updateCache(origTenantId, SchemaUtil.getSchemaNameFromFullName(parentViewName), SchemaUtil.getTableNameFromFullName(parentViewName), alwaysHitServer, resolvedTimestamp);
            if (result.getTable() != null) {
                try {
                    tableRef = this.connection.getTableRef(new PTableKey(tenantId, fullTableName));
                    table = tableRef.getTable();
                    return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.TABLE_ALREADY_EXISTS, tableRef.getResolvedTimeStamp(), table);
                }
                catch (TableNotFoundException e) {
                    return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.TABLE_NOT_FOUND, -1L, null);
                }
            }
        } else {
            tryCount = 0;
            do {
                byte[] schemaBytes = PVarchar.INSTANCE.toBytes(schemaName);
                byte[] tableBytes = PVarchar.INSTANCE.toBytes(tableName);
                ConnectionQueryServices queryServices = this.connection.getQueryServices();
                result = queryServices.getTable(tenantId, schemaBytes, tableBytes, tableTimestamp, resolvedTimestamp);
                if (result.getTable() != null && result.getTable().isTransactional() && !isTransactional) {
                    long resolveTimestamp = TransactionUtil.getResolvedTimestamp(this.connection, result.getTable().isTransactional(), Long.MAX_VALUE);
                    if (result.getTable().getTimeStamp() >= resolveTimestamp) {
                        result = queryServices.getTable(tenantId, schemaBytes, tableBytes, tableTimestamp, resolveTimestamp);
                    }
                }
                if ("SYSTEM".equals(schemaName)) {
                    if (result.getMutationCode() == MetaDataProtocol.MutationCode.TABLE_ALREADY_EXISTS && result.getTable() == null) {
                        result.setTable(table);
                    }
                    if (result.getTable() != null) {
                        this.addTableToCache(result, alwaysHitServer);
                    }
                    return result;
                }
                MetaDataProtocol.MutationCode code = result.getMutationCode();
                PTable resultTable = result.getTable();
                if (resultTable != null) {
                    this.addTableToCache(result, alwaysHitServer);
                    return result;
                }
                if (table != null) {
                    if (code == MetaDataProtocol.MutationCode.TABLE_ALREADY_EXISTS) {
                        result.setTable(table);
                        long resolvedTime = TransactionUtil.getResolvedTime(this.connection, result);
                        if (this.addColumnsIndexesAndLastDDLTimestampsFromAncestors(result, resolvedTimestamp, true, false)) {
                            this.updateIndexesWithAncestorMap(result);
                            this.connection.addTable(result.getTable(), resolvedTime);
                        } else {
                            this.connection.updateResolvedTimestamp(table, resolvedTime);
                        }
                        return result;
                    }
                    if (code == MetaDataProtocol.MutationCode.TABLE_NOT_FOUND && tryCount + 1 == maxTryCount) {
                        this.connection.removeTable(origTenantId, fullTableName, table.getParentName() == null ? null : table.getParentName().getString(), table.getTimeStamp());
                    }
                    TableMetricsManager.updateMetricsForSystemCatalogTableMethod(null, MetricType.NUM_METADATA_LOOKUP_FAILURES, 1L);
                }
                tenantId = null;
            } while (++tryCount < maxTryCount);
        }
        return result;
    }

    private boolean avoidRpcToGetTable(boolean alwaysHitServer, Long resolvedTimestamp, boolean systemTable, PTable table, PTableRef tableRef, long tableResolvedTimestamp) {
        if (table != null && !alwaysHitServer) {
            String ucfInfoForLogging;
            long effectiveUpdateCacheFreq;
            if (systemTable && table.getRowTimestampColPos() == -1 || resolvedTimestamp == tableResolvedTimestamp) {
                return true;
            }
            boolean overrideUcfToAlways = false;
            if (table.getType() == PTableType.INDEX) {
                boolean bl = overrideUcfToAlways = PIndexState.PENDING_DISABLE.equals((Object)table.getIndexState()) || !IndexMaintainer.sendIndexMaintainer(table);
            }
            if (!overrideUcfToAlways && !table.getIndexes().isEmpty()) {
                List<PTable> indexes = table.getIndexes();
                ArrayList maintainedIndexes = Lists.newArrayList(IndexMaintainer.maintainedIndexes(indexes.iterator()));
                boolean bl = overrideUcfToAlways = indexes.size() != maintainedIndexes.size();
            }
            if (overrideUcfToAlways) {
                effectiveUpdateCacheFreq = (Long)ConnectionProperty.UPDATE_CACHE_FREQUENCY.getValue("ALWAYS");
                ucfInfoForLogging = "override-to-always";
            } else if (table.getUpdateCacheFrequency() != QueryServicesOptions.DEFAULT_UPDATE_CACHE_FREQUENCY) {
                effectiveUpdateCacheFreq = table.getUpdateCacheFrequency();
                ucfInfoForLogging = "table-level";
            } else {
                effectiveUpdateCacheFreq = (Long)ConnectionProperty.UPDATE_CACHE_FREQUENCY.getValue(this.connection.getQueryServices().getProps().get("phoenix.default.update.cache.frequency"));
                String string = ucfInfoForLogging = this.connection.getQueryServices().getProps().get("phoenix.default.update.cache.frequency") != null ? "connection-level" : "default";
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Using " + ucfInfoForLogging + " Update Cache Frequency (value = " + effectiveUpdateCacheFreq + "ms) for " + table.getName() + (table.getTenantId() != null ? ", Tenant ID: " + table.getTenantId() : ""));
            }
            return MetaDataUtil.avoidMetadataRPC(this.connection, table, tableRef, effectiveUpdateCacheFreq);
        }
        return false;
    }

    public MetaDataProtocol.MetaDataMutationResult updateCache(String schemaName) throws SQLException {
        return this.updateCache(schemaName, false);
    }

    public MetaDataProtocol.MetaDataMutationResult updateCache(String schemaName, boolean alwaysHitServer) throws SQLException {
        long clientTimeStamp = this.getClientTimeStamp();
        PSchema schema = null;
        try {
            schema = this.connection.getMetaDataCache().getSchema(new PTableKey(null, schemaName));
            if (schema != null && !alwaysHitServer) {
                return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.SCHEMA_ALREADY_EXISTS, schema, -1L);
            }
        }
        catch (SchemaNotFoundException schemaNotFoundException) {
            // empty catch block
        }
        MetaDataProtocol.MetaDataMutationResult result = this.connection.getQueryServices().getSchema(schemaName, clientTimeStamp);
        return result;
    }

    public MetaDataProtocol.MetaDataMutationResult updateCache(PName tenantId, List<String> functionNames, boolean alwaysHitServer) throws SQLException {
        MetaDataProtocol.MetaDataMutationResult result;
        long clientTimeStamp = this.getClientTimeStamp();
        ArrayList<PFunction> functions = new ArrayList<PFunction>(functionNames.size());
        ArrayList<Long> functionTimeStamps = new ArrayList<Long>(functionNames.size());
        Iterator<String> iterator = functionNames.iterator();
        while (iterator.hasNext()) {
            PFunction function = null;
            try {
                String functionName = iterator.next();
                function = this.connection.getMetaDataCache().getFunction(new PTableKey(tenantId, functionName));
                if (function != null && !alwaysHitServer && function.getTimeStamp() == clientTimeStamp - 1L) {
                    functions.add(function);
                    iterator.remove();
                    continue;
                }
                if (function != null && function.getTimeStamp() != clientTimeStamp - 1L) {
                    functionTimeStamps.add(function.getTimeStamp());
                    continue;
                }
                functionTimeStamps.add(Long.MAX_VALUE);
            }
            catch (FunctionNotFoundException e) {
                functionTimeStamps.add(Long.MAX_VALUE);
            }
        }
        if (functionNames.isEmpty()) {
            return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.FUNCTION_ALREADY_EXISTS, -1L, functions, true);
        }
        int maxTryCount = tenantId == null ? 1 : 2;
        int tryCount = 0;
        do {
            ArrayList<Pair<byte[], Long>> functionsToFecth = new ArrayList<Pair<byte[], Long>>(functionNames.size());
            for (int i = 0; i < functionNames.size(); ++i) {
                functionsToFecth.add((Pair<byte[], Long>)new Pair((Object)PVarchar.INSTANCE.toBytes(functionNames.get(i)), functionTimeStamps.get(i)));
            }
            result = this.connection.getQueryServices().getFunctions(tenantId, functionsToFecth, clientTimeStamp);
            MetaDataProtocol.MutationCode code = result.getMutationCode();
            if (result.getFunctions() != null && !result.getFunctions().isEmpty()) {
                result.getFunctions().addAll(functions);
                this.addFunctionToCache(result);
                return result;
            }
            if (code == MetaDataProtocol.MutationCode.FUNCTION_ALREADY_EXISTS) {
                result.getFunctions().addAll(functions);
                this.addFunctionToCache(result);
                return result;
            }
            if (code == MetaDataProtocol.MutationCode.FUNCTION_NOT_FOUND && tryCount + 1 == maxTryCount) {
                for (Pair pair : functionsToFecth) {
                    this.connection.removeFunction(tenantId, Bytes.toString((byte[])((byte[])pair.getFirst())), (Long)pair.getSecond());
                }
                throw new FunctionNotFoundException(functionNames.toString() + " not found");
            }
            tenantId = null;
        } while (++tryCount < maxTryCount);
        return result;
    }

    private boolean addColumnsIndexesAndLastDDLTimestampsFromAncestors(MetaDataProtocol.MetaDataMutationResult result, Long resolvedTimestamp, boolean alwaysAddAncestorColumnsAndIndexes, boolean alwaysHitServerForAncestors) throws SQLException {
        boolean hasIndexId;
        PTable table = result.getTable();
        boolean bl = hasIndexId = table.getViewIndexId() != null;
        if (table.getType() == PTableType.INDEX || table.getType() == PTableType.VIEW && table.getViewType() != PTable.ViewType.MAPPED) {
            String tableName = null;
            try {
                String parentName = table.getParentName().getString();
                String parentSchemaName = SchemaUtil.getSchemaNameFromFullName(parentName);
                tableName = SchemaUtil.getTableNameFromFullName(parentName);
                MetaDataProtocol.MetaDataMutationResult parentResult = this.updateCache(this.connection.getTenantId(), parentSchemaName, tableName, alwaysHitServerForAncestors, resolvedTimestamp);
                PTable parentTable = parentResult.getTable();
                if (parentResult.getMutationCode() == MetaDataProtocol.MutationCode.TABLE_NOT_FOUND || parentTable == null) {
                    parentResult = this.updateCache(table.getTenantId(), parentSchemaName, tableName, false, resolvedTimestamp);
                    parentTable = parentResult.getTable();
                }
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("addColumnsAndIndexesFromAncestors parent logical name " + table.getBaseTableLogicalName().getString() + " parent name " + table.getParentName().getString() + " tableName=" + table.getName());
                }
                if (parentResult.getMutationCode() == MetaDataProtocol.MutationCode.TABLE_NOT_FOUND || parentTable == null) {
                    String schemaName = table.getSchemaName() != null ? table.getSchemaName().getString() : null;
                    throw new TableNotFoundException(schemaName, parentName);
                }
                if (hasIndexId && parentTable.getType() != PTableType.VIEW) {
                    result.setTable(this.getPTableWithAncestorLastDDLTimestampMap(table, parentTable));
                    return false;
                }
                if (!(alwaysAddAncestorColumnsAndIndexes || result.wasUpdated() || parentResult.wasUpdated())) {
                    return false;
                }
                if (!table.getType().equals((Object)PTableType.INDEX) || hasIndexId) {
                    PTable pTableWithDerivedColumnsAndIndexes = ViewUtil.addDerivedColumnsAndIndexesFromParent(this.connection, table, parentTable);
                    result.setTable(this.getPTableWithAncestorLastDDLTimestampMap(pTableWithDerivedColumnsAndIndexes, parentTable));
                } else {
                    result.setTable(this.getPTableWithAncestorLastDDLTimestampMap(table, parentTable));
                }
                return true;
            }
            catch (Throwable e) {
                TableMetricsManager.updateMetricsForSystemCatalogTableMethod(tableName, MetricType.NUM_METADATA_LOOKUP_FAILURES, 1L);
                throw e;
            }
        }
        return false;
    }

    private void updateIndexesWithAncestorMap(MetaDataProtocol.MetaDataMutationResult result) throws SQLException {
        PTable table = result.getTable();
        if (table.getIndexes().isEmpty()) {
            return;
        }
        ArrayList<PTable> newIndexes = new ArrayList<PTable>(table.getIndexes().size());
        for (PTable index : table.getIndexes()) {
            newIndexes.add(this.getPTableWithAncestorLastDDLTimestampMap(index, table));
        }
        result.setTable(PTableImpl.builderWithColumns(table, PTableImpl.getColumnsToClone(table)).setIndexes(newIndexes).build());
    }

    private PTable getPTableWithAncestorLastDDLTimestampMap(PTable pTable, PTable parentTable) throws SQLException {
        HashMap<PTableKey, Long> ancestorMap = new HashMap<PTableKey, Long>(parentTable.getAncestorLastDDLTimestampMap());
        if (pTable.getParentName().equals(parentTable.getName())) {
            ancestorMap.put(parentTable.getKey(), parentTable.getLastDDLTimestamp());
        }
        return PTableImpl.builderWithColumns(pTable, PTableImpl.getColumnsToClone(pTable)).setAncestorLastDDLTimestampMap(ancestorMap).build();
    }

    private void addFunctionArgMutation(String functionName, PFunction.FunctionArgument arg, PreparedStatement argUpsert, int position) throws SQLException {
        argUpsert.setString(1, this.connection.getTenantId() == null ? null : this.connection.getTenantId().getString());
        argUpsert.setString(2, functionName);
        argUpsert.setString(3, arg.getArgumentType());
        byte[] bytes = Bytes.toBytes((short)((short)position));
        argUpsert.setBytes(4, bytes);
        argUpsert.setBoolean(5, arg.isArrayType());
        argUpsert.setBoolean(6, arg.isConstant());
        argUpsert.setString(7, arg.getDefaultValue() == null ? null : arg.getDefaultValue().toString());
        argUpsert.setString(8, arg.getMinValue() == null ? null : arg.getMinValue().toString());
        argUpsert.setString(9, arg.getMaxValue() == null ? null : arg.getMaxValue().toString());
        argUpsert.execute();
    }

    public MutationState createTable(CreateTableStatement statement, byte[][] splits, PTable parent, String viewStatement, PTable.ViewType viewType, PDataType viewIndexIdType, byte[] rowKeyMatcher, byte[][] viewColumnConstants, BitSet isViewColumnReferenced) throws SQLException {
        MetaDataProtocol.MetaDataMutationResult result;
        org.apache.phoenix.parse.TableName tableName = statement.getTableName();
        HashMap tableProps = Maps.newHashMapWithExpectedSize((int)statement.getProps().size());
        HashMap commonFamilyProps = Maps.newHashMapWithExpectedSize((int)(statement.getProps().size() + 1));
        this.populatePropertyMaps(statement.getProps(), tableProps, commonFamilyProps, statement.getTableType(), SchemaUtil.getUnEscapedFullName(tableName.toString()), false);
        splits = this.processSplits(tableProps, splits);
        boolean isAppendOnlySchema = false;
        long updateCacheFrequency = (Long)ConnectionProperty.UPDATE_CACHE_FREQUENCY.getValue(this.connection.getQueryServices().getProps().get("phoenix.default.update.cache.frequency"));
        Long updateCacheFrequencyProp = (Long)TableProperty.UPDATE_CACHE_FREQUENCY.getValue(tableProps);
        if (parent == null) {
            Boolean appendOnlySchemaProp = (Boolean)TableProperty.APPEND_ONLY_SCHEMA.getValue(tableProps);
            if (appendOnlySchemaProp != null) {
                isAppendOnlySchema = appendOnlySchemaProp;
            }
            if (updateCacheFrequencyProp != null) {
                updateCacheFrequency = updateCacheFrequencyProp;
            }
        } else {
            isAppendOnlySchema = parent.isAppendOnlySchema();
            long l = updateCacheFrequency = updateCacheFrequencyProp != null ? updateCacheFrequencyProp.longValue() : parent.getUpdateCacheFrequency();
        }
        if (isAppendOnlySchema && updateCacheFrequency == 0L) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.UPDATE_CACHE_FREQUENCY_INVALID).setSchemaName(tableName.getSchemaName()).setTableName(tableName.getTableName()).build().buildException();
        }
        Boolean immutableProp = (Boolean)TableProperty.IMMUTABLE_ROWS.getValue(tableProps);
        if (statement.immutableRows() != null && immutableProp != null) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.IMMUTABLE_TABLE_PROPERTY_INVALID).setSchemaName(tableName.getSchemaName()).setTableName(tableName.getTableName()).build().buildException();
        }
        PTable table = null;
        if (isAppendOnlySchema && (result = this.updateCache(tableName.getSchemaName(), tableName.getTableName())).getMutationCode() == MetaDataProtocol.MutationCode.TABLE_ALREADY_EXISTS) {
            table = result.getTable();
            if (!statement.ifNotExists()) {
                TableMetricsManager.updateMetricsForSystemCatalogTableMethod(tableName.toString(), MetricType.NUM_METADATA_LOOKUP_FAILURES, 1L);
                throw new NewerTableAlreadyExistsException(tableName.getSchemaName(), tableName.getTableName(), table);
            }
            List<ColumnDef> columnDefs = statement.getColumnDefs();
            PrimaryKeyConstraint pkConstraint = statement.getPrimaryKeyConstraint();
            for (ColumnDef columnDef : columnDefs) {
                if (!pkConstraint.contains(columnDef.getColumnDefName())) continue;
                columnDef.setIsPK(true);
            }
            return this.addColumn(table, columnDefs, statement.getProps(), statement.ifNotExists(), true, NamedTableNode.create(statement.getTableName()), statement.getTableType(), false, null);
        }
        table = this.createTableInternal(statement, splits, parent, viewStatement, viewType, viewIndexIdType, rowKeyMatcher, viewColumnConstants, isViewColumnReferenced, false, null, null, null, tableProps, commonFamilyProps);
        if (table == null || table.getType() == PTableType.VIEW || statement.isNoVerify()) {
            return new MutationState(0, 0L, this.connection);
        }
        PostDDLCompiler compiler = new PostDDLCompiler(this.connection);
        Long scn = this.connection.getSCN();
        long ts = scn == null ? table.getTimeStamp() : scn.longValue();
        TableRef tableRef = new TableRef(null, table, ts, false);
        byte[] emptyCF = SchemaUtil.getEmptyColumnFamily(table);
        MutationPlan plan = compiler.compile(Collections.singletonList(tableRef), emptyCF, null, null, ts);
        return this.connection.getQueryServices().updateData(plan);
    }

    private byte[][] processSplits(Map<String, Object> tableProperties, byte[][] splits) throws SQLException {
        String splitFilesLocation = (String)tableProperties.get("SPLITS_FILE");
        if (splitFilesLocation == null || splitFilesLocation.isEmpty()) {
            splitFilesLocation = null;
        }
        if (splits.length == 0 && splitFilesLocation == null) {
            return splits;
        }
        if (splits.length != 0 && splitFilesLocation != null) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.SPLITS_AND_SPLIT_FILE_EXISTS).build().buildException();
        }
        if (splitFilesLocation == null) {
            return splits;
        }
        File splitFile = new File(splitFilesLocation);
        if (!splitFile.exists() || !splitFile.isFile()) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.SPLIT_FILE_DONT_EXIST).build().buildException();
        }
        ArrayList<byte[]> splitsListFromFile = new ArrayList<byte[]>();
        Path path = Paths.get(splitFilesLocation, new String[0]);
        try (BufferedReader reader = Files.newBufferedReader(path);){
            String line;
            while ((line = reader.readLine()) != null) {
                splitsListFromFile.add(Bytes.toBytes((String)line));
            }
        }
        catch (IOException ioe) {
            LOGGER.warn("Exception while reading splits file", (Throwable)ioe);
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.UNABLE_TO_OPEN_SPLIT_FILE).build().buildException();
        }
        return (byte[][])splitsListFromFile.toArray((T[])new byte[splitsListFromFile.size()][]);
    }

    private void populatePropertyMaps(ListMultimap<String, Pair<String, Object>> statementProps, Map<String, Object> tableProps, Map<String, Object> commonFamilyProps, PTableType tableType, String tableName, boolean isCDCIndex) throws SQLException {
        ColumnFamilyDescriptor defaultDescriptor = ColumnFamilyDescriptorBuilder.of((byte[])QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES);
        if (!statementProps.isEmpty()) {
            List propsList = statementProps.get((Object)"");
            for (Pair prop : propsList) {
                if (tableType == PTableType.INDEX && !isCDCIndex && MetaDataUtil.propertyNotAllowedToBeOutOfSync((String)prop.getFirst())) {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_SET_OR_ALTER_PROPERTY_FOR_INDEX).setMessage("Property: " + (String)prop.getFirst()).build().buildException();
                }
                if (tableType == PTableType.INDEX && "phoenix.max.lookback.age.seconds".equals(prop.getFirst())) {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_SET_OR_ALTER_MAX_LOOKBACK_FOR_INDEX).setMessage("Property: " + (String)prop.getFirst()).build().buildException();
                }
                if (((String)prop.getFirst()).equalsIgnoreCase("TTL") && (tableType != PTableType.SYSTEM || MetaDataUtil.SYSTEM_TABLES_WITH_TTL_SUPPORTED.contains(tableName))) {
                    TTLExpression ttlExpr;
                    tableProps.put((String)prop.getFirst(), prop.getSecond());
                    if (prop.getSecond() == null || !((ttlExpr = MetaDataUtil.convertForeverAndNoneTTLValue(prop.getSecond(), false)) instanceof LiteralTTLExpression) || tableType == PTableType.VIEW) continue;
                    Integer value = ((LiteralTTLExpression)ttlExpr).getTTLValue();
                    commonFamilyProps.put((String)prop.getFirst(), value);
                    continue;
                }
                if (defaultDescriptor.getValue(Bytes.toBytes((String)((String)prop.getFirst()))) == null) {
                    if (tableType == PTableType.INDEX && "UPDATE_CACHE_FREQUENCY".equals(prop.getFirst())) {
                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_SET_OR_ALTER_UPDATE_CACHE_FREQ_FOR_INDEX).build().buildException();
                    }
                    tableProps.put((String)prop.getFirst(), prop.getSecond());
                    continue;
                }
                commonFamilyProps.put((String)prop.getFirst(), prop.getSecond());
            }
        }
    }

    private boolean isViewTTLEnabled() {
        return this.connection.getQueryServices().getConfiguration().getBoolean("phoenix.view.ttl.enabled", true);
    }

    public MutationState updateStatistics(UpdateStatisticsStatement updateStatisticsStmt) throws SQLException {
        this.connection.rollback();
        ColumnResolver resolver = FromCompiler.getResolver(updateStatisticsStmt, this.connection);
        PTable table = resolver.getTables().get(0).getTable();
        long rowCount = 0L;
        if (updateStatisticsStmt.updateColumns()) {
            rowCount += this.updateStatisticsInternal(table.getPhysicalName(), table, updateStatisticsStmt.getProps(), true);
        }
        if (updateStatisticsStmt.updateIndex()) {
            for (PTable index : table.getIndexes()) {
                if (index.getIndexType() == PTable.IndexType.LOCAL) continue;
                if (table.getType() != PTableType.VIEW) {
                    rowCount += this.updateStatisticsInternal(index.getPhysicalName(), index, updateStatisticsStmt.getProps(), true);
                    continue;
                }
                rowCount += this.updateStatisticsInternal(table.getPhysicalName(), index, updateStatisticsStmt.getProps(), true);
            }
            PName physicalName = table.getPhysicalName();
            List<byte[]> localCFs = MetaDataUtil.getLocalIndexColumnFamilies(this.connection, physicalName.getBytes());
            if (!localCFs.isEmpty()) {
                rowCount += this.updateStatisticsInternal(physicalName, table, updateStatisticsStmt.getProps(), localCFs, false);
            }
            if (table.getType() != PTableType.VIEW && (table.isMultiTenant() || MetaDataUtil.hasViewIndexTable(this.connection, table.getPhysicalName()))) {
                final PName viewIndexPhysicalTableName = PNameFactory.newName(MetaDataUtil.getViewIndexPhysicalName(table.getPhysicalName().getBytes()));
                DelegateTable indexLogicalTable = new DelegateTable(table){

                    @Override
                    public PName getPhysicalName() {
                        return viewIndexPhysicalTableName;
                    }
                };
                rowCount += this.updateStatisticsInternal(viewIndexPhysicalTableName, indexLogicalTable, updateStatisticsStmt.getProps(), true);
            }
        }
        final long count = rowCount;
        return new MutationState(1, 1000L, this.connection){

            @Override
            public long getUpdateCount() {
                return count;
            }
        };
    }

    private long updateStatisticsInternal(PName physicalName, PTable logicalTable, Map<String, Object> statsProps, boolean checkLastStatsUpdateTime) throws SQLException {
        return this.updateStatisticsInternal(physicalName, logicalTable, statsProps, null, checkLastStatsUpdateTime);
    }

    private long updateStatisticsInternal(PName physicalName, PTable logicalTable, Map<String, Object> statsProps, List<byte[]> cfs, boolean checkLastStatsUpdateTime) throws SQLException {
        ReadOnlyProps props = this.connection.getQueryServices().getProps();
        long msMinBetweenUpdates = props.getLong("phoenix.stats.minUpdateFrequency", 0L);
        Long scn = this.connection.getSCN();
        long clientTimeStamp = this.connection.getSCN() == null ? Long.MAX_VALUE : scn;
        long msSinceLastUpdate = Long.MAX_VALUE;
        if (checkLastStatsUpdateTime) {
            String query = "SELECT CURRENT_DATE(),LAST_STATS_UPDATE_TIME FROM " + PhoenixDatabaseMetaData.SYSTEM_STATS_NAME + " WHERE " + "PHYSICAL_NAME" + "= ?  AND " + "COLUMN_FAMILY" + " IS NULL AND " + "LAST_STATS_UPDATE_TIME" + " IS NOT NULL";
            PreparedStatement selectStatsStmt = this.connection.prepareStatement(query);
            Object object = null;
            try {
                selectStatsStmt.setString(1, physicalName.getString());
                try (ResultSet rs = selectStatsStmt.executeQuery(query);){
                    if (rs.next()) {
                        msSinceLastUpdate = rs.getLong(1) - rs.getLong(2);
                    }
                }
            }
            catch (Throwable rs) {
                object = rs;
                throw rs;
            }
            finally {
                if (selectStatsStmt != null) {
                    if (object != null) {
                        try {
                            selectStatsStmt.close();
                        }
                        catch (Throwable rs) {
                            ((Throwable)object).addSuppressed(rs);
                        }
                    } else {
                        selectStatsStmt.close();
                    }
                }
            }
        }
        long rowCount = 0L;
        if (msSinceLastUpdate >= msMinBetweenUpdates) {
            PostDDLCompiler compiler = new PostDDLCompiler(this.connection);
            DelegateTable nonTxnLogicalTable = new DelegateTable(logicalTable){

                @Override
                public TransactionFactory.Provider getTransactionProvider() {
                    return null;
                }
            };
            TableRef tableRef = new TableRef(null, nonTxnLogicalTable, clientTimeStamp, false);
            MutationPlan plan = compiler.compile(Collections.singletonList(tableRef), null, cfs, null, clientTimeStamp);
            Scan scan = plan.getContext().getScan();
            StatisticsUtil.setScanAttributes(scan, statsProps);
            boolean runUpdateStatsAsync = props.getBoolean("phoenix.update.stats.command.async", true);
            scan.setAttribute("_RunUpdateStatsAsync", runUpdateStatsAsync ? PDataType.TRUE_BYTES : PDataType.FALSE_BYTES);
            MutationState mutationState = plan.execute();
            rowCount = mutationState.getUpdateCount();
        }
        if (cfs == null) {
            List<PColumnFamily> families = logicalTable.getColumnFamilies();
            if (families.isEmpty()) {
                this.connection.getQueryServices().invalidateStats(new GuidePostsKey(physicalName.getBytes(), SchemaUtil.getEmptyColumnFamily(logicalTable)));
            } else {
                for (PColumnFamily family : families) {
                    this.connection.getQueryServices().invalidateStats(new GuidePostsKey(physicalName.getBytes(), family.getName().getBytes()));
                }
            }
        } else {
            for (byte[] cf : cfs) {
                this.connection.getQueryServices().invalidateStats(new GuidePostsKey(physicalName.getBytes(), cf));
            }
        }
        return rowCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MutationState buildIndexAtTimeStamp(PTable index, NamedTableNode dataTableNode) throws SQLException {
        block13: {
            Properties props = new Properties(this.connection.getClientInfo());
            props.setProperty("BuildIndexAt", Long.toString(this.connection.getSCN() + 1L));
            PhoenixConnection conn = new PhoenixConnection(this.connection, this.connection.getQueryServices(), props);
            MetaDataClient newClientAtNextTimeStamp = new MetaDataClient(conn);
            conn.setAutoCommit(true);
            ColumnResolver resolver = FromCompiler.getResolver(dataTableNode, conn);
            TableRef tableRef = resolver.getTables().get(0);
            boolean success = false;
            SQLException sqlException = null;
            try {
                MutationState state = newClientAtNextTimeStamp.buildIndex(index, tableRef);
                success = true;
                MutationState mutationState = state;
                return mutationState;
            }
            catch (SQLException e) {
                sqlException = e;
                return sqlException;
            }
            finally {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    if (sqlException == null) {
                        if (success) {
                            sqlException = e;
                        }
                    }
                    sqlException.setNextException(e);
                }
                if (sqlException == null) break block13;
                throw sqlException;
            }
        }
        throw new IllegalStateException();
    }

    private MutationPlan getMutationPlanForBuildingIndex(PTable index, TableRef dataTableRef) throws SQLException {
        if (index.getIndexType() == PTable.IndexType.LOCAL) {
            PostLocalIndexDDLCompiler compiler = new PostLocalIndexDDLCompiler(this.connection, this.getFullTableName(dataTableRef));
            return compiler.compile(index);
        }
        if (dataTableRef.getTable().isTransactional()) {
            PostIndexDDLCompiler compiler = new PostIndexDDLCompiler(this.connection, dataTableRef);
            return compiler.compile(index);
        }
        ServerBuildIndexCompiler compiler = new ServerBuildIndexCompiler(this.connection, this.getFullTableName(dataTableRef));
        return compiler.compile(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MutationState buildIndex(PTable index, TableRef dataTableRef) throws SQLException {
        AlterIndexStatement indexStatement = null;
        boolean wasAutoCommit = this.connection.getAutoCommit();
        try {
            this.connection.setAutoCommit(true);
            MutationPlan mutationPlan = this.getMutationPlanForBuildingIndex(index, dataTableRef);
            Scan scan = mutationPlan.getContext().getScan();
            Long scn = this.connection.getSCN();
            try {
                if (ScanUtil.isDefaultTimeRange(scan.getTimeRange())) {
                    if (scn == null) {
                        scn = mutationPlan.getContext().getCurrentTime();
                    }
                    scan.setTimeRange(dataTableRef.getLowerBoundTimeStamp(), scn.longValue());
                }
            }
            catch (IOException e) {
                throw new SQLException(e);
            }
            long startTime = EnvironmentEdgeManager.currentTimeMillis();
            MutationState state = this.connection.getQueryServices().updateData(mutationPlan);
            long firstUpsertSelectTime = EnvironmentEdgeManager.currentTimeMillis() - startTime;
            long sleepTime = this.connection.getQueryServices().getProps().getLong("phoenix.index.population.wait.time", 5000L);
            if (!dataTableRef.getTable().isTransactional() && sleepTime > 0L) {
                long delta = sleepTime - firstUpsertSelectTime;
                if (delta > 0L) {
                    try {
                        Thread.sleep(delta);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.INTERRUPTED_EXCEPTION).setRootCause(e).build().buildException();
                    }
                }
                long minTimestamp = index.getTimeStamp() - firstUpsertSelectTime;
                try {
                    mutationPlan.getContext().getScan().setTimeRange(minTimestamp, scn.longValue());
                }
                catch (IOException e) {
                    throw new SQLException(e);
                }
                MutationState newMutationState = this.connection.getQueryServices().updateData(mutationPlan);
                state.join(newMutationState);
            }
            indexStatement = FACTORY.alterIndex(FACTORY.namedTable(null, org.apache.phoenix.parse.TableName.create(index.getSchemaName().getString(), index.getTableName().getString())), dataTableRef.getTable().getTableName().getString(), false, PIndexState.ACTIVE);
            this.alterIndex(indexStatement);
            MutationState mutationState = state;
            return mutationState;
        }
        finally {
            this.connection.setAutoCommit(wasAutoCommit);
        }
    }

    private String getFullTableName(TableRef dataTableRef) {
        String schemaName = dataTableRef.getTable().getSchemaName().getString();
        String tableName = dataTableRef.getTable().getTableName().getString();
        String fullName = schemaName == null ? "\"" + tableName + "\"" : "\"" + schemaName + "\"" + "." + "\"" + tableName + "\"";
        return fullName;
    }

    public MutationState declareCursor(DeclareCursorStatement statement, QueryPlan queryPlan) throws SQLException {
        CursorUtil.declareCursor(statement, queryPlan);
        return new MutationState(0, 0L, this.connection);
    }

    public MutationState open(OpenStatement statement) throws SQLException {
        CursorUtil.openCursor(statement, this.connection);
        return new MutationState(0, 0L, this.connection);
    }

    public MutationState close(CloseStatement statement) throws SQLException {
        CursorUtil.closeCursor(statement);
        return new MutationState(0, 0L, this.connection);
    }

    private PDataType getViewIndexDataType() throws SQLException {
        boolean supportsLongViewIndexId = this.connection.getQueryServices().getProps().getBoolean("phoenix.index.longViewIndex.enabled", false);
        return supportsLongViewIndexId ? MetaDataUtil.getViewIndexIdDataType() : MetaDataUtil.getLegacyViewIndexIdDataType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutationState createIndex(CreateIndexStatement statement, byte[][] splits) throws SQLException {
        IndexKeyConstraint ik = statement.getIndexConstraint();
        org.apache.phoenix.parse.TableName indexTableName = statement.getIndexTableName();
        HashMap tableProps = Maps.newHashMapWithExpectedSize((int)statement.getProps().size());
        HashMap commonFamilyProps = Maps.newHashMapWithExpectedSize((int)(statement.getProps().size() + 1));
        this.populatePropertyMaps(statement.getProps(), tableProps, commonFamilyProps, PTableType.INDEX, indexTableName.toString(), CDCUtil.isCDCIndex(SchemaUtil.getTableNameFromFullName(statement.getIndexTableName().toString())));
        List<Pair<ParseNode, SortOrder>> indexParseNodeAndSortOrderList = ik.getParseNodeAndSortOrderList();
        List<ColumnName> includedColumns = statement.getIncludeColumns();
        TableRef tableRef = null;
        PTable table = null;
        boolean allocateIndexId = false;
        boolean isLocalIndex = statement.getIndexType() == PTable.IndexType.LOCAL;
        int hbaseVersion = this.connection.getQueryServices().getLowestClusterHBaseVersion();
        if (isLocalIndex) {
            if (!this.connection.getQueryServices().getProps().getBoolean("phoenix.index.allowLocalIndex", true)) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.UNALLOWED_LOCAL_INDEXES).setTableName(indexTableName.getTableName()).build().buildException();
            }
            if (!this.connection.getQueryServices().supportsFeature(ConnectionQueryServices.Feature.LOCAL_INDEX)) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.NO_LOCAL_INDEXES).setTableName(indexTableName.getTableName()).build().buildException();
            }
        }
        HashSet acquiredColumnMutexSet = Sets.newHashSetWithExpectedSize((int)3);
        String physicalSchemaName = null;
        String physicalTableName = null;
        PTable dataTable = null;
        try {
            long threshold;
            PColumn col;
            LinkedHashSet unusedPkColumns;
            boolean isTenantConnection;
            ColumnResolver resolver = FromCompiler.getResolverForCreateIndex(statement, this.connection, statement.getUdfParseNodes());
            tableRef = resolver.getTables().get(0);
            Date asyncCreatedDate = null;
            if (statement.isAsync()) {
                asyncCreatedDate = new Date(tableRef.getCurrentTime());
            }
            dataTable = tableRef.getTable();
            boolean bl = isTenantConnection = this.connection.getTenantId() != null;
            if (isTenantConnection && dataTable.getType() != PTableType.VIEW) {
                throw new SQLFeatureNotSupportedException("An index may only be created for a VIEW through a tenant-specific connection");
            }
            if (!dataTable.isImmutableRows()) {
                boolean tableWithRowTimestampCol;
                if (hbaseVersion < MetaDataProtocol.MUTABLE_SI_VERSION_THRESHOLD) {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.NO_MUTABLE_INDEXES).setTableName(indexTableName.getTableName()).build().buildException();
                }
                if (!this.connection.getQueryServices().hasIndexWALCodec() && !dataTable.isTransactional()) {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.INVALID_MUTABLE_INDEX_CONFIG).setTableName(indexTableName.getTableName()).build().buildException();
                }
                boolean bl2 = tableWithRowTimestampCol = dataTable.getRowTimestampColPos() != -1;
                if (tableWithRowTimestampCol) {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_CREATE_INDEX_ON_MUTABLE_TABLE_WITH_ROWTIMESTAMP).setTableName(indexTableName.getTableName()).build().buildException();
                }
            }
            if (dataTable.isTransactional() && isLocalIndex && dataTable.getTransactionProvider().getTransactionProvider().isUnsupported(PhoenixTransactionProvider.Feature.ALLOW_LOCAL_INDEX)) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_CREATE_LOCAL_INDEX_FOR_TXN_TABLE).setMessage(dataTable.getTransactionProvider().name()).setTableName(indexTableName.getTableName()).build().buildException();
            }
            int posOffset = 0;
            List<PColumn> pkColumns = dataTable.getPKColumns();
            if (dataTable.getBucketNum() != null) {
                unusedPkColumns = Sets.newLinkedHashSetWithExpectedSize((int)(pkColumns.size() - 1));
                ++posOffset;
            } else {
                unusedPkColumns = Sets.newLinkedHashSetWithExpectedSize((int)pkColumns.size());
            }
            for (int i = posOffset; i < pkColumns.size(); ++i) {
                PColumn column = pkColumns.get(i);
                unusedPkColumns.add(new RowKeyColumnExpression((PDatum)column, new RowKeyValueAccessor(pkColumns, i), "\"" + column.getName().getString() + "\""));
            }
            ArrayList allPkColumns = Lists.newArrayListWithExpectedSize((int)unusedPkColumns.size());
            ArrayList columnDefs = Lists.newArrayListWithExpectedSize((int)(includedColumns.size() + indexParseNodeAndSortOrderList.size()));
            if (isLocalIndex || dataTable.getType() == PTableType.VIEW && dataTable.getViewType() != PTable.ViewType.MAPPED) {
                allocateIndexId = true;
                PDataType dataType = this.getViewIndexDataType();
                ColumnName colName = ColumnName.caseSensitiveColumnName(MetaDataUtil.getViewIndexIdColumnName());
                allPkColumns.add(new ColumnDefInPkConstraint(colName, SortOrder.getDefault(), false));
                columnDefs.add(FACTORY.columnDef(colName, dataType.getSqlTypeName(), false, null, null, false, SortOrder.getDefault(), null, false));
            }
            if (dataTable.isMultiTenant()) {
                PColumn col2 = dataTable.getPKColumns().get(posOffset);
                RowKeyColumnExpression columnExpression = new RowKeyColumnExpression((PDatum)col2, new RowKeyValueAccessor(pkColumns, posOffset), col2.getName().getString());
                unusedPkColumns.remove(columnExpression);
                PDataType dataType = IndexUtil.getIndexColumnDataType(col2);
                ColumnName colName = ColumnName.caseSensitiveColumnName(IndexUtil.getIndexColumnName(col2));
                allPkColumns.add(new ColumnDefInPkConstraint(colName, col2.getSortOrder(), false));
                columnDefs.add(FACTORY.columnDef(colName, dataType.getSqlTypeName(), col2.isNullable(), col2.getMaxLength(), col2.getScale(), false, SortOrder.getDefault(), col2.getName().getString(), col2.isRowTimestamp()));
            }
            PhoenixStatement phoenixStatment = new PhoenixStatement(this.connection);
            StatementContext context = new StatementContext(phoenixStatment, resolver);
            IndexExpressionCompiler expressionIndexCompiler = new IndexExpressionCompiler(context);
            HashSet indexedColumnNames = Sets.newHashSetWithExpectedSize((int)indexParseNodeAndSortOrderList.size());
            for (Pair<ParseNode, SortOrder> pair : indexParseNodeAndSortOrderList) {
                ParseNode parseNode = (ParseNode)pair.getFirst();
                parseNode = StatementNormalizer.normalize(parseNode, resolver);
                expressionIndexCompiler.reset();
                Expression expression = parseNode.accept(expressionIndexCompiler);
                if (expressionIndexCompiler.isAggregate()) {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.AGGREGATE_EXPRESSION_NOT_ALLOWED_IN_INDEX).build().buildException();
                }
                if (expressionIndexCompiler.isJsonFragment()) {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.JSON_FRAGMENT_NOT_ALLOWED_IN_INDEX_EXPRESSION).build().buildException();
                }
                if (expression.getDeterminism() != Determinism.ALWAYS && expression.getDeterminism() != Determinism.PER_ROW) {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.NON_DETERMINISTIC_EXPRESSION_NOT_ALLOWED_IN_INDEX).build().buildException();
                }
                if (expression.isStateless()) {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.STATELESS_EXPRESSION_NOT_ALLOWED_IN_INDEX).build().buildException();
                }
                unusedPkColumns.remove(expression);
                StringBuilder buf = new StringBuilder();
                parseNode.toSQL(resolver, buf);
                String expressionStr = StringUtil.escapeBackslash(buf.toString());
                ColumnName colName = null;
                ColumnRef colRef = expressionIndexCompiler.getColumnRef();
                boolean isRowTimestamp = false;
                if (colRef != null) {
                    PColumn column = colRef.getColumn();
                    String columnFamilyName = column.getFamilyName() != null ? column.getFamilyName().getString() : null;
                    colName = ColumnName.caseSensitiveColumnName(IndexUtil.getIndexColumnName(columnFamilyName, column.getName().getString()));
                    isRowTimestamp = column.isRowTimestamp();
                } else {
                    String name = expressionStr.replaceAll("\"", "'");
                    colName = ColumnName.caseSensitiveColumnName(IndexUtil.getIndexColumnName(null, name));
                }
                indexedColumnNames.add(colName);
                PDataType dataType = IndexUtil.getIndexColumnDataType(expression.isNullable(), expression.getDataType());
                allPkColumns.add(new ColumnDefInPkConstraint(colName, (SortOrder)((Object)pair.getSecond()), isRowTimestamp));
                columnDefs.add(FACTORY.columnDef(colName, dataType.getSqlTypeName(), expression.isNullable(), expression.getMaxLength(), expression.getScale(), false, (SortOrder)((Object)pair.getSecond()), expressionStr, isRowTimestamp));
            }
            if (!unusedPkColumns.isEmpty()) {
                for (RowKeyColumnExpression colExpression : unusedPkColumns) {
                    col = dataTable.getPKColumns().get(colExpression.getPosition());
                    if (col.getViewConstant() != null) continue;
                    ColumnName colName = ColumnName.caseSensitiveColumnName(IndexUtil.getIndexColumnName(col));
                    allPkColumns.add(new ColumnDefInPkConstraint(colName, colExpression.getSortOrder(), col.isRowTimestamp()));
                    PDataType dataType = IndexUtil.getIndexColumnDataType(colExpression.isNullable(), colExpression.getDataType());
                    columnDefs.add(FACTORY.columnDef(colName, dataType.getSqlTypeName(), colExpression.isNullable(), colExpression.getMaxLength(), colExpression.getScale(), false, colExpression.getSortOrder(), colExpression.toString(), col.isRowTimestamp()));
                }
            }
            for (ColumnName colName : includedColumns) {
                col = resolver.resolveColumn(null, colName.getFamilyName(), colName.getColumnName()).getColumn();
                if (indexedColumnNames.contains(colName = ColumnName.caseSensitiveColumnName(IndexUtil.getIndexColumnName(col)))) {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.COLUMN_EXIST_IN_DEF).build().buildException();
                }
                if (SchemaUtil.isPKColumn(col) || col.getViewConstant() != null) continue;
                colName = ColumnName.caseSensitiveColumnName(isLocalIndex ? IndexUtil.getLocalIndexColumnFamily(col.getFamilyName().getString()) : col.getFamilyName().getString(), IndexUtil.getIndexColumnName(col));
                columnDefs.add(FACTORY.columnDef(colName, col.getDataType().getSqlTypeName(), col.isNullable(), col.getMaxLength(), col.getScale(), false, col.getSortOrder(), col.getExpressionStr(), col.isRowTimestamp()));
            }
            Configuration config = this.connection.getQueryServices().getConfiguration();
            if (!this.connection.getQueryServices().getProps().getBoolean("phoenix.disable.view.subtree.validation", false) && !"SYSTEM".equals(dataTable.getSchemaName().getString())) {
                this.verifyIfDescendentViewsExtendPk(dataTable, config);
            }
            if (dataTable.getType() == PTableType.VIEW) {
                String physicalName = dataTable.getPhysicalName().getString();
                physicalSchemaName = SchemaUtil.getSchemaNameFromFullName(physicalName);
                physicalTableName = SchemaUtil.getTableNameFromFullName(physicalName);
                ArrayList requiredCols = Lists.newArrayList((Iterable)indexedColumnNames);
                requiredCols.addAll(includedColumns);
                for (Object colName : requiredCols) {
                    String colNameSeparatedByDot = ((ColumnName)colName).getColumnName().replace(":", ".");
                    boolean acquiredMutex = this.writeCell(null, physicalSchemaName, physicalTableName, colNameSeparatedByDot);
                    if (!acquiredMutex) {
                        throw new ConcurrentTableMutationException(physicalSchemaName, physicalTableName);
                    }
                    acquiredColumnMutexSet.add(colNameSeparatedByDot);
                }
            }
            if ((threshold = Long.parseLong(config.get("phoenix.index.async.threshold"))) > 0L && !statement.isAsync()) {
                HashSet<String> columnFamilies = new HashSet<String>();
                for (ColumnDef column : columnDefs) {
                    try {
                        String columnFamily = IndexUtil.getDataColumnFamilyName(column.getColumnDefName().getColumnName());
                        columnFamilies.add(!columnFamily.equals("") ? columnFamily : (dataTable.getDefaultFamilyName() != null ? dataTable.getDefaultFamilyName().toString() : "0"));
                    }
                    catch (Exception exception) {}
                }
                long estimatedBytes = 0L;
                for (String colFamily : columnFamilies) {
                    long[] byteCounts;
                    GuidePostsInfo gps = this.connection.getQueryServices().getTableStats(new GuidePostsKey(Bytes.toBytes((String)tableRef.getTable().toString()), Bytes.toBytes((String)colFamily)));
                    for (long byteCount : byteCounts = gps.getByteCounts()) {
                        estimatedBytes += byteCount;
                    }
                    if (threshold >= estimatedBytes) continue;
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.ABOVE_INDEX_NON_ASYNC_THRESHOLD).build().buildException();
                }
            }
            if (dataTable.getDefaultFamilyName() != null && dataTable.getType() != PTableType.VIEW && !allocateIndexId) {
                statement.getProps().put((Object)"", (Object)new Pair((Object)"DEFAULT_COLUMN_FAMILY", (Object)dataTable.getDefaultFamilyName().getString()));
            }
            PrimaryKeyConstraint pk = FACTORY.primaryKey(null, allPkColumns);
            tableProps.put("DATA_TABLE_NAME", dataTable.getPhysicalName().getString());
            CreateTableStatement tableStatement = FACTORY.createTable(indexTableName, statement.getProps(), columnDefs, pk, statement.getSplitNodes(), PTableType.INDEX, statement.ifNotExists(), null, statement.getWhere(), statement.getBindCount(), null);
            table = this.createTableInternal(tableStatement, splits, dataTable, null, null, this.getViewIndexDataType(), null, null, null, allocateIndexId, statement.getIndexType(), asyncCreatedDate, null, tableProps, commonFamilyProps);
        }
        catch (Throwable throwable) {
            this.deleteMutexCells(physicalSchemaName, physicalTableName, acquiredColumnMutexSet);
            throw throwable;
        }
        this.deleteMutexCells(physicalSchemaName, physicalTableName, acquiredColumnMutexSet);
        if (table == null) {
            return new MutationState(0, 0L, this.connection);
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Created index " + table.getName().getString() + " at " + table.getTimeStamp());
        }
        boolean asyncIndexBuildEnabled = this.connection.getQueryServices().getProps().getBoolean("phoenix.index.async.build.enabled", true);
        if (statement.isAsync() && asyncIndexBuildEnabled) {
            return new MutationState(0, 0L, this.connection);
        }
        if (table.getIndexState() == PIndexState.CREATE_DISABLE) {
            return new MutationState(0, 0L, this.connection);
        }
        if (this.connection.getSCN() != null) {
            return this.buildIndexAtTimeStamp(table, statement.getTable());
        }
        MutationState state = this.buildIndex(table, tableRef);
        if (ValidateLastDDLTimestampUtil.getValidateLastDdlTimestampEnabled(this.connection)) {
            this.connection.removeTable(this.connection.getTenantId(), dataTable.getName().getString(), null, dataTable.getTimeStamp());
        }
        return state;
    }

    public MutationState createCDC(CreateCDCStatement statement) throws SQLException {
        int pkOffset;
        ColumnResolver resolver = FromCompiler.getResolver(NamedTableNode.create(statement.getDataTable()), this.connection);
        TableRef tableRef = resolver.getTables().get(0);
        PTable dataTable = tableRef.getTable();
        String dataTableFullName = SchemaUtil.getTableName(statement.getDataTable().getSchemaName(), statement.getDataTable().getTableName());
        String cdcObjName = statement.getCdcObjName().getName();
        String streamName = this.getStreamNameIfCDCEnabled(dataTableFullName);
        if (streamName != null) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.CDC_ALREADY_ENABLED).setTableName(streamName).build().buildException();
        }
        HashMap<String, Object> tableProps = Maps.newHashMapWithExpectedSize((int)statement.getProps().size());
        HashMap commonFamilyProps = Maps.newHashMapWithExpectedSize((int)(statement.getProps().size() + 1));
        this.populatePropertyMaps(statement.getProps(), (Map<String, Object>)tableProps, commonFamilyProps, PTableType.CDC, cdcObjName, false);
        Properties props = this.connection.getClientInfo();
        props.put("phoenix.index.create.default.state", "ACTIVE");
        String escapedDataTableFullName = SchemaUtil.getFullTableNameWithQuotes(statement.getDataTable().getSchemaName(), statement.getDataTable().getTableName(), true, true);
        String createIndexSql = "CREATE UNCOVERED INDEX " + (statement.isIfNotExists() ? "IF NOT EXISTS " : "") + "\"" + CDCUtil.getCDCIndexName(cdcObjName) + "\" ON " + escapedDataTableFullName + " (" + "PARTITION_ID" + "(), " + "PHOENIX_ROW_TIMESTAMP" + "()) ASYNC";
        ArrayList<String> indexProps = new ArrayList<String>();
        indexProps.add("REPLICATION_SCOPE=0");
        if (TableProperty.SALT_BUCKETS.getValue((Map<String, Object>)tableProps) != null) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.SALTING_NOT_ALLOWED_FOR_CDC).setTableName(cdcObjName).build().buildException();
        }
        indexProps.add("SALT_BUCKETS=0");
        Object columnEncodedBytes = TableProperty.COLUMN_ENCODED_BYTES.getValue((Map<String, Object>)tableProps);
        if (columnEncodedBytes != null) {
            indexProps.add("COLUMN_ENCODED_BYTES=" + columnEncodedBytes);
        }
        createIndexSql = createIndexSql + EMPTY_TABLE + String.join((CharSequence)", ", indexProps);
        try (java.sql.Connection internalConnection = QueryUtil.getConnection(props, this.connection.getQueryServices().getConfiguration());){
            PhoenixStatement pstmt = new PhoenixStatement((PhoenixConnection)internalConnection);
            pstmt.execute(createIndexSql);
        }
        catch (SQLException e) {
            if (e.getErrorCode() == SQLExceptionCode.TABLE_ALREADY_EXIST.getErrorCode()) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.TABLE_ALREADY_EXIST).setTableName(cdcObjName).setRootCause(e).build().buildException();
            }
            throw e;
        }
        List<PColumn> pkColumns = dataTable.getPKColumns();
        ArrayList<ColumnDef> columnDefs = new ArrayList<ColumnDef>();
        ArrayList<ColumnDefInPkConstraint> pkColumnDefs = new ArrayList<ColumnDefInPkConstraint>();
        for (int i = pkOffset = dataTable.getBucketNum() != null ? 1 : 0; i < pkColumns.size(); ++i) {
            PColumn pcol = pkColumns.get(i);
            columnDefs.add(FACTORY.columnDef(FACTORY.columnName("\"" + pcol.getName().getString() + "\""), pcol.getDataType().getSqlTypeName(), false, null, false, pcol.getMaxLength(), pcol.getScale(), false, pcol.getSortOrder(), "", null, false));
            pkColumnDefs.add(FACTORY.columnDefInPkConstraint(FACTORY.columnName("\"" + pcol.getName().getString() + "\""), pcol.getSortOrder(), pcol.isRowTimestamp()));
        }
        columnDefs.add(FACTORY.columnDef(FACTORY.columnName("CDC JSON"), PVarchar.INSTANCE.getSqlTypeName(), false, null, true, null, null, false, SortOrder.getDefault(), "", null, false));
        tableProps = new HashMap<String, Object>();
        if (dataTable.getImmutableStorageScheme() == PTable.ImmutableStorageScheme.SINGLE_CELL_ARRAY_WITH_OFFSETS) {
            tableProps.put(TableProperty.IMMUTABLE_STORAGE_SCHEME.getPropertyName(), PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN.name());
        }
        if (dataTable.isMultiTenant()) {
            tableProps.put(TableProperty.MULTI_TENANT.getPropertyName(), Boolean.TRUE);
        }
        CreateTableStatement tableStatement = FACTORY.createTable(org.apache.phoenix.parse.TableName.create(dataTable.getSchemaName().getString(), cdcObjName), null, columnDefs, FACTORY.primaryKey(null, pkColumnDefs), Collections.emptyList(), PTableType.CDC, statement.isIfNotExists(), null, null, statement.getBindCount(), null);
        this.createTableInternal(tableStatement, null, dataTable, null, null, null, null, null, null, false, null, null, statement.getIncludeScopes(), tableProps, commonFamilyProps);
        if (PTableType.TABLE == dataTable.getType()) {
            this.updateStreamPartitionMetadata(dataTableFullName, cdcObjName);
        }
        return new MutationState(0, 0L, this.connection);
    }

    private void updateStreamPartitionMetadata(String tableName, String cdcObjName) throws SQLException {
        long cdcIndexTimestamp = CDCUtil.getCDCCreationTimestamp(this.connection.getTable(tableName));
        String streamName = String.format(CDCUtil.CDC_STREAM_NAME_FORMAT, tableName, cdcObjName, cdcIndexTimestamp, CDCUtil.getCDCCreationUTCDateTime(cdcIndexTimestamp));
        this.markCDCStreamStatus(tableName, streamName, CDCUtil.CdcStreamStatus.ENABLING);
        try {
            List<Mutation> sysTaskUpsertMutations = Task.getMutationsForAddTask(new SystemTaskParams.SystemTaskParamsBuilder().setConn(this.connection).setTaskType(PTable.TaskType.CDC_STREAM_PARTITION).setTableName(tableName).setSchemaName(streamName).build());
            byte[] rowKey = sysTaskUpsertMutations.get(0).getRow();
            MetaDataProtocol.MetaDataMutationResult metaDataMutationResult = Task.taskMetaDataCoprocessorExec(this.connection, rowKey, new TaskMetaDataServiceCallBack(sysTaskUpsertMutations));
            if (MetaDataProtocol.MutationCode.UNABLE_TO_UPSERT_TASK.equals((Object)metaDataMutationResult.getMutationCode())) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.UNABLE_TO_UPSERT_TASK).setSchemaName("SYSTEM").setTableName("TASK").build().buildException();
            }
        }
        catch (IOException ioe) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.UNABLE_TO_UPSERT_TASK).setRootCause(ioe).setMessage(ioe.getMessage()).setSchemaName("SYSTEM").setTableName("TASK").build().buildException();
        }
    }

    public String getStreamNameIfCDCEnabled(String tableName) throws SQLException {
        String query = "SELECT STREAM_NAME FROM " + PhoenixDatabaseMetaData.SYSTEM_CDC_STREAM_STATUS_NAME + " WHERE TABLE_NAME = ? AND STREAM_STATUS IN (?, ?)";
        try (PreparedStatement ps = this.connection.prepareStatement(query);){
            ps.setString(1, tableName);
            ps.setString(2, CDCUtil.CdcStreamStatus.ENABLING.getSerializedValue());
            ps.setString(3, CDCUtil.CdcStreamStatus.ENABLED.getSerializedValue());
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                String string = rs.getString(1);
                return string;
            }
        }
        return null;
    }

    private void verifyIfDescendentViewsExtendPk(PTable tableOrView, Configuration config) throws SQLException {
        DelegateQueryServices services;
        if (this.connection.getQueryServices() instanceof ConnectionlessQueryServicesImpl) {
            return;
        }
        if (this.connection.getQueryServices() instanceof DelegateQueryServices && (services = (DelegateQueryServices)((Object)this.connection.getQueryServices())).getDelegate() instanceof ConnectionlessQueryServicesImpl) {
            return;
        }
        byte[] systemChildLinkTable = SchemaUtil.isNamespaceMappingEnabled(null, config) ? PhoenixDatabaseMetaData.SYSTEM_CHILD_LINK_NAMESPACE_BYTES : PhoenixDatabaseMetaData.SYSTEM_CHILD_LINK_NAME_BYTES;
        try (Table childLinkTable = this.connection.getQueryServices().getTable(systemChildLinkTable);){
            byte[] tenantId = this.connection.getTenantId() == null ? null : this.connection.getTenantId().getBytes();
            byte[] schemaNameBytes = tableOrView.getSchemaName().getBytes();
            byte[] viewOrTableName = tableOrView.getTableName().getBytes();
            Pair<List<PTable>, List<TableInfo>> descViews = ViewUtil.findAllDescendantViews(childLinkTable, config, tenantId, schemaNameBytes, viewOrTableName, Long.MAX_VALUE, false, false);
            List legitimateChildViews = (List)descViews.getFirst();
            int dataTableOrViewPkCols = tableOrView.getPKColumns().size();
            if (legitimateChildViews != null && legitimateChildViews.size() > 0) {
                for (PTable childView : legitimateChildViews) {
                    if (childView.getPKColumns().size() <= dataTableOrViewPkCols) continue;
                    LOGGER.error("Creation of view index not allowed as child view {} extends pk", (Object)childView.getName());
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_CREATE_INDEX_CHILD_VIEWS_EXTEND_PK).build().buildException();
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("Error while retrieving descendent views", (Throwable)e);
            throw new SQLException(e);
        }
    }

    public MutationState dropSequence(DropSequenceStatement statement) throws SQLException {
        Long scn = this.connection.getSCN();
        long timestamp = scn == null ? Long.MAX_VALUE : scn;
        String schemaName = this.connection.getSchema() != null && statement.getSequenceName().getSchemaName() == null ? this.connection.getSchema() : statement.getSequenceName().getSchemaName();
        String sequenceName = statement.getSequenceName().getTableName();
        String tenantId = this.connection.getTenantId() == null ? null : this.connection.getTenantId().getString();
        try {
            this.connection.getQueryServices().dropSequence(tenantId, schemaName, sequenceName, timestamp);
        }
        catch (SequenceNotFoundException e) {
            if (statement.ifExists()) {
                return new MutationState(0, 0L, this.connection);
            }
            throw e;
        }
        return new MutationState(1, 1000L, this.connection);
    }

    public MutationState createSequence(CreateSequenceStatement statement, long startWith, long incrementBy, long cacheSize, long minValue, long maxValue) throws SQLException {
        Long scn = this.connection.getSCN();
        long timestamp = scn == null ? Long.MAX_VALUE : scn;
        String tenantId = this.connection.getTenantId() == null ? null : this.connection.getTenantId().getString();
        String schemaName = statement.getSequenceName().getSchemaName();
        if (SchemaUtil.isNamespaceMappingEnabled(null, this.connection.getQueryServices().getProps())) {
            if (schemaName == null || schemaName.equals("")) {
                schemaName = this.connection.getSchema();
            }
            if (schemaName != null) {
                FromCompiler.getResolverForSchema(schemaName, this.connection);
            }
        }
        return this.createSequence(tenantId, schemaName, statement.getSequenceName().getTableName(), statement.ifNotExists(), startWith, incrementBy, cacheSize, statement.getCycle(), minValue, maxValue, timestamp);
    }

    private MutationState createSequence(String tenantId, String schemaName, String sequenceName, boolean ifNotExists, long startWith, long incrementBy, long cacheSize, boolean cycle, long minValue, long maxValue, long timestamp) throws SQLException {
        try {
            this.connection.getQueryServices().createSequence(tenantId, schemaName, sequenceName, startWith, incrementBy, cacheSize, minValue, maxValue, cycle, timestamp);
        }
        catch (SequenceAlreadyExistsException e) {
            if (ifNotExists) {
                return new MutationState(0, 0L, this.connection);
            }
            throw e;
        }
        return new MutationState(1, 1000L, this.connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutationState createFunction(CreateFunctionStatement stmt) throws SQLException {
        boolean wasAutoCommit = this.connection.getAutoCommit();
        this.connection.rollback();
        try {
            PFunction function = new PFunction(stmt.getFunctionInfo(), stmt.isTemporary(), stmt.isReplace());
            this.connection.setAutoCommit(false);
            String tenantIdStr = this.connection.getTenantId() == null ? null : this.connection.getTenantId().getString();
            ArrayList functionData = Lists.newArrayListWithExpectedSize((int)(function.getFunctionArguments().size() + 1));
            List<PFunction.FunctionArgument> args = function.getFunctionArguments();
            try (PreparedStatement argUpsert = this.connection.prepareStatement(INSERT_FUNCTION_ARGUMENT);){
                for (int i = 0; i < args.size(); ++i) {
                    PFunction.FunctionArgument arg = args.get(i);
                    this.addFunctionArgMutation(function.getFunctionName(), arg, argUpsert, i);
                }
                functionData.addAll((Collection)this.connection.getMutationState().toMutations().next().getSecond());
                this.connection.rollback();
            }
            var8_8 = null;
            try (PreparedStatement functionUpsert = this.connection.prepareStatement(CREATE_FUNCTION);){
                functionUpsert.setString(1, tenantIdStr);
                functionUpsert.setString(2, function.getFunctionName());
                functionUpsert.setInt(3, function.getFunctionArguments().size());
                functionUpsert.setString(4, function.getClassName());
                functionUpsert.setString(5, function.getJarPath());
                functionUpsert.setString(6, function.getReturnType());
                functionUpsert.execute();
                functionData.addAll((Collection)this.connection.getMutationState().toMutations(null).next().getSecond());
                this.connection.rollback();
            }
            catch (Throwable i) {
                var8_8 = i;
                throw i;
            }
            MetaDataProtocol.MetaDataMutationResult result = this.connection.getQueryServices().createFunction(functionData, function, stmt.isTemporary());
            MetaDataProtocol.MutationCode code = result.getMutationCode();
            switch (code) {
                case FUNCTION_ALREADY_EXISTS: {
                    if (!function.isReplace()) {
                        throw new FunctionAlreadyExistsException(function.getFunctionName(), result.getFunctions().get(0));
                    }
                    this.connection.removeFunction(function.getTenantId(), function.getFunctionName(), result.getMutationTime());
                    this.addFunctionToCache(result);
                }
                case NEWER_FUNCTION_FOUND: {
                    throw new NewerFunctionAlreadyExistsException(function.getFunctionName(), result.getFunctions().get(0));
                }
            }
            ArrayList<PFunction> functions = new ArrayList<PFunction>(1);
            functions.add(function);
            result = new MetaDataProtocol.MetaDataMutationResult(code, result.getMutationTime(), functions, true);
            if (function.isReplace()) {
                this.connection.removeFunction(function.getTenantId(), function.getFunctionName(), result.getMutationTime());
            }
            this.addFunctionToCache(result);
        }
        finally {
            this.connection.setAutoCommit(wasAutoCommit);
        }
        return new MutationState(1, 1000L, this.connection);
    }

    private static ColumnDef findColumnDefOrNull(List<ColumnDef> colDefs, ColumnName colName) {
        for (ColumnDef colDef : colDefs) {
            if (!colDef.getColumnDefName().getColumnName().equals(colName.getColumnName())) continue;
            return colDef;
        }
        return null;
    }

    private static boolean checkAndValidateRowTimestampCol(ColumnDef colDef, PrimaryKeyConstraint pkConstraint, boolean rowTimeStampColAlreadyFound, PTableType tableType) throws SQLException {
        ColumnName columnDefName = colDef.getColumnDefName();
        if (tableType == PTableType.VIEW && (pkConstraint.getNumColumnsWithRowTimestamp() > 0 || colDef.isRowTimestamp())) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.ROWTIMESTAMP_NOT_ALLOWED_ON_VIEW).setColumnName(columnDefName.getColumnName()).build().buildException();
        }
        if (tableType == PTableType.TABLE) {
            boolean isColumnDeclaredRowTimestamp;
            boolean bl = isColumnDeclaredRowTimestamp = colDef.isRowTimestamp() || pkConstraint.isColumnRowTimestamp(columnDefName);
            if (isColumnDeclaredRowTimestamp) {
                boolean isColumnPartOfPk;
                boolean bl2 = isColumnPartOfPk = colDef.isPK() || pkConstraint.contains(columnDefName);
                if (isColumnDeclaredRowTimestamp && !isColumnPartOfPk) {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.ROWTIMESTAMP_PK_COL_ONLY).setColumnName(columnDefName.getColumnName()).build().buildException();
                }
                PDataType dataType = colDef.getDataType();
                if (isColumnDeclaredRowTimestamp && dataType != PLong.INSTANCE && dataType != PUnsignedLong.INSTANCE && !dataType.isCoercibleTo(PTimestamp.INSTANCE)) {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.ROWTIMESTAMP_COL_INVALID_TYPE).setColumnName(columnDefName.getColumnName()).build().buildException();
                }
                if (rowTimeStampColAlreadyFound && isColumnDeclaredRowTimestamp) {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.ROWTIMESTAMP_ONE_PK_COL_ONLY).setColumnName(columnDefName.getColumnName()).build().buildException();
                }
                return true;
            }
        }
        return false;
    }

    private boolean writeCell(String tenantId, String schemaName, String tableName, String columnName) throws SQLException {
        return this.connection.getQueryServices().writeMutexCell(tenantId, schemaName, tableName, columnName, null);
    }

    private void deleteCell(String tenantId, String schemaName, String tableName, String columnName) throws SQLException {
        this.connection.getQueryServices().deleteMutexCell(tenantId, schemaName, tableName, columnName, null);
    }

    private void populateFamilyPropsList(Map<String, PName> familyNames, Map<String, Object> commonFamilyProps, CreateTableStatement statement, String defaultFamilyName, boolean isLocalIndex, List<Pair<byte[], Map<String, Object>>> familyPropList) throws SQLException {
        for (PName familyName : familyNames.values()) {
            String fam = familyName.getString();
            List propsForCF = statement.getProps().get((Object)IndexUtil.getActualColumnFamilyName(fam));
            if (propsForCF.isEmpty()) {
                familyPropList.add((Pair<byte[], Map<String, Object>>)new Pair((Object)familyName.getBytes(), commonFamilyProps));
                continue;
            }
            HashMap combinedFamilyProps = Maps.newHashMapWithExpectedSize((int)(propsForCF.size() + commonFamilyProps.size()));
            combinedFamilyProps.putAll(commonFamilyProps);
            for (Pair prop : propsForCF) {
                if (!fam.equals("") && MetaDataUtil.propertyNotAllowedToBeOutOfSync((String)prop.getFirst())) {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.COLUMN_FAMILY_NOT_ALLOWED_FOR_PROPERTY).setMessage("Property: " + (String)prop.getFirst()).build().buildException();
                }
                combinedFamilyProps.put(prop.getFirst(), prop.getSecond());
            }
            familyPropList.add((Pair<byte[], Map<String, Object>>)new Pair((Object)familyName.getBytes(), (Object)combinedFamilyProps));
        }
        if (familyNames.isEmpty()) {
            byte[] cf = defaultFamilyName == null ? (!isLocalIndex ? QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES : QueryConstants.DEFAULT_LOCAL_INDEX_COLUMN_FAMILY_BYTES) : Bytes.toBytes((String)defaultFamilyName);
            familyPropList.add((Pair<byte[], Map<String, Object>>)new Pair((Object)cf, commonFamilyProps));
        }
    }

    private TTLExpression checkAndGetTTLFromHierarchy(PTable parent, String entityName) throws SQLException {
        if (CDCUtil.isCDCIndex(entityName)) {
            return LiteralTTLExpression.TTL_EXPRESSION_FOREVER;
        }
        return parent != null ? (parent.getType() == PTableType.TABLE ? parent.getTTLExpression() : (parent.getType() == PTableType.VIEW && parent.getViewType() != PTable.ViewType.MAPPED ? this.getTTLFromViewHierarchy(parent) : LiteralTTLExpression.TTL_EXPRESSION_NOT_DEFINED)) : LiteralTTLExpression.TTL_EXPRESSION_NOT_DEFINED;
    }

    private TTLExpression getTTLFromViewHierarchy(PTable view) throws SQLException {
        return !view.getTTLExpression().equals(LiteralTTLExpression.TTL_EXPRESSION_NOT_DEFINED) ? view.getTTLExpression() : (this.checkIfParentIsTable(view) ? PhoenixRuntime.getTable(this.connection, view.getPhysicalNames().get(0).toString()).getTTLExpression() : this.getTTLFromViewHierarchy(PhoenixRuntime.getTable(this.connection, view.getParentName().toString())));
    }

    private boolean checkIfParentIsTable(PTable view) {
        PName parentName = view.getParentName();
        if (parentName == null) {
            return true;
        }
        return parentName.getString().equals(view.getPhysicalName().getString());
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PTable createTableInternal(CreateTableStatement statement, byte[][] splits, PTable parent, String viewStatement, PTable.ViewType viewType, PDataType viewIndexIdType, byte[] rowKeyMatcher, final byte[][] viewColumnConstants, final BitSet isViewColumnReferenced, boolean allocateIndexId, PTable.IndexType indexType, Date asyncCreatedDate, Set<PTable.CDCChangeScope> cdcIncludeScopes, Map<String, Object> tableProps, Map<String, Object> commonFamilyProps) throws SQLException {
        PTableType tableType = statement.getTableType();
        boolean wasAutoCommit = this.connection.getAutoCommit();
        org.apache.phoenix.parse.TableName tableNameNode = null;
        boolean allowSystemCatalogRollback = this.connection.getQueryServices().getProps().getBoolean("phoenix.allow.system.catalog.rollback", false);
        HashSet acquiredColumnMutexSet = Sets.newHashSetWithExpectedSize((int)3);
        String parentPhysicalName = parent != null && parent.getPhysicalName() != null ? parent.getPhysicalName().getString() : null;
        String parentPhysicalSchemaName = parentPhysicalName != null ? SchemaUtil.getSchemaNameFromFullName(parentPhysicalName) : null;
        String parentPhysicalTableName = parentPhysicalName != null ? SchemaUtil.getTableNameFromFullName(parentPhysicalName) : null;
        this.connection.rollback();
        try {
            MetaDataProtocol.MutationCode code;
            MetaDataProtocol.MetaDataMutationResult result;
            PIndexState indexState;
            PTable.EncodedCQCounter cqCounter;
            LinkedHashMap<PColumn, PColumn> columns;
            Boolean useStatsForParallelizationProp;
            String autoPartitionSeq;
            long updateCacheFrequency;
            boolean disableWAL;
            String pkName;
            String streamingTopicName;
            String schemaVersion;
            boolean isStrictTTL;
            Boolean isChangeDetectionEnabledProp;
            TTLExpression ttlFromHierarchy;
            TTLExpression ttl;
            int baseTableColumnCount;
            PTable.ImmutableStorageScheme immutableStorageScheme;
            PTable.QualifierEncodingScheme encodingScheme;
            boolean isNamespaceMapped;
            Long timestamp;
            boolean rowKeyOrderOptimizable;
            List<Object> physicalNames;
            boolean isAppendOnlySchema;
            boolean isImmutableRows;
            String defaultFamilyName;
            Integer saltBucketNum;
            TransactionFactory.Provider transactionProvider;
            boolean storeNulls;
            boolean multiTenant;
            PName tenantId;
            String tableName;
            String schemaName;
            block306: {
                PColumn autoPartitionCol;
                PName parentName;
                void var97_159;
                void var98_179;
                PIndexState pIndexState;
                Object column;
                PTable viewPhysicalTable;
                HashMap inputCqCounters;
                HashMap changedCqCounters;
                void position;
                int n;
                boolean rowTimeStampColumnAlreadyFound;
                LinkedHashMap familyNames;
                LinkedHashSet pkColumns;
                List<ColumnDef> colDefs;
                boolean sharedTable;
                Long guidePostsWidth;
                String physicalTableName;
                Iterator<Object> pkColumnsIterator;
                List<Object> pkColumnsNames;
                PrimaryKeyConstraint pkConstraint;
                String cdcIncludeScopesStr;
                boolean isLocalIndex;
                String tenantIdStr;
                String parentTableName;
                ArrayList tableMetaData;
                block310: {
                    block309: {
                        void var82_109;
                        Object linkStatement;
                        boolean addSaltColumn;
                        block308: {
                            block307: {
                                int autoPartitionColIndex;
                                Object dataType;
                                Object transactionTTL;
                                boolean transactionsEnabled;
                                boolean transactional;
                                this.connection.setAutoCommit(false);
                                tableMetaData = Lists.newArrayListWithExpectedSize((int)(statement.getColumnDefs().size() + 3));
                                tableNameNode = statement.getTableName();
                                schemaName = this.connection.getSchema() != null && tableNameNode.getSchemaName() == null ? this.connection.getSchema() : tableNameNode.getSchemaName();
                                tableName = tableNameNode.getTableName();
                                String fullTableName = SchemaUtil.getTableName(schemaName, tableName);
                                parentTableName = null;
                                tenantId = this.connection.getTenantId();
                                tenantIdStr = tenantId == null ? null : tenantId.getString();
                                Long scn = this.connection.getSCN();
                                long clientTimeStamp = scn == null ? Long.MAX_VALUE : scn;
                                multiTenant = false;
                                storeNulls = false;
                                transactionProvider = parent != null ? parent.getTransactionProvider() : null;
                                saltBucketNum = null;
                                defaultFamilyName = null;
                                isImmutableRows = false;
                                isAppendOnlySchema = false;
                                physicalNames = Collections.emptyList();
                                addSaltColumn = false;
                                rowKeyOrderOptimizable = true;
                                timestamp = null;
                                isNamespaceMapped = parent == null ? SchemaUtil.isNamespaceMappingEnabled(tableType, this.connection.getQueryServices().getProps()) : parent.isNamespaceMapped();
                                isLocalIndex = indexType == PTable.IndexType.LOCAL;
                                encodingScheme = PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS;
                                immutableStorageScheme = PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN;
                                baseTableColumnCount = tableType == PTableType.VIEW ? parent.getColumns().size() : -1;
                                ttl = LiteralTTLExpression.TTL_EXPRESSION_NOT_DEFINED;
                                ttlFromHierarchy = LiteralTTLExpression.TTL_EXPRESSION_NOT_DEFINED;
                                TTLExpression ttlProp = (TTLExpression)TableProperty.TTL.getValue(tableProps);
                                if (ttlProp != null) {
                                    if (!this.isViewTTLEnabled() && tableType == PTableType.VIEW) {
                                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.VIEW_TTL_NOT_ENABLED).setSchemaName(schemaName).setTableName(tableName).build().buildException();
                                    }
                                    if (!MetaDataUtil.isTTLSupported(tableType, viewType, fullTableName)) {
                                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.TTL_SUPPORTED_FOR_TABLES_AND_VIEWS_ONLY).setSchemaName(schemaName).setTableName(tableName).build().buildException();
                                    }
                                    ttlFromHierarchy = this.checkAndGetTTLFromHierarchy(parent, tableName);
                                    if (!ttlFromHierarchy.equals(LiteralTTLExpression.TTL_EXPRESSION_NOT_DEFINED)) {
                                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.TTL_ALREADY_DEFINED_IN_HIERARCHY).setSchemaName(schemaName).setTableName(tableName).build().buildException();
                                    }
                                    try {
                                        ttlProp.validateTTLOnCreate(this.connection, statement, parent, tableProps);
                                    }
                                    catch (IllegalArgumentException e) {
                                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.ILLEGAL_DATA).setMessage(e.getMessage()).setSchemaName(schemaName).setTableName(tableName).build().buildException();
                                    }
                                    ttl = MetaDataUtil.getCompatibleTTLExpression(ttlProp, tableType, viewType, fullTableName);
                                } else {
                                    ttlFromHierarchy = this.checkAndGetTTLFromHierarchy(parent, tableName);
                                    if (!ttlFromHierarchy.equals(LiteralTTLExpression.TTL_EXPRESSION_NOT_DEFINED)) {
                                        ttlFromHierarchy.validateTTLOnCreate(this.connection, statement, parent, tableProps);
                                    }
                                }
                                isChangeDetectionEnabledProp = (Boolean)TableProperty.CHANGE_DETECTION_ENABLED.getValue(tableProps);
                                this.verifyChangeDetectionTableType(tableType, isChangeDetectionEnabledProp);
                                Boolean isStrictTTLProp = (Boolean)TableProperty.IS_STRICT_TTL.getValue(tableProps);
                                isStrictTTL = tableType == PTableType.INDEX && parent != null ? parent.isStrictTTL() : (isStrictTTLProp != null ? isStrictTTLProp : true);
                                schemaVersion = (String)TableProperty.SCHEMA_VERSION.getValue(tableProps);
                                streamingTopicName = (String)TableProperty.STREAMING_TOPIC_NAME.getValue(tableProps);
                                String string = cdcIncludeScopesStr = cdcIncludeScopes == null ? null : CDCUtil.makeChangeScopeStringFromEnums(cdcIncludeScopes);
                                if (parent != null && tableType == PTableType.INDEX) {
                                    Object parentName2;
                                    timestamp = TransactionUtil.getTableTimestamp(this.connection, transactionProvider != null, transactionProvider);
                                    isImmutableRows = parent.isImmutableRows();
                                    isAppendOnlySchema = parent.isAppendOnlySchema();
                                    if (isLocalIndex || parent.getType() == PTableType.VIEW && parent.getViewType() != PTable.ViewType.MAPPED) {
                                        PName physicalName = parent.getPhysicalName();
                                        saltBucketNum = parent.getBucketNum();
                                        addSaltColumn = saltBucketNum != null && !isLocalIndex;
                                        String string2 = defaultFamilyName = parent.getDefaultFamilyName() == null ? null : parent.getDefaultFamilyName().getString();
                                        if (isLocalIndex) {
                                            defaultFamilyName = parent.getDefaultFamilyName() == null ? "L#0" : IndexUtil.getLocalIndexColumnFamily(parent.getDefaultFamilyName().getString());
                                            saltBucketNum = null;
                                            physicalNames = Collections.singletonList(PNameFactory.newName(physicalName.getBytes()));
                                        } else {
                                            defaultFamilyName = parent.getDefaultFamilyName() == null ? "0" : parent.getDefaultFamilyName().getString();
                                            parentName2 = parent.getBaseTableLogicalName();
                                            physicalNames = Collections.singletonList(PNameFactory.newName(MetaDataUtil.getViewIndexPhysicalName((PName)parentName2, isNamespaceMapped)));
                                        }
                                    }
                                    multiTenant = parent.isMultiTenant();
                                    storeNulls = parent.getStoreNulls();
                                    parentTableName = parent.getTableName().getString();
                                    PreparedStatement incrementStatement = this.connection.prepareStatement(INCREMENT_SEQ_NUM);
                                    parentName2 = null;
                                    try {
                                        incrementStatement.setString(1, tenantIdStr);
                                        incrementStatement.setString(2, schemaName);
                                        incrementStatement.setString(3, parentTableName);
                                        incrementStatement.setLong(4, parent.getSequenceNumber());
                                        incrementStatement.execute();
                                        tableMetaData.addAll((Collection)this.connection.getMutationState().toMutations(timestamp).next().getSecond());
                                        this.connection.rollback();
                                    }
                                    catch (Throwable throwable) {
                                        parentName2 = throwable;
                                        throw throwable;
                                    }
                                    finally {
                                        if (incrementStatement != null) {
                                            if (parentName2 != null) {
                                                try {
                                                    incrementStatement.close();
                                                }
                                                catch (Throwable throwable) {
                                                    ((Throwable)parentName2).addSuppressed(throwable);
                                                }
                                            } else {
                                                incrementStatement.close();
                                            }
                                        }
                                    }
                                    PreparedStatement linkStatement2 = this.connection.prepareStatement(CREATE_LINK);
                                    parentName2 = null;
                                    try {
                                        linkStatement2.setString(1, tenantIdStr);
                                        linkStatement2.setString(2, schemaName);
                                        linkStatement2.setString(3, parentTableName);
                                        linkStatement2.setString(4, tableName);
                                        linkStatement2.setByte(5, PTable.LinkType.INDEX_TABLE.getSerializedValue());
                                        linkStatement2.setLong(6, parent.getSequenceNumber());
                                        linkStatement2.setString(7, PTableType.INDEX.getSerializedValue());
                                        linkStatement2.execute();
                                    }
                                    catch (Throwable throwable) {
                                        parentName2 = throwable;
                                        throw throwable;
                                    }
                                    finally {
                                        if (linkStatement2 != null) {
                                            if (parentName2 != null) {
                                                try {
                                                    linkStatement2.close();
                                                }
                                                catch (Throwable throwable) {
                                                    ((Throwable)parentName2).addSuppressed(throwable);
                                                }
                                            } else {
                                                linkStatement2.close();
                                            }
                                        }
                                    }
                                    if (parent.getType() == PTableType.VIEW) {
                                        linkStatement2 = this.connection.prepareStatement(CREATE_VIEW_INDEX_PARENT_LINK);
                                        parentName2 = null;
                                        try {
                                            linkStatement2.setString(1, tenantIdStr);
                                            linkStatement2.setString(2, schemaName);
                                            linkStatement2.setString(3, tableName);
                                            linkStatement2.setString(4, parent.getName().getString());
                                            linkStatement2.setByte(5, PTable.LinkType.VIEW_INDEX_PARENT_TABLE.getSerializedValue());
                                            linkStatement2.execute();
                                        }
                                        catch (Throwable throwable) {
                                            parentName2 = throwable;
                                            throw throwable;
                                        }
                                        finally {
                                            if (linkStatement2 != null) {
                                                if (parentName2 != null) {
                                                    try {
                                                        linkStatement2.close();
                                                    }
                                                    catch (Throwable throwable) {
                                                        ((Throwable)parentName2).addSuppressed(throwable);
                                                    }
                                                } else {
                                                    linkStatement2.close();
                                                }
                                            }
                                        }
                                    }
                                }
                                pkConstraint = statement.getPrimaryKeyConstraint();
                                pkName = null;
                                pkColumnsNames = Collections.emptyList();
                                pkColumnsIterator = Collections.emptyIterator();
                                if (pkConstraint != null) {
                                    pkColumnsNames = pkConstraint.getColumnNames();
                                    pkColumnsIterator = pkColumnsNames.iterator();
                                    pkName = pkConstraint.getName();
                                }
                                if (tableType != PTableType.INDEX && (tableType != PTableType.VIEW || viewType == PTable.ViewType.MAPPED)) {
                                    Boolean isImmutableRowsProp = statement.immutableRows() != null ? statement.immutableRows() : (Boolean)TableProperty.IMMUTABLE_ROWS.getValue(tableProps);
                                    isImmutableRows = isImmutableRowsProp == null ? this.connection.getQueryServices().getProps().getBoolean("phoenix.mutate.immutableRows", false) : isImmutableRowsProp.booleanValue();
                                }
                                if (tableType == PTableType.TABLE) {
                                    Boolean isAppendOnlySchemaProp = (Boolean)TableProperty.APPEND_ONLY_SCHEMA.getValue(tableProps);
                                    boolean bl = isAppendOnlySchema = isAppendOnlySchemaProp != null ? isAppendOnlySchemaProp : false;
                                }
                                if (tableType != PTableType.VIEW && tableType != PTableType.CDC && !allocateIndexId) {
                                    saltBucketNum = (Integer)TableProperty.SALT_BUCKETS.getValue(tableProps);
                                    if (saltBucketNum != null) {
                                        if (saltBucketNum < 0) throw new SQLExceptionInfo.Builder(SQLExceptionCode.INVALID_BUCKET_NUM).build().buildException();
                                        if (saltBucketNum > SaltingUtil.MAX_BUCKET_NUM) {
                                            throw new SQLExceptionInfo.Builder(SQLExceptionCode.INVALID_BUCKET_NUM).build().buildException();
                                        }
                                    }
                                    if (saltBucketNum == null) {
                                        if (parent != null) {
                                            saltBucketNum = parent.getBucketNum();
                                        }
                                    } else if (saltBucketNum == 0) {
                                        saltBucketNum = null;
                                    }
                                    boolean bl = addSaltColumn = saltBucketNum != null;
                                }
                                if (tableType != PTableType.INDEX && (tableType != PTableType.VIEW || viewType == PTable.ViewType.MAPPED)) {
                                    Boolean multiTenantProp = (Boolean)tableProps.get("MULTI_TENANT");
                                    multiTenant = Boolean.TRUE.equals(multiTenantProp);
                                    defaultFamilyName = (String)TableProperty.DEFAULT_COLUMN_FAMILY.getValue(tableProps);
                                }
                                disableWAL = false;
                                Boolean disableWALProp = (Boolean)TableProperty.DISABLE_WAL.getValue(tableProps);
                                if (disableWALProp != null) {
                                    disableWAL = disableWALProp;
                                }
                                updateCacheFrequency = (Long)ConnectionProperty.UPDATE_CACHE_FREQUENCY.getValue(this.connection.getQueryServices().getProps().get("phoenix.default.update.cache.frequency"));
                                if (tableType == PTableType.INDEX && parent != null) {
                                    updateCacheFrequency = parent.getUpdateCacheFrequency();
                                }
                                Long updateCacheFrequencyProp = (Long)TableProperty.UPDATE_CACHE_FREQUENCY.getValue(tableProps);
                                if (tableType != PTableType.INDEX && updateCacheFrequencyProp != null) {
                                    updateCacheFrequency = updateCacheFrequencyProp;
                                }
                                physicalTableName = (String)TableProperty.PHYSICAL_TABLE_NAME.getValue(tableProps);
                                autoPartitionSeq = (String)TableProperty.AUTO_PARTITION_SEQ.getValue(tableProps);
                                guidePostsWidth = (Long)TableProperty.GUIDE_POSTS_WIDTH.getValue(tableProps);
                                if (guidePostsWidth != null && tableType != PTableType.TABLE) {
                                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_SET_GUIDE_POST_WIDTH).setSchemaName(schemaName).setTableName(tableName).build().buildException();
                                }
                                Boolean storeNullsProp = (Boolean)TableProperty.STORE_NULLS.getValue(tableProps);
                                if (storeNullsProp == null) {
                                    if (parent == null) {
                                        storeNulls = this.connection.getQueryServices().getProps().getBoolean("phoenix.table.default.store.nulls", false);
                                        tableProps.put("STORE_NULLS", storeNulls);
                                    }
                                } else {
                                    storeNulls = storeNullsProp;
                                }
                                Boolean transactionalProp = (Boolean)TableProperty.TRANSACTIONAL.getValue(tableProps);
                                TransactionFactory.Provider transactionProviderProp = (TransactionFactory.Provider)((Object)TableProperty.TRANSACTION_PROVIDER.getValue(tableProps));
                                if ((transactionalProp != null || transactionProviderProp != null) && parent != null) {
                                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.ONLY_TABLE_MAY_BE_DECLARED_TRANSACTIONAL).setSchemaName(schemaName).setTableName(tableName).build().buildException();
                                }
                                if (parent == null && (transactional = transactionProviderProp != null ? true : (transactionalProp == null ? this.connection.getQueryServices().getProps().getBoolean("phoenix.table.istransactional.default", false) : transactionalProp.booleanValue()))) {
                                    transactionProvider = transactionProviderProp == null ? (TransactionFactory.Provider)((Object)TableProperty.TRANSACTION_PROVIDER.getValue(this.connection.getQueryServices().getProps().get("phoenix.table.transaction.provider.default", QueryServicesOptions.DEFAULT_TRANSACTION_PROVIDER))) : transactionProviderProp;
                                }
                                if (!(transactionsEnabled = this.connection.getQueryServices().getProps().getBoolean("phoenix.transactions.enabled", false)) && transactionProvider != null) {
                                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_CREATE_TXN_TABLE_IF_TXNS_DISABLED).setSchemaName(schemaName).setTableName(tableName).build().buildException();
                                }
                                if (pkConstraint.getNumColumnsWithRowTimestamp() > 0 && transactionProvider != null) {
                                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_CREATE_TXN_TABLE_WITH_ROW_TIMESTAMP).setSchemaName(schemaName).setTableName(tableName).build().buildException();
                                }
                                if ((ttlProp != null || TableProperty.TTL.getValue(commonFamilyProps) != null) && transactionProvider != null && transactionProvider.getTransactionProvider().isUnsupported(PhoenixTransactionProvider.Feature.SET_TTL)) {
                                    throw new SQLExceptionInfo.Builder(PhoenixTransactionProvider.Feature.SET_TTL.getCode()).setMessage(transactionProvider.name()).setSchemaName(schemaName).setTableName(tableName).build().buildException();
                                }
                                tableProps.put("TRANSACTION_PROVIDER", (Object)transactionProvider);
                                if (transactionProvider != null && (transactionTTL = commonFamilyProps.remove("TTL")) != null) {
                                    commonFamilyProps.put("dataset.table.ttl", transactionTTL);
                                }
                                useStatsForParallelizationProp = (Boolean)TableProperty.USE_STATS_FOR_PARALLELIZATION.getValue(tableProps);
                                boolean bl = sharedTable = statement.getTableType() == PTableType.VIEW || allocateIndexId;
                                if (transactionProvider != null) {
                                    Integer maxVersionsProp;
                                    if (Boolean.FALSE.equals(storeNullsProp)) {
                                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.STORE_NULLS_MUST_BE_TRUE_FOR_TRANSACTIONAL).setSchemaName(schemaName).setTableName(tableName).build().buildException();
                                    }
                                    storeNulls = true;
                                    tableProps.put("STORE_NULLS", Boolean.TRUE);
                                    if (!sharedTable && (maxVersionsProp = (Integer)commonFamilyProps.get("VERSIONS")) == null) {
                                        TableDescriptor desc;
                                        if (parent != null && (desc = this.connection.getQueryServices().getTableDescriptor(parent.getPhysicalName().getBytes())) != null) {
                                            maxVersionsProp = desc.getColumnFamily(SchemaUtil.getEmptyColumnFamily(parent)).getMaxVersions();
                                        }
                                        if (maxVersionsProp == null) {
                                            maxVersionsProp = this.connection.getQueryServices().getProps().getInt("phoenix.transactions.maxVersions", Integer.MAX_VALUE);
                                        }
                                        commonFamilyProps.put("VERSIONS", maxVersionsProp);
                                    }
                                }
                                Long l = timestamp == null ? TransactionUtil.getTableTimestamp(this.connection, transactionProvider != null, transactionProvider) : (timestamp = timestamp);
                                if (sharedTable) {
                                    if (tableProps.get("DEFAULT_COLUMN_FAMILY") != null) {
                                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.DEFAULT_COLUMN_FAMILY_ON_SHARED_TABLE).setSchemaName(schemaName).setTableName(tableName).build().buildException();
                                    }
                                    if (SchemaUtil.hasHTableDescriptorProps(tableProps)) {
                                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.VIEW_WITH_PROPERTIES).build().buildException();
                                    }
                                }
                                colDefs = statement.getColumnDefs();
                                if (tenantId != null && !sharedTable) {
                                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_CREATE_TENANT_SPECIFIC_TABLE).setSchemaName(schemaName).setTableName(tableName).build().buildException();
                                }
                                if (autoPartitionSeq != null && !PLong.INSTANCE.isCastableTo((PDataType)(dataType = colDefs.get(autoPartitionColIndex = multiTenant ? 1 : 0).getDataType()))) {
                                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.SEQUENCE_NOT_CASTABLE_TO_AUTO_PARTITION_ID_COLUMN).setSchemaName(schemaName).setTableName(tableName).build().buildException();
                                }
                                if (tableType != PTableType.VIEW) break block307;
                                physicalNames = Collections.singletonList(PNameFactory.newName(parent.getPhysicalName().getString()));
                                if (viewType == PTable.ViewType.MAPPED) {
                                    columns = Maps.newLinkedHashMap();
                                    pkColumns = Sets.newLinkedHashSetWithExpectedSize((int)colDefs.size());
                                    break block308;
                                } else {
                                    rowKeyOrderOptimizable = parent.rowKeyOrderOptimizable();
                                    if (rowKeyOrderOptimizable) {
                                        UpgradeUtil.addRowKeyOrderOptimizableCell(tableMetaData, SchemaUtil.getTableKey(tenantIdStr, schemaName, tableName), clientTimeStamp);
                                    }
                                    multiTenant = parent.isMultiTenant();
                                    saltBucketNum = parent.getBucketNum();
                                    isAppendOnlySchema = parent.isAppendOnlySchema();
                                    isImmutableRows = parent.isImmutableRows();
                                    if (updateCacheFrequencyProp == null) {
                                        updateCacheFrequency = parent.getUpdateCacheFrequency();
                                    }
                                    disableWAL = disableWALProp == null ? parent.isWALDisabled() : disableWALProp.booleanValue();
                                    defaultFamilyName = parent.getDefaultFamilyName() == null ? null : parent.getDefaultFamilyName().getString();
                                    List<PColumn> allColumns = parent.getColumns();
                                    if (saltBucketNum != null) {
                                        allColumns = allColumns.subList(1, allColumns.size());
                                    }
                                    columns = new LinkedHashMap<PColumn, PColumn>(allColumns.size() + colDefs.size());
                                    for (PColumn pColumn : allColumns) {
                                        columns.put(pColumn, pColumn);
                                    }
                                    pkColumns = Sets.newLinkedHashSet(parent.getPKColumns());
                                    linkStatement = this.connection.prepareStatement(CREATE_VIEW_LINK);
                                    Throwable throwable = null;
                                    try {
                                        linkStatement.setString(1, tenantIdStr);
                                        linkStatement.setString(2, schemaName);
                                        linkStatement.setString(3, tableName);
                                        linkStatement.setString(4, parent.getName().getString());
                                        linkStatement.setByte(5, PTable.LinkType.PARENT_TABLE.getSerializedValue());
                                        linkStatement.setString(6, parent.getTenantId() == null ? null : parent.getTenantId().getString());
                                        linkStatement.execute();
                                    }
                                    catch (Throwable throwable2) {
                                        Throwable throwable3 = throwable2;
                                        throw throwable2;
                                    }
                                    finally {
                                        if (linkStatement != null) {
                                            if (throwable != null) {
                                                try {
                                                    linkStatement.close();
                                                }
                                                catch (Throwable throwable4) {
                                                    throwable.addSuppressed(throwable4);
                                                }
                                            } else {
                                                linkStatement.close();
                                            }
                                        }
                                    }
                                    linkStatement = this.connection.prepareStatement(CREATE_CHILD_LINK);
                                    Throwable throwable5 = null;
                                    try {
                                        linkStatement.setString(1, parent.getTenantId() == null ? null : parent.getTenantId().getString());
                                        linkStatement.setString(2, parent.getSchemaName() == null ? null : parent.getSchemaName().getString());
                                        linkStatement.setString(3, parent.getTableName().getString());
                                        linkStatement.setString(4, tenantIdStr);
                                        linkStatement.setString(5, SchemaUtil.getTableName(schemaName, tableName));
                                        linkStatement.setByte(6, PTable.LinkType.CHILD_TABLE.getSerializedValue());
                                        linkStatement.execute();
                                    }
                                    catch (Throwable throwable6) {
                                        Throwable throwable7 = throwable6;
                                        throw throwable6;
                                    }
                                    finally {
                                        if (linkStatement != null) {
                                            if (throwable5 != null) {
                                                try {
                                                    linkStatement.close();
                                                }
                                                catch (Throwable throwable8) {
                                                    throwable5.addSuppressed(throwable8);
                                                }
                                            } else {
                                                linkStatement.close();
                                            }
                                        }
                                    }
                                }
                            }
                            columns = new LinkedHashMap<PColumn, PColumn>(colDefs.size());
                            pkColumns = Sets.newLinkedHashSetWithExpectedSize((int)(colDefs.size() + 1));
                        }
                        if (tableType == PTableType.CDC) {
                            physicalNames = parent.getType() == PTableType.VIEW ? Collections.singletonList(PNameFactory.newName(MetaDataUtil.getViewIndexPhysicalName(parent.getBaseTableLogicalName(), isNamespaceMapped))) : Collections.singletonList(PNameFactory.newName(SchemaUtil.getTableName(schemaName, CDCUtil.getCDCIndexName(tableName))));
                        }
                        if (!(physicalNames.isEmpty() || viewType == PTable.ViewType.MAPPED && (((PName)physicalNames.get(0)).getString().equals(SchemaUtil.getTableName(schemaName, tableName)) || ((PName)physicalNames.get(0)).getString().equals(SchemaUtil.getPhysicalHBaseTableName(schemaName, tableName, isNamespaceMapped).getString())))) {
                            PreparedStatement linkStatement3 = this.connection.prepareStatement(CREATE_LINK);
                            linkStatement = null;
                            try {
                                for (PName pName : physicalNames) {
                                    linkStatement3.setString(1, tenantIdStr);
                                    linkStatement3.setString(2, schemaName);
                                    linkStatement3.setString(3, tableName);
                                    linkStatement3.setString(4, pName.getString());
                                    linkStatement3.setByte(5, PTable.LinkType.PHYSICAL_TABLE.getSerializedValue());
                                    if (tableType == PTableType.VIEW) {
                                        if (parent.getType() == PTableType.TABLE) {
                                            linkStatement3.setString(4, SchemaUtil.getTableName(parent.getSchemaName().getString(), parent.getTableName().getString()));
                                            linkStatement3.setLong(6, parent.getSequenceNumber());
                                        } else {
                                            PTable logicalTable = this.connection.getTable(new PTableKey(null, SchemaUtil.replaceNamespaceSeparator(pName)));
                                            linkStatement3.setString(4, SchemaUtil.getTableName(logicalTable.getSchemaName().getString(), logicalTable.getTableName().getString()));
                                            linkStatement3.setLong(6, logicalTable.getSequenceNumber());
                                        }
                                        linkStatement3.setString(7, null);
                                    } else {
                                        linkStatement3.setLong(6, parent.getSequenceNumber());
                                        linkStatement3.setString(7, PTableType.INDEX.getSerializedValue());
                                    }
                                    linkStatement3.execute();
                                }
                            }
                            catch (Throwable throwable) {
                                linkStatement = throwable;
                                throw throwable;
                            }
                            finally {
                                if (linkStatement3 != null) {
                                    if (linkStatement != null) {
                                        try {
                                            linkStatement3.close();
                                        }
                                        catch (Throwable throwable) {
                                            ((Throwable)linkStatement).addSuppressed(throwable);
                                        }
                                    } else {
                                        linkStatement3.close();
                                    }
                                }
                            }
                            tableMetaData.addAll((Collection)this.connection.getMutationState().toMutations(timestamp).next().getSecond());
                            this.connection.rollback();
                        }
                        familyNames = Maps.newLinkedHashMap();
                        rowTimeStampColumnAlreadyFound = false;
                        int n2 = columns.size();
                        if (saltBucketNum != null) {
                            ++var82_109;
                            if (addSaltColumn) {
                                pkColumns.add(SaltingUtil.SALTING_COLUMN);
                            }
                        }
                        n = pkColumns.size();
                        position = var82_109;
                        cqCounter = PTable.EncodedCQCounter.NULL_COUNTER;
                        changedCqCounters = new HashMap(colDefs.size());
                        inputCqCounters = new HashMap();
                        viewPhysicalTable = null;
                        if (tableType != PTableType.VIEW) break block309;
                        if (viewType == PTable.ViewType.MAPPED) break block310;
                        viewPhysicalTable = this.connection.getTable(((PName)physicalNames.get(0)).getString());
                        immutableStorageScheme = viewPhysicalTable.getImmutableStorageScheme();
                        encodingScheme = viewPhysicalTable.getEncodingScheme();
                        if (!EncodedColumnsUtil.usesEncodedColumnNames(viewPhysicalTable)) break block310;
                        cqCounter = viewPhysicalTable.getEncodedCQCounter();
                        break block310;
                    }
                    if (!SchemaUtil.isSystemTable(Bytes.toBytes((String)SchemaUtil.getTableName(schemaName, tableName))) || SchemaUtil.isLogTable(schemaName, tableName)) {
                        if (parent != null) {
                            Byte encodingSchemeSerializedByte = (Byte)TableProperty.COLUMN_ENCODED_BYTES.getValue(tableProps);
                            encodingScheme = encodingSchemeSerializedByte != null ? this.getEncodingScheme(tableProps, schemaName, tableName, transactionProvider) : parent.getEncodingScheme();
                            PTable.ImmutableStorageScheme immutableStorageScheme2 = (PTable.ImmutableStorageScheme)TableProperty.IMMUTABLE_STORAGE_SCHEME.getValue(tableProps);
                            if (immutableStorageScheme2 == null) {
                                immutableStorageScheme = parent.getImmutableStorageScheme();
                            } else {
                                this.checkImmutableStorageSchemeForIndex(immutableStorageScheme2, schemaName, tableName, transactionProvider);
                                immutableStorageScheme = immutableStorageScheme2;
                            }
                            if (immutableStorageScheme == PTable.ImmutableStorageScheme.SINGLE_CELL_ARRAY_WITH_OFFSETS && encodingScheme == PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS) {
                                if (encodingSchemeSerializedByte != null) {
                                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.INVALID_IMMUTABLE_STORAGE_SCHEME_AND_COLUMN_QUALIFIER_BYTES).setSchemaName(schemaName).setTableName(tableName).build().buildException();
                                }
                                encodingScheme = PTable.QualifierEncodingScheme.fromSerializedValue((byte)QueryServicesOptions.DEFAULT_COLUMN_ENCODED_BYTES);
                            }
                            if (tableType != PTableType.CDC && parent.getImmutableStorageScheme() == PTable.ImmutableStorageScheme.SINGLE_CELL_ARRAY_WITH_OFFSETS && immutableStorageScheme == PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN) {
                                throw new SQLExceptionInfo.Builder(SQLExceptionCode.INVALID_IMMUTABLE_STORAGE_SCHEME_CHANGE).setSchemaName(schemaName).setTableName(tableName).build().buildException();
                            }
                            LOGGER.info(String.format("STORAGE--ENCODING: %s--%s", immutableStorageScheme, encodingScheme));
                        } else {
                            encodingScheme = this.getEncodingScheme(tableProps, schemaName, tableName, transactionProvider);
                            PTable.ImmutableStorageScheme immutableStorageSchemeProp = (PTable.ImmutableStorageScheme)TableProperty.IMMUTABLE_STORAGE_SCHEME.getValue(tableProps);
                            if (immutableStorageSchemeProp == null) {
                                if (transactionProvider == null || !transactionProvider.getTransactionProvider().isUnsupported(PhoenixTransactionProvider.Feature.COLUMN_ENCODING)) {
                                    immutableStorageScheme = multiTenant ? PTable.ImmutableStorageScheme.valueOf(this.connection.getQueryServices().getProps().get("phoenix.default.multitenant.immutable.storage.scheme", QueryServicesOptions.DEFAULT_MULTITENANT_IMMUTABLE_STORAGE_SCHEME)) : (isImmutableRows ? PTable.ImmutableStorageScheme.valueOf(this.connection.getQueryServices().getProps().get("phoenix.default.immutable.storage.scheme", QueryServicesOptions.DEFAULT_IMMUTABLE_STORAGE_SCHEME)) : PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN);
                                }
                            } else {
                                immutableStorageScheme = isImmutableRows ? immutableStorageSchemeProp : PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN;
                                this.checkImmutableStorageSchemeForIndex(immutableStorageScheme, schemaName, tableName, transactionProvider);
                            }
                            if (immutableStorageScheme != PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN && encodingScheme == PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS) {
                                throw new SQLExceptionInfo.Builder(SQLExceptionCode.INVALID_IMMUTABLE_STORAGE_SCHEME_AND_COLUMN_QUALIFIER_BYTES).setSchemaName(schemaName).setTableName(tableName).build().buildException();
                            }
                        }
                        PTable.EncodedCQCounter encodedCQCounter = cqCounter = encodingScheme != PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS ? new PTable.EncodedCQCounter() : PTable.EncodedCQCounter.NULL_COUNTER;
                        if (encodingScheme != PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS && statement.getFamilyCQCounters() != null) {
                            for (Map.Entry entry : statement.getFamilyCQCounters().entrySet()) {
                                if ((Integer)entry.getValue() < 11) {
                                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.INVALID_CQ).setSchemaName(schemaName).setTableName(tableName).build().buildException();
                                }
                                cqCounter.setValue((String)entry.getKey(), (Integer)entry.getValue());
                                changedCqCounters.put(entry.getKey(), cqCounter.getNextQualifier((String)entry.getKey()));
                                inputCqCounters.putIfAbsent(entry.getKey(), new HashSet());
                            }
                        }
                    }
                }
                boolean wasPKDefined = false;
                HashSet hashSet = Sets.newHashSetWithExpectedSize((int)colDefs.size());
                HashSet<String> pkColumnNames = new HashSet<String>();
                for (PColumn pColumn : pkColumns) {
                    pkColumnNames.add(pColumn.getName().toString());
                }
                for (ColumnDef colDef : colDefs) {
                    void var97_147;
                    rowTimeStampColumnAlreadyFound = MetaDataClient.checkAndValidateRowTimestampCol(colDef, pkConstraint, rowTimeStampColumnAlreadyFound, tableType);
                    if (colDef.isPK()) {
                        if (wasPKDefined) {
                            throw new SQLExceptionInfo.Builder(SQLExceptionCode.PRIMARY_KEY_ALREADY_EXISTS).setColumnName(colDef.getColumnDefName().getColumnName()).build().buildException();
                        }
                        wasPKDefined = true;
                    } else if (!colDef.isNull() && !isImmutableRows) {
                        if (wasPKDefined) throw new SQLExceptionInfo.Builder(SQLExceptionCode.KEY_VALUE_NOT_NULL).setSchemaName(schemaName).setTableName(tableName).setColumnName(colDef.getColumnDefName().getColumnName()).build().buildException();
                        if (!SchemaUtil.isPKColumn(pkConstraint, colDef)) {
                            throw new SQLExceptionInfo.Builder(SQLExceptionCode.KEY_VALUE_NOT_NULL).setSchemaName(schemaName).setTableName(tableName).setColumnName(colDef.getColumnDefName().getColumnName()).build().buildException();
                        }
                    }
                    ColumnName columnDefName = colDef.getColumnDefName();
                    String colDefFamily = columnDefName.getFamilyName();
                    boolean isPkColumn = SchemaUtil.isPKColumn(pkConstraint, colDef);
                    Object var97_148 = null;
                    if (!isPkColumn) {
                        if (immutableStorageScheme == PTable.ImmutableStorageScheme.SINGLE_CELL_ARRAY_WITH_OFFSETS && encodingScheme != PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS) {
                            String string = colDefFamily != null ? colDefFamily : (defaultFamilyName != null ? defaultFamilyName : "0");
                        } else {
                            String string = defaultFamilyName != null ? defaultFamilyName : "0";
                        }
                    }
                    Object var98_161 = null;
                    if (!isPkColumn) {
                        if (colDef.getEncodedQualifier() != null && encodingScheme != PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS) {
                            Integer n3;
                            if (cqCounter.getNextQualifier((String)var97_147) > 11 && !inputCqCounters.containsKey(var97_147)) {
                                throw new SQLExceptionInfo.Builder(SQLExceptionCode.MISSING_CQ).setSchemaName(schemaName).setTableName(tableName).build().buildException();
                            }
                            if (statement.getFamilyCQCounters() == null || statement.getFamilyCQCounters().get(var97_147) == null) {
                                if (colDef.getEncodedQualifier() >= cqCounter.getNextQualifier((String)var97_147)) {
                                    cqCounter.setValue((String)var97_147, colDef.getEncodedQualifier());
                                    cqCounter.increment((String)var97_147);
                                }
                                changedCqCounters.put(var97_147, cqCounter.getNextQualifier((String)var97_147));
                            }
                            if ((n3 = colDef.getEncodedQualifier()) < 11) throw new SQLExceptionInfo.Builder(SQLExceptionCode.INVALID_CQ).setSchemaName(schemaName).setTableName(tableName).build().buildException();
                            if (n3 >= cqCounter.getNextQualifier((String)var97_147)) {
                                throw new SQLExceptionInfo.Builder(SQLExceptionCode.INVALID_CQ).setSchemaName(schemaName).setTableName(tableName).build().buildException();
                            }
                            inputCqCounters.putIfAbsent(var97_147, new HashSet());
                            Set familyCounters = (Set)inputCqCounters.get(var97_147);
                            if (!familyCounters.add(n3)) {
                                throw new SQLExceptionInfo.Builder(SQLExceptionCode.DUPLICATE_CQ).setSchemaName(schemaName).setTableName(tableName).build().buildException();
                            }
                        } else {
                            if (inputCqCounters.containsKey(var97_147)) {
                                throw new SQLExceptionInfo.Builder(SQLExceptionCode.MISSING_CQ).setSchemaName(schemaName).setTableName(tableName).build().buildException();
                            }
                            if (isAppendOnlySchema) {
                                Integer n4 = 11 + position;
                            } else {
                                Integer n5 = cqCounter.getNextQualifier((String)var97_147);
                            }
                        }
                    }
                    byte[] columnQualifierBytes = null;
                    try {
                        void var98_160;
                        columnQualifierBytes = EncodedColumnsUtil.getColumnQualifierBytes(columnDefName.getColumnName(), (Integer)var98_160, encodingScheme, isPkColumn);
                    }
                    catch (PTable.QualifierEncodingScheme.QualifierOutOfRangeException e) {
                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.MAX_COLUMNS_EXCEEDED).setSchemaName(schemaName).setTableName(tableName).build().buildException();
                    }
                    column = ColumnMetaDataOps.newColumn((int)position++, colDef, pkConstraint, defaultFamilyName, false, columnQualifierBytes, isImmutableRows);
                    if (!isAppendOnlySchema && colDef.getEncodedQualifier() == null && cqCounter.increment((String)var97_147)) {
                        changedCqCounters.put(var97_147, cqCounter.getNextQualifier((String)var97_147));
                    }
                    if (SchemaUtil.isPKColumn((PColumn)column)) {
                        if (pkColumnsIterator.hasNext() && !column.getName().getString().equals(((ColumnName)((Pair)pkColumnsIterator.next()).getFirst()).getColumnName())) {
                            throw new SQLExceptionInfo.Builder(SQLExceptionCode.PRIMARY_KEY_OUT_OF_ORDER).setSchemaName(schemaName).setTableName(tableName).setColumnName(column.getName().getString()).build().buildException();
                        }
                        if (tableType == PTableType.VIEW && viewType != PTable.ViewType.MAPPED) {
                            this.throwIfLastPKOfParentIsVariableLength(parent, schemaName, tableName, colDef);
                        }
                        if (!pkColumns.add(column)) {
                            throw new ColumnAlreadyExistsException(schemaName, tableName, column.getName().getString());
                        }
                    }
                    if (this.isDuplicateColumn(columns, pkColumnNames, (PColumn)column)) {
                        throw new ColumnAlreadyExistsException(schemaName, tableName, column.getName().getString());
                    }
                    if (tableType == PTableType.VIEW) {
                        hashSet.add(column.getPosition());
                    }
                    if (isPkColumn) {
                        pkColumnNames.add(column.getName().toString());
                    }
                    if ((colDef.getDataType() == PVarbinary.INSTANCE || colDef.getDataType().isArrayType()) && SchemaUtil.isPKColumn((PColumn)column) && pkColumnsIterator.hasNext()) {
                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.VARBINARY_IN_ROW_KEY).setSchemaName(schemaName).setTableName(tableName).setColumnName(column.getName().getString()).build().buildException();
                    }
                    if (colDef.getDataType() == PBson.INSTANCE && SchemaUtil.isPKColumn((PColumn)column) && pkColumnsIterator.hasNext()) {
                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.BSON_IN_ROW_KEY).setSchemaName(schemaName).setTableName(tableName).setColumnName(column.getName().getString()).build().buildException();
                    }
                    if (column.getFamilyName() == null) continue;
                    familyNames.put(IndexUtil.getActualColumnFamilyName(column.getFamilyName().getString()), column.getFamilyName());
                }
                if (!wasPKDefined && pkColumnsNames.isEmpty() && tableType != PTableType.VIEW && viewType != PTable.ViewType.MAPPED) {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.PRIMARY_KEY_MISSING).setSchemaName(schemaName).setTableName(tableName).build().buildException();
                }
                if (!pkColumnsNames.isEmpty() && pkColumnsNames.size() != pkColumns.size() - n) {
                    ColumnDef colDef;
                    Iterator<Object> pkColumnNamesIterator = pkColumnsNames.iterator();
                    do {
                        if (!pkColumnNamesIterator.hasNext()) throw new SQLExceptionInfo.Builder(SQLExceptionCode.INVALID_PRIMARY_KEY_CONSTRAINT).setSchemaName(schemaName).setTableName(tableName).build().buildException();
                        ColumnName colName = (ColumnName)((Pair)pkColumnNamesIterator.next()).getFirst();
                        colDef = MetaDataClient.findColumnDefOrNull(colDefs, colName);
                        if (colDef != null) continue;
                        throw new ColumnNotFoundException(schemaName, tableName, null, colName.getColumnName());
                    } while (colDef.getColumnDefName().getFamilyName() == null);
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.PRIMARY_KEY_WITH_FAMILY_NAME).setSchemaName(schemaName).setTableName(tableName).setColumnName(colDef.getColumnDefName().getColumnName()).setFamilyName(colDef.getColumnDefName().getFamilyName()).build().buildException();
                }
                if (!statement.getProps().isEmpty()) {
                    for (String familyName : statement.getProps().keySet()) {
                        if (familyName.equals("")) continue;
                        if (familyNames.get(familyName) == null) {
                            throw new SQLExceptionInfo.Builder(SQLExceptionCode.PROPERTIES_FOR_FAMILY).setFamilyName(familyName).build().buildException();
                        }
                        if (statement.getTableType() != PTableType.VIEW) continue;
                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.VIEW_WITH_PROPERTIES).build().buildException();
                    }
                }
                MetaDataClient.throwIfInsufficientColumns(schemaName, tableName, pkColumns, saltBucketNum != null, multiTenant);
                ArrayList familyPropList = Lists.newArrayListWithExpectedSize((int)familyNames.size());
                this.populateFamilyPropsList(familyNames, commonFamilyProps, statement, defaultFamilyName, isLocalIndex, familyPropList);
                if (SchemaUtil.isMetaTable(schemaName, tableName)) {
                    PName newSchemaName = PNameFactory.newName(schemaName);
                    PTableImpl table = new PTableImpl.Builder().setType(tableType).setTimeStamp(0L).setIndexDisableTimestamp(0L).setSequenceNumber(0L).setImmutableRows(isImmutableRows).setDisableWAL(Boolean.TRUE.equals(disableWAL)).setMultiTenant(false).setStoreNulls(false).setViewIndexIdType(viewIndexIdType).setIndexType(indexType).setUpdateCacheFrequency(0L).setNamespaceMapped(isNamespaceMapped).setAutoPartitionSeqName(autoPartitionSeq).setAppendOnlySchema(isAppendOnlySchema).setImmutableStorageScheme(PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN).setQualifierEncodingScheme(PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS).setBaseColumnCount(-1).setEncodedCQCounter(PTable.EncodedCQCounter.NULL_COUNTER).setUseStatsForParallelization(true).setExcludedColumns((List<PColumn>)ImmutableList.of()).setTenantId(tenantId).setSchemaName(newSchemaName).setTableName(PNameFactory.newName(tableName)).setPkName(PNameFactory.newName("pk")).setDefaultFamilyName(defaultFamilyName == null ? null : PNameFactory.newName(defaultFamilyName)).setRowKeyOrderOptimizable(true).setIndexes(Collections.emptyList()).setPhysicalNames((List<PName>)ImmutableList.of()).setColumns(columns.values()).setLastDDLTimestamp(0L).setIndexWhere(statement.getWhereClause() == null ? null : statement.getWhereClause().toString()).setRowKeyMatcher(rowKeyMatcher).setTTL(LiteralTTLExpression.TTL_EXPRESSION_NOT_DEFINED).build();
                    this.connection.addTable(table, 0L);
                }
                if (EncodedColumnsUtil.usesEncodedColumnNames(encodingScheme)) {
                    String schemaNameToUse = tableType == PTableType.VIEW ? viewPhysicalTable.getSchemaName().getString() : schemaName;
                    String tableNameToUse = tableType == PTableType.VIEW ? viewPhysicalTable.getTableName().getString() : tableName;
                    boolean sharedIndex = tableType == PTableType.INDEX && (indexType == PTable.IndexType.LOCAL || parent.getType() == PTableType.VIEW);
                    String tenantIdToUse = this.connection.getTenantId() != null && sharedIndex ? this.connection.getTenantId().getString() : null;
                    for (Map.Entry entry : changedCqCounters.entrySet()) {
                        PreparedStatement linkStatement = this.connection.prepareStatement(UPDATE_ENCODED_COLUMN_COUNTER);
                        column = null;
                        try {
                            linkStatement.setString(1, tenantIdToUse);
                            linkStatement.setString(2, schemaNameToUse);
                            linkStatement.setString(3, tableNameToUse);
                            linkStatement.setString(4, (String)entry.getKey());
                            linkStatement.setInt(5, (Integer)entry.getValue());
                            linkStatement.execute();
                        }
                        catch (Throwable throwable) {
                            column = throwable;
                            throw throwable;
                        }
                        finally {
                            if (linkStatement == null) continue;
                            if (column != null) {
                                try {
                                    linkStatement.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)column).addSuppressed(throwable);
                                }
                                continue;
                            }
                            linkStatement.close();
                        }
                    }
                    if (tableType == PTableType.VIEW && !changedCqCounters.isEmpty()) {
                        Throwable throwable = null;
                        try (PreparedStatement preparedStatement = this.connection.prepareStatement(INCREMENT_SEQ_NUM);){
                            preparedStatement.setString(1, null);
                            preparedStatement.setString(2, viewPhysicalTable.getSchemaName().getString());
                            preparedStatement.setString(3, viewPhysicalTable.getTableName().getString());
                            preparedStatement.setLong(4, viewPhysicalTable.getSequenceNumber() + 1L);
                            preparedStatement.execute();
                        }
                        catch (Throwable linkStatement) {
                            Throwable throwable9 = linkStatement;
                            throw linkStatement;
                        }
                    }
                    if (this.connection.getMutationState().toMutations(timestamp).hasNext()) {
                        tableMetaData.addAll((Collection)this.connection.getMutationState().toMutations(timestamp).next().getSecond());
                        this.connection.rollback();
                    }
                }
                short nextKeySeq = 0;
                ArrayList columnMetadata = Lists.newArrayListWithExpectedSize((int)columns.size());
                boolean isRegularView = tableType == PTableType.VIEW && viewType != PTable.ViewType.MAPPED;
                for (Map.Entry entry : columns.entrySet()) {
                    Short keySeq;
                    Short s;
                    void var98_176;
                    PColumn pColumn = (PColumn)entry.getValue();
                    final int columnPosition = pColumn.getPosition();
                    if (parent != null && parent.getAutoPartitionSeqName() != null && parent.getPKColumns().get(MetaDataUtil.getAutoPartitionColIndex(parent)).equals(pColumn)) {
                        DelegateColumn delegateColumn = new DelegateColumn(pColumn){

                            @Override
                            public byte[] getViewConstant() {
                                return QueryConstants.EMPTY_COLUMN_VALUE_BYTES;
                            }

                            @Override
                            public boolean isViewReferenced() {
                                return true;
                            }
                        };
                        entry.setValue(delegateColumn);
                    } else if (isViewColumnReferenced != null) {
                        if (viewColumnConstants != null && columnPosition < viewColumnConstants.length) {
                            DelegateColumn delegateColumn = new DelegateColumn(pColumn){

                                @Override
                                public byte[] getViewConstant() {
                                    return viewColumnConstants[columnPosition];
                                }

                                @Override
                                public boolean isViewReferenced() {
                                    return isViewColumnReferenced.get(columnPosition);
                                }
                            };
                            entry.setValue(delegateColumn);
                        } else {
                            DelegateColumn delegateColumn = new DelegateColumn(pColumn){

                                @Override
                                public boolean isViewReferenced() {
                                    return isViewColumnReferenced.get(columnPosition);
                                }
                            };
                            entry.setValue(delegateColumn);
                        }
                        if (isViewColumnReferenced.get(columnPosition) || hashSet.contains(columnPosition)) {
                            void var98_175;
                            boolean acquiredMutex = this.writeCell(null, parentPhysicalSchemaName, parentPhysicalTableName, var98_175.toString());
                            if (!acquiredMutex) {
                                throw new ConcurrentTableMutationException(parentPhysicalSchemaName, parentPhysicalTableName);
                            }
                            acquiredColumnMutexSet.add(var98_175.toString());
                        }
                    }
                    if (SchemaUtil.isPKColumn((PColumn)var98_176)) {
                        nextKeySeq = (short)(nextKeySeq + 1);
                        s = nextKeySeq;
                    } else {
                        s = keySeq = null;
                    }
                    if (!allowSystemCatalogRollback && isRegularView && columnPosition < baseTableColumnCount) continue;
                    ColumnMetaDataOps.addColumnMutation(this.connection, schemaName, tableName, (PColumn)var98_176, parentTableName, pkName, keySeq, saltBucketNum != null);
                    columnMetadata.addAll((Collection)this.connection.getMutationState().toMutations(timestamp).next().getSecond());
                    this.connection.rollback();
                }
                Collections.reverse(columnMetadata);
                tableMetaData.addAll(columnMetadata);
                String dataTableName = parent == null || tableType == PTableType.VIEW ? null : parent.getTableName().getString();
                String string = this.connection.getClientInfo("phoenix.index.create.default.state");
                if (string == null) {
                    String string3 = this.connection.getQueryServices().getConfiguration().get("phoenix.index.create.default.state", QueryServicesOptions.DEFAULT_CREATE_INDEX_STATE);
                }
                if ((pIndexState = PIndexState.valueOf((String)var98_179)) == PIndexState.CREATE_DISABLE && (indexType == PTable.IndexType.LOCAL || sharedTable)) {
                    PIndexState pIndexState2 = PIndexState.BUILDING;
                }
                Object object = indexState = parent == null || tableType == PTableType.VIEW || tableType == PTableType.CDC ? null : var97_159;
                if (indexState == null && tableProps.containsKey("INDEX_STATE")) {
                    indexState = PIndexState.fromSerializedValue(tableProps.get("INDEX_STATE").toString());
                }
                PreparedStatement tableUpsert = this.connection.prepareStatement(CREATE_TABLE);
                tableUpsert.setString(1, tenantIdStr);
                tableUpsert.setString(2, schemaName);
                tableUpsert.setString(3, tableName);
                tableUpsert.setString(4, tableType.getSerializedValue());
                tableUpsert.setLong(5, 0L);
                tableUpsert.setInt(6, (int)position);
                if (saltBucketNum != null) {
                    tableUpsert.setInt(7, saltBucketNum);
                } else {
                    tableUpsert.setNull(7, 4);
                }
                tableUpsert.setString(8, pkName);
                tableUpsert.setString(9, dataTableName);
                tableUpsert.setString(10, indexState == null ? null : indexState.getSerializedValue());
                tableUpsert.setBoolean(11, isImmutableRows);
                tableUpsert.setString(12, defaultFamilyName);
                if (parent != null && parent.getAutoPartitionSeqName() != null && viewStatement == null) {
                    tableUpsert.setString(13, "x");
                } else {
                    tableUpsert.setString(13, viewStatement);
                }
                tableUpsert.setBoolean(14, disableWAL);
                tableUpsert.setBoolean(15, multiTenant);
                if (viewType == null) {
                    tableUpsert.setNull(16, -6);
                } else {
                    tableUpsert.setByte(16, viewType.getSerializedValue());
                }
                if (indexType == null) {
                    tableUpsert.setNull(17, -6);
                } else {
                    tableUpsert.setByte(17, indexType.getSerializedValue());
                }
                tableUpsert.setBoolean(18, storeNulls);
                if (parent != null && tableType == PTableType.VIEW) {
                    tableUpsert.setInt(19, parent.getColumns().size());
                } else {
                    tableUpsert.setInt(19, -1);
                }
                if (transactionProvider == null) {
                    tableUpsert.setNull(20, -6);
                } else {
                    tableUpsert.setByte(20, transactionProvider.getCode());
                }
                tableUpsert.setLong(21, updateCacheFrequency);
                tableUpsert.setBoolean(22, isNamespaceMapped);
                if (autoPartitionSeq == null) {
                    tableUpsert.setNull(23, 12);
                } else {
                    tableUpsert.setString(23, autoPartitionSeq);
                }
                tableUpsert.setBoolean(24, isAppendOnlySchema);
                if (guidePostsWidth == null) {
                    tableUpsert.setNull(25, -5);
                } else {
                    tableUpsert.setLong(25, guidePostsWidth);
                }
                tableUpsert.setByte(26, immutableStorageScheme.getSerializedMetadataValue());
                tableUpsert.setByte(27, encodingScheme.getSerializedMetadataValue());
                if (useStatsForParallelizationProp == null) {
                    tableUpsert.setNull(28, 16);
                } else {
                    tableUpsert.setBoolean(28, useStatsForParallelizationProp);
                }
                if (indexType == PTable.IndexType.LOCAL || parent != null && parent.getType() == PTableType.VIEW && tableType == PTableType.INDEX) {
                    tableUpsert.setInt(29, viewIndexIdType.getSqlType());
                } else {
                    tableUpsert.setNull(29, 0);
                }
                if (isChangeDetectionEnabledProp == null) {
                    tableUpsert.setNull(30, 16);
                } else {
                    tableUpsert.setBoolean(30, isChangeDetectionEnabledProp);
                }
                if (physicalTableName == null) {
                    tableUpsert.setNull(31, 12);
                } else {
                    tableUpsert.setString(31, physicalTableName);
                }
                if (schemaVersion == null) {
                    tableUpsert.setNull(32, 12);
                } else {
                    tableUpsert.setString(32, schemaVersion);
                }
                if (streamingTopicName == null) {
                    tableUpsert.setNull(33, 12);
                } else {
                    tableUpsert.setString(33, streamingTopicName);
                }
                if (tableType == PTableType.INDEX && statement.getWhereClause() != null) {
                    tableUpsert.setString(34, statement.getWhereClause().toString());
                } else {
                    tableUpsert.setNull(34, 12);
                }
                if (cdcIncludeScopesStr == null) {
                    tableUpsert.setNull(35, 12);
                } else {
                    tableUpsert.setString(35, cdcIncludeScopesStr);
                }
                if (ttl == null || ttl.equals(LiteralTTLExpression.TTL_EXPRESSION_NOT_DEFINED)) {
                    tableUpsert.setNull(36, 12);
                } else {
                    tableUpsert.setString(36, ttl.getTTLExpression());
                }
                if (rowKeyMatcher == null || Bytes.compareTo((byte[])rowKeyMatcher, (byte[])HConstants.EMPTY_BYTE_ARRAY) == 0) {
                    tableUpsert.setNull(37, 9000);
                } else {
                    tableUpsert.setBytes(37, rowKeyMatcher);
                }
                tableUpsert.setBoolean(38, isStrictTTL);
                tableUpsert.execute();
                if (asyncCreatedDate != null) {
                    try (PreparedStatement setAsync = this.connection.prepareStatement(SET_ASYNC_CREATED_DATE);){
                        setAsync.setString(1, tenantIdStr);
                        setAsync.setString(2, schemaName);
                        setAsync.setString(3, tableName);
                        setAsync.setDate(4, asyncCreatedDate);
                        setAsync.execute();
                    }
                }
                Date syncCreatedDate = new Date(EnvironmentEdgeManager.currentTimeMillis());
                try (PreparedStatement setSync = this.connection.prepareStatement(SET_INDEX_SYNC_CREATED_DATE);){
                    setSync.setString(1, tenantIdStr);
                    setSync.setString(2, schemaName);
                    setSync.setString(3, tableName);
                    setSync.setDate(4, syncCreatedDate);
                    setSync.execute();
                }
                tableMetaData.addAll((Collection)this.connection.getMutationState().toMutations(timestamp).next().getSecond());
                this.connection.rollback();
                Collections.reverse(tableMetaData);
                if (indexType != PTable.IndexType.LOCAL) {
                    splits = SchemaUtil.processSplits(splits, pkColumns, saltBucketNum, this.connection.getQueryServices().getProps().getBoolean("phoenix.query.force.rowkeyorder", false));
                }
                PName pName = parentName = physicalNames != null && physicalNames.size() > 0 ? (PName)physicalNames.get(0) : null;
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("createTable tableName=" + tableName + " parent=" + (parent == null ? "" : parent.getTableName() + "-" + parent.getPhysicalName()) + " parent physical=" + parentName + "-" + (physicalNames.size() > 0 ? physicalNames.get(0) : "null") + " viewType " + (Object)((Object)viewType) + allocateIndexId);
                }
                result = this.connection.getQueryServices().createTable(tableMetaData, viewType == PTable.ViewType.MAPPED || allocateIndexId ? ((PName)physicalNames.get(0)).getBytes() : null, tableType, tableProps, familyPropList, splits, isNamespaceMapped, allocateIndexId, UpgradeUtil.isNoUpgradeSet(this.connection.getClientInfo()), parent);
                code = result.getMutationCode();
                try {
                    boolean tableAlreadyExists;
                    if (code != MetaDataProtocol.MutationCode.TABLE_NOT_FOUND && (tableAlreadyExists = this.handleCreateTableMutationCode(result, code, statement, schemaName, tableName, parent))) {
                        PTable pTable = null;
                        return pTable;
                    }
                    if (parent == null || parent.getAutoPartitionSeqName() == null) break block306;
                    autoPartitionCol = parent.getPKColumns().get(MetaDataUtil.getAutoPartitionColIndex(parent));
                }
                catch (Throwable e) {
                    TableMetricsManager.updateMetricsForSystemCatalogTableMethod(tableNameNode.toString(), MetricType.NUM_METADATA_LOOKUP_FAILURES, 1L);
                    throw e;
                }
                final Long autoPartitionNum = result.getAutoPartitionNum();
                columns.put(autoPartitionCol, new DelegateColumn(autoPartitionCol){

                    @Override
                    public byte[] getViewConstant() {
                        PDataType dataType = autoPartitionCol.getDataType();
                        Object val = dataType.toObject(autoPartitionNum, (PDataType)PLong.INSTANCE);
                        byte[] bytes = new byte[dataType.getByteSize() + 1];
                        dataType.toBytes(val, bytes, 0);
                        return bytes;
                    }

                    @Override
                    public boolean isViewReferenced() {
                        return true;
                    }
                });
                String viewPartitionClause = QueryUtil.getViewPartitionClause(MetaDataUtil.getAutoPartitionColumnName(parent), autoPartitionNum);
                viewStatement = viewStatement != null ? viewStatement + " AND " + viewPartitionClause : QueryUtil.getViewStatement(parent.getSchemaName().getString(), parent.getTableName().getString(), viewPartitionClause);
            }
            PName newSchemaName = PNameFactory.newName(schemaName);
            PTable.EncodedCQCounter cqCounterToBe = tableType == PTableType.VIEW ? PTable.EncodedCQCounter.NULL_COUNTER : cqCounter;
            PTableImpl table = new PTableImpl.Builder().setType(tableType).setState(indexState).setTimeStamp(timestamp != null ? timestamp.longValue() : result.getMutationTime()).setIndexDisableTimestamp(0L).setSequenceNumber(0L).setImmutableRows(isImmutableRows).setViewStatement(viewStatement).setDisableWAL(Boolean.TRUE.equals(disableWAL)).setMultiTenant(multiTenant).setStoreNulls(storeNulls).setViewType(viewType).setViewIndexIdType(viewIndexIdType).setViewIndexId(result.getViewIndexId()).setIndexType(indexType).setTransactionProvider(transactionProvider).setUpdateCacheFrequency(updateCacheFrequency).setNamespaceMapped(isNamespaceMapped).setAutoPartitionSeqName(autoPartitionSeq).setAppendOnlySchema(isAppendOnlySchema).setImmutableStorageScheme(immutableStorageScheme).setQualifierEncodingScheme(encodingScheme).setBaseColumnCount(baseTableColumnCount).setEncodedCQCounter(cqCounterToBe).setUseStatsForParallelization(useStatsForParallelizationProp).setExcludedColumns((List<PColumn>)ImmutableList.of()).setTenantId(tenantId).setSchemaName(newSchemaName).setTableName(PNameFactory.newName(tableName)).setPkName(pkName == null ? null : PNameFactory.newName(pkName)).setDefaultFamilyName(defaultFamilyName == null ? null : PNameFactory.newName(defaultFamilyName)).setRowKeyOrderOptimizable(rowKeyOrderOptimizable).setBucketNum(saltBucketNum).setIndexes(Collections.emptyList()).setParentSchemaName(parent == null ? null : parent.getSchemaName()).setParentTableName(parent == null ? null : parent.getTableName()).setPhysicalNames((List<PName>)ImmutableList.copyOf(physicalNames)).setColumns(columns.values()).setViewModifiedUpdateCacheFrequency(tableType == PTableType.VIEW && parent != null && parent.getUpdateCacheFrequency() != updateCacheFrequency).setViewModifiedUseStatsForParallelization(tableType == PTableType.VIEW && parent != null && parent.useStatsForParallelization() != useStatsForParallelizationProp).setLastDDLTimestamp(result.getTable() != null ? result.getTable().getLastDDLTimestamp() : null).setIsChangeDetectionEnabled(isChangeDetectionEnabledProp).setIsStrictTTL(isStrictTTL).setSchemaVersion(schemaVersion).setExternalSchemaId(result.getTable() != null ? result.getTable().getExternalSchemaId() : null).setStreamingTopicName(streamingTopicName).setIndexWhere(statement.getWhereClause() == null ? null : statement.getWhereClause().toString()).setCDCIncludeScopes(cdcIncludeScopes).setTTL(ttl == null || ttl.equals(LiteralTTLExpression.TTL_EXPRESSION_NOT_DEFINED) ? TTLExpressionFactory.create(ttlFromHierarchy) : TTLExpressionFactory.create(ttl)).setRowKeyMatcher(rowKeyMatcher).build();
            result = new MetaDataProtocol.MetaDataMutationResult(code, result.getMutationTime(), (PTable)table, true);
            this.addTableToCache(result, false);
            PTableImpl pTableImpl = table;
            return pTableImpl;
        }
        finally {
            this.connection.setAutoCommit(wasAutoCommit);
            this.deleteMutexCells(parentPhysicalSchemaName, parentPhysicalTableName, acquiredColumnMutexSet);
        }
    }

    private boolean isDuplicateColumn(LinkedHashMap<PColumn, PColumn> columns, Set<String> pkColumnNames, PColumn column) {
        return columns.put(column, column) != null || column.getFamilyName() != null && "0".equals(column.getFamilyName().toString()) && pkColumnNames.contains(column.getName().toString());
    }

    private void verifyChangeDetectionTableType(PTableType tableType, Boolean isChangeDetectionEnabledProp) throws SQLException {
        if (isChangeDetectionEnabledProp != null && isChangeDetectionEnabledProp.booleanValue() && tableType != PTableType.TABLE && tableType != PTableType.VIEW) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.CHANGE_DETECTION_SUPPORTED_FOR_TABLES_AND_VIEWS_ONLY).build().buildException();
        }
    }

    private PTable.QualifierEncodingScheme getEncodingScheme(Map<String, Object> tableProps, String schemaName, String tableName, TransactionFactory.Provider transactionProvider) throws SQLException {
        PTable.QualifierEncodingScheme encodingScheme = null;
        Byte encodingSchemeSerializedByte = (Byte)TableProperty.COLUMN_ENCODED_BYTES.getValue(tableProps);
        if (encodingSchemeSerializedByte == null && tableProps.containsKey("ENCODING_SCHEME")) {
            encodingSchemeSerializedByte = PTable.QualifierEncodingScheme.valueOf((String)tableProps.get("ENCODING_SCHEME")).getSerializedMetadataValue();
        }
        if (encodingSchemeSerializedByte == null) {
            if (transactionProvider == null || !transactionProvider.getTransactionProvider().isUnsupported(PhoenixTransactionProvider.Feature.COLUMN_ENCODING)) {
                encodingSchemeSerializedByte = (byte)this.connection.getQueryServices().getProps().getInt("phoenix.default.column.encoded.bytes.attrib", QueryServicesOptions.DEFAULT_COLUMN_ENCODED_BYTES);
                encodingScheme = PTable.QualifierEncodingScheme.fromSerializedValue(encodingSchemeSerializedByte);
            } else {
                encodingScheme = PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS;
            }
        } else {
            encodingScheme = PTable.QualifierEncodingScheme.fromSerializedValue(encodingSchemeSerializedByte);
            if (encodingScheme != PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS && transactionProvider != null && transactionProvider.getTransactionProvider().isUnsupported(PhoenixTransactionProvider.Feature.COLUMN_ENCODING)) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.UNSUPPORTED_COLUMN_ENCODING_FOR_TXN_PROVIDER).setSchemaName(schemaName).setTableName(tableName).setMessage(transactionProvider.name()).build().buildException();
            }
        }
        return encodingScheme;
    }

    private void checkImmutableStorageSchemeForIndex(PTable.ImmutableStorageScheme immutableStorageSchemeProp, String schemaName, String tableName, TransactionFactory.Provider transactionProvider) throws SQLException {
        if (immutableStorageSchemeProp != PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN && transactionProvider != null && transactionProvider.getTransactionProvider().isUnsupported(PhoenixTransactionProvider.Feature.COLUMN_ENCODING)) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.UNSUPPORTED_STORAGE_FORMAT_FOR_TXN_PROVIDER).setSchemaName(schemaName).setTableName(tableName).setMessage(transactionProvider.name()).build().buildException();
        }
    }

    @VisibleForTesting
    public boolean handleCreateTableMutationCode(MetaDataProtocol.MetaDataMutationResult result, MetaDataProtocol.MutationCode code, CreateTableStatement statement, String schemaName, String tableName, PTable parent) throws SQLException {
        switch (code) {
            case TABLE_ALREADY_EXISTS: {
                if (result.getTable() != null) {
                    this.addTableToCache(result, false);
                }
                if (!statement.ifNotExists()) {
                    throw new TableAlreadyExistsException(schemaName, tableName, result.getTable());
                }
                return true;
            }
            case NEWER_TABLE_FOUND: {
                if (!statement.ifNotExists()) {
                    throw new NewerTableAlreadyExistsException(schemaName, tableName, result.getTable());
                }
                return false;
            }
            case UNALLOWED_TABLE_MUTATION: {
                this.throwsSQLExceptionUtil("CANNOT_MUTATE_TABLE", schemaName, tableName);
            }
            case CONCURRENT_TABLE_MUTATION: {
                this.addTableToCache(result, false);
                throw new ConcurrentTableMutationException(schemaName, tableName);
            }
            case AUTO_PARTITION_SEQUENCE_NOT_FOUND: {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.AUTO_PARTITION_SEQUENCE_UNDEFINED).setSchemaName(schemaName).setTableName(tableName).build().buildException();
            }
            case CANNOT_COERCE_AUTO_PARTITION_ID: 
            case UNABLE_TO_CREATE_CHILD_LINK: 
            case PARENT_TABLE_NOT_FOUND: 
            case TABLE_NOT_IN_REGION: {
                this.throwsSQLExceptionUtil(String.valueOf((Object)code), schemaName, tableName);
            }
            case TOO_MANY_INDEXES: 
            case UNABLE_TO_UPDATE_PARENT_TABLE: {
                this.throwsSQLExceptionUtil(String.valueOf((Object)code), SchemaUtil.getSchemaNameFromFullName(parent.getPhysicalName().getString()), SchemaUtil.getTableNameFromFullName(parent.getPhysicalName().getString()));
            }
            case ERROR_WRITING_TO_SCHEMA_REGISTRY: {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.ERROR_WRITING_TO_SCHEMA_REGISTRY).setSchemaName(schemaName).setTableName(tableName).build().buildException();
            }
        }
        throw new SQLExceptionInfo.Builder(SQLExceptionCode.UNEXPECTED_MUTATION_CODE).setSchemaName(schemaName).setTableName(tableName).setMessage("mutation code: " + (Object)((Object)code)).build().buildException();
    }

    private void throwsSQLExceptionUtil(String code, String schemaName, String tableName) throws SQLException {
        throw new SQLExceptionInfo.Builder(SQLExceptionCode.valueOf(code)).setSchemaName(schemaName).setTableName(tableName).build().buildException();
    }

    private static void throwIfInsufficientColumns(String schemaName, String tableName, Collection<PColumn> columns, boolean isSalted, boolean isMultiTenant) throws SQLException {
        PColumn tenantIdCol;
        if (!isMultiTenant) {
            return;
        }
        int nPKColumns = columns.size() - (isSalted ? 1 : 0);
        if (nPKColumns < 2) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.INSUFFICIENT_MULTI_TENANT_COLUMNS).setSchemaName(schemaName).setTableName(tableName).build().buildException();
        }
        Iterator<PColumn> iterator = columns.iterator();
        if (isSalted) {
            iterator.next();
        }
        if ((tenantIdCol = iterator.next()).isNullable()) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.INSUFFICIENT_MULTI_TENANT_COLUMNS).setSchemaName(schemaName).setTableName(tableName).build().buildException();
        }
    }

    public MutationState dropTable(DropTableStatement statement) throws SQLException {
        String schemaName = this.connection.getSchema() != null && statement.getTableName().getSchemaName() == null ? this.connection.getSchema() : statement.getTableName().getSchemaName();
        String tableName = statement.getTableName().getTableName();
        return this.dropTable(schemaName, tableName, null, statement.getTableType(), statement.ifExists(), statement.cascade(), statement.getSkipAddingParentColumns());
    }

    public MutationState dropFunction(DropFunctionStatement statement) throws SQLException {
        return this.dropFunction(statement.getFunctionName(), statement.ifExists());
    }

    public MutationState dropIndex(DropIndexStatement statement) throws SQLException {
        String schemaName = statement.getTableName().getSchemaName();
        String tableName = statement.getIndexName().getName();
        String parentTableName = statement.getTableName().getTableName();
        return this.dropTable(schemaName, tableName, parentTableName, PTableType.INDEX, statement.ifExists(), false, false);
    }

    public MutationState dropCDC(DropCDCStatement statement) throws SQLException {
        String schemaName = statement.getTableName().getSchemaName();
        String cdcTableName = statement.getCdcObjName().getName();
        String parentTableName = statement.getTableName().getTableName();
        String indexName = CDCUtil.getCDCIndexName(statement.getCdcObjName().getName());
        long cdcIndexTimestamp = this.connection.getTable(indexName).getTimeStamp();
        String streamName = String.format(CDCUtil.CDC_STREAM_NAME_FORMAT, parentTableName, cdcTableName, cdcIndexTimestamp, CDCUtil.getCDCCreationUTCDateTime(cdcIndexTimestamp));
        this.markCDCStreamStatus(parentTableName, streamName, CDCUtil.CdcStreamStatus.DISABLED);
        this.dropTable(schemaName, cdcTableName, parentTableName, PTableType.CDC, statement.ifExists(), false, false);
        try {
            return this.dropTable(schemaName, indexName, parentTableName, PTableType.INDEX, statement.ifExists(), false, false);
        }
        catch (SQLException e) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.fromErrorCode(e.getErrorCode())).setTableName(statement.getCdcObjName().getName()).setRootCause(e.getCause()).build().buildException();
        }
    }

    private void deleteAllStreamMetadataForTable(String tableName) throws SQLException {
        String deleteStreamStatusQuery = "DELETE FROM " + PhoenixDatabaseMetaData.SYSTEM_CDC_STREAM_STATUS_NAME + " WHERE TABLE_NAME = ?";
        String deleteStreamPartitionsQuery = "DELETE FROM " + PhoenixDatabaseMetaData.SYSTEM_CDC_STREAM_NAME + " WHERE TABLE_NAME = ?";
        LOGGER.info("Deleting Stream Metadata for table {}", (Object)tableName);
        try (PreparedStatement ps = this.connection.prepareStatement(deleteStreamStatusQuery);){
            ps.setString(1, tableName);
            ps.executeUpdate();
            this.connection.commit();
        }
        ps = this.connection.prepareStatement(deleteStreamPartitionsQuery);
        var5_5 = null;
        try {
            ps.setString(1, tableName);
            ps.executeUpdate();
            this.connection.commit();
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (ps != null) {
                if (var5_5 != null) {
                    try {
                        ps.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    ps.close();
                }
            }
        }
    }

    private void markCDCStreamStatus(String tableName, String streamName, CDCUtil.CdcStreamStatus status) throws SQLException {
        String streamStatusSQL = "UPSERT INTO " + PhoenixDatabaseMetaData.SYSTEM_CDC_STREAM_STATUS_NAME + " VALUES (?, ?, ?)";
        try (PreparedStatement ps = this.connection.prepareStatement(streamStatusSQL);){
            ps.setString(1, tableName);
            ps.setString(2, streamName);
            ps.setString(3, status.getSerializedValue());
            ps.executeUpdate();
            this.connection.commit();
            LOGGER.info("Marked stream {} for table {} as {}", new Object[]{streamName, tableName, status});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MutationState dropFunction(String functionName, boolean ifExists) throws SQLException {
        this.connection.rollback();
        boolean wasAutoCommit = this.connection.getAutoCommit();
        try {
            PName tenantId = this.connection.getTenantId();
            byte[] key = SchemaUtil.getFunctionKey(tenantId == null ? ByteUtil.EMPTY_BYTE_ARRAY : tenantId.getBytes(), Bytes.toBytes((String)functionName));
            Long scn = this.connection.getSCN();
            long clientTimeStamp = scn == null ? Long.MAX_VALUE : scn;
            try {
                PFunction function = this.connection.getMetaDataCache().getFunction(new PTableKey(tenantId, functionName));
                if (function.isTemporaryFunction()) {
                    this.connection.removeFunction(tenantId, functionName, clientTimeStamp);
                    MutationState mutationState = new MutationState(0, 0L, this.connection);
                    return mutationState;
                }
            }
            catch (FunctionNotFoundException function) {
                // empty catch block
            }
            ArrayList functionMetaData = Lists.newArrayListWithExpectedSize((int)2);
            Delete functionDelete = new Delete(key, clientTimeStamp);
            functionMetaData.add(functionDelete);
            MetaDataProtocol.MetaDataMutationResult result = this.connection.getQueryServices().dropFunction(functionMetaData, ifExists);
            MetaDataProtocol.MutationCode code = result.getMutationCode();
            switch (code) {
                case FUNCTION_NOT_FOUND: {
                    if (ifExists) break;
                    throw new FunctionNotFoundException(functionName);
                }
                default: {
                    this.connection.removeFunction(tenantId, functionName, result.getMutationTime());
                }
            }
            MutationState mutationState = new MutationState(0, 0L, this.connection);
            return mutationState;
        }
        finally {
            this.connection.setAutoCommit(wasAutoCommit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    MutationState dropTable(String schemaName, String tableName, String parentTableName, PTableType tableType, boolean ifExists, boolean cascade, boolean skipAddingParentColumns) throws SQLException {
        block35: {
            fullTableName = SchemaUtil.getTableName(schemaName, tableName);
            try {
                ptable = this.connection.getTable(fullTableName);
                if (PTableType.TABLE.equals((Object)ptable.getType()) && CDCUtil.hasCDCIndex(ptable)) {
                    this.deleteAllStreamMetadataForTable(fullTableName);
                }
                if (parentTableName != null && !parentTableName.equals(ptable.getParentTableName().getString())) {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.PARENT_TABLE_NOT_FOUND).setSchemaName(schemaName).setTableName(tableName).build().buildException();
                }
            }
            catch (TableNotFoundException e) {
                if (ifExists || e.isThrownToForceReReadForTransformingTable()) break block35;
                if (tableType == PTableType.INDEX) {
                    throw new IndexNotFoundException(e.getSchemaName(), e.getTableName(), e.getTimeStamp());
                }
                throw e;
            }
        }
        this.connection.rollback();
        wasAutoCommit = this.connection.getAutoCommit();
        tenantId = this.connection.getTenantId();
        tenantIdStr = tenantId == null ? null : tenantId.getString();
        try {
            key = SchemaUtil.getTableKey(tenantIdStr, schemaName, tableName);
            scn = this.connection.getSCN();
            clientTimeStamp = scn == null ? 0x7FFFFFFFFFFFFFFFL : scn;
            tableMetaData = Lists.newArrayListWithExpectedSize((int)2);
            tableDelete = new Delete(key, clientTimeStamp);
            tableMetaData.add(tableDelete);
            hasViewIndexTable = false;
            if (parentTableName != null) {
                linkKey = MetaDataUtil.getParentLinkKey(tenantIdStr, schemaName, parentTableName, tableName);
                linkDelete = new Delete(linkKey, clientTimeStamp);
                tableMetaData.add(linkDelete);
            }
            result = this.connection.getQueryServices().dropTable(tableMetaData, tableType, cascade);
            code = result.getMutationCode();
            table = result.getTable();
            switch (10.$SwitchMap$org$apache$phoenix$coprocessorclient$MetaDataProtocol$MutationCode[code.ordinal()]) {
                case 16: {
                    if (ifExists) break;
                    throw new TableNotFoundException(schemaName, tableName);
                }
                case 4: {
                    throw new NewerTableAlreadyExistsException(schemaName, tableName, result.getTable());
                }
                case 5: {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_MUTATE_TABLE).setSchemaName(schemaName).setTableName(tableName).build().buildException();
                }
                case 17: {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.UNABLE_TO_DELETE_CHILD_LINK).setSchemaName(schemaName).setTableName(tableName).build().buildException();
                }
                default: {
                    this.connection.removeTable(tenantId, SchemaUtil.getTableName(schemaName, tableName), parentTableName, result.getMutationTime());
                    if (table == null) break;
                    dropMetaData = this.connection.getQueryServices().getProps().getBoolean("phoenix.schema.dropMetaData", true);
                    ts = scn == null ? result.getMutationTime() : scn.longValue();
                    tableRefs = Lists.newArrayListWithExpectedSize((int)(2 + table.getIndexes().size()));
                    this.connection.setAutoCommit(true);
                    if (tableType != PTableType.VIEW) ** GOTO lbl59
                    for (PTable index : table.getIndexes()) {
                        tableRefs.add(new TableRef(null, index, ts, false));
                    }
                    ** GOTO lbl103
lbl59:
                    // 1 sources

                    v0 = dropMetaData = result.getTable().getViewIndexId() == null && this.connection.getQueryServices().getProps().getBoolean("phoenix.schema.dropMetaData", true) != false;
                    if (parentTableName == null) {
                        hasViewIndexTable = true;
                        MetaDataUtil.deleteViewIndexSequences(this.connection, table.getPhysicalName(), table.isNamespaceMapped());
                        viewIndexPhysicalName = MetaDataUtil.getViewIndexPhysicalName(table.getPhysicalName().getBytes());
                        if (!dropMetaData) {
                            try {
                                admin = this.connection.getQueryServices().getAdmin();
                                var28_30 = null;
                                try {
                                    hasViewIndexTable = admin.tableExists(TableName.valueOf((byte[])viewIndexPhysicalName));
                                }
                                catch (Throwable var29_32) {
                                    var28_30 = var29_32;
                                    throw var29_32;
                                }
                                finally {
                                    if (admin != null) {
                                        if (var28_30 != null) {
                                            try {
                                                admin.close();
                                            }
                                            catch (Throwable var29_31) {
                                                var28_30.addSuppressed(var29_31);
                                            }
                                        } else {
                                            admin.close();
                                        }
                                    }
                                }
                            }
                            catch (IOException admin) {
                                // empty catch block
                            }
                        }
                    }
                    if (tableType == PTableType.TABLE && (table.isMultiTenant() || hasViewIndexTable) && hasViewIndexTable) {
                        viewIndexPhysicalName = MetaDataUtil.getViewIndexPhysicalName(table.getPhysicalName().getBytes());
                        viewIndexSchemaName = SchemaUtil.getSchemaNameFromFullName((byte[])viewIndexPhysicalName);
                        viewIndexTableName = SchemaUtil.getTableNameFromFullName((byte[])viewIndexPhysicalName);
                        viewIndexName = PNameFactory.newName(SchemaUtil.getTableName(viewIndexSchemaName, viewIndexTableName));
                        viewIndexTable = new PTableImpl.Builder().setName(viewIndexName).setKey(new PTableKey(tenantId, viewIndexName.getString())).setSchemaName(PNameFactory.newName(viewIndexSchemaName)).setTableName(PNameFactory.newName(viewIndexTableName)).setType(PTableType.VIEW).setViewType(PTable.ViewType.MAPPED).setTimeStamp(ts).setPkColumns(Collections.emptyList()).setAllColumns(Collections.emptyList()).setRowKeySchema(RowKeySchema.EMPTY_SCHEMA).setIndexes(Collections.emptyList()).setFamilyAttributes(table.getColumnFamilies()).setPhysicalNames(Collections.emptyList()).setNamespaceMapped(table.isNamespaceMapped()).setImmutableStorageScheme(table.getImmutableStorageScheme()).setQualifierEncodingScheme(table.getEncodingScheme()).setUseStatsForParallelization(table.useStatsForParallelization()).setIsStrictTTL(table.isStrictTTL()).build();
                        tableRefs.add(new TableRef(null, viewIndexTable, ts, false));
                    }
                    tableRefs.add(new TableRef(null, table, ts, false));
                    viewIndexPhysicalName = table.getIndexes().iterator();
                    while (viewIndexPhysicalName.hasNext()) {
                        index = (PTable)viewIndexPhysicalName.next();
                        tableRefs.add(new TableRef(null, index, ts, false));
                    }
lbl103:
                    // 2 sources

                    if (dropMetaData) break;
                    plan = new PostDDLCompiler(this.connection).compile(tableRefs, null, null, Collections.emptyList(), ts);
                    var27_28 = this.connection.getQueryServices().updateData(plan);
                    return var27_28;
                }
            }
            var22_24 = new MutationState(0, 0L, this.connection);
            return var22_24;
        }
        finally {
            this.connection.setAutoCommit(wasAutoCommit);
        }
    }

    private MetaDataProtocol.MutationCode processMutationResult(String schemaName, String tableName, MetaDataProtocol.MetaDataMutationResult result) throws SQLException {
        MetaDataProtocol.MutationCode mutationCode = result.getMutationCode();
        PName tenantId = this.connection.getTenantId();
        switch (mutationCode) {
            case TABLE_NOT_FOUND: {
                this.connection.removeTable(tenantId, SchemaUtil.getTableName(schemaName, tableName), null, Long.MAX_VALUE);
                throw new TableNotFoundException(schemaName, tableName);
            }
            case UNALLOWED_TABLE_MUTATION: {
                String columnName = null;
                String familyName = null;
                String msg = null;
                if (result.getColumnName() != null) {
                    familyName = result.getFamilyName() == null ? null : Bytes.toString((byte[])result.getFamilyName());
                    columnName = Bytes.toString((byte[])result.getColumnName());
                    msg = "Cannot add/drop column referenced by VIEW";
                }
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_MUTATE_TABLE).setSchemaName(schemaName).setTableName(tableName).setFamilyName(familyName).setColumnName(columnName).setMessage(msg).build().buildException();
            }
            case UNALLOWED_SCHEMA_MUTATION: {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_SET_OR_ALTER_TTL).setSchemaName(schemaName).setTableName(tableName).build().buildException();
            }
            case NO_OP: 
            case COLUMN_ALREADY_EXISTS: 
            case COLUMN_NOT_FOUND: {
                break;
            }
            case CONCURRENT_TABLE_MUTATION: {
                this.addTableToCache(result, false);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(LogUtil.addCustomAnnotations("CONCURRENT_TABLE_MUTATION for table " + SchemaUtil.getTableName(schemaName, tableName), this.connection));
                }
                throw new ConcurrentTableMutationException(schemaName, tableName);
            }
            case NEWER_TABLE_FOUND: {
                throw new NewerTableAlreadyExistsException(schemaName, tableName, result.getTable());
            }
            case NO_PK_COLUMNS: {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.PRIMARY_KEY_MISSING).setSchemaName(schemaName).setTableName(tableName).build().buildException();
            }
            case TABLE_ALREADY_EXISTS: {
                break;
            }
            case ERROR_WRITING_TO_SCHEMA_REGISTRY: {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.ERROR_WRITING_TO_SCHEMA_REGISTRY).setSchemaName(schemaName).setTableName(tableName).build().buildException();
            }
            default: {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.UNEXPECTED_MUTATION_CODE).setSchemaName(schemaName).setTableName(tableName).setMessage("mutation code: " + (Object)((Object)mutationCode)).build().buildException();
            }
        }
        return mutationCode;
    }

    private long incrementTableSeqNum(PTable table, PTableType expectedType, int columnCountDelta, MetaPropertiesEvaluated metaPropertiesEvaluated) throws SQLException {
        return this.incrementTableSeqNum(table, expectedType, columnCountDelta, metaPropertiesEvaluated.getIsTransactional(), metaPropertiesEvaluated.getTransactionProvider(), metaPropertiesEvaluated.getUpdateCacheFrequency(), metaPropertiesEvaluated.getIsImmutableRows(), metaPropertiesEvaluated.getDisableWAL(), metaPropertiesEvaluated.getMultiTenant(), metaPropertiesEvaluated.getStoreNulls(), metaPropertiesEvaluated.getGuidePostWidth(), metaPropertiesEvaluated.getAppendOnlySchema(), metaPropertiesEvaluated.getImmutableStorageScheme(), metaPropertiesEvaluated.getUseStatsForParallelization(), metaPropertiesEvaluated.getTTL(), metaPropertiesEvaluated.isChangeDetectionEnabled(), metaPropertiesEvaluated.isStrictTTL(), metaPropertiesEvaluated.getPhysicalTableName(), metaPropertiesEvaluated.getSchemaVersion(), metaPropertiesEvaluated.getColumnEncodedBytes(), metaPropertiesEvaluated.getStreamingTopicName());
    }

    private long incrementTableSeqNum(PTable table, PTableType expectedType, int columnCountDelta, Boolean isTransactional, Long updateCacheFrequency, String physicalTableName, String schemaVersion, PTable.QualifierEncodingScheme columnEncodedBytes) throws SQLException {
        return this.incrementTableSeqNum(table, expectedType, columnCountDelta, isTransactional, null, updateCacheFrequency, null, null, null, null, -1L, null, null, null, null, false, null, physicalTableName, schemaVersion, columnEncodedBytes, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long incrementTableSeqNum(PTable table, PTableType expectedType, int columnCountDelta, Boolean isTransactional, TransactionFactory.Provider transactionProvider, Long updateCacheFrequency, Boolean isImmutableRows, Boolean disableWAL, Boolean isMultiTenant, Boolean storeNulls, Long guidePostWidth, Boolean appendOnlySchema, PTable.ImmutableStorageScheme immutableStorageScheme, Boolean useStatsForParallelization, TTLExpression ttl, Boolean isChangeDetectionEnabled, Boolean isStrictTTL, String physicalTableName, String schemaVersion, PTable.QualifierEncodingScheme columnEncodedBytes, String streamingTopicName) throws SQLException {
        String schemaName = table.getSchemaName().getString();
        String tableName = table.getTableName().getString();
        int totalColumnCount = table.getColumns().size() + (table.getBucketNum() == null ? 0 : -1);
        long seqNum = table.getSequenceNumber() + 1L;
        String tenantId = this.connection.getTenantId() == null ? null : this.connection.getTenantId().getString();
        try (PreparedStatement tableUpsert = this.connection.prepareStatement(MUTATE_TABLE);){
            tableUpsert.setString(1, tenantId);
            tableUpsert.setString(2, schemaName);
            tableUpsert.setString(3, tableName);
            tableUpsert.setString(4, expectedType.getSerializedValue());
            tableUpsert.setLong(5, seqNum);
            tableUpsert.setInt(6, totalColumnCount + columnCountDelta);
            tableUpsert.execute();
        }
        if (isImmutableRows != null) {
            MetaDataClient.mutateBooleanProperty(this.connection, tenantId, schemaName, tableName, "IMMUTABLE_ROWS", isImmutableRows);
        }
        if (disableWAL != null) {
            MetaDataClient.mutateBooleanProperty(this.connection, tenantId, schemaName, tableName, "DISABLE_WAL", disableWAL);
        }
        if (isMultiTenant != null) {
            MetaDataClient.mutateBooleanProperty(this.connection, tenantId, schemaName, tableName, "MULTI_TENANT", isMultiTenant);
        }
        if (storeNulls != null) {
            MetaDataClient.mutateBooleanProperty(this.connection, tenantId, schemaName, tableName, "STORE_NULLS", storeNulls);
        }
        if (isTransactional != null) {
            MetaDataClient.mutateBooleanProperty(this.connection, tenantId, schemaName, tableName, "TRANSACTIONAL", isTransactional);
        }
        if (transactionProvider != null) {
            MetaDataClient.mutateByteProperty(this.connection, tenantId, schemaName, tableName, "TRANSACTION_PROVIDER", transactionProvider.getCode());
        }
        if (updateCacheFrequency != null) {
            MetaDataClient.mutateLongProperty(this.connection, tenantId, schemaName, tableName, "UPDATE_CACHE_FREQUENCY", updateCacheFrequency);
        }
        if (guidePostWidth == null || guidePostWidth >= 0L) {
            MetaDataClient.mutateLongProperty(this.connection, tenantId, schemaName, tableName, "GUIDE_POSTS_WIDTH", guidePostWidth);
        }
        if (appendOnlySchema != null) {
            MetaDataClient.mutateBooleanProperty(this.connection, tenantId, schemaName, tableName, "APPEND_ONLY_SCHEMA", appendOnlySchema);
        }
        if (columnEncodedBytes != null) {
            MetaDataClient.mutateByteProperty(this.connection, tenantId, schemaName, tableName, "ENCODING_SCHEME", columnEncodedBytes.getSerializedMetadataValue());
        }
        if (immutableStorageScheme != null) {
            MetaDataClient.mutateStringProperty(this.connection, tenantId, schemaName, tableName, "IMMUTABLE_STORAGE_SCHEME", immutableStorageScheme.name());
        }
        if (useStatsForParallelization != null) {
            MetaDataClient.mutateBooleanProperty(this.connection, tenantId, schemaName, tableName, "USE_STATS_FOR_PARALLELIZATION", useStatsForParallelization);
        }
        if (ttl != null) {
            MetaDataClient.mutateStringProperty(this.connection, tenantId, schemaName, tableName, "TTL", ttl.equals(LiteralTTLExpression.TTL_EXPRESSION_NOT_DEFINED) ? null : ttl.getTTLExpression());
        }
        if (isChangeDetectionEnabled != null) {
            MetaDataClient.mutateBooleanProperty(this.connection, tenantId, schemaName, tableName, "CHANGE_DETECTION_ENABLED", isChangeDetectionEnabled);
        }
        if (isStrictTTL != null) {
            MetaDataClient.mutateBooleanProperty(this.connection, tenantId, schemaName, tableName, "IS_STRICT_TTL", isStrictTTL);
        }
        if (!Strings.isNullOrEmpty((String)physicalTableName)) {
            MetaDataClient.mutateStringProperty(this.connection, tenantId, schemaName, tableName, "PHYSICAL_TABLE_NAME", physicalTableName);
        }
        if (!Strings.isNullOrEmpty((String)schemaVersion)) {
            MetaDataClient.mutateStringProperty(this.connection, tenantId, schemaName, tableName, "SCHEMA_VERSION", schemaVersion);
        }
        if (!Strings.isNullOrEmpty((String)streamingTopicName)) {
            MetaDataClient.mutateStringProperty(this.connection, tenantId, schemaName, tableName, "STREAMING_TOPIC_NAME", streamingTopicName);
        }
        return seqNum;
    }

    public static void mutateTransformProperties(java.sql.Connection connection, String tenantId, String schemaName, String tableName, String physicalTableName, PTable.ImmutableStorageScheme immutableStorageScheme, PTable.QualifierEncodingScheme columnEncodedBytes) throws SQLException {
        if (columnEncodedBytes != null) {
            MetaDataClient.mutateByteProperty(connection, tenantId, schemaName, tableName, "ENCODING_SCHEME", columnEncodedBytes.getSerializedMetadataValue());
        }
        if (immutableStorageScheme != null) {
            MetaDataClient.mutateByteProperty(connection, tenantId, schemaName, tableName, "IMMUTABLE_STORAGE_SCHEME", immutableStorageScheme.getSerializedMetadataValue());
        }
        if (!Strings.isNullOrEmpty((String)physicalTableName)) {
            MetaDataClient.mutateStringProperty(connection, tenantId, schemaName, tableName, "PHYSICAL_TABLE_NAME", physicalTableName);
        }
    }

    private static void mutateBooleanProperty(java.sql.Connection connection, String tenantId, String schemaName, String tableName, String propertyName, boolean propertyValue) throws SQLException {
        String updatePropertySql = "UPSERT INTO SYSTEM.\"CATALOG\"( TENANT_ID,TABLE_SCHEM,TABLE_NAME," + propertyName + ") VALUES (?, ?, ?, ?)";
        try (PreparedStatement tableBoolUpsert = connection.prepareStatement(updatePropertySql);){
            tableBoolUpsert.setString(1, tenantId);
            tableBoolUpsert.setString(2, schemaName);
            tableBoolUpsert.setString(3, tableName);
            tableBoolUpsert.setBoolean(4, propertyValue);
            tableBoolUpsert.execute();
        }
    }

    private static void mutateLongProperty(java.sql.Connection connection, String tenantId, String schemaName, String tableName, String propertyName, Long propertyValue) throws SQLException {
        String updatePropertySql = "UPSERT INTO SYSTEM.\"CATALOG\"( TENANT_ID,TABLE_SCHEM,TABLE_NAME," + propertyName + ") VALUES (?, ?, ?, ?)";
        try (PreparedStatement tableBoolUpsert = connection.prepareStatement(updatePropertySql);){
            tableBoolUpsert.setString(1, tenantId);
            tableBoolUpsert.setString(2, schemaName);
            tableBoolUpsert.setString(3, tableName);
            if (propertyValue == null) {
                tableBoolUpsert.setNull(4, -5);
            } else {
                tableBoolUpsert.setLong(4, propertyValue);
            }
            tableBoolUpsert.execute();
        }
    }

    private static void mutateIntegerProperty(java.sql.Connection connection, String tenantId, String schemaName, String tableName, String propertyName, Integer propertyValue) throws SQLException {
        String updatePropertySql = "UPSERT INTO SYSTEM.\"CATALOG\"( TENANT_ID,TABLE_SCHEM,TABLE_NAME," + propertyName + ") VALUES (?, ?, ?, ?)";
        try (PreparedStatement tableBoolUpsert = connection.prepareStatement(updatePropertySql);){
            tableBoolUpsert.setString(1, tenantId);
            tableBoolUpsert.setString(2, schemaName);
            tableBoolUpsert.setString(3, tableName);
            if (propertyValue == null) {
                tableBoolUpsert.setNull(4, 4);
            } else {
                tableBoolUpsert.setInt(4, propertyValue);
            }
            tableBoolUpsert.execute();
        }
    }

    private static void mutateByteProperty(java.sql.Connection connection, String tenantId, String schemaName, String tableName, String propertyName, Byte propertyValue) throws SQLException {
        String updatePropertySql = "UPSERT INTO SYSTEM.\"CATALOG\"( TENANT_ID,TABLE_SCHEM,TABLE_NAME," + propertyName + ") VALUES (?, ?, ?, ?)";
        try (PreparedStatement tableBoolUpsert = connection.prepareStatement(updatePropertySql);){
            tableBoolUpsert.setString(1, tenantId);
            tableBoolUpsert.setString(2, schemaName);
            tableBoolUpsert.setString(3, tableName);
            if (propertyValue == null) {
                tableBoolUpsert.setNull(4, -6);
            } else {
                tableBoolUpsert.setByte(4, propertyValue);
            }
            tableBoolUpsert.execute();
        }
    }

    private static void mutateStringProperty(java.sql.Connection connection, String tenantId, String schemaName, String tableName, String propertyName, String propertyValue) throws SQLException {
        String updatePropertySql = "UPSERT INTO SYSTEM.\"CATALOG\"( TENANT_ID,TABLE_SCHEM,TABLE_NAME," + propertyName + ") VALUES (?, ?, ?, ?)";
        try (PreparedStatement tableBoolUpsert = connection.prepareStatement(updatePropertySql);){
            tableBoolUpsert.setString(1, tenantId);
            tableBoolUpsert.setString(2, schemaName);
            tableBoolUpsert.setString(3, tableName);
            tableBoolUpsert.setString(4, propertyValue);
            tableBoolUpsert.execute();
        }
    }

    public MutationState addColumn(AddColumnStatement statement) throws SQLException {
        PTable table = FromCompiler.getResolver(statement, this.connection).getTables().get(0).getTable();
        return this.addColumn(table, statement.getColumnDefs(), statement.getProps(), statement.ifNotExists(), false, statement.getTable(), statement.getTableType(), statement.isCascade(), statement.getIndexes());
    }

    /*
     * Could not resolve type clashes
     */
    public MutationState addColumn(PTable table, List<ColumnDef> origColumnDefs, ListMultimap<String, Pair<String, Object>> stmtProperties, boolean ifNotExists, boolean removeTableProps, NamedTableNode namedTableNode, PTableType tableType, boolean cascade, List<NamedNode> indexes) throws SQLException {
        this.connection.rollback();
        List<Object> indexesPTable = Lists.newArrayListWithExpectedSize((int)(indexes != null ? indexes.size() : table.getIndexes().size()));
        HashMap<PTable, Integer> indexToColumnSizeMap = new HashMap<PTable, Integer>();
        if (cascade && (indexes == null || !indexes.isEmpty())) {
            indexesPTable = this.getIndexesPTableForCascade(indexes, table);
            if (indexesPTable.size() == 0) {
                cascade = false;
            } else {
                for (PTable index : indexesPTable) {
                    indexToColumnSizeMap.put(index, index.getColumns().size());
                }
            }
        }
        boolean wasAutoCommit = this.connection.getAutoCommit();
        ArrayList columns = Lists.newArrayListWithExpectedSize((int)(origColumnDefs != null ? origColumnDefs.size() : 0));
        PName tenantId = this.connection.getTenantId();
        boolean sharedIndex = tableType == PTableType.INDEX && (table.getIndexType() == PTable.IndexType.LOCAL || table.getViewIndexId() != null);
        String tenantIdToUse = this.connection.getTenantId() != null && sharedIndex ? this.connection.getTenantId().getString() : null;
        String schemaName = table.getSchemaName().getString();
        String tableName = table.getTableName().getString();
        PName physicalName = table.getPhysicalName();
        String physicalSchemaName = SchemaUtil.getSchemaNameFromFullName(physicalName.getString());
        String physicalTableName = SchemaUtil.getTableNameFromFullName(physicalName.getString());
        HashSet acquiredColumnMutexSet = Sets.newHashSetWithExpectedSize((int)3);
        boolean acquiredBaseTableMutex = false;
        try {
            List<Object> columnDefs;
            this.connection.setAutoCommit(false);
            if ((table.isAppendOnlySchema() || ifNotExists) && origColumnDefs != null) {
                columnDefs = Lists.newArrayList();
                for (ColumnDef columnDef : origColumnDefs) {
                    String familyName = columnDef.getColumnDefName().getFamilyName();
                    String columnName = columnDef.getColumnDefName().getColumnName();
                    if (familyName != null) {
                        try {
                            PColumnFamily columnFamily = table.getColumnFamily(familyName);
                            columnFamily.getPColumnForColumnName(columnName);
                            if (ifNotExists) continue;
                            throw new ColumnAlreadyExistsException(schemaName, tableName, columnName);
                        }
                        catch (ColumnFamilyNotFoundException | ColumnNotFoundException e) {
                            columnDefs.add(columnDef);
                            continue;
                        }
                    }
                    try {
                        table.getColumnForColumnName(columnName);
                        if (ifNotExists) continue;
                        throw new ColumnAlreadyExistsException(schemaName, tableName, columnName);
                    }
                    catch (ColumnNotFoundException e) {
                        columnDefs.add(columnDef);
                    }
                }
            } else {
                columnDefs = origColumnDefs == null ? Collections.emptyList() : origColumnDefs;
            }
            boolean retried = false;
            boolean changingPhoenixTableProperty = false;
            MutableBoolean areWeIntroducingTTLAtThisLevel = new MutableBoolean(false);
            MetaProperties metaProperties = new MetaProperties();
            while (true) {
                Long scn;
                MetaDataProtocol.MetaDataMutationResult result;
                byte[] projectCF;
                byte[] emptyCF;
                PTable transformingNewTable;
                int numPkColumnsAdded;
                MetaPropertiesEvaluated metaPropertiesEvaluated;
                block118: {
                    Object familyName;
                    boolean isTransformNeeded;
                    int numCols;
                    HashMap<String, List<Pair<String, Object>>> properties = new HashMap<String, List<Pair<String, Object>>>(stmtProperties.size());
                    metaProperties = this.loadStmtProperties(stmtProperties, properties, table, removeTableProps);
                    ColumnResolver resolver = FromCompiler.getResolver(namedTableNode, this.connection);
                    table = resolver.getTables().get(0).getTable();
                    int nIndexes = table.getIndexes().size();
                    int nNewColumns = numCols = columnDefs.size();
                    ArrayList tableMetaData = Lists.newArrayListWithExpectedSize((int)((1 + nNewColumns) * (nIndexes + 1)));
                    ArrayList columnMetaData = Lists.newArrayListWithExpectedSize((int)(nNewColumns * (nIndexes + 1)));
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug(LogUtil.addCustomAnnotations("Resolved table to " + table.getName().getString() + " with seqNum " + table.getSequenceNumber() + " at timestamp " + table.getTimeStamp() + " with " + table.getColumns().size() + " columns: " + table.getColumns(), this.connection));
                    }
                    int position = table.getColumns().size();
                    boolean addPKColumns = columnDefs.stream().anyMatch(ColumnDef::isPK);
                    if (addPKColumns) {
                        List<PColumn> currentPKs = table.getPKColumns();
                        PColumn lastPK = currentPKs.get(currentPKs.size() - 1);
                        if (lastPK.getDataType() == PVarbinary.INSTANCE || lastPK.getDataType().isArrayType()) {
                            throw new SQLExceptionInfo.Builder(SQLExceptionCode.VARBINARY_LAST_PK).setColumnName(lastPK.getName().getString()).build().buildException();
                        }
                        if (lastPK.getDataType() == PBson.INSTANCE) {
                            throw new SQLExceptionInfo.Builder(SQLExceptionCode.BSON_LAST_PK).setColumnName(lastPK.getName().getString()).build().buildException();
                        }
                        if (lastPK.isNullable() && lastPK.getDataType().isFixedWidth()) {
                            throw new SQLExceptionInfo.Builder(SQLExceptionCode.NULLABLE_FIXED_WIDTH_LAST_PK).setColumnName(lastPK.getName().getString()).build().buildException();
                        }
                    }
                    metaPropertiesEvaluated = new MetaPropertiesEvaluated();
                    changingPhoenixTableProperty = this.evaluateStmtProperties(metaProperties, metaPropertiesEvaluated, table, schemaName, tableName, areWeIntroducingTTLAtThisLevel);
                    if (areWeIntroducingTTLAtThisLevel.booleanValue()) {
                        TTLExpression ttlAlreadyDefined = LiteralTTLExpression.TTL_EXPRESSION_NOT_DEFINED;
                        if (table.getType() != PTableType.TABLE) {
                            ttlAlreadyDefined = this.checkAndGetTTLFromHierarchy(PhoenixRuntime.getTableNoCache(this.connection, table.getParentName().toString()), tableName);
                        }
                        if (!((Object)ttlAlreadyDefined).equals(LiteralTTLExpression.TTL_EXPRESSION_NOT_DEFINED)) {
                            throw new SQLExceptionInfo.Builder(SQLExceptionCode.TTL_ALREADY_DEFINED_IN_HIERARCHY).setSchemaName(schemaName).setTableName(tableName).build().buildException();
                        }
                    }
                    if (isTransformNeeded = TransformClient.checkIsTransformNeeded(metaProperties, schemaName, table, tableName, null, tenantIdToUse, this.connection)) {
                        if (MetaDataUtil.hasLocalIndexTable(this.connection, physicalTableName.getBytes())) {
                            throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_TRANSFORM_TABLE_WITH_LOCAL_INDEX).setSchemaName(schemaName).setTableName(tableName).build().buildException();
                        }
                        if (table.isAppendOnlySchema()) {
                            throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_TRANSFORM_TABLE_WITH_APPEND_ONLY_SCHEMA).setSchemaName(schemaName).setTableName(tableName).build().buildException();
                        }
                        if (table.isTransactional()) {
                            throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_TRANSFORM_TRANSACTIONAL_TABLE).setSchemaName(schemaName).setTableName(tableName).build().buildException();
                        }
                    }
                    boolean willBeImmutableRows = Boolean.TRUE.equals(metaPropertiesEvaluated.getIsImmutableRows()) || metaPropertiesEvaluated.getIsImmutableRows() == null && table.isImmutableRows();
                    boolean willBeTxnl = metaProperties.getNonTxToTx();
                    Long timeStamp = TransactionUtil.getTableTimestamp(this.connection, table.isTransactional() || willBeTxnl, table.isTransactional() ? table.getTransactionProvider() : metaPropertiesEvaluated.getTransactionProvider());
                    numPkColumnsAdded = 0;
                    LinkedHashSet<String> colFamiliesForPColumnsToBeAdded = new LinkedHashSet<String>();
                    LinkedHashSet<String> families = new LinkedHashSet<String>();
                    PTable tableForCQCounters = tableType == PTableType.VIEW ? this.connection.getTable(table.getPhysicalName().getString()) : table;
                    PTable.EncodedCQCounter cqCounterToUse = tableForCQCounters.getEncodedCQCounter();
                    HashMap<Object, Integer> changedCqCounters = new HashMap<Object, Integer>(numCols);
                    if (numCols > 0) {
                        StatementContext context = new StatementContext(new PhoenixStatement(this.connection), resolver);
                        short nextKeySeq = SchemaUtil.getMaxKeySeq(table);
                        for (ColumnDef colDef : columnDefs) {
                            if (colDef != null && !colDef.isNull()) {
                                if (colDef.isPK()) {
                                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.NOT_NULLABLE_COLUMN_IN_ROW_KEY).setColumnName(colDef.getColumnDefName().getColumnName()).build().buildException();
                                }
                                if (!willBeImmutableRows) {
                                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.KEY_VALUE_NOT_NULL).setColumnName(colDef.getColumnDefName().getColumnName()).build().buildException();
                                }
                            }
                            if (colDef != null && colDef.isPK() && table.getType() == PTableType.VIEW && table.getViewType() != PTable.ViewType.MAPPED) {
                                this.throwIfLastPKOfParentIsVariableLength(this.getParentOfView(table), schemaName, tableName, colDef);
                            }
                            if (colDef != null && colDef.isRowTimestamp()) {
                                throw new SQLExceptionInfo.Builder(SQLExceptionCode.ROWTIMESTAMP_CREATE_ONLY).setColumnName(colDef.getColumnDefName().getColumnName()).build().buildException();
                            }
                            if (!colDef.validateDefault(context, null)) {
                                colDef = new ColumnDef(colDef, null);
                            }
                            if (!colDef.isPK() && table.hasConditionalTTL()) {
                                PColumnFamily family = table.getColumnFamilies().get(0);
                                String tableFamilyName = family.getName().getString();
                                String colFamilyName = colDef.getColumnDefName().getFamilyName();
                                if (colFamilyName == null) {
                                    String string = colFamilyName = table.getDefaultFamilyName() == null ? "0" : table.getDefaultFamilyName().getString();
                                }
                                if (!colFamilyName.equals(tableFamilyName)) {
                                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_SET_CONDITIONAL_TTL_ON_TABLE_WITH_MULTIPLE_COLUMN_FAMILIES).setMessage(String.format("Cannot add column %s", colDef)).build().buildException();
                                }
                            }
                            familyName = null;
                            Integer encodedCQ = null;
                            if (!colDef.isPK()) {
                                String defaultColumnFamily;
                                String colDefFamily = colDef.getColumnDefName().getFamilyName();
                                PTable.ImmutableStorageScheme storageScheme = table.getImmutableStorageScheme();
                                String string = defaultColumnFamily = tableForCQCounters.getDefaultFamilyName() != null && !Strings.isNullOrEmpty((String)tableForCQCounters.getDefaultFamilyName().getString()) ? tableForCQCounters.getDefaultFamilyName().getString() : "0";
                                if (table.getType() == PTableType.INDEX && table.getIndexType() == PTable.IndexType.LOCAL) {
                                    defaultColumnFamily = "L#" + defaultColumnFamily;
                                }
                                familyName = storageScheme == PTable.ImmutableStorageScheme.SINGLE_CELL_ARRAY_WITH_OFFSETS ? (colDefFamily != null ? colDefFamily : defaultColumnFamily) : defaultColumnFamily;
                                Integer n = encodedCQ = table.isAppendOnlySchema() ? Integer.valueOf(11 + position) : cqCounterToUse.getNextQualifier((String)familyName);
                                if (!table.isAppendOnlySchema() && cqCounterToUse.increment((String)familyName)) {
                                    changedCqCounters.put(familyName, cqCounterToUse.getNextQualifier((String)familyName));
                                }
                            }
                            byte[] columnQualifierBytes = null;
                            try {
                                columnQualifierBytes = EncodedColumnsUtil.getColumnQualifierBytes(colDef.getColumnDefName().getColumnName(), encodedCQ, table, colDef.isPK());
                            }
                            catch (PTable.QualifierEncodingScheme.QualifierOutOfRangeException e) {
                                throw new SQLExceptionInfo.Builder(SQLExceptionCode.MAX_COLUMNS_EXCEEDED).setSchemaName(schemaName).setTableName(tableName).build().buildException();
                            }
                            PColumn column = ColumnMetaDataOps.newColumn(position++, colDef, PrimaryKeyConstraint.EMPTY, table.getDefaultFamilyName() == null ? null : table.getDefaultFamilyName().getString(), true, columnQualifierBytes, willBeImmutableRows);
                            HashMap<PTable, PColumn> indexToIndexColumnMap = null;
                            if (cascade) {
                                indexToIndexColumnMap = this.getPTablePColumnHashMapForCascade(indexesPTable, willBeImmutableRows, colDef, (String)familyName, indexToColumnSizeMap);
                            }
                            columns.add(column);
                            String pkName = null;
                            Short keySeq = null;
                            if (column.getFamilyName() == null) {
                                ++numPkColumnsAdded;
                                pkName = table.getPKName() == null ? null : table.getPKName().getString();
                                nextKeySeq = (short)(nextKeySeq + 1);
                                keySeq = nextKeySeq;
                            } else {
                                families.add(column.getFamilyName().getString());
                            }
                            colFamiliesForPColumnsToBeAdded.add(column.getFamilyName() == null ? null : column.getFamilyName().getString());
                            ColumnMetaDataOps.addColumnMutation(this.connection, schemaName, tableName, column, null, pkName, keySeq, table.getBucketNum() != null);
                            if (!cascade) continue;
                            for (PTable index : indexesPTable) {
                                LOGGER.info("Adding column " + column.getName().getString() + " to " + index.getTableName().toString());
                                ColumnMetaDataOps.addColumnMutation(this.connection, schemaName, index.getTableName().getString(), indexToIndexColumnMap.get(index), null, "", keySeq, index.getBucketNum() != null);
                            }
                        }
                        if (numPkColumnsAdded > 0) {
                            ArrayList pkColumns = Lists.newArrayListWithExpectedSize((int)(table.getPKColumns().size() + numPkColumnsAdded));
                            pkColumns.addAll(table.getPKColumns());
                            for (int i = 0; i < numCols; ++i) {
                                if (!((ColumnDef)columnDefs.get(i)).isPK()) continue;
                                pkColumns.add(columns.get(i));
                            }
                            int pkSlotPosition = table.getPKColumns().size() - 1;
                            for (Object index : table.getIndexes()) {
                                short nextIndexKeySeq = SchemaUtil.getMaxKeySeq((PTable)index);
                                int indexPosition = index.getColumns().size();
                                for (int i = 0; i < numCols; ++i) {
                                    ColumnDef colDef = (ColumnDef)columnDefs.get(i);
                                    if (!colDef.isPK()) continue;
                                    PDataType indexColDataType = IndexUtil.getIndexColumnDataType(colDef.isNull(), colDef.getDataType());
                                    ColumnName indexColName = ColumnName.caseSensitiveColumnName(IndexUtil.getIndexColumnName(null, colDef.getColumnDefName().getColumnName()));
                                    RowKeyColumnExpression expression = new RowKeyColumnExpression((PDatum)columns.get(i), new RowKeyValueAccessor(pkColumns, pkSlotPosition));
                                    ColumnDef indexColDef = FACTORY.columnDef(indexColName, indexColDataType.getSqlTypeName(), colDef.isNull(), colDef.getMaxLength(), colDef.getScale(), true, colDef.getSortOrder(), ((Object)expression).toString(), colDef.isRowTimestamp());
                                    PColumn indexColumn = ColumnMetaDataOps.newColumn(indexPosition++, indexColDef, PrimaryKeyConstraint.EMPTY, null, true, null, willBeImmutableRows);
                                    nextIndexKeySeq = (short)(nextIndexKeySeq + 1);
                                    ColumnMetaDataOps.addColumnMutation(this.connection, schemaName, index.getTableName().getString(), indexColumn, index.getParentTableName().getString(), index.getPKName() == null ? null : index.getPKName().getString(), nextIndexKeySeq, index.getBucketNum() != null);
                                }
                            }
                            ++pkSlotPosition;
                        }
                        columnMetaData.addAll((Collection)this.connection.getMutationState().toMutations(timeStamp).next().getSecond());
                        this.connection.rollback();
                    } else {
                        if (Boolean.FALSE.equals(metaPropertiesEvaluated.getIsImmutableRows()) && !table.getIndexes().isEmpty()) {
                            int hbaseVersion = this.connection.getQueryServices().getLowestClusterHBaseVersion();
                            if (hbaseVersion < MetaDataProtocol.MUTABLE_SI_VERSION_THRESHOLD) {
                                throw new SQLExceptionInfo.Builder(SQLExceptionCode.NO_MUTABLE_INDEXES).setSchemaName(schemaName).setTableName(tableName).build().buildException();
                            }
                            if (!this.connection.getQueryServices().hasIndexWALCodec() && !table.isTransactional()) {
                                throw new SQLExceptionInfo.Builder(SQLExceptionCode.INVALID_MUTABLE_INDEX_CONFIG).setSchemaName(schemaName).setTableName(tableName).build().buildException();
                            }
                        }
                        if (Boolean.TRUE.equals(metaPropertiesEvaluated.getMultiTenant())) {
                            MetaDataClient.throwIfInsufficientColumns(schemaName, tableName, table.getPKColumns(), table.getBucketNum() != null, metaPropertiesEvaluated.getMultiTenant());
                        }
                    }
                    if (!table.getIndexes().isEmpty() && (numPkColumnsAdded > 0 || metaProperties.getNonTxToTx() || metaPropertiesEvaluated.getUpdateCacheFrequency() != null)) {
                        for (PTable index : table.getIndexes()) {
                            this.incrementTableSeqNum(index, index.getType(), numPkColumnsAdded, metaProperties.getNonTxToTx() ? Boolean.TRUE : null, metaPropertiesEvaluated.getUpdateCacheFrequency(), metaPropertiesEvaluated.getPhysicalTableName(), metaPropertiesEvaluated.getSchemaVersion(), metaProperties.getColumnEncodedBytesProp());
                        }
                        tableMetaData.addAll((Collection)this.connection.getMutationState().toMutations(timeStamp).next().getSecond());
                        this.connection.rollback();
                    }
                    if (cascade) {
                        for (PTable index : indexesPTable) {
                            this.incrementTableSeqNum(index, index.getType(), columnDefs.size(), Boolean.FALSE, metaPropertiesEvaluated.getUpdateCacheFrequency(), metaPropertiesEvaluated.getPhysicalTableName(), metaPropertiesEvaluated.getSchemaVersion(), metaPropertiesEvaluated.getColumnEncodedBytes());
                        }
                        tableMetaData.addAll((Collection)this.connection.getMutationState().toMutations(timeStamp).next().getSecond());
                        this.connection.rollback();
                    }
                    long seqNum = 0L;
                    if (changingPhoenixTableProperty || columnDefs.size() > 0) {
                        seqNum = this.incrementTableSeqNum(table, tableType, columnDefs.size(), metaPropertiesEvaluated);
                        tableMetaData.addAll((Collection)this.connection.getMutationState().toMutations(timeStamp).next().getSecond());
                        this.connection.rollback();
                    }
                    transformingNewTable = null;
                    if (isTransformNeeded) {
                        try {
                            transformingNewTable = TransformClient.addTransform(this.connection, tenantIdToUse, table, metaProperties, seqNum, PTable.TransformType.METADATA_TRANSFORM);
                        }
                        catch (SQLException ex) {
                            this.connection.rollback();
                            throw ex;
                        }
                    }
                    Collections.reverse(tableMetaData);
                    tableMetaData.addAll(columnMetaData);
                    if (!changedCqCounters.isEmpty()) {
                        PreparedStatement linkStatement = this.connection.prepareStatement(UPDATE_ENCODED_COLUMN_COUNTER);
                        familyName = null;
                        try {
                            Object index;
                            index = changedCqCounters.entrySet().iterator();
                            while (index.hasNext()) {
                                Map.Entry entry = index.next();
                                linkStatement.setString(1, tenantIdToUse);
                                linkStatement.setString(2, tableForCQCounters.getSchemaName().getString());
                                linkStatement.setString(3, tableForCQCounters.getTableName().getString());
                                linkStatement.setString(4, (String)entry.getKey());
                                linkStatement.setInt(5, (Integer)entry.getValue());
                                linkStatement.execute();
                            }
                        }
                        catch (Throwable index) {
                            familyName = index;
                            throw index;
                        }
                        finally {
                            if (linkStatement != null) {
                                if (familyName != null) {
                                    try {
                                        linkStatement.close();
                                    }
                                    catch (Throwable index) {
                                        ((Throwable)familyName).addSuppressed(index);
                                    }
                                } else {
                                    linkStatement.close();
                                }
                            }
                        }
                        if (tableType == PTableType.VIEW) {
                            PreparedStatement incrementStatement = this.connection.prepareStatement(INCREMENT_SEQ_NUM);
                            familyName = null;
                            try {
                                incrementStatement.setString(1, null);
                                incrementStatement.setString(2, tableForCQCounters.getSchemaName().getString());
                                incrementStatement.setString(3, tableForCQCounters.getTableName().getString());
                                incrementStatement.setLong(4, tableForCQCounters.getSequenceNumber() + 1L);
                                incrementStatement.execute();
                            }
                            catch (Throwable index) {
                                familyName = index;
                                throw index;
                            }
                            finally {
                                if (incrementStatement != null) {
                                    if (familyName != null) {
                                        try {
                                            incrementStatement.close();
                                        }
                                        catch (Throwable index) {
                                            ((Throwable)familyName).addSuppressed(index);
                                        }
                                    } else {
                                        incrementStatement.close();
                                    }
                                }
                            }
                        }
                        tableMetaData.addAll((Collection)this.connection.getMutationState().toMutations(timeStamp).next().getSecond());
                        this.connection.rollback();
                    }
                    byte[] family = families.size() > 0 ? ((String)families.iterator().next()).getBytes(StandardCharsets.UTF_8) : null;
                    emptyCF = null;
                    projectCF = null;
                    if (table.getType() != PTableType.VIEW && family != null) {
                        if (table.getColumnFamilies().isEmpty()) {
                            emptyCF = family;
                        } else {
                            try {
                                table.getColumnFamily(family);
                            }
                            catch (ColumnFamilyNotFoundException e) {
                                projectCF = family;
                                emptyCF = SchemaUtil.getEmptyColumnFamily(table);
                            }
                        }
                    }
                    if (EncodedColumnsUtil.usesEncodedColumnNames(table) && stmtProperties.isEmpty() && !acquiredBaseTableMutex && !(acquiredBaseTableMutex = this.writeCell(null, physicalSchemaName, physicalTableName, null))) {
                        throw new ConcurrentTableMutationException(physicalSchemaName, physicalTableName);
                    }
                    for (PColumn pColumn : columns) {
                        boolean acquiredMutex = this.writeCell(null, physicalSchemaName, physicalTableName, pColumn.toString());
                        if (!acquiredMutex && !acquiredColumnMutexSet.contains(pColumn.toString())) {
                            throw new ConcurrentTableMutationException(physicalSchemaName, physicalTableName);
                        }
                        acquiredColumnMutexSet.add(pColumn.toString());
                    }
                    result = this.connection.getQueryServices().addColumn(tableMetaData, table, this.getParentTable(table), transformingNewTable, properties, colFamiliesForPColumnsToBeAdded, columns);
                    try {
                        MetaDataProtocol.MutationCode code = this.processMutationResult(schemaName, tableName, result);
                        if (code != MetaDataProtocol.MutationCode.COLUMN_ALREADY_EXISTS) break block118;
                        this.addTableToCache(result, false);
                        if (!ifNotExists) {
                            throw new ColumnAlreadyExistsException(schemaName, tableName, SchemaUtil.findExistingColumn(result.getTable(), columns));
                        }
                        MutationState acquiredMutex = new MutationState(0, 0L, this.connection);
                        return acquiredMutex;
                    }
                    catch (ConcurrentTableMutationException e) {
                        if (retried) {
                            throw e;
                        }
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug(LogUtil.addCustomAnnotations("Caught ConcurrentTableMutationException for table " + SchemaUtil.getTableName(schemaName, tableName) + ". Will try again...", this.connection));
                        }
                        retried = true;
                        continue;
                    }
                    catch (Throwable e) {
                        TableMetricsManager.updateMetricsForSystemCatalogTableMethod(tableName, MetricType.NUM_METADATA_LOOKUP_FAILURES, 1L);
                        throw e;
                    }
                }
                String fullTableName = SchemaUtil.getTableName(schemaName, tableName);
                long resolvedTimeStamp = TransactionUtil.getResolvedTime(this.connection, result);
                if (table.getIndexes().isEmpty() || numPkColumnsAdded == 0 && !metaProperties.getNonTxToTx()) {
                    this.addTableToCache(result, false, resolvedTimeStamp);
                    table = result.getTable();
                } else {
                    this.connection.removeTable(tenantId, fullTableName, null, resolvedTimeStamp);
                }
                if (table.getType() == PTableType.TABLE && Boolean.FALSE.equals(metaPropertiesEvaluated.getMultiTenant()) && MetaDataUtil.hasViewIndexTable(this.connection, table.getPhysicalName())) {
                    this.connection.setAutoCommit(true);
                    MetaDataUtil.deleteViewIndexSequences(this.connection, table.getPhysicalName(), table.isNamespaceMapped());
                    if (!this.connection.getQueryServices().getProps().getBoolean("phoenix.schema.dropMetaData", true)) {
                        scn = this.connection.getSCN();
                        long ts = scn == null ? result.getMutationTime() : scn.longValue();
                        byte[] viewIndexPhysicalName = MetaDataUtil.getViewIndexPhysicalName(table.getPhysicalName().getBytes());
                        String viewIndexSchemaName = SchemaUtil.getSchemaNameFromFullName(viewIndexPhysicalName);
                        String viewIndexTableName = SchemaUtil.getTableNameFromFullName(viewIndexPhysicalName);
                        PName viewIndexName = PNameFactory.newName(SchemaUtil.getTableName(viewIndexSchemaName, viewIndexTableName));
                        PTableImpl viewIndexTable = new PTableImpl.Builder().setName(viewIndexName).setKey(new PTableKey(tenantId, viewIndexName.getString())).setSchemaName(PNameFactory.newName(viewIndexSchemaName)).setTableName(PNameFactory.newName(viewIndexTableName)).setType(PTableType.VIEW).setViewType(PTable.ViewType.MAPPED).setTimeStamp(ts).setPkColumns(Collections.emptyList()).setAllColumns(Collections.emptyList()).setRowKeySchema(RowKeySchema.EMPTY_SCHEMA).setIndexes(Collections.emptyList()).setFamilyAttributes(table.getColumnFamilies()).setPhysicalNames(Collections.emptyList()).setNamespaceMapped(table.isNamespaceMapped()).setImmutableStorageScheme(table.getImmutableStorageScheme()).setQualifierEncodingScheme(table.getEncodingScheme()).setUseStatsForParallelization(table.useStatsForParallelization()).setIsStrictTTL(table.isStrictTTL()).build();
                        List<TableRef> tableRefs = Collections.singletonList(new TableRef(null, viewIndexTable, ts, false));
                        MutationPlan plan = new PostDDLCompiler(this.connection).compile(tableRefs, null, null, Collections.emptyList(), ts);
                        this.connection.getQueryServices().updateData(plan);
                    }
                }
                if (transformingNewTable != null) {
                    this.connection.removeTable(tenantId, fullTableName, null, resolvedTimeStamp);
                    this.connection.getQueryServices().clearCache();
                }
                if (emptyCF != null) {
                    scn = this.connection.getSCN();
                    this.connection.setAutoCommit(true);
                    long ts = scn == null ? result.getMutationTime() : scn.longValue();
                    MutationPlan plan = new PostDDLCompiler(this.connection).compile(Collections.singletonList(new TableRef(null, table, ts, false)), emptyCF, projectCF == null ? null : Collections.singletonList(projectCF), null, ts);
                    MutationState mutationState = this.connection.getQueryServices().updateData(plan);
                    return mutationState;
                }
                MutationState mutationState = new MutationState(0, 0L, this.connection);
                return mutationState;
                break;
            }
        }
        finally {
            this.connection.setAutoCommit(wasAutoCommit);
            if (acquiredBaseTableMutex) {
                this.deleteCell(null, physicalSchemaName, physicalTableName, null);
            }
            this.deleteMutexCells(physicalSchemaName, physicalTableName, acquiredColumnMutexSet);
        }
    }

    private List<PTable> getIndexesPTableForCascade(List<NamedNode> indexes, PTable table) throws SQLException {
        boolean isView = table.getType().equals((Object)PTableType.VIEW);
        ArrayList<PTable> indexesPTable = new ArrayList<PTable>();
        if (indexes == null) {
            indexesPTable.addAll(table.getIndexes());
            for (PTable index : table.getIndexes()) {
                if (!index.getIndexType().equals((Object)PTable.IndexType.LOCAL) && (!isView || !index.getTableName().toString().contains("#"))) continue;
                indexesPTable.remove(index);
            }
        } else {
            ArrayList indexesParam = Lists.newArrayListWithExpectedSize((int)indexes.size());
            for (NamedNode namedNode : indexes) {
                indexesParam.add(namedNode.getName());
            }
            for (PTable pTable : table.getIndexes()) {
                if (pTable.getIndexType().equals((Object)PTable.IndexType.LOCAL)) {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.NOT_SUPPORTED_CASCADE_FEATURE_LOCAL_INDEX).setTableName(pTable.getName().getString()).build().buildException();
                }
                if (!indexesParam.remove(pTable.getTableName().getString())) continue;
                indexesPTable.add(pTable);
            }
            if (!indexesParam.isEmpty()) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.INCORRECT_INDEX_NAME).setTableName(StringUtils.join((CharSequence)",", (Iterable)indexesParam)).build().buildException();
            }
        }
        return indexesPTable;
    }

    private HashMap<PTable, PColumn> getPTablePColumnHashMapForCascade(List<PTable> indexesPTable, boolean willBeImmutableRows, ColumnDef colDef, String familyName, Map<PTable, Integer> indexToColumnSizeMap) throws SQLException {
        if (colDef.isPK()) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.NOT_SUPPORTED_CASCADE_FEATURE_PK).build().buildException();
        }
        HashMap<PTable, PColumn> indexColumn = new HashMap<PTable, PColumn>(indexesPTable.size());
        ColumnName indexColName = ColumnName.caseSensitiveColumnName(IndexUtil.getIndexColumnName(familyName, colDef.getColumnDefName().getColumnName()));
        ColumnDef indexColDef = FACTORY.columnDef(indexColName, colDef.getDataType().getSqlTypeName(), colDef.isNull(), colDef.getMaxLength(), colDef.getScale(), false, colDef.getSortOrder(), colDef.getExpression(), colDef.isRowTimestamp());
        for (PTable index : indexesPTable) {
            int iPos = indexToColumnSizeMap.get(index);
            PTable.EncodedCQCounter cqCounterToUse = index.getEncodedCQCounter();
            int baseCount = 0;
            baseCount = cqCounterToUse != null && cqCounterToUse.getNextQualifier(familyName) != null ? cqCounterToUse.getNextQualifier(familyName) : 0;
            Integer encodedCQ = index.isAppendOnlySchema() ? Integer.valueOf(11 + iPos) : baseCount + iPos;
            byte[] columnQualifierBytes = EncodedColumnsUtil.getColumnQualifierBytes(indexColDef.getColumnDefName().getColumnName(), encodedCQ, index, indexColDef.isPK());
            PColumn iColumn = ColumnMetaDataOps.newColumn(iPos, indexColDef, null, index.getDefaultFamilyName() == null ? null : index.getDefaultFamilyName().getString(), false, columnQualifierBytes, willBeImmutableRows);
            indexColumn.put(index, iColumn);
            indexToColumnSizeMap.put(index, iPos + 1);
        }
        return indexColumn;
    }

    private void deleteMutexCells(String physicalSchemaName, String physicalTableName, Set<String> acquiredColumnMutexSet) throws SQLException {
        if (!acquiredColumnMutexSet.isEmpty()) {
            for (String columnName : acquiredColumnMutexSet) {
                this.deleteCell(null, physicalSchemaName, physicalTableName, columnName);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private String dropColumnMutations(PTable table, List<PColumn> columnsToDrop) throws SQLException {
        String tenantId = this.connection.getTenantId() == null ? "" : this.connection.getTenantId().getString();
        String schemaName = table.getSchemaName().getString();
        String tableName = table.getTableName().getString();
        String familyName = null;
        StringBuilder buf = new StringBuilder("DELETE FROM SYSTEM.\"CATALOG\" WHERE ");
        buf.append("(TENANT_ID,TABLE_SCHEM,TABLE_NAME,COLUMN_NAME, COLUMN_FAMILY) IN (");
        for (PColumn pColumn : columnsToDrop) {
            buf.append("('" + tenantId + "'");
            buf.append(",'" + schemaName + "'");
            buf.append(",'" + tableName + "'");
            buf.append(",'" + pColumn.getName().getString() + "'");
            buf.append(",'" + (pColumn.getFamilyName() == null ? "" : pColumn.getFamilyName().getString()) + "'),");
        }
        buf.setCharAt(buf.length() - 1, ')');
        Throwable throwable = null;
        try (PreparedStatement delCol = this.connection.prepareStatement(buf.toString());){
            delCol.execute();
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
        Collections.sort(columnsToDrop, new Comparator<PColumn>(){

            @Override
            public int compare(PColumn left, PColumn right) {
                return Ints.compare((int)left.getPosition(), (int)right.getPosition());
            }
        });
        boolean isSalted = table.getBucketNum() != null;
        int n = 0;
        try (PreparedStatement colUpdate = this.connection.prepareStatement(UPDATE_COLUMN_POSITION);){
            colUpdate.setString(1, tenantId);
            colUpdate.setString(2, schemaName);
            colUpdate.setString(3, tableName);
            for (int i = columnsToDrop.get(n).getPosition() + 1; i < table.getColumns().size(); ++i) {
                void var9_14;
                PColumn column = table.getColumns().get(i);
                if (columnsToDrop.contains(column)) {
                    ++var9_14;
                    continue;
                }
                colUpdate.setString(4, column.getName().getString());
                colUpdate.setString(5, column.getFamilyName() == null ? null : column.getFamilyName().getString());
                colUpdate.setInt(6, column.getPosition() - var9_14 - (isSalted ? 1 : 0));
                colUpdate.execute();
            }
        }
        return familyName;
    }

    private static byte[] getNewEmptyColumnFamilyOrNull(PTable table, PColumn columnToDrop) {
        if (table.getType() != PTableType.VIEW && !SchemaUtil.isPKColumn(columnToDrop) && table.getColumnFamilies().get(0).getName().equals(columnToDrop.getFamilyName()) && table.getColumnFamilies().get(0).getColumns().size() == 1) {
            return SchemaUtil.getEmptyColumnFamily(table.getDefaultFamilyName(), table.getColumnFamilies().subList(1, table.getColumnFamilies().size()), table.getIndexType() == PTable.IndexType.LOCAL);
        }
        return null;
    }

    private PTable getParentTable(PTable table) throws SQLException {
        boolean hasIndexId;
        PTable parentTable = null;
        boolean bl = hasIndexId = table.getViewIndexId() != null;
        if (table.getType() == PTableType.INDEX && hasIndexId || table.getType() == PTableType.VIEW && table.getViewType() != PTable.ViewType.MAPPED) {
            parentTable = this.connection.getTable(table.getParentName().getString());
            if (parentTable == null) {
                String schemaName = table.getSchemaName() != null ? table.getSchemaName().getString() : null;
                throw new TableNotFoundException(schemaName, table.getTableName().getString());
            }
            if (hasIndexId && parentTable.getType() != PTableType.VIEW) {
                return null;
            }
        }
        return parentTable;
    }

    /*
     * Exception decompiling
     */
    public MutationState dropColumn(DropColumnStatement statement) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [12[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutationState alterIndex(AlterIndexStatement statement) throws SQLException {
        this.connection.rollback();
        boolean wasAutoCommit = this.connection.getAutoCommit();
        long seqNum = 0L;
        try {
            block55: {
                TableRef dataTableRef;
                PTable index;
                String dataTableName = statement.getTableName();
                final String indexName = statement.getTable().getName().getTableName();
                boolean isAsync = statement.isAsync();
                boolean isRebuildAll = statement.isRebuildAll();
                String tenantId = this.connection.getTenantId() == null ? null : this.connection.getTenantId().getString();
                PTable table = FromCompiler.getIndexResolver(statement, this.connection).getTables().get(0).getTable();
                String schemaName = statement.getTable().getName().getSchemaName();
                String tableName = table.getTableName().getString();
                HashMap<String, List<Pair<String, Object>>> properties = new HashMap<String, List<Pair<String, Object>>>(statement.getProps().size());
                MetaProperties metaProperties = this.loadStmtProperties(statement.getProps(), properties, table, false);
                boolean isTransformNeeded = TransformClient.checkIsTransformNeeded(metaProperties, schemaName, table, indexName, dataTableName, tenantId, this.connection);
                MetaPropertiesEvaluated metaPropertiesEvaluated = new MetaPropertiesEvaluated();
                boolean changingPhoenixTableProperty = this.evaluateStmtProperties(metaProperties, metaPropertiesEvaluated, table, schemaName, tableName, new MutableBoolean(false));
                PIndexState newIndexState = statement.getIndexState();
                if (isAsync && newIndexState != PIndexState.REBUILD) {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.ASYNC_NOT_ALLOWED).setMessage(" ASYNC building of index is allowed only with REBUILD index state").setSchemaName(schemaName).setTableName(indexName).build().buildException();
                }
                if (newIndexState == PIndexState.REBUILD) {
                    newIndexState = PIndexState.BUILDING;
                }
                this.connection.setAutoCommit(false);
                TableRef indexRef = FromCompiler.getResolver(statement, this.connection).getTables().get(0);
                try (Statement tableUpsert = null;){
                    tableUpsert = newIndexState == PIndexState.ACTIVE ? this.connection.prepareStatement(UPDATE_INDEX_STATE_TO_ACTIVE) : this.connection.prepareStatement(UPDATE_INDEX_STATE);
                    tableUpsert.setString(1, this.connection.getTenantId() == null ? null : this.connection.getTenantId().getString());
                    tableUpsert.setString(2, schemaName);
                    tableUpsert.setString(3, indexName);
                    tableUpsert.setString(4, newIndexState.getSerializedValue());
                    tableUpsert.setLong(5, 0L);
                    if (newIndexState == PIndexState.ACTIVE) {
                        tableUpsert.setLong(6, 0L);
                    }
                    tableUpsert.execute();
                }
                Long timeStamp = indexRef.getTable().isTransactional() ? Long.valueOf(indexRef.getTimeStamp()) : null;
                List tableMetadata = (List)this.connection.getMutationState().toMutations(timeStamp).next().getSecond();
                this.connection.rollback();
                if (changingPhoenixTableProperty) {
                    seqNum = this.incrementTableSeqNum(table, statement.getTableType(), 0, metaPropertiesEvaluated);
                    tableMetadata.addAll((Collection)this.connection.getMutationState().toMutations(timeStamp).next().getSecond());
                    this.connection.rollback();
                }
                MetaDataProtocol.MetaDataMutationResult result = this.connection.getQueryServices().updateIndexState(tableMetadata, dataTableName, properties, table);
                try {
                    block56: {
                        MetaDataProtocol.MutationCode code = result.getMutationCode();
                        if (code == MetaDataProtocol.MutationCode.TABLE_NOT_FOUND) {
                            throw new TableNotFoundException(schemaName, indexName);
                        }
                        if (code == MetaDataProtocol.MutationCode.UNALLOWED_TABLE_MUTATION) {
                            throw new SQLExceptionInfo.Builder(SQLExceptionCode.INVALID_INDEX_STATE_TRANSITION).setMessage(" currentState=" + (Object)((Object)indexRef.getTable().getIndexState()) + ". requestedState=" + (Object)((Object)newIndexState)).setSchemaName(schemaName).setTableName(indexName).build().buildException();
                        }
                        if (isTransformNeeded) {
                            if (indexRef.getTable().getViewIndexId() != null) {
                                throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_TRANSFORM_LOCAL_OR_VIEW_INDEX).setSchemaName(schemaName).setTableName(indexName).build().buildException();
                            }
                            try {
                                TransformClient.addTransform(this.connection, tenantId, table, metaProperties, seqNum, PTable.TransformType.METADATA_TRANSFORM);
                            }
                            catch (SQLException ex) {
                                this.connection.rollback();
                                throw ex;
                            }
                        }
                        if (code == MetaDataProtocol.MutationCode.TABLE_ALREADY_EXISTS && result.getTable() != null) {
                            this.addTableToCache(result, false);
                            indexRef.setTable(result.getTable());
                            if (newIndexState == PIndexState.BUILDING && isAsync) {
                                if (isRebuildAll) {
                                    List<Task.TaskRecord> tasks = Task.queryTaskTable(this.connection, null, schemaName, tableName, PTable.TaskType.INDEX_REBUILD, tenantId, indexName);
                                    if (tasks == null || tasks.size() == 0) {
                                        Timestamp ts = new Timestamp(EnvironmentEdgeManager.currentTimeMillis());
                                        HashMap<String, Object> props = new HashMap<String, Object>(){
                                            {
                                                this.put("IndexName", indexName);
                                                this.put("RebuildAll", true);
                                            }
                                        };
                                        try {
                                            String json = JacksonUtil.getObjectWriter().writeValueAsString((Object)props);
                                            List<Mutation> sysTaskUpsertMutations = Task.getMutationsForAddTask(new SystemTaskParams.SystemTaskParamsBuilder().setConn(this.connection).setTaskType(PTable.TaskType.INDEX_REBUILD).setTenantId(tenantId).setSchemaName(schemaName).setTableName(dataTableName).setTaskStatus(PTable.TaskStatus.CREATED.toString()).setData(json).setPriority(null).setStartTs(ts).setEndTs(null).setAccessCheckEnabled(true).build());
                                            byte[] rowKey = sysTaskUpsertMutations.get(0).getRow();
                                            MetaDataProtocol.MetaDataMutationResult metaDataMutationResult = Task.taskMetaDataCoprocessorExec(this.connection, rowKey, new TaskMetaDataServiceCallBack(sysTaskUpsertMutations));
                                            if (MetaDataProtocol.MutationCode.UNABLE_TO_UPSERT_TASK.equals((Object)metaDataMutationResult.getMutationCode())) {
                                                throw new SQLExceptionInfo.Builder(SQLExceptionCode.UNABLE_TO_UPSERT_TASK).setSchemaName("SYSTEM").setTableName("TASK").build().buildException();
                                            }
                                        }
                                        catch (IOException e) {
                                            throw new SQLException("Exception happened while adding a System.Task" + e.toString());
                                        }
                                    }
                                } else {
                                    try {
                                        tableUpsert = this.connection.prepareStatement(UPDATE_INDEX_REBUILD_ASYNC_STATE);
                                        tableUpsert.setString(1, this.connection.getTenantId() == null ? null : this.connection.getTenantId().getString());
                                        tableUpsert.setString(2, schemaName);
                                        tableUpsert.setString(3, indexName);
                                        long beginTimestamp = result.getTable().getTimeStamp();
                                        tableUpsert.setLong(4, beginTimestamp);
                                        tableUpsert.execute();
                                        this.connection.commit();
                                    }
                                    finally {
                                        if (tableUpsert != null) {
                                            tableUpsert.close();
                                        }
                                    }
                                }
                            }
                        }
                        if (newIndexState != PIndexState.BUILDING || isAsync) break block55;
                        index = indexRef.getTable();
                        if (IndexUtil.isGlobalIndex(index) && index.getViewIndexId() == null) {
                            TableName physicalTableName = TableName.valueOf((byte[])index.getPhysicalName().getBytes());
                            try (Admin admin = this.connection.getQueryServices().getAdmin();){
                                admin.disableTable(physicalTableName);
                                admin.truncateTable(physicalTableName, true);
                                break block56;
                            }
                            catch (IOException ie) {
                                String failedTable = physicalTableName.getNameAsString();
                                throw new SQLExceptionInfo.Builder(SQLExceptionCode.UNKNOWN_ERROR_CODE).setMessage("Error when truncating index table [" + failedTable + "] before rebuilding: " + ie.getMessage()).setTableName(failedTable).build().buildException();
                            }
                        }
                        Long scn = this.connection.getSCN();
                        long ts = scn == null ? Long.MAX_VALUE : scn;
                        MutationPlan plan = new PostDDLCompiler(this.connection).compile(Collections.singletonList(indexRef), null, null, Collections.emptyList(), ts);
                        this.connection.getQueryServices().updateData(plan);
                    }
                    NamedTableNode dataTableNode = NamedTableNode.create(null, org.apache.phoenix.parse.TableName.create(schemaName, dataTableName), Collections.emptyList());
                    this.connection.setAutoCommit(true);
                    if (this.connection.getSCN() != null) {
                        MutationState ts = this.buildIndexAtTimeStamp(index, dataTableNode);
                        return ts;
                    }
                    dataTableRef = FromCompiler.getResolver(dataTableNode, this.connection).getTables().get(0);
                }
                catch (Throwable e) {
                    try {
                        TableMetricsManager.updateMetricsForSystemCatalogTableMethod(dataTableName, MetricType.NUM_METADATA_LOOKUP_FAILURES, 1L);
                        throw e;
                    }
                    catch (TableNotFoundException e2) {
                        if (!statement.ifExists()) {
                            throw e2;
                        }
                        MutationState mutationState = new MutationState(0, 0L, this.connection);
                        return mutationState;
                    }
                }
                MutationState mutationState = this.buildIndex(index, dataTableRef);
                return mutationState;
            }
            MutationState mutationState = new MutationState(1, 1000L, this.connection);
            return mutationState;
        }
        finally {
            this.connection.setAutoCommit(wasAutoCommit);
        }
    }

    private void addTableToCache(MetaDataProtocol.MetaDataMutationResult result, boolean alwaysHitServerForAncestors) throws SQLException {
        this.addTableToCache(result, alwaysHitServerForAncestors, TransactionUtil.getResolvedTime(this.connection, result));
    }

    private void addTableToCache(MetaDataProtocol.MetaDataMutationResult result, boolean alwaysHitServerForAncestors, long timestamp) throws SQLException {
        this.addColumnsIndexesAndLastDDLTimestampsFromAncestors(result, null, false, alwaysHitServerForAncestors);
        this.updateIndexesWithAncestorMap(result);
        this.connection.addTable(result.getTable(), timestamp);
    }

    private void addFunctionToCache(MetaDataProtocol.MetaDataMutationResult result) throws SQLException {
        for (PFunction function : result.getFunctions()) {
            this.connection.addFunction(function);
        }
    }

    private void addSchemaToCache(MetaDataProtocol.MetaDataMutationResult result) throws SQLException {
        this.connection.addSchema(result.getSchema());
    }

    private void throwIfLastPKOfParentIsVariableLength(PTable parent, String viewSchemaName, String viewName, ColumnDef col) throws SQLException {
        if (this.isLastPKVariableLength(parent)) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_MODIFY_VIEW_PK).setSchemaName(viewSchemaName).setTableName(viewName).setColumnName(col.getColumnDefName().getColumnName()).build().buildException();
        }
    }

    private boolean isLastPKVariableLength(PTable table) {
        List<PColumn> pkColumns = table.getPKColumns();
        return !pkColumns.get(pkColumns.size() - 1).getDataType().isFixedWidth();
    }

    private PTable getParentOfView(PTable view) throws SQLException {
        return this.connection.getTable(new PTableKey(view.getTenantId(), view.getParentName().getString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutationState createSchema(CreateSchemaStatement create) throws SQLException {
        boolean wasAutoCommit = this.connection.getAutoCommit();
        this.connection.rollback();
        try {
            List schemaMutations;
            if (!SchemaUtil.isNamespaceMappingEnabled(null, this.connection.getQueryServices().getProps())) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.CREATE_SCHEMA_NOT_ALLOWED).setSchemaName(create.getSchemaName()).build().buildException();
            }
            boolean isIfNotExists = create.isIfNotExists();
            PSchema schema = new PSchema(create.getSchemaName());
            this.validateSchema(schema.getSchemaName());
            this.connection.setAutoCommit(false);
            try (PreparedStatement schemaUpsert = this.connection.prepareStatement(CREATE_SCHEMA);){
                schemaUpsert.setString(1, schema.getSchemaName());
                schemaUpsert.setString(2, EMPTY_TABLE);
                schemaUpsert.execute();
                schemaMutations = (List)this.connection.getMutationState().toMutations(null).next().getSecond();
                this.connection.rollback();
            }
            MetaDataProtocol.MetaDataMutationResult result = this.connection.getQueryServices().createSchema(schemaMutations, schema.getSchemaName());
            MetaDataProtocol.MutationCode code = result.getMutationCode();
            try {
                switch (code) {
                    case SCHEMA_ALREADY_EXISTS: {
                        if (result.getSchema() != null) {
                            this.addSchemaToCache(result);
                        }
                        if (!isIfNotExists) {
                            throw new SchemaAlreadyExistsException(schema.getSchemaName());
                        }
                        break;
                    }
                    case NEWER_SCHEMA_FOUND: {
                        throw new NewerSchemaAlreadyExistsException(schema.getSchemaName());
                    }
                    default: {
                        result = new MetaDataProtocol.MetaDataMutationResult(code, schema, result.getMutationTime());
                        this.addSchemaToCache(result);
                        break;
                    }
                }
            }
            catch (Throwable e) {
                TableMetricsManager.updateMetricsForSystemCatalogTableMethod(null, MetricType.NUM_METADATA_LOOKUP_FAILURES, 1L);
                throw e;
            }
        }
        finally {
            this.connection.setAutoCommit(wasAutoCommit);
        }
        return new MutationState(0, 0L, this.connection);
    }

    private void validateSchema(String schemaName) throws SQLException {
        if (SchemaUtil.NOT_ALLOWED_SCHEMA_LIST.contains(schemaName)) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.SCHEMA_NOT_ALLOWED).setSchemaName(schemaName).build().buildException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutationState dropSchema(DropSchemaStatement executableDropSchemaStatement) throws SQLException {
        this.connection.rollback();
        boolean wasAutoCommit = this.connection.getAutoCommit();
        try {
            PSchema schema = new PSchema(executableDropSchemaStatement.getSchemaName());
            String schemaName = schema.getSchemaName();
            boolean ifExists = executableDropSchemaStatement.ifExists();
            byte[] key = SchemaUtil.getSchemaKey(schemaName);
            Long scn = this.connection.getSCN();
            long clientTimeStamp = scn == null ? Long.MAX_VALUE : scn;
            ArrayList schemaMetaData = Lists.newArrayListWithExpectedSize((int)2);
            Delete schemaDelete = new Delete(key, clientTimeStamp);
            schemaMetaData.add(schemaDelete);
            MetaDataProtocol.MetaDataMutationResult result = this.connection.getQueryServices().dropSchema(schemaMetaData, schemaName);
            MetaDataProtocol.MutationCode code = result.getMutationCode();
            schema = result.getSchema();
            try {
                switch (code) {
                    case SCHEMA_NOT_FOUND: {
                        if (!ifExists) {
                            throw new SchemaNotFoundException(schemaName);
                        }
                        break;
                    }
                    case NEWER_SCHEMA_FOUND: {
                        throw new NewerSchemaAlreadyExistsException(schemaName);
                    }
                    case TABLES_EXIST_ON_SCHEMA: {
                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_MUTATE_SCHEMA).setSchemaName(schemaName).build().buildException();
                    }
                    default: {
                        this.connection.removeSchema(schema, result.getMutationTime());
                        break;
                    }
                }
            }
            catch (Throwable e) {
                TableMetricsManager.updateMetricsForSystemCatalogTableMethod(null, MetricType.NUM_METADATA_LOOKUP_FAILURES, 1L);
                throw e;
            }
            MutationState mutationState = new MutationState(0, 0L, this.connection);
            return mutationState;
        }
        finally {
            this.connection.setAutoCommit(wasAutoCommit);
        }
    }

    public MutationState useSchema(UseSchemaStatement useSchemaStatement) throws SQLException {
        if (useSchemaStatement.getSchemaName().equals("")) {
            this.connection.setSchema(null);
        } else {
            FromCompiler.getResolverForSchema(useSchemaStatement, this.connection).resolveSchema(useSchemaStatement.getSchemaName());
            this.connection.setSchema(useSchemaStatement.getSchemaName());
        }
        return new MutationState(0, 0L, this.connection);
    }

    private MetaProperties loadStmtProperties(ListMultimap<String, Pair<String, Object>> stmtProperties, Map<String, List<Pair<String, Object>>> properties, PTable table, boolean removeTableProps) throws SQLException {
        MetaProperties metaProperties = new MetaProperties();
        for (String family : stmtProperties.keySet()) {
            List origPropsList = stmtProperties.get((Object)family);
            ArrayList propsList = Lists.newArrayListWithExpectedSize((int)origPropsList.size());
            for (Pair prop : origPropsList) {
                String propName = (String)prop.getFirst();
                if (TableProperty.isPhoenixTableProperty(propName)) {
                    TableProperty tableProp = TableProperty.valueOf(propName);
                    tableProp.validate(true, !family.equals(""), table.getType());
                    Object value = tableProp.getValue(prop.getSecond());
                    if (propName.equals("IMMUTABLE_ROWS")) {
                        metaProperties.setImmutableRowsProp((Boolean)value);
                    } else if (propName.equals("MULTI_TENANT")) {
                        metaProperties.setMultiTenantProp((Boolean)value);
                    } else if (propName.equals("DISABLE_WAL")) {
                        metaProperties.setDisableWALProp((Boolean)value);
                    } else if (propName.equals("STORE_NULLS")) {
                        metaProperties.setStoreNullsProp((Boolean)value);
                    } else if (propName.equals("TRANSACTIONAL")) {
                        metaProperties.setIsTransactionalProp((Boolean)value);
                    } else if (propName.equals("TRANSACTION_PROVIDER")) {
                        metaProperties.setTransactionProviderProp((TransactionFactory.Provider)((Object)value));
                    } else if (propName.equals("UPDATE_CACHE_FREQUENCY")) {
                        metaProperties.setUpdateCacheFrequencyProp((Long)value);
                    } else if (propName.equals("PHYSICAL_TABLE_NAME")) {
                        metaProperties.setPhysicalTableNameProp((String)value);
                    } else if (propName.equals("GUIDE_POSTS_WIDTH")) {
                        metaProperties.setGuidePostWidth((Long)value);
                    } else if (propName.equals("APPEND_ONLY_SCHEMA")) {
                        metaProperties.setAppendOnlySchemaProp((Boolean)value);
                    } else if (propName.equalsIgnoreCase("IMMUTABLE_STORAGE_SCHEME")) {
                        metaProperties.setImmutableStorageSchemeProp((PTable.ImmutableStorageScheme)value);
                    } else if (propName.equalsIgnoreCase("COLUMN_ENCODED_BYTES")) {
                        metaProperties.setColumnEncodedBytesProp(PTable.QualifierEncodingScheme.fromSerializedValue((Byte)value));
                    } else if (propName.equalsIgnoreCase("USE_STATS_FOR_PARALLELIZATION")) {
                        metaProperties.setUseStatsForParallelizationProp((Boolean)value);
                    } else if (propName.equalsIgnoreCase("TTL")) {
                        metaProperties.setTTL((TTLExpression)value);
                    } else if (propName.equalsIgnoreCase("CHANGE_DETECTION_ENABLED")) {
                        metaProperties.setChangeDetectionEnabled((Boolean)value);
                    } else if (propName.equalsIgnoreCase("PHYSICAL_TABLE_NAME")) {
                        metaProperties.setPhysicalTableName((String)value);
                    } else if (propName.equalsIgnoreCase("SCHEMA_VERSION")) {
                        metaProperties.setSchemaVersion((String)value);
                    } else if (propName.equalsIgnoreCase("STREAMING_TOPIC_NAME")) {
                        metaProperties.setStreamingTopicName((String)value);
                    } else if (propName.equalsIgnoreCase("IS_STRICT_TTL")) {
                        metaProperties.setStrictTTL((Boolean)value);
                    }
                }
                if (removeTableProps && (TableProperty.isPhoenixTableProperty(propName) || MetaDataUtil.isHTableProperty(propName))) continue;
                propsList.add(prop);
            }
            properties.put(family, propsList);
        }
        return metaProperties;
    }

    private boolean evaluateStmtProperties(MetaProperties metaProperties, MetaPropertiesEvaluated metaPropertiesEvaluated, PTable table, String schemaName, String tableName, MutableBoolean areWeIntroducingTTLAtThisLevel) throws SQLException {
        boolean changingPhoenixTableProperty = false;
        if (metaProperties.getImmutableRowsProp() != null && metaProperties.getImmutableRowsProp().booleanValue() != table.isImmutableRows()) {
            if (table.getImmutableStorageScheme() != PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_ALTER_IMMUTABLE_ROWS_PROPERTY).setSchemaName(schemaName).setTableName(tableName).build().buildException();
            }
            metaPropertiesEvaluated.setIsImmutableRows(metaProperties.getImmutableRowsProp());
            changingPhoenixTableProperty = true;
        }
        if (metaProperties.getImmutableRowsProp() != null && table.getType() != PTableType.INDEX && metaProperties.getImmutableRowsProp().booleanValue() != table.isImmutableRows()) {
            metaPropertiesEvaluated.setIsImmutableRows(metaProperties.getImmutableRowsProp());
            changingPhoenixTableProperty = true;
        }
        if (metaProperties.getMultiTenantProp() != null && metaProperties.getMultiTenantProp().booleanValue() != table.isMultiTenant()) {
            metaPropertiesEvaluated.setMultiTenant(metaProperties.getMultiTenantProp());
            changingPhoenixTableProperty = true;
        }
        if (metaProperties.getDisableWALProp() != null && metaProperties.getDisableWALProp().booleanValue() != table.isWALDisabled()) {
            metaPropertiesEvaluated.setDisableWAL(metaProperties.getDisableWALProp());
            changingPhoenixTableProperty = true;
        }
        if (metaProperties.getUpdateCacheFrequencyProp() != null) {
            if (table.getType() == PTableType.INDEX) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_SET_OR_ALTER_UPDATE_CACHE_FREQ_FOR_INDEX).build().buildException();
            }
            if (metaProperties.getUpdateCacheFrequencyProp().longValue() != table.getUpdateCacheFrequency()) {
                metaPropertiesEvaluated.setUpdateCacheFrequency(metaProperties.getUpdateCacheFrequencyProp());
                changingPhoenixTableProperty = true;
            }
        }
        if (metaProperties.getAppendOnlySchemaProp() != null && metaProperties.getAppendOnlySchemaProp().booleanValue() != table.isAppendOnlySchema()) {
            metaPropertiesEvaluated.setAppendOnlySchema(metaProperties.getAppendOnlySchemaProp());
            changingPhoenixTableProperty = true;
        }
        if (metaProperties.getColumnEncodedBytesProp() != null && metaProperties.getColumnEncodedBytesProp() != table.getEncodingScheme()) {
            changingPhoenixTableProperty = true;
        }
        if (metaProperties.getImmutableStorageSchemeProp() != null && metaProperties.getImmutableStorageSchemeProp() != table.getImmutableStorageScheme()) {
            changingPhoenixTableProperty = true;
        }
        PTable.ImmutableStorageScheme immutableStorageScheme = table.getImmutableStorageScheme();
        if (metaProperties.getImmutableStorageSchemeProp() != null) {
            immutableStorageScheme = metaProperties.getImmutableStorageSchemeProp();
        }
        PTable.QualifierEncodingScheme encodingScheme = table.getEncodingScheme();
        if (metaProperties.getColumnEncodedBytesProp() != null) {
            encodingScheme = metaProperties.getColumnEncodedBytesProp();
        }
        if (immutableStorageScheme == PTable.ImmutableStorageScheme.SINGLE_CELL_ARRAY_WITH_OFFSETS && encodingScheme == PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.INVALID_IMMUTABLE_STORAGE_SCHEME_AND_COLUMN_QUALIFIER_BYTES).setSchemaName(schemaName).setTableName(tableName).build().buildException();
        }
        if (metaProperties.getGuidePostWidth() == null || metaProperties.getGuidePostWidth() >= 0L) {
            metaPropertiesEvaluated.setGuidePostWidth(metaProperties.getGuidePostWidth());
            changingPhoenixTableProperty = true;
        }
        if (metaProperties.getStoreNullsProp() != null && metaProperties.getStoreNullsProp().booleanValue() != table.getStoreNulls()) {
            metaPropertiesEvaluated.setStoreNulls(metaProperties.getStoreNullsProp());
            changingPhoenixTableProperty = true;
        }
        if (metaProperties.getUseStatsForParallelizationProp() != null && (table.useStatsForParallelization() == null || metaProperties.getUseStatsForParallelizationProp().booleanValue() != table.useStatsForParallelization().booleanValue())) {
            metaPropertiesEvaluated.setUseStatsForParallelization(metaProperties.getUseStatsForParallelizationProp());
            changingPhoenixTableProperty = true;
        }
        if (metaProperties.getIsTransactionalProp() != null && metaProperties.getIsTransactionalProp().booleanValue() != table.isTransactional()) {
            metaPropertiesEvaluated.setIsTransactional(metaProperties.getIsTransactionalProp());
            if (!metaPropertiesEvaluated.getIsTransactional().booleanValue()) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.TX_MAY_NOT_SWITCH_TO_NON_TX).setSchemaName(schemaName).setTableName(tableName).build().buildException();
            }
            boolean transactionsEnabled = this.connection.getQueryServices().getProps().getBoolean("phoenix.transactions.enabled", false);
            if (!transactionsEnabled) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_ALTER_TO_BE_TXN_IF_TXNS_DISABLED).setSchemaName(schemaName).setTableName(tableName).build().buildException();
            }
            if (SchemaUtil.hasRowTimestampColumn(table)) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_ALTER_TO_BE_TXN_WITH_ROW_TIMESTAMP).setSchemaName(schemaName).setTableName(tableName).build().buildException();
            }
            TransactionFactory.Provider provider = metaProperties.getTransactionProviderProp();
            if (provider == null) {
                provider = (TransactionFactory.Provider)((Object)TableProperty.TRANSACTION_PROVIDER.getValue(this.connection.getQueryServices().getProps().get("phoenix.table.transaction.provider.default", QueryServicesOptions.DEFAULT_TRANSACTION_PROVIDER)));
            }
            metaPropertiesEvaluated.setTransactionProvider(provider);
            if (provider.getTransactionProvider().isUnsupported(PhoenixTransactionProvider.Feature.ALTER_NONTX_TO_TX)) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_ALTER_TABLE_FROM_NON_TXN_TO_TXNL).setMessage(provider.name() + ". ").setSchemaName(schemaName).setTableName(tableName).build().buildException();
            }
            changingPhoenixTableProperty = true;
            metaProperties.setNonTxToTx(true);
        }
        if (metaProperties.getTTL() != null) {
            if (table.getType() == PTableType.INDEX) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_SET_OR_ALTER_PROPERTY_FOR_INDEX).build().buildException();
            }
            if (!this.isViewTTLEnabled() && table.getType() == PTableType.VIEW) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.VIEW_TTL_NOT_ENABLED).build().buildException();
            }
            if (!MetaDataUtil.isTTLSupported(table.getType(), table.getViewType(), table.getName().toString())) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.TTL_SUPPORTED_FOR_TABLES_AND_VIEWS_ONLY).build().buildException();
            }
            if (metaProperties.getTTL() != table.getTTLExpression()) {
                TTLExpression newTTL = metaProperties.getTTL();
                newTTL.validateTTLOnAlter(this.connection, table);
                metaPropertiesEvaluated.setTTL(MetaDataUtil.getCompatibleTTLExpression(metaProperties.getTTL(), table.getType(), table.getViewType(), table.getName().toString()));
                changingPhoenixTableProperty = true;
            }
            areWeIntroducingTTLAtThisLevel.setTrue();
        }
        if (metaProperties.isChangeDetectionEnabled() != null) {
            this.verifyChangeDetectionTableType(table.getType(), metaProperties.isChangeDetectionEnabled());
            if (!metaProperties.isChangeDetectionEnabled().equals(table.isChangeDetectionEnabled())) {
                metaPropertiesEvaluated.setChangeDetectionEnabled(metaProperties.isChangeDetectionEnabled());
                changingPhoenixTableProperty = true;
            }
        }
        if (!Strings.isNullOrEmpty((String)metaProperties.getPhysicalTableNameProp()) && !metaProperties.getPhysicalTableNameProp().equals(table.getPhysicalName(true))) {
            metaPropertiesEvaluated.setPhysicalTableName(metaProperties.getPhysicalTableNameProp());
            changingPhoenixTableProperty = true;
        }
        if (!Strings.isNullOrEmpty((String)metaProperties.getSchemaVersion()) && !metaProperties.getSchemaVersion().equals(table.getSchemaVersion())) {
            metaPropertiesEvaluated.setSchemaVersion(metaProperties.getSchemaVersion());
            changingPhoenixTableProperty = true;
        }
        if (!Strings.isNullOrEmpty((String)metaProperties.getStreamingTopicName()) && !metaProperties.getStreamingTopicName().equals(table.getStreamingTopicName())) {
            metaPropertiesEvaluated.setStreamingTopicName(metaProperties.getStreamingTopicName());
            changingPhoenixTableProperty = true;
        }
        if (metaProperties.isStrictTTL() != null && !metaProperties.isStrictTTL().equals(table.isStrictTTL())) {
            metaPropertiesEvaluated.setStrictTTL(metaProperties.isStrictTTL());
            changingPhoenixTableProperty = true;
        }
        return changingPhoenixTableProperty;
    }

    public MutationState changePermissions(ChangePermsStatement changePermsStatement) throws SQLException {
        LOGGER.info(changePermsStatement.toString());
        try (Admin admin = this.connection.getQueryServices().getAdmin();){
            Connection hConnection = admin.getConnection();
            if (changePermsStatement.getSchemaName() != null) {
                if (!changePermsStatement.getSchemaName().equals("default")) {
                    FromCompiler.getResolverForSchema(changePermsStatement.getSchemaName(), this.connection);
                }
                this.changePermsOnSchema(hConnection, changePermsStatement);
            } else if (changePermsStatement.getTableName() != null) {
                PTable inputTable = this.connection.getTable(SchemaUtil.normalizeFullTableName(changePermsStatement.getTableName().toString()));
                if (!PTableType.TABLE.equals((Object)inputTable.getType()) && !PTableType.SYSTEM.equals((Object)inputTable.getType())) {
                    throw new AccessDeniedException("Cannot GRANT or REVOKE permissions on INDEX TABLES or VIEWS");
                }
                this.changePermsOnTables(hConnection, admin, changePermsStatement, inputTable);
            } else {
                this.changePermsOnUser(hConnection, changePermsStatement);
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Throwable throwable) {
            throw ClientUtil.parseServerException(throwable);
        }
        return new MutationState(0, 0L, this.connection);
    }

    private void changePermsOnSchema(Connection hConnection, ChangePermsStatement changePermsStatement) throws Throwable {
        if (changePermsStatement.isGrantStatement()) {
            AccessControlClient.grant((Connection)hConnection, (String)changePermsStatement.getSchemaName(), (String)changePermsStatement.getName(), (Permission.Action[])changePermsStatement.getPermsList());
        } else {
            AccessControlClient.revoke((Connection)hConnection, (String)changePermsStatement.getSchemaName(), (String)changePermsStatement.getName(), (Permission.Action[])Permission.Action.values());
        }
    }

    private void changePermsOnTables(Connection hConnection, Admin admin, ChangePermsStatement changePermsStatement, PTable inputTable) throws Throwable {
        TableName tableName = SchemaUtil.getPhysicalTableName(inputTable.getPhysicalName().getBytes(), inputTable.isNamespaceMapped());
        this.changePermsOnTable(hConnection, changePermsStatement, tableName);
        boolean schemaInconsistency = false;
        ArrayList<PTable> inconsistentTables = null;
        for (PTable indexTable : inputTable.getIndexes()) {
            if (indexTable.getIndexType().equals((Object)PTable.IndexType.LOCAL)) continue;
            if (inputTable.isNamespaceMapped() != indexTable.isNamespaceMapped()) {
                schemaInconsistency = true;
                if (inconsistentTables == null) {
                    inconsistentTables = new ArrayList<PTable>();
                }
                inconsistentTables.add(indexTable);
                continue;
            }
            LOGGER.info("Updating permissions for Index Table: " + indexTable.getName() + " Base Table: " + inputTable.getName());
            tableName = SchemaUtil.getPhysicalTableName(indexTable.getPhysicalName().getBytes(), indexTable.isNamespaceMapped());
            this.changePermsOnTable(hConnection, changePermsStatement, tableName);
        }
        if (schemaInconsistency) {
            for (PTable table : inconsistentTables) {
                LOGGER.error("Fail to propagate permissions to Index Table: " + table.getName());
            }
            throw new TablesNotInSyncException(inputTable.getTableName().getString(), ((PTable)inconsistentTables.get(0)).getTableName().getString(), "Namespace properties");
        }
        byte[] viewIndexTableBytes = MetaDataUtil.getViewIndexPhysicalName(inputTable.getPhysicalName().getBytes());
        tableName = TableName.valueOf((byte[])viewIndexTableBytes);
        boolean viewIndexTableExists = admin.tableExists(tableName);
        if (viewIndexTableExists) {
            LOGGER.info("Updating permissions for View Index Table: " + Bytes.toString((byte[])viewIndexTableBytes) + " Base Table: " + inputTable.getName());
            this.changePermsOnTable(hConnection, changePermsStatement, tableName);
        } else if (inputTable.isMultiTenant()) {
            LOGGER.error("View Index Table not found for MultiTenant Table: " + inputTable.getName());
            LOGGER.error("Fail to propagate permissions to view Index Table: " + tableName.getNameAsString());
            throw new TablesNotInSyncException(inputTable.getTableName().getString(), Bytes.toString((byte[])viewIndexTableBytes), " View Index table should exist for MultiTenant tables");
        }
    }

    private void changePermsOnTable(Connection hConnection, ChangePermsStatement changePermsStatement, TableName tableName) throws Throwable {
        if (changePermsStatement.isGrantStatement()) {
            AccessControlClient.grant((Connection)hConnection, (TableName)tableName, (String)changePermsStatement.getName(), null, null, (Permission.Action[])changePermsStatement.getPermsList());
        } else {
            AccessControlClient.revoke((Connection)hConnection, (TableName)tableName, (String)changePermsStatement.getName(), null, null, (Permission.Action[])Permission.Action.values());
        }
    }

    private void changePermsOnUser(Connection hConnection, ChangePermsStatement changePermsStatement) throws Throwable {
        if (changePermsStatement.isGrantStatement()) {
            AccessControlClient.grant((Connection)hConnection, (String)changePermsStatement.getName(), (Permission.Action[])changePermsStatement.getPermsList());
        } else {
            AccessControlClient.revoke((Connection)hConnection, (String)changePermsStatement.getName(), (Permission.Action[])Permission.Action.values());
        }
    }

    private static class MetaPropertiesEvaluated {
        private Boolean isImmutableRows;
        private Boolean multiTenant = null;
        private Boolean disableWAL = null;
        private Long updateCacheFrequency = null;
        private Boolean appendOnlySchema = null;
        private Long guidePostWidth = -1L;
        private PTable.ImmutableStorageScheme immutableStorageScheme = null;
        private PTable.QualifierEncodingScheme columnEncodedBytes = null;
        private Boolean storeNulls = null;
        private Boolean useStatsForParallelization = null;
        private Boolean isTransactional = null;
        private TransactionFactory.Provider transactionProvider = null;
        private TTLExpression ttl = null;
        private Boolean isChangeDetectionEnabled = null;
        private Boolean isStrictTTL = null;
        private String physicalTableName = null;
        private String schemaVersion = null;
        private String streamingTopicName = null;

        private MetaPropertiesEvaluated() {
        }

        public Boolean getIsImmutableRows() {
            return this.isImmutableRows;
        }

        public void setIsImmutableRows(Boolean isImmutableRows) {
            this.isImmutableRows = isImmutableRows;
        }

        public Boolean getMultiTenant() {
            return this.multiTenant;
        }

        public void setMultiTenant(Boolean multiTenant) {
            this.multiTenant = multiTenant;
        }

        public Boolean getDisableWAL() {
            return this.disableWAL;
        }

        public void setDisableWAL(Boolean disableWAL) {
            this.disableWAL = disableWAL;
        }

        public Long getUpdateCacheFrequency() {
            return this.updateCacheFrequency;
        }

        public void setUpdateCacheFrequency(Long updateCacheFrequency) {
            this.updateCacheFrequency = updateCacheFrequency;
        }

        public Boolean getAppendOnlySchema() {
            return this.appendOnlySchema;
        }

        public void setAppendOnlySchema(Boolean appendOnlySchema) {
            this.appendOnlySchema = appendOnlySchema;
        }

        public Long getGuidePostWidth() {
            return this.guidePostWidth;
        }

        public void setGuidePostWidth(Long guidePostWidth) {
            this.guidePostWidth = guidePostWidth;
        }

        public PTable.ImmutableStorageScheme getImmutableStorageScheme() {
            return this.immutableStorageScheme;
        }

        public void setImmutableStorageScheme(PTable.ImmutableStorageScheme immutableStorageScheme) {
            this.immutableStorageScheme = immutableStorageScheme;
        }

        public PTable.QualifierEncodingScheme getColumnEncodedBytes() {
            return this.columnEncodedBytes;
        }

        public void setColumnEncodedBytes(PTable.QualifierEncodingScheme columnEncodedBytes) {
            this.columnEncodedBytes = columnEncodedBytes;
        }

        public Boolean getStoreNulls() {
            return this.storeNulls;
        }

        public void setStoreNulls(Boolean storeNulls) {
            this.storeNulls = storeNulls;
        }

        public Boolean getUseStatsForParallelization() {
            return this.useStatsForParallelization;
        }

        public void setUseStatsForParallelization(Boolean useStatsForParallelization) {
            this.useStatsForParallelization = useStatsForParallelization;
        }

        public Boolean getIsTransactional() {
            return this.isTransactional;
        }

        public void setIsTransactional(Boolean isTransactional) {
            this.isTransactional = isTransactional;
        }

        public TransactionFactory.Provider getTransactionProvider() {
            return this.transactionProvider;
        }

        public void setTransactionProvider(TransactionFactory.Provider transactionProvider) {
            this.transactionProvider = transactionProvider;
        }

        public TTLExpression getTTL() {
            return this.ttl;
        }

        public void setTTL(TTLExpression ttl) {
            this.ttl = ttl;
        }

        public Boolean isChangeDetectionEnabled() {
            return this.isChangeDetectionEnabled;
        }

        public void setChangeDetectionEnabled(Boolean isChangeDetectionEnabled) {
            this.isChangeDetectionEnabled = isChangeDetectionEnabled;
        }

        public String getPhysicalTableName() {
            return this.physicalTableName;
        }

        public void setPhysicalTableName(String physicalTableName) {
            this.physicalTableName = physicalTableName;
        }

        public String getSchemaVersion() {
            return this.schemaVersion;
        }

        public void setSchemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
        }

        public String getStreamingTopicName() {
            return this.streamingTopicName;
        }

        public void setStreamingTopicName(String streamingTopicName) {
            this.streamingTopicName = streamingTopicName;
        }

        public Boolean isStrictTTL() {
            return this.isStrictTTL;
        }

        public void setStrictTTL(Boolean isStrictTTL) {
            this.isStrictTTL = isStrictTTL;
        }
    }

    public static class MetaProperties {
        private Boolean isImmutableRowsProp = null;
        private Boolean multiTenantProp = null;
        private Boolean disableWALProp = null;
        private Boolean storeNullsProp = null;
        private TransactionFactory.Provider transactionProviderProp = null;
        private Boolean isTransactionalProp = null;
        private Long updateCacheFrequencyProp = null;
        private String physicalTableNameProp = null;
        private PTable.QualifierEncodingScheme columnEncodedBytesProp = null;
        private Boolean appendOnlySchemaProp = null;
        private Long guidePostWidth = -1L;
        private PTable.ImmutableStorageScheme immutableStorageSchemeProp = null;
        private Boolean useStatsForParallelizationProp = null;
        private boolean nonTxToTx = false;
        private TTLExpression ttl = null;
        private Boolean isChangeDetectionEnabled = null;
        private Boolean isStrictTTL = null;
        private String physicalTableName = null;
        private String schemaVersion = null;
        private String streamingTopicName = null;

        public Boolean getImmutableRowsProp() {
            return this.isImmutableRowsProp;
        }

        public void setImmutableRowsProp(Boolean isImmutableRowsProp) {
            this.isImmutableRowsProp = isImmutableRowsProp;
        }

        public Boolean getMultiTenantProp() {
            return this.multiTenantProp;
        }

        public void setMultiTenantProp(Boolean multiTenantProp) {
            this.multiTenantProp = multiTenantProp;
        }

        public Boolean getDisableWALProp() {
            return this.disableWALProp;
        }

        public void setDisableWALProp(Boolean disableWALProp) {
            this.disableWALProp = disableWALProp;
        }

        public Boolean getStoreNullsProp() {
            return this.storeNullsProp;
        }

        public void setStoreNullsProp(Boolean storeNullsProp) {
            this.storeNullsProp = storeNullsProp;
        }

        public TransactionFactory.Provider getTransactionProviderProp() {
            return this.transactionProviderProp;
        }

        public void setTransactionProviderProp(TransactionFactory.Provider transactionProviderProp) {
            this.transactionProviderProp = transactionProviderProp;
        }

        public Boolean getIsTransactionalProp() {
            return this.isTransactionalProp;
        }

        public void setIsTransactionalProp(Boolean isTransactionalProp) {
            this.isTransactionalProp = isTransactionalProp;
        }

        public void setPhysicalTableNameProp(String physicalTableNameProp) {
            this.physicalTableNameProp = physicalTableNameProp;
        }

        public String getPhysicalTableNameProp() {
            return this.physicalTableNameProp;
        }

        public Long getUpdateCacheFrequencyProp() {
            return this.updateCacheFrequencyProp;
        }

        public void setUpdateCacheFrequencyProp(Long updateCacheFrequencyProp) {
            this.updateCacheFrequencyProp = updateCacheFrequencyProp;
        }

        public Boolean getAppendOnlySchemaProp() {
            return this.appendOnlySchemaProp;
        }

        public void setAppendOnlySchemaProp(Boolean appendOnlySchemaProp) {
            this.appendOnlySchemaProp = appendOnlySchemaProp;
        }

        public Long getGuidePostWidth() {
            return this.guidePostWidth;
        }

        public void setGuidePostWidth(Long guidePostWidth) {
            this.guidePostWidth = guidePostWidth;
        }

        public PTable.ImmutableStorageScheme getImmutableStorageSchemeProp() {
            return this.immutableStorageSchemeProp;
        }

        public void setImmutableStorageSchemeProp(PTable.ImmutableStorageScheme immutableStorageSchemeProp) {
            this.immutableStorageSchemeProp = immutableStorageSchemeProp;
        }

        public PTable.QualifierEncodingScheme getColumnEncodedBytesProp() {
            return this.columnEncodedBytesProp;
        }

        public void setColumnEncodedBytesProp(PTable.QualifierEncodingScheme columnEncodedBytesProp) {
            this.columnEncodedBytesProp = columnEncodedBytesProp;
        }

        public Boolean getUseStatsForParallelizationProp() {
            return this.useStatsForParallelizationProp;
        }

        public void setUseStatsForParallelizationProp(Boolean useStatsForParallelizationProp) {
            this.useStatsForParallelizationProp = useStatsForParallelizationProp;
        }

        public boolean getNonTxToTx() {
            return this.nonTxToTx;
        }

        public void setNonTxToTx(boolean nonTxToTx) {
            this.nonTxToTx = nonTxToTx;
        }

        public TTLExpression getTTL() {
            return this.ttl;
        }

        public void setTTL(TTLExpression ttl) {
            this.ttl = ttl;
        }

        public Boolean isChangeDetectionEnabled() {
            return this.isChangeDetectionEnabled;
        }

        public void setChangeDetectionEnabled(Boolean isChangeDetectionEnabled) {
            this.isChangeDetectionEnabled = isChangeDetectionEnabled;
        }

        public String getPhysicalTableName() {
            return this.physicalTableName;
        }

        public void setPhysicalTableName(String physicalTableName) {
            this.physicalTableName = physicalTableName;
        }

        public String getSchemaVersion() {
            return this.schemaVersion;
        }

        public void setSchemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
        }

        public String getStreamingTopicName() {
            return this.streamingTopicName;
        }

        public void setStreamingTopicName(String streamingTopicName) {
            this.streamingTopicName = streamingTopicName;
        }

        public Boolean isStrictTTL() {
            return this.isStrictTTL;
        }

        public void setStrictTTL(Boolean isStrictTTL) {
            this.isStrictTTL = isStrictTTL;
        }
    }
}

