/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.query;

import java.io.IOException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.TableState;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.regionserver.NoSuchColumnFamilyException;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.hbase.zookeeper.ZNodePaths;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminUtilWithFallback {
    private static final Logger LOG = LoggerFactory.getLogger(AdminUtilWithFallback.class);

    public static boolean tableExists(Admin admin, TableName tableName) throws IOException, InterruptedException {
        try {
            return admin.tableExists(tableName);
        }
        catch (IOException e) {
            if (e instanceof NoSuchColumnFamilyException || e.getCause() != null && e.getCause() instanceof NoSuchColumnFamilyException) {
                LOG.warn("Admin API to retrieve table existence failed due to missing CF in meta. This should happen only when HBase master is running on 1.x and current regionserver is on 2.x. Falling back to retrieve info from ZK.", (Throwable)e);
                return AdminUtilWithFallback.getTableStateFromZk(tableName, admin) != null;
            }
            throw e;
        }
    }

    private static ZooKeeperProtos.DeprecatedTableState.State getTableState(ZKWatcher zkw, TableName tableName) throws KeeperException, InterruptedException {
        String znode = ZNodePaths.joinZNode((String)zkw.getZNodePaths().tableZNode, (String)tableName.getNameAsString());
        byte[] data = ZKUtil.getData((ZKWatcher)zkw, (String)znode);
        if (data != null && data.length > 0) {
            try {
                ProtobufUtil.expectPBMagicPrefix((byte[])data);
                ZooKeeperProtos.DeprecatedTableState.Builder builder = ZooKeeperProtos.DeprecatedTableState.newBuilder();
                int magicLen = ProtobufUtil.lengthOfPBMagic();
                ProtobufUtil.mergeFrom((Message.Builder)builder, (byte[])data, (int)magicLen, (int)(data.length - magicLen));
                return builder.getState();
            }
            catch (IOException ioe) {
                KeeperException.DataInconsistencyException ke = new KeeperException.DataInconsistencyException();
                ke.initCause((Throwable)ioe);
                throw ke;
            }
            catch (DeserializationException de) {
                throw ZKUtil.convert((DeserializationException)de);
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static TableState.State getTableStateFromZk(TableName tableName, Admin admin) throws IOException, InterruptedException {
        try (ZKWatcher zkWatcher = new ZKWatcher(admin.getConfiguration(), "phoenix-admin-fallback", null);){
            TableState.State tableState;
            ZooKeeperProtos.DeprecatedTableState.State state = AdminUtilWithFallback.getTableState(zkWatcher, tableName);
            if (state == null) {
                TableState.State state2 = null;
                return state2;
            }
            switch (state) {
                case ENABLED: {
                    tableState = TableState.State.ENABLED;
                    break;
                }
                case DISABLED: {
                    tableState = TableState.State.DISABLED;
                    break;
                }
                case DISABLING: {
                    tableState = TableState.State.DISABLING;
                    break;
                }
                case ENABLING: {
                    tableState = TableState.State.ENABLING;
                    break;
                }
                default: {
                    throw new IOException("ZK state inconsistent");
                }
            }
            TableState.State state3 = tableState;
            return state3;
        }
        catch (KeeperException e) {
            throw new IOException(e);
        }
    }
}

