/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.parse;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.parse.ColumnName;
import org.apache.phoenix.parse.DMLStatement;
import org.apache.phoenix.parse.HintNode;
import org.apache.phoenix.parse.NamedTableNode;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.RowReturningDMLStatement;
import org.apache.phoenix.parse.SelectStatement;
import org.apache.phoenix.parse.UDFParseNode;

public class UpsertStatement
extends DMLStatement
implements RowReturningDMLStatement {
    private final List<ColumnName> columns;
    private final List<ParseNode> values;
    private final SelectStatement select;
    private final HintNode hint;
    private final List<Pair<ColumnName, ParseNode>> onDupKeyPairs;
    private final OnDuplicateKeyType onDupKeyType;
    private final boolean returningRow;

    public UpsertStatement(NamedTableNode table, HintNode hint, List<ColumnName> columns, List<ParseNode> values, SelectStatement select, int bindCount, Map<String, UDFParseNode> udfParseNodes, List<Pair<ColumnName, ParseNode>> onDupKeyPairs, OnDuplicateKeyType onDupKeyType, boolean returningRow) {
        super(table, bindCount, udfParseNodes);
        this.columns = columns == null ? Collections.emptyList() : columns;
        this.values = values;
        this.select = select;
        this.hint = hint == null ? HintNode.EMPTY_HINT_NODE : hint;
        this.onDupKeyPairs = onDupKeyPairs;
        this.onDupKeyType = onDupKeyType;
        this.returningRow = returningRow;
    }

    public List<ColumnName> getColumns() {
        return this.columns;
    }

    public List<ParseNode> getValues() {
        return this.values;
    }

    public SelectStatement getSelect() {
        return this.select;
    }

    public HintNode getHint() {
        return this.hint;
    }

    public List<Pair<ColumnName, ParseNode>> getOnDupKeyPairs() {
        return this.onDupKeyPairs;
    }

    public OnDuplicateKeyType getOnDupKeyType() {
        return this.onDupKeyType;
    }

    @Override
    public boolean isReturningRow() {
        return this.returningRow;
    }

    public static enum OnDuplicateKeyType {
        NONE,
        IGNORE,
        UPDATE,
        UPDATE_ONLY;

    }
}

