/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.parse;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.RowKeyColumnExpression;
import org.apache.phoenix.expression.function.FunctionExpression;
import org.apache.phoenix.expression.function.PartitionIdFunction;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.RowKeyValueAccessor;

public class PartitionIdParseNode
extends FunctionParseNode {
    PartitionIdParseNode(String name, List<ParseNode> children, FunctionParseNode.BuiltInFunctionInfo info) {
        super(name, children, info);
    }

    @Override
    public FunctionExpression create(List<Expression> children, StatementContext context) throws SQLException {
        if (children.size() != 0) {
            throw new IllegalArgumentException("PartitionIdFunction does not take any parameters");
        }
        PTable table = context.getCurrentTable().getTable();
        if (table.getViewIndexId() != null && table.isMultiTenant()) {
            return new PartitionIdFunction(PartitionIdParseNode.getExpressions(table, 2));
        }
        if (table.getViewIndexId() != null || table.isMultiTenant()) {
            return new PartitionIdFunction(PartitionIdParseNode.getExpressions(table, 1));
        }
        return new PartitionIdFunction(PartitionIdParseNode.getExpressions(table, 0));
    }

    private static List<Expression> getExpressions(PTable table, int position) {
        ArrayList<Expression> expressionList = new ArrayList<Expression>(1);
        expressionList.add(new RowKeyColumnExpression(table.getPKColumns().get(position), new RowKeyValueAccessor(table.getPKColumns(), position)));
        return expressionList;
    }
}

