/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.parse;

import org.apache.phoenix.compile.ColumnResolver;
import org.apache.phoenix.parse.LiteralParseNode;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.schema.types.PInteger;

public final class OrderByNode {
    private final ParseNode child;
    private final boolean nullsLast;
    private final boolean orderAscending;

    OrderByNode(ParseNode child, boolean nullsLast, boolean orderAscending) {
        this.child = child;
        this.nullsLast = nullsLast;
        this.orderAscending = orderAscending;
    }

    public boolean isNullsLast() {
        return this.nullsLast;
    }

    public boolean isAscending() {
        return this.orderAscending;
    }

    public ParseNode getNode() {
        return this.child;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.child == null ? 0 : this.child.hashCode());
        result = 31 * result + (this.nullsLast ? 1231 : 1237);
        result = 31 * result + (this.orderAscending ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OrderByNode other = (OrderByNode)obj;
        if (this.child == null ? other.child != null : !this.child.equals(other.child)) {
            return false;
        }
        if (this.nullsLast != other.nullsLast) {
            return false;
        }
        return this.orderAscending == other.orderAscending;
    }

    public String toString() {
        return this.child.toString() + (this.orderAscending ? " asc" : " desc") + " nulls " + (this.nullsLast ? "last" : "first");
    }

    public void toSQL(ColumnResolver resolver, StringBuilder buf) {
        this.child.toSQL(resolver, buf);
        if (!this.orderAscending) {
            buf.append(" DESC");
        }
        if (this.nullsLast) {
            buf.append(" NULLS LAST ");
        }
    }

    public boolean isIntegerLiteral() {
        return this.child instanceof LiteralParseNode && ((LiteralParseNode)this.child).getType() == PInteger.INSTANCE;
    }

    public Integer getValueIfIntegerLiteral() {
        if (!this.isIntegerLiteral()) {
            return null;
        }
        return (Integer)((LiteralParseNode)this.child).getValue();
    }
}

