/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.parse;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.phoenix.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.phoenix.util.SchemaUtil;

public class HintNode {
    public static final HintNode EMPTY_HINT_NODE = new HintNode();
    public static final char SEPARATOR = ' ';
    public static final String PREFIX = "(";
    public static final String SUFFIX = ")";
    private static final Pattern HINT_PATTERN = Pattern.compile("(?<hintWord>\\w+)\\s*(?:\\s*\\(\\s*(?<hintArgs>[^)]+)\\s*\\))?");
    private static final Pattern HINT_ARG_PATTERN = Pattern.compile("(?<hintArg>\"[^\"]+\"|\\S+)");
    private final Map<Hint, String> hints;

    public static HintNode create(HintNode hintNode, Hint hint) {
        return HintNode.create(hintNode, hint, "");
    }

    public static HintNode create(HintNode hintNode, Hint hint, String value) {
        HashMap<Hint, String> hints = new HashMap<Hint, String>(hintNode.hints);
        hints.put(hint, value);
        return new HintNode(hints);
    }

    public static HintNode combine(HintNode hintNode, HintNode override) {
        HashMap<Hint, String> hints = new HashMap<Hint, String>(hintNode.hints);
        hints.putAll(override.hints);
        return new HintNode(hints);
    }

    public static HintNode subtract(HintNode hintNode, Hint[] remove) {
        HashMap<Hint, String> hints = new HashMap<Hint, String>(hintNode.hints);
        for (Hint hint : remove) {
            hints.remove((Object)hint);
        }
        return new HintNode(hints);
    }

    private HintNode() {
        this.hints = new HashMap<Hint, String>();
    }

    private HintNode(Map<Hint, String> hints) {
        this.hints = ImmutableMap.copyOf(hints);
    }

    public HintNode(String hint) {
        HashMap<Hint, String> hints = new HashMap<Hint, String>();
        Matcher hintMatcher = HINT_PATTERN.matcher(hint);
        while (hintMatcher.find()) {
            try {
                Hint hintWord = Hint.valueOf(hintMatcher.group("hintWord").toUpperCase());
                String hintArgsStr = hintMatcher.group("hintArgs");
                ArrayList<String> hintArgs = new ArrayList<String>();
                if (hintArgsStr != null) {
                    Matcher hintArgMatcher = HINT_ARG_PATTERN.matcher(hintArgsStr);
                    while (hintArgMatcher.find()) {
                        hintArgs.add(SchemaUtil.normalizeIdentifier(hintArgMatcher.group()));
                    }
                }
                String string = hintArgsStr = (hintArgsStr = String.join((CharSequence)" ", hintArgs)).equals("") ? "" : PREFIX + hintArgsStr + SUFFIX;
                if (hints.containsKey((Object)hintWord)) {
                    hints.put(hintWord, (String)hints.get((Object)hintWord) + hintArgsStr);
                    continue;
                }
                hints.put(hintWord, hintArgsStr);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        this.hints = ImmutableMap.copyOf(hints);
    }

    public boolean isEmpty() {
        return this.hints.isEmpty();
    }

    public String getHint(Hint hint) {
        return this.hints.get((Object)hint);
    }

    public boolean hasHint(Hint hint) {
        return this.hints.containsKey((Object)hint);
    }

    public Set<Hint> getHints() {
        return this.hints.keySet();
    }

    public String toString() {
        if (this.hints.isEmpty()) {
            return "";
        }
        StringBuilder buf = new StringBuilder("/*+ ");
        for (Map.Entry<Hint, String> entry : this.hints.entrySet()) {
            buf.append((Object)entry.getKey());
            buf.append(entry.getValue());
            buf.append(' ');
        }
        buf.append("*/ ");
        return buf.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.hints == null ? 0 : this.hints.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HintNode other = (HintNode)obj;
        return !(this.hints == null ? other.hints != null : !this.hints.equals(other.hints));
    }

    public static enum Hint {
        RANGE_SCAN,
        SKIP_SCAN,
        NO_CHILD_PARENT_JOIN_OPTIMIZATION,
        NO_INDEX,
        INDEX,
        USE_DATA_OVER_INDEX_TABLE,
        USE_INDEX_OVER_DATA_TABLE,
        NO_CACHE,
        USE_SORT_MERGE_JOIN,
        USE_PERSISTENT_CACHE,
        NO_STAR_JOIN,
        SEEK_TO_COLUMN,
        NO_SEEK_TO_COLUMN,
        SMALL,
        SERIAL,
        FORWARD_SCAN,
        HASH_AGGREGATE,
        NO_INDEX_SERVER_MERGE,
        CDC_INCLUDE;

    }
}

