/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.parse;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.phoenix.compile.ColumnResolver;
import org.apache.phoenix.parse.CompoundParseNode;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.ParseNodeVisitor;

public class DocumentFieldTypeParseNode
extends CompoundParseNode {
    DocumentFieldTypeParseNode(ParseNode fieldKey, ParseNode value) {
        super(Arrays.asList(fieldKey, value));
    }

    @Override
    public <T> T accept(ParseNodeVisitor<T> visitor) throws SQLException {
        List l = Collections.emptyList();
        if (visitor.visitEnter(this)) {
            l = this.acceptChildren(visitor);
        }
        return visitor.visitLeave(this, l);
    }

    @Override
    public void toSQL(ColumnResolver resolver, StringBuilder buf) {
        List<ParseNode> children = this.getChildren();
        buf.append("field_type(");
        children.get(0).toSQL(resolver, buf);
        buf.append(", ");
        children.get(1).toSQL(resolver, buf);
        buf.append(")");
    }

    public ParseNode getFieldKey() {
        return this.getChildren().get(0);
    }

    public ParseNode getValue() {
        return this.getChildren().get(1);
    }
}

