/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.parse;

import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.phoenix.compile.ColumnResolver;
import org.apache.phoenix.parse.BinaryParseNode;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.ParseNodeVisitor;
import org.apache.phoenix.util.QueryUtil;

public abstract class ComparisonParseNode
extends BinaryParseNode {
    public ComparisonParseNode(ParseNode lhs, ParseNode rhs) {
        super(lhs, rhs);
    }

    @Override
    public final <T> T accept(ParseNodeVisitor<T> visitor) throws SQLException {
        List l = Collections.emptyList();
        if (visitor.visitEnter(this)) {
            l = this.acceptChildren(visitor);
        }
        return visitor.visitLeave(this, l);
    }

    public abstract CompareOperator getFilterOp();

    public abstract CompareOperator getInvertFilterOp();

    @Override
    public void toSQL(ColumnResolver resolver, StringBuilder buf) {
        List<ParseNode> children = this.getChildren();
        children.get(0).toSQL(resolver, buf);
        buf.append(" " + QueryUtil.toSQL(this.getFilterOp()) + " ");
        children.get(1).toSQL(resolver, buf);
    }
}

