/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.parse;

import org.apache.phoenix.parse.NamedNode;
import org.apache.phoenix.util.SchemaUtil;

public class ColumnName {
    private final NamedNode familyNode;
    private final NamedNode columnNode;

    public static ColumnName caseSensitiveColumnName(String familyName, String columnName) {
        return new ColumnName(NamedNode.caseSensitiveNamedNode(familyName), NamedNode.caseSensitiveNamedNode(columnName));
    }

    public static ColumnName caseSensitiveColumnName(String columnName) {
        return new ColumnName(null, NamedNode.caseSensitiveNamedNode(columnName));
    }

    public static ColumnName newColumnName(NamedNode columnName) {
        return new ColumnName(null, columnName);
    }

    public static ColumnName newColumnName(NamedNode familyName, NamedNode columnName) {
        return new ColumnName(familyName, columnName);
    }

    public static ColumnName newColumnName(String familyName, String columnName) {
        return new ColumnName(familyName, columnName);
    }

    private ColumnName(NamedNode familyNode, NamedNode columnNode) {
        this.familyNode = familyNode;
        this.columnNode = columnNode;
    }

    ColumnName(String familyName, String columnName) {
        this.familyNode = familyName == null ? null : new NamedNode(familyName);
        this.columnNode = new NamedNode(columnName);
    }

    ColumnName(String columnName) {
        this(null, columnName);
    }

    public String getFamilyName() {
        return this.familyNode == null ? null : this.familyNode.getName();
    }

    public String getColumnName() {
        return this.columnNode.getName();
    }

    public NamedNode getFamilyNode() {
        return this.familyNode;
    }

    public NamedNode getColumnNode() {
        return this.columnNode;
    }

    public String toString() {
        return SchemaUtil.getColumnName(this.getFamilyName(), this.getColumnName());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.columnNode.hashCode();
        result = 31 * result + (this.familyNode == null ? 0 : this.familyNode.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ColumnName other = (ColumnName)obj;
        if (!this.columnNode.equals(other.columnNode)) {
            return false;
        }
        return !(this.familyNode == null ? other.familyNode != null : !this.familyNode.equals(other.familyNode));
    }
}

