/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.parse;

import java.sql.SQLException;
import java.util.List;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.function.BsonUpdateExpressionFunction;
import org.apache.phoenix.expression.function.FunctionExpression;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.schema.types.PBson;
import org.apache.phoenix.schema.types.PDataType;

public class BsonUpdateExpressionParseNode
extends FunctionParseNode {
    public BsonUpdateExpressionParseNode(String name, List<ParseNode> children, FunctionParseNode.BuiltInFunctionInfo info) {
        super(name, children, info);
    }

    @Override
    public FunctionExpression create(List<Expression> children, StatementContext context) throws SQLException {
        PDataType dataType = children.get(0).getDataType();
        if (!dataType.isCoercibleTo(PBson.INSTANCE)) {
            throw new SQLException(dataType + " type is unsupported for BSON_CONDITION_EXPRESSION().");
        }
        return new BsonUpdateExpressionFunction(children);
    }
}

