/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.monitoring.connectionqueryservice;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.phoenix.monitoring.ConnectionQueryServicesMetric;
import org.apache.phoenix.monitoring.ConnectionQueryServicesMetricImpl;
import org.apache.phoenix.monitoring.MetricType;
import org.apache.phoenix.monitoring.connectionqueryservice.ConnectionQueryServicesMetricsHistograms;

public class ConnectionQueryServicesMetrics {
    private final String connectionQueryServiceName;
    private Map<MetricType, ConnectionQueryServicesMetric> metricRegister;
    private ConnectionQueryServicesMetricsHistograms connectionQueryServiceMetricsHistograms;

    public ConnectionQueryServicesMetrics(String connectionQueryServiceName, Configuration conf) {
        this.connectionQueryServiceName = connectionQueryServiceName;
        this.metricRegister = new HashMap<MetricType, ConnectionQueryServicesMetric>();
        for (QueryServiceMetrics connectionQueryServiceMetric : QueryServiceMetrics.values()) {
            connectionQueryServiceMetric.metric = new ConnectionQueryServicesMetricImpl(connectionQueryServiceMetric.metricType);
            this.metricRegister.put(connectionQueryServiceMetric.metricType, connectionQueryServiceMetric.metric);
        }
        this.connectionQueryServiceMetricsHistograms = new ConnectionQueryServicesMetricsHistograms(connectionQueryServiceName, conf);
    }

    public void setMetricValue(MetricType type, long val) {
        if (!this.metricRegister.containsKey((Object)type)) {
            return;
        }
        ConnectionQueryServicesMetric metric = this.metricRegister.get((Object)type);
        metric.set(val);
    }

    public long getMetricValue(MetricType type) {
        if (!this.metricRegister.containsKey((Object)type)) {
            return 0L;
        }
        ConnectionQueryServicesMetric metric = this.metricRegister.get((Object)type);
        return metric.getValue();
    }

    public String getConnectionQueryServiceName() {
        return this.connectionQueryServiceName;
    }

    public List<ConnectionQueryServicesMetric> getAllMetrics() {
        return new ArrayList<ConnectionQueryServicesMetric>(this.metricRegister.values());
    }

    public ConnectionQueryServicesMetricsHistograms getConnectionQueryServiceHistograms() {
        return this.connectionQueryServiceMetricsHistograms;
    }

    public static enum QueryServiceMetrics {
        CONNECTION_QUERY_SERVICE_OPEN_PHOENIX_CONNECTIONS_COUNTER(MetricType.OPEN_PHOENIX_CONNECTIONS_COUNTER),
        CONNECTION_QUERY_SERVICE_OPEN_INTERNAL_PHOENIX_CONNECTIONS_COUNTER(MetricType.OPEN_INTERNAL_PHOENIX_CONNECTIONS_COUNTER),
        CONNECTION_QUERY_SERVICE_PHOENIX_CONNECTIONS_THROTTLED_COUNTER(MetricType.PHOENIX_CONNECTIONS_THROTTLED_COUNTER);

        private MetricType metricType;
        private ConnectionQueryServicesMetric metric;

        private QueryServiceMetrics(MetricType metricType) {
            this.metricType = metricType;
        }
    }
}

