/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.monitoring;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.monitoring.HistogramDistribution;
import org.apache.phoenix.monitoring.LatencyHistogram;
import org.apache.phoenix.monitoring.MetricPublisherSupplierFactory;
import org.apache.phoenix.monitoring.MetricServiceResolver;
import org.apache.phoenix.monitoring.MetricType;
import org.apache.phoenix.monitoring.NoOpTableMetricsManager;
import org.apache.phoenix.monitoring.PhoenixTableMetric;
import org.apache.phoenix.monitoring.SizeHistogram;
import org.apache.phoenix.monitoring.TableClientMetrics;
import org.apache.phoenix.monitoring.TableHistograms;
import org.apache.phoenix.query.QueryServicesOptions;
import org.apache.phoenix.thirdparty.com.google.common.base.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableMetricsManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(TableMetricsManager.class);
    private static final Set<String> allowedListOfTableNames = new HashSet<String>();
    private static volatile boolean isTableLevelMetricsEnabled;
    private static volatile boolean isMetricPublisherEnabled;
    private static volatile ConcurrentMap<String, TableClientMetrics> tableClientMetricsMapping;
    private static volatile TableMetricsManager tableMetricsManager;
    private static volatile MetricPublisherSupplierFactory mPublisher;
    private static volatile QueryServicesOptions options;

    @SuppressWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="This is how we implement the singleton pattern")
    public TableMetricsManager(QueryServicesOptions ops) {
        options = ops;
        isTableLevelMetricsEnabled = options.isTableLevelMetricsEnabled();
        LOGGER.info(String.format("Phoenix Table metrics enabled status: %s", isTableLevelMetricsEnabled));
        tableClientMetricsMapping = new ConcurrentHashMap<String, TableClientMetrics>();
        String tableNamesList = options.getAllowedListTableNames();
        if (tableNamesList != null && !tableNamesList.isEmpty()) {
            for (String tableName : tableNamesList.split(",")) {
                allowedListOfTableNames.add(tableName);
            }
        }
        isMetricPublisherEnabled = options.isMetricPublisherEnabled();
        LOGGER.info(String.format("Phoenix table level metrics publisher enabled status %s", isMetricPublisherEnabled));
    }

    public TableMetricsManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static TableMetricsManager getInstance() {
        TableMetricsManager localRef = tableMetricsManager;
        if (localRef != null) return localRef;
        Class<TableMetricsManager> clazz = TableMetricsManager.class;
        synchronized (TableMetricsManager.class) {
            if (localRef != null) return localRef;
            QueryServicesOptions options = QueryServicesOptions.withDefaults();
            if (!options.isTableLevelMetricsEnabled()) {
                tableMetricsManager = NoOpTableMetricsManager.noOpsTableMetricManager;
                return tableMetricsManager;
            }
            localRef = tableMetricsManager = new TableMetricsManager(options);
            LOGGER.info("Phoenix Table metrics created object for metrics manager");
            if (!isMetricPublisherEnabled) return localRef;
            String className = options.getMetricPublisherClass();
            if (className != null) {
                MetricServiceResolver mResolver = new MetricServiceResolver();
                LOGGER.info(String.format("Phoenix table level metrics publisher className %s", className));
                try {
                    mPublisher = mResolver.instantiate(className);
                    mPublisher.registerMetricProvider();
                }
                catch (Throwable e) {
                    LOGGER.error("The exception from metric publish Function", e);
                }
            } else {
                LOGGER.error("Phoenix table level metrics publisher className cannot be null");
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return localRef;
        }
    }

    @VisibleForTesting
    public static void setInstance(TableMetricsManager metricsManager) {
        tableMetricsManager = metricsManager;
    }

    public static void updateMetricsMethod(String tableName, MetricType type, long value) {
        try {
            TableMetricsManager.getInstance().updateMetrics(tableName, type, value);
        }
        catch (Exception e) {
            LOGGER.error("Failed updating Phoenix table level metrics", (Throwable)e);
        }
    }

    public static void pushMetricsFromConnInstanceMethod(Map<String, Map<MetricType, Long>> map) {
        try {
            TableMetricsManager.getInstance().pushMetricsFromConnInstance(map);
        }
        catch (Exception e) {
            LOGGER.error("Failed pushing Phoenix table level metrics", (Throwable)e);
        }
    }

    public static Map<String, List<PhoenixTableMetric>> getTableMetricsMethod() {
        try {
            return TableMetricsManager.getInstance().getTableLevelMetrics();
        }
        catch (Exception e) {
            LOGGER.error("Failed retrieving table level Metrics", (Throwable)e);
            return null;
        }
    }

    public static void clearTableLevelMetricsMethod() {
        try {
            TableMetricsManager.getInstance().clearTableLevelMetrics();
        }
        catch (Exception e) {
            LOGGER.error("Failed resetting table level Metrics", (Throwable)e);
        }
    }

    @VisibleForTesting
    public static Long getMetricValue(String tableName, MetricType type) {
        TableClientMetrics tableMetrics = TableMetricsManager.getInstance().getTableClientMetrics(tableName);
        if (tableMetrics == null) {
            return null;
        }
        for (PhoenixTableMetric metric : tableMetrics.getMetricMap()) {
            if (metric.getMetricType() != type) continue;
            return metric.getValue();
        }
        return null;
    }

    public void pushMetricsFromConnInstance(Map<String, Map<MetricType, Long>> map) {
        if (map == null) {
            LOGGER.debug("Phoenix table level metrics input map cannot be null");
            return;
        }
        long startTime = EnvironmentEdgeManager.currentTime();
        for (Map.Entry<String, Map<MetricType, Long>> tableEntry : map.entrySet()) {
            for (Map.Entry<MetricType, Long> metricEntry : tableEntry.getValue().entrySet()) {
                this.updateMetrics(tableEntry.getKey(), metricEntry.getKey(), metricEntry.getValue());
            }
        }
        LOGGER.debug(String.format("Phoenix table level metrics completed updating metrics from conn instance, timetaken:\t%d", EnvironmentEdgeManager.currentTime() - startTime));
    }

    public void updateMetrics(String tableName, MetricType type, long value) {
        long startTime = EnvironmentEdgeManager.currentTime();
        TableClientMetrics tInstance = this.getTableClientMetrics(tableName);
        if (tInstance == null) {
            LOGGER.debug("Table level client metrics are disabled for table: " + tableName);
            return;
        }
        tInstance.changeMetricValue(type, value);
        LOGGER.debug(String.format("Phoenix table level metrics completed updating metric %s to value %s, timetaken = %s", new Object[]{type, value, EnvironmentEdgeManager.currentTime() - startTime}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TableClientMetrics getTableClientMetrics(String tableName) {
        if (Strings.isNullOrEmpty((String)tableName)) {
            LOGGER.debug("Phoenix Table metrics TableName cannot be null or empty");
            return null;
        }
        if (!allowedListOfTableNames.isEmpty() && !allowedListOfTableNames.contains(tableName)) {
            return null;
        }
        TableClientMetrics tInstance = (TableClientMetrics)tableClientMetricsMapping.get(tableName);
        if (tInstance != null) return tInstance;
        Class<TableMetricsManager> clazz = TableMetricsManager.class;
        synchronized (TableMetricsManager.class) {
            tInstance = (TableClientMetrics)tableClientMetricsMapping.get(tableName);
            if (tInstance != null) return tInstance;
            LOGGER.info(String.format("Phoenix Table metrics creating object for table: %s", tableName));
            tInstance = new TableClientMetrics(tableName, options.getConfiguration());
            if (isMetricPublisherEnabled && mPublisher != null) {
                mPublisher.registerMetrics(tInstance);
            }
            tableClientMetricsMapping.put(tableName, tInstance);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return tInstance;
        }
    }

    public Map<String, List<PhoenixTableMetric>> getTableLevelMetrics() {
        long startTime = EnvironmentEdgeManager.currentTime();
        HashMap<String, List<PhoenixTableMetric>> map = new HashMap<String, List<PhoenixTableMetric>>();
        for (Map.Entry entry : tableClientMetricsMapping.entrySet()) {
            map.put((String)entry.getKey(), ((TableClientMetrics)entry.getValue()).getMetricMap());
        }
        long timeTakenForMetricConversion = EnvironmentEdgeManager.currentTime() - startTime;
        LOGGER.info(String.format("Phoenix Table metrics fetching complete, timeTaken: \t%d", timeTakenForMetricConversion));
        return map;
    }

    private void updateMetricsForSystemCatalogTable(String userTable, MetricType mType, long value) {
        if (userTable != null && !userTable.equals(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME)) {
            TableMetricsManager.updateMetricsMethod(userTable, mType, value);
        }
        TableMetricsManager.updateMetricsMethod(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME, mType, value);
    }

    public void clearTableLevelMetrics() {
        if (tableClientMetricsMapping != null) {
            tableClientMetricsMapping.clear();
        }
        LOGGER.info("Phoenix Table metrics clearing complete");
    }

    public static void updateMetricsForSystemCatalogTableMethod(String userTable, MetricType mType, long value) {
        try {
            TableMetricsManager.getInstance().updateMetricsForSystemCatalogTable(userTable, mType, value);
        }
        catch (Exception e) {
            LOGGER.error("Failed updating Metrics for System catalog Table", (Throwable)e);
        }
    }

    public void clear() {
        TableMetricsManager.clearTableLevelMetricsMethod();
    }

    public static Map<String, List<HistogramDistribution>> getSizeHistogramsForAllTables() {
        HashMap<String, List<HistogramDistribution>> map = new HashMap<String, List<HistogramDistribution>>();
        for (Map.Entry entry : tableClientMetricsMapping.entrySet()) {
            TableHistograms tableHistograms = ((TableClientMetrics)entry.getValue()).getTableHistograms();
            map.put((String)entry.getKey(), tableHistograms.getTableSizeHistogramsDistribution());
        }
        return map;
    }

    public static Map<String, List<HistogramDistribution>> getLatencyHistogramsForAllTables() {
        HashMap<String, List<HistogramDistribution>> map = new HashMap<String, List<HistogramDistribution>>();
        for (Map.Entry entry : tableClientMetricsMapping.entrySet()) {
            TableHistograms tableHistograms = ((TableClientMetrics)entry.getValue()).getTableHistograms();
            map.put((String)entry.getKey(), tableHistograms.getTableLatencyHistogramsDistribution());
        }
        return map;
    }

    public static LatencyHistogram getUpsertLatencyHistogramForTable(String tableName) {
        TableClientMetrics tableMetrics = TableMetricsManager.getTableClientMetricsInstance(tableName);
        if (tableMetrics != null) {
            return tableMetrics.getTableHistograms().getUpsertLatencyHisto();
        }
        return null;
    }

    public static SizeHistogram getUpsertSizeHistogramForTable(String tableName) {
        TableClientMetrics tableMetrics = TableMetricsManager.getTableClientMetricsInstance(tableName);
        if (tableMetrics != null) {
            return tableMetrics.getTableHistograms().getUpsertSizeHisto();
        }
        return null;
    }

    public static LatencyHistogram getDeleteLatencyHistogramForTable(String tableName) {
        TableClientMetrics tableMetrics = TableMetricsManager.getTableClientMetricsInstance(tableName);
        if (tableMetrics != null) {
            return tableMetrics.getTableHistograms().getDeleteLatencyHisto();
        }
        return null;
    }

    public static SizeHistogram getDeleteSizeHistogramForTable(String tableName) {
        TableClientMetrics tableMetrics = TableMetricsManager.getTableClientMetricsInstance(tableName);
        if (tableMetrics != null) {
            return tableMetrics.getTableHistograms().getDeleteSizeHisto();
        }
        return null;
    }

    public static LatencyHistogram getQueryLatencyHistogramForTable(String tableName) {
        TableClientMetrics tableMetrics = TableMetricsManager.getTableClientMetricsInstance(tableName);
        if (tableMetrics != null) {
            return tableMetrics.getTableHistograms().getQueryLatencyHisto();
        }
        return null;
    }

    public static SizeHistogram getQuerySizeHistogramForTable(String tableName) {
        TableClientMetrics tableMetrics = TableMetricsManager.getTableClientMetricsInstance(tableName);
        if (tableMetrics != null) {
            return tableMetrics.getTableHistograms().getQuerySizeHisto();
        }
        return null;
    }

    public static LatencyHistogram getPointLookupLatencyHistogramForTable(String tableName) {
        TableClientMetrics tableMetrics = TableMetricsManager.getTableClientMetricsInstance(tableName);
        if (tableMetrics != null) {
            return tableMetrics.getTableHistograms().getPointLookupLatencyHisto();
        }
        return null;
    }

    public static SizeHistogram getPointLookupSizeHistogramForTable(String tableName) {
        TableClientMetrics tableMetrics = TableMetricsManager.getTableClientMetricsInstance(tableName);
        if (tableMetrics != null) {
            return tableMetrics.getTableHistograms().getPointLookupSizeHisto();
        }
        return null;
    }

    public static LatencyHistogram getRangeScanLatencyHistogramForTable(String tableName) {
        TableClientMetrics tableMetrics = TableMetricsManager.getTableClientMetricsInstance(tableName);
        if (tableMetrics != null) {
            return tableMetrics.getTableHistograms().getRangeScanLatencyHisto();
        }
        return null;
    }

    public static SizeHistogram getRangeScanSizeHistogramForTable(String tableName) {
        TableClientMetrics tableMetrics = TableMetricsManager.getTableClientMetricsInstance(tableName);
        if (tableMetrics != null) {
            return tableMetrics.getTableHistograms().getRangeScanSizeHisto();
        }
        return null;
    }

    public static void updateHistogramMetricsForQueryLatency(String tableName, long elapsedTime, boolean isPointLookup) {
        TableClientMetrics tableMetrics = TableMetricsManager.getTableClientMetricsInstance(tableName);
        if (tableMetrics != null) {
            LOGGER.trace("Updating latency histograms for select query: tableName: " + tableName + " isPointLookup: " + isPointLookup + " elapsedTime: " + elapsedTime);
            tableMetrics.getTableHistograms().getQueryLatencyHisto().add(elapsedTime);
            if (isPointLookup) {
                tableMetrics.getTableHistograms().getPointLookupLatencyHisto().add(elapsedTime);
            } else {
                tableMetrics.getTableHistograms().getRangeScanLatencyHisto().add(elapsedTime);
            }
        }
    }

    public static void updateHistogramMetricsForQueryScanBytes(long scanBytes, String tableName, boolean isPointLookup) {
        TableClientMetrics tableMetrics = TableMetricsManager.getTableClientMetricsInstance(tableName);
        if (tableMetrics != null) {
            tableMetrics.getTableHistograms().getQuerySizeHisto().add(scanBytes);
            if (isPointLookup) {
                tableMetrics.getTableHistograms().getPointLookupSizeHisto().add(scanBytes);
            } else {
                tableMetrics.getTableHistograms().getRangeScanSizeHisto().add(scanBytes);
            }
        }
    }

    public static void updateSizeHistogramMetricsForMutations(String tableName, long mutationBytes, boolean isUpsert) {
        TableClientMetrics tableMetrics = TableMetricsManager.getTableClientMetricsInstance(tableName);
        if (tableMetrics != null) {
            LOGGER.trace("Updating size histograms for mutations: tableName: " + tableName + " isUpsert: " + isUpsert + "  mutation bytes: " + mutationBytes);
            if (isUpsert) {
                tableMetrics.getTableHistograms().getUpsertSizeHisto().add(mutationBytes);
            } else {
                tableMetrics.getTableHistograms().getDeleteSizeHisto().add(mutationBytes);
            }
        }
    }

    private static TableClientMetrics getTableClientMetricsInstance(String tableName) {
        TableClientMetrics tableMetrics = TableMetricsManager.getInstance().getTableClientMetrics(tableName);
        if (tableMetrics == null) {
            LOGGER.trace("Table level client metrics are disabled for table: " + tableName);
            return null;
        }
        return tableMetrics;
    }

    public static void updateLatencyHistogramForMutations(String tableName, long elapsedTime, boolean isUpsert) {
        TableClientMetrics tableMetrics = TableMetricsManager.getTableClientMetricsInstance(tableName);
        if (tableMetrics != null) {
            LOGGER.trace("Updating latency histograms for mutations: tableName: " + tableName + " isUpsert: " + isUpsert + "  elapsedTime: " + elapsedTime);
            if (isUpsert) {
                tableMetrics.getTableHistograms().getUpsertLatencyHisto().add(elapsedTime);
            } else {
                tableMetrics.getTableHistograms().getDeleteLatencyHisto().add(elapsedTime);
            }
        }
    }

    static {
        tableClientMetricsMapping = null;
        tableMetricsManager = null;
        mPublisher = null;
        options = null;
    }
}

