/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.monitoring;

import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.JsonMapper;
import org.apache.phoenix.log.LogLevel;
import org.apache.phoenix.monitoring.CombinableMetric;
import org.apache.phoenix.monitoring.MetricType;
import org.apache.phoenix.monitoring.ReadMetricQueue;

public class ScanMetricsHolder {
    private final CombinableMetric countOfRPCcalls;
    private final CombinableMetric countOfRemoteRPCcalls;
    private final CombinableMetric sumOfMillisSecBetweenNexts;
    private final CombinableMetric countOfNSRE;
    private final CombinableMetric countOfBytesInResults;
    private final CombinableMetric countOfBytesInRemoteResults;
    private final CombinableMetric countOfRegions;
    private final CombinableMetric countOfRPCRetries;
    private final CombinableMetric countOfRemoteRPCRetries;
    private final CombinableMetric countOfRowsScanned;
    private final CombinableMetric countOfRowsFiltered;
    private final CombinableMetric countOfBytesScanned;
    private final CombinableMetric countOfRowsPaged;
    private Map<String, Long> scanMetricMap;
    private Object scan;
    private static final ScanMetricsHolder NO_OP_INSTANCE = new ScanMetricsHolder(new ReadMetricQueue(false, LogLevel.OFF), "", null);

    public static ScanMetricsHolder getInstance(ReadMetricQueue readMetrics, String tableName, Scan scan, LogLevel connectionLogLevel) {
        if (connectionLogLevel == LogLevel.OFF && !readMetrics.isRequestMetricsEnabled()) {
            return NO_OP_INSTANCE;
        }
        scan.setScanMetricsEnabled(true);
        return new ScanMetricsHolder(readMetrics, tableName, scan);
    }

    private ScanMetricsHolder(ReadMetricQueue readMetrics, String tableName, Scan scan) {
        readMetrics.addScanHolder(this);
        this.scan = scan;
        this.countOfRPCcalls = readMetrics.allotMetric(MetricType.COUNT_RPC_CALLS, tableName);
        this.countOfRemoteRPCcalls = readMetrics.allotMetric(MetricType.COUNT_REMOTE_RPC_CALLS, tableName);
        this.sumOfMillisSecBetweenNexts = readMetrics.allotMetric(MetricType.COUNT_MILLS_BETWEEN_NEXTS, tableName);
        this.countOfNSRE = readMetrics.allotMetric(MetricType.COUNT_NOT_SERVING_REGION_EXCEPTION, tableName);
        this.countOfBytesInResults = readMetrics.allotMetric(MetricType.COUNT_BYTES_REGION_SERVER_RESULTS, tableName);
        this.countOfBytesInRemoteResults = readMetrics.allotMetric(MetricType.COUNT_BYTES_IN_REMOTE_RESULTS, tableName);
        this.countOfRegions = readMetrics.allotMetric(MetricType.COUNT_SCANNED_REGIONS, tableName);
        this.countOfRPCRetries = readMetrics.allotMetric(MetricType.COUNT_RPC_RETRIES, tableName);
        this.countOfRemoteRPCRetries = readMetrics.allotMetric(MetricType.COUNT_REMOTE_RPC_RETRIES, tableName);
        this.countOfRowsScanned = readMetrics.allotMetric(MetricType.COUNT_ROWS_SCANNED, tableName);
        this.countOfRowsFiltered = readMetrics.allotMetric(MetricType.COUNT_ROWS_FILTERED, tableName);
        this.countOfBytesScanned = readMetrics.allotMetric(MetricType.SCAN_BYTES, tableName);
        this.countOfRowsPaged = readMetrics.allotMetric(MetricType.PAGED_ROWS_COUNTER, tableName);
    }

    public CombinableMetric getCountOfRemoteRPCcalls() {
        return this.countOfRemoteRPCcalls;
    }

    public CombinableMetric getSumOfMillisSecBetweenNexts() {
        return this.sumOfMillisSecBetweenNexts;
    }

    public CombinableMetric getCountOfNSRE() {
        return this.countOfNSRE;
    }

    public CombinableMetric getCountOfBytesInRemoteResults() {
        return this.countOfBytesInRemoteResults;
    }

    public CombinableMetric getCountOfRegions() {
        return this.countOfRegions;
    }

    public CombinableMetric getCountOfRPCRetries() {
        return this.countOfRPCRetries;
    }

    public CombinableMetric getCountOfRemoteRPCRetries() {
        return this.countOfRemoteRPCRetries;
    }

    public CombinableMetric getCountOfRowsFiltered() {
        return this.countOfRowsFiltered;
    }

    public CombinableMetric getCountOfRPCcalls() {
        return this.countOfRPCcalls;
    }

    public CombinableMetric getCountOfBytesInResults() {
        return this.countOfBytesInResults;
    }

    public CombinableMetric getCountOfRowsScanned() {
        return this.countOfRowsScanned;
    }

    public Map<String, Long> getScanMetricMap() {
        return this.scanMetricMap;
    }

    public CombinableMetric getCountOfBytesScanned() {
        return this.countOfBytesScanned;
    }

    public CombinableMetric getCountOfRowsPaged() {
        return this.countOfRowsPaged;
    }

    public void setScanMetricMap(Map<String, Long> scanMetricMap) {
        this.scanMetricMap = scanMetricMap;
    }

    public String toString() {
        try {
            return "{\"scan\":" + this.scan + ", \"scanMetrics\":" + JsonMapper.writeObjectAsString(this.scanMetricMap) + "}";
        }
        catch (IOException e) {
            return "{\"Exception while converting scan metrics to Json\":\"" + e.getMessage() + "\"}";
        }
    }
}

