/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.monitoring;

import java.util.HashMap;
import java.util.Map;
import org.HdrHistogram.ConcurrentHistogram;
import org.HdrHistogram.Histogram;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.phoenix.monitoring.HistogramDistribution;
import org.apache.phoenix.monitoring.HistogramDistributionImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangeHistogram {
    private Histogram histogram;
    private long[] ranges;
    private String name;
    private String desc;
    private static final Logger LOGGER = LoggerFactory.getLogger(RangeHistogram.class);

    public RangeHistogram(long[] ranges, String name, String description) {
        Preconditions.checkNotNull((Object)ranges);
        Preconditions.checkArgument((ranges.length != 0 ? 1 : 0) != 0);
        this.ranges = ranges;
        this.name = name;
        this.desc = description;
        this.histogram = new ConcurrentHistogram(this.ranges[this.ranges.length - 1], 2);
    }

    public void add(long value) {
        if (value > this.histogram.getHighestTrackableValue()) {
            LOGGER.warn("Histogram recording higher value than maximum. Ignoring it.");
            return;
        }
        this.histogram.recordValue(value);
    }

    public Histogram getHistogram() {
        return this.histogram;
    }

    public long[] getRanges() {
        return this.ranges;
    }

    public String getName() {
        return this.name;
    }

    public String getDesc() {
        return this.desc;
    }

    public HistogramDistribution getRangeHistogramDistribution() {
        Histogram snapshot = this.histogram.copy();
        HistogramDistributionImpl distribution = new HistogramDistributionImpl(this.name, snapshot.getMinValue(), snapshot.getMaxValue(), snapshot.getTotalCount(), this.generateDistributionMap(snapshot));
        return distribution;
    }

    private Map<String, Long> generateDistributionMap(Histogram snapshot) {
        long priorRange = 0L;
        HashMap<String, Long> map = new HashMap<String, Long>();
        for (int i = 0; i < this.ranges.length; ++i) {
            long nextNonEquivalentRange = this.histogram.nextNonEquivalentValue(priorRange);
            long val = snapshot.getCountBetweenValues(nextNonEquivalentRange, this.ranges[i]);
            map.put(priorRange + "," + this.ranges[i], val);
            priorRange = this.ranges[i];
        }
        return map;
    }
}

