/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.monitoring;

import java.util.Map;
import org.apache.hadoop.hbase.metrics.Gauge;
import org.apache.hadoop.hbase.metrics.MetricRegistries;
import org.apache.hadoop.hbase.metrics.MetricRegistry;
import org.apache.hadoop.hbase.metrics.MetricRegistryInfo;
import org.apache.phoenix.monitoring.GlobalMetricRegistriesAdapter;
import org.apache.phoenix.monitoring.MetricPublisherSupplierFactory;
import org.apache.phoenix.monitoring.MetricType;
import org.apache.phoenix.monitoring.PhoenixTableMetric;
import org.apache.phoenix.monitoring.TableClientMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmxMetricProvider
implements MetricPublisherSupplierFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmxMetricProvider.class);
    private static final String metricsName = "PHOENIX-TableLevel";
    private static final String metricsDesc = "Phoenix Client Metrics";
    private static final String metricsjmxContext = "phoenixTableLevel";
    private static final String metricsContext = "Phoenix,sub=CLIENT";
    private MetricRegistry metricRegistry;

    @Override
    public void registerMetricProvider() {
        this.metricRegistry = this.createMetricRegistry();
        GlobalMetricRegistriesAdapter.getInstance().registerMetricRegistry(this.metricRegistry);
    }

    @Override
    public void unregisterMetricProvider() {
    }

    private MetricRegistry createMetricRegistry() {
        LOGGER.info("Creating Metric Registry for Phoenix Table Level Metrics");
        MetricRegistryInfo registryInfo = new MetricRegistryInfo(metricsName, metricsDesc, metricsjmxContext, metricsContext, true);
        return MetricRegistries.global().create(registryInfo);
    }

    private String getMetricNameFromMetricType(MetricType type, String tableName) {
        return tableName + "_table_" + (Object)((Object)type);
    }

    @Override
    public void registerMetrics(TableClientMetrics tInstance) {
        for (Map.Entry<MetricType, PhoenixTableMetric> entry : tInstance.getMetricRegistry().entrySet()) {
            this.metricRegistry.register(this.getMetricNameFromMetricType(entry.getKey(), tInstance.getTableName()), (Gauge)new PhoenixMetricGauge(entry.getValue()));
        }
    }

    @Override
    public void unRegisterMetrics(TableClientMetrics tInstance) {
        for (Map.Entry<MetricType, PhoenixTableMetric> entry : tInstance.getMetricRegistry().entrySet()) {
            this.metricRegistry.remove(this.getMetricNameFromMetricType(entry.getKey(), tInstance.getTableName()));
        }
    }

    private static class PhoenixMetricGauge
    implements Gauge<Long> {
        private final PhoenixTableMetric metric;

        public PhoenixMetricGauge(PhoenixTableMetric metric) {
            this.metric = metric;
        }

        public Long getValue() {
            return this.metric.getValue();
        }
    }
}

