/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.monitoring;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.phoenix.monitoring.Metric;
import org.apache.phoenix.monitoring.MetricType;

public class AtomicMetric
implements Metric {
    private final MetricType type;
    private final AtomicLong value = new AtomicLong();

    public AtomicMetric(MetricType type) {
        this.type = type;
    }

    @Override
    public MetricType getMetricType() {
        return this.type;
    }

    @Override
    public long getValue() {
        return this.value.get();
    }

    @Override
    public void change(long delta) {
        this.value.addAndGet(delta);
    }

    @Override
    public void increment() {
        this.value.incrementAndGet();
    }

    @Override
    public String getCurrentMetricState() {
        return this.getMetricType().shortName() + ": " + this.value.get();
    }

    @Override
    public void reset() {
        this.value.set(0L);
    }

    @Override
    public void set(long value) {
        this.value.set(value);
    }

    @Override
    public void decrement() {
        this.value.decrementAndGet();
    }
}

