/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce.util;

import org.apache.hadoop.conf.Configuration;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;

public final class PhoenixConfigurationUtilHelper {
    @Deprecated
    public static final String MAPREDUCE_INPUT_CLUSTER_QUORUM = "phoenix.mapreduce.input.cluster.quorum";
    @Deprecated
    public static final String MAPREDUCE_OUTPUT_CLUSTER_QUORUM = "phoenix.mapreduce.output.cluster.quorum";
    public static final String MAPREDUCE_INPUT_CLUSTER_URL = "phoenix.mapreduce.input.cluster.url";
    public static final String MAPREDUCE_OUTPUT_CLUSTER_URL = "phoenix.mapreduce.output.cluster.url";
    public static final String TRANSFORM_MONITOR_ENABLED = "phoenix.transform.monitor.enabled";
    public static final boolean DEFAULT_TRANSFORM_MONITOR_ENABLED = true;

    public static long[] getLongs(Configuration conf, String name) {
        String[] strings = conf.getTrimmedStrings(name);
        if (strings.length == 0) {
            return null;
        }
        long[] longs = new long[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            longs[i] = Long.parseLong(strings[i]);
        }
        return longs;
    }

    @Deprecated
    public static String getInputCluster(Configuration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        String quorum = configuration.get(MAPREDUCE_INPUT_CLUSTER_QUORUM);
        if (quorum == null) {
            quorum = configuration.get("hbase.client.zookeeper.quorum");
        }
        if (quorum == null) {
            quorum = configuration.get("hbase.zookeeper.quorum");
        }
        return quorum;
    }

    public static String getInputClusterUrl(Configuration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        String url = configuration.get(MAPREDUCE_INPUT_CLUSTER_URL);
        if (url == null) {
            url = "jdbc:phoenix";
        }
        return url;
    }

    @Deprecated
    public static Integer getClientPort(Configuration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        String clientPortString = configuration.get("hbase.zookeeper.property.clientPort");
        return clientPortString == null ? null : Integer.valueOf(Integer.parseInt(clientPortString));
    }

    @Deprecated
    public static String getZNodeParent(Configuration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        return configuration.get("zookeeper.znode.parent");
    }

    @Deprecated
    public static String getOutputCluster(Configuration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        String quorum = configuration.get(MAPREDUCE_OUTPUT_CLUSTER_QUORUM);
        if (quorum == null) {
            quorum = configuration.get("hbase.client.zookeeper.quorum");
        }
        if (quorum == null) {
            quorum = configuration.get("hbase.zookeeper.quorum");
        }
        return quorum;
    }

    @Deprecated
    public static String getInputClusterZkQuorum(Configuration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        return configuration.get(MAPREDUCE_INPUT_CLUSTER_QUORUM);
    }

    public static String getOutputClusterUrl(Configuration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        String quorum = configuration.get(MAPREDUCE_OUTPUT_CLUSTER_URL);
        if (quorum == null) {
            quorum = "jdbc:phoenix";
        }
        return quorum;
    }

    @Deprecated
    public static String getZKQuorum(Configuration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        return configuration.get("hbase.client.zookeeper.quorum", configuration.get("hbase.zookeeper.quorum"));
    }

    @Deprecated
    public static String getOutputClusterZkQuorum(Configuration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        return configuration.get(MAPREDUCE_OUTPUT_CLUSTER_QUORUM);
    }

    static {
        Configuration.addDeprecation((String)"phoneix.mapreduce.output.cluster.quorum", (String)MAPREDUCE_OUTPUT_CLUSTER_QUORUM);
    }
}

