/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce.util;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.phoenix.mapreduce.util.PhoenixConfigurationUtilHelper;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;
import org.apache.phoenix.util.PropertiesUtil;

public class ConnectionUtil {
    public static Connection getInputConnection(Configuration conf) throws SQLException {
        Preconditions.checkNotNull((Object)conf);
        return ConnectionUtil.getInputConnection(conf, new Properties());
    }

    public static Connection getInputConnection(Configuration conf, Properties props) throws SQLException {
        String inputQuorum = PhoenixConfigurationUtilHelper.getInputCluster(conf);
        if (inputQuorum != null) {
            Properties copyProps = PropertiesUtil.deepCopy(props);
            copyProps.setProperty("hbase.client.zookeeper.quorum", inputQuorum);
            return DriverManager.getConnection(PhoenixConfigurationUtilHelper.getInputClusterUrl(conf), PropertiesUtil.combineProperties(copyProps, conf));
        }
        return DriverManager.getConnection(PhoenixConfigurationUtilHelper.getInputClusterUrl(conf), PropertiesUtil.combineProperties(props, conf));
    }

    public static Connection getOutputConnection(Configuration conf) throws SQLException {
        return ConnectionUtil.getOutputConnection(conf, new Properties());
    }

    public static Connection getOutputConnection(Configuration conf, Properties props) throws SQLException {
        Preconditions.checkNotNull((Object)conf);
        String outputQuorum = PhoenixConfigurationUtilHelper.getOutputCluster(conf);
        if (outputQuorum != null) {
            Properties copyProps = PropertiesUtil.deepCopy(props);
            copyProps.setProperty("hbase.client.zookeeper.quorum", outputQuorum);
            return DriverManager.getConnection(PhoenixConfigurationUtilHelper.getInputClusterUrl(conf), PropertiesUtil.combineProperties(copyProps, conf));
        }
        return DriverManager.getConnection(PhoenixConfigurationUtilHelper.getOutputClusterUrl(conf), PropertiesUtil.combineProperties(props, conf));
    }
}

