/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.log;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.log.BaseConnectionLimiter;
import org.apache.phoenix.log.ConnectionActivityLogger;
import org.apache.phoenix.log.ConnectionLimiter;
import org.apache.phoenix.log.LogLevel;
import org.apache.phoenix.monitoring.GlobalClientMetrics;
import org.apache.phoenix.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingConnectionLimiter
extends BaseConnectionLimiter {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingConnectionLimiter.class);
    private static long MIN_IN_MILLIS = 60000L;
    protected final boolean enableActivityLogging;
    protected final long loggingIntervalInMillis;
    protected long lastLoggedTimeInMillis;
    protected long lastCollectedTimeInMillis;
    protected final Map<UUID, ConnectionActivityLogger> openConnectionActivityLoggers;

    private LoggingConnectionLimiter(Builder builder) {
        super(builder.profileName, builder.shouldThrottleNumConnections, builder.maxConnectionsAllowed, builder.maxInternalConnectionsAllowed);
        this.enableActivityLogging = builder.enableActivityLogging;
        this.loggingIntervalInMillis = (long)builder.loggingIntervalInMins * MIN_IN_MILLIS;
        this.lastCollectedTimeInMillis = this.lastLoggedTimeInMillis = System.currentTimeMillis();
        this.openConnectionActivityLoggers = Maps.newHashMap();
    }

    @Override
    public void acquireConnection(PhoenixConnection connection) throws SQLException {
        super.acquireConnection(connection);
        if (this.enableActivityLogging && this.openConnectionActivityLoggers.size() < this.maxConnectionsAllowed + this.maxInternalConnectionsAllowed) {
            ConnectionActivityLogger logger = new ConnectionActivityLogger(connection, LogLevel.INFO);
            this.openConnectionActivityLoggers.put(connection.getUniqueID(), logger);
        }
    }

    @Override
    public void returnConnection(PhoenixConnection connection) {
        super.returnConnection(connection);
        UUID phxConnUniqueID = connection.getUniqueID();
        Preconditions.checkNotNull((Object)phxConnUniqueID, (Object)"Got null UUID for Phoenix Connection!");
        if (this.enableActivityLogging) {
            this.openConnectionActivityLoggers.remove(phxConnUniqueID);
        }
    }

    @Override
    public int onSweep(boolean internal) {
        long currentTimeInMillis = System.currentTimeMillis();
        boolean shouldCollectNow = currentTimeInMillis - this.lastCollectedTimeInMillis >= this.loggingIntervalInMillis;
        int garbageCollectedConnections = 0;
        if (this.enableActivityLogging && shouldCollectNow) {
            Iterator<Map.Entry<UUID, ConnectionActivityLogger>> iterator = this.openConnectionActivityLoggers.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<UUID, ConnectionActivityLogger> entry = iterator.next();
                ConnectionActivityLogger logger = entry.getValue();
                boolean checkReclaimable = logger.isInternalConnection() && internal || !logger.isInternalConnection() && !internal;
                if (!checkReclaimable) continue;
                PhoenixConnection monitoredConnection = logger.getConnection();
                LOGGER.info(String.format("connection-sweep-activity-log for %s: %s", logger.getConnectionID(), logger.getActivityLog()));
                if (monitoredConnection != null) continue;
                garbageCollectedConnections += this.collectConnection(internal);
                iterator.remove();
            }
            LOGGER.info(String.format("connection-profile-metrics-log for %s: internal=%s, freed=%d, current=%d, open=%d, throttled=%d", this.profileName, internal, garbageCollectedConnections, internal ? this.getInternalConnectionCount() : this.getConnectionCount(), internal ? GlobalClientMetrics.GLOBAL_OPEN_INTERNAL_PHOENIX_CONNECTIONS.getMetric().getValue() : GlobalClientMetrics.GLOBAL_OPEN_PHOENIX_CONNECTIONS.getMetric().getValue(), GlobalClientMetrics.GLOBAL_PHOENIX_CONNECTIONS_THROTTLED_COUNTER.getMetric().getValue()));
            this.lastCollectedTimeInMillis = currentTimeInMillis;
        }
        return garbageCollectedConnections;
    }

    private int collectConnection(boolean internal) {
        if (internal && this.internalConnectionCount > 0) {
            --this.internalConnectionCount;
            GlobalClientMetrics.GLOBAL_OPEN_INTERNAL_PHOENIX_CONNECTIONS.decrement();
            return 1;
        }
        if (!internal && this.connectionCount > 0) {
            --this.connectionCount;
            GlobalClientMetrics.GLOBAL_OPEN_PHOENIX_CONNECTIONS.decrement();
            return 1;
        }
        return 0;
    }

    @VisibleForTesting
    public Map<String, String> getActivityLog() throws SQLException {
        HashMap activityLog = Maps.newHashMap();
        if (this.enableActivityLogging) {
            for (ConnectionActivityLogger connectionLogger : this.openConnectionActivityLoggers.values()) {
                activityLog.put(connectionLogger.getConnectionID(), connectionLogger.getActivityLog());
            }
        }
        return activityLog;
    }

    public static class Builder {
        protected String profileName;
        protected boolean enableActivityLogging;
        protected int loggingIntervalInMins;
        protected int maxConnectionsAllowed;
        protected int maxInternalConnectionsAllowed;
        protected boolean shouldThrottleNumConnections;

        public Builder(boolean shouldThrottleNumConnections) {
            this.shouldThrottleNumConnections = shouldThrottleNumConnections;
        }

        public Builder withConnectionProfile(String profileName) {
            this.profileName = profileName;
            return this;
        }

        public Builder withMaxAllowed(int maxAllowed) {
            this.maxConnectionsAllowed = maxAllowed;
            return this;
        }

        public Builder withMaxInternalAllowed(int maxInternalAllowed) {
            this.maxInternalConnectionsAllowed = maxInternalAllowed;
            return this;
        }

        public Builder withLogging(boolean enabled) {
            this.enableActivityLogging = enabled;
            return this;
        }

        public Builder withLoggingIntervalInMins(int loggingIntervalInMins) {
            this.loggingIntervalInMins = loggingIntervalInMins;
            return this;
        }

        public ConnectionLimiter build() {
            return new LoggingConnectionLimiter(this);
        }
    }
}

