/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.log;

import org.apache.phoenix.log.BaseConnectionLimiter;
import org.apache.phoenix.log.ConnectionLimiter;

public class DefaultConnectionLimiter
extends BaseConnectionLimiter {
    private DefaultConnectionLimiter(Builder builder) {
        super(builder.profileName, builder.shouldThrottleNumConnections, builder.maxConnectionsAllowed, builder.maxInternalConnectionsAllowed);
    }

    public static class Builder {
        protected String profileName;
        protected int maxConnectionsAllowed;
        protected int maxInternalConnectionsAllowed;
        protected boolean shouldThrottleNumConnections;

        public Builder(boolean shouldThrottleNumConnections) {
            this.shouldThrottleNumConnections = shouldThrottleNumConnections;
        }

        public Builder withConnectionProfile(String profileName) {
            this.profileName = profileName;
            return this;
        }

        public Builder withMaxAllowed(int maxAllowed) {
            this.maxConnectionsAllowed = maxAllowed;
            return this;
        }

        public Builder withMaxInternalAllowed(int maxInternalAllowed) {
            this.maxInternalConnectionsAllowed = maxInternalAllowed;
            return this;
        }

        public ConnectionLimiter build() {
            return new DefaultConnectionLimiter(this);
        }
    }
}

