/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.job;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.phoenix.monitoring.HTableThreadPoolHistograms;
import org.apache.phoenix.monitoring.HTableThreadPoolMetricsManager;

public class HTableThreadPoolWithUtilizationStats
extends ThreadPoolExecutor {
    private final String htableThreadPoolHistogramsName;
    private final Supplier<HTableThreadPoolHistograms> hTableThreadPoolHistogramsSupplier;

    public HTableThreadPoolWithUtilizationStats(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, String htableThreadPoolHistogramsName, Supplier<HTableThreadPoolHistograms> supplier) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
        this.htableThreadPoolHistogramsName = htableThreadPoolHistogramsName;
        this.hTableThreadPoolHistogramsSupplier = supplier;
    }

    @Override
    public void execute(Runnable runnable) {
        Preconditions.checkNotNull((Object)runnable);
        if (this.hTableThreadPoolHistogramsSupplier != null) {
            HTableThreadPoolMetricsManager.updateActiveThreads(this.htableThreadPoolHistogramsName, this.getActiveCount(), this.hTableThreadPoolHistogramsSupplier);
            HTableThreadPoolMetricsManager.updateQueueSize(this.htableThreadPoolHistogramsName, this.getQueue().size(), this.hTableThreadPoolHistogramsSupplier);
        }
        super.execute(runnable);
    }
}

