/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.job;

import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.phoenix.util.EnvironmentEdgeManager;

public abstract class AbstractRoundRobinQueue<E>
extends AbstractQueue<E>
implements BlockingQueue<E> {
    private final Map<Object, ProducerList<E>> producerMap = new HashMap<Object, ProducerList<E>>();
    private final LinkedList<ProducerList<E>> producerLists = new LinkedList();
    private final Object lock = new Object();
    private final boolean newProducerToFront;
    private int currentProducer;
    private int size;
    private int maxSize;

    public AbstractRoundRobinQueue(int maxSize) {
        this(maxSize, false);
    }

    public AbstractRoundRobinQueue(int maxSize, boolean newProducerToFront) {
        this.newProducerToFront = newProducerToFront;
        this.maxSize = maxSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<E> iterator() {
        Object object = this.lock;
        synchronized (object) {
            ArrayList allElements = new ArrayList(this.size);
            ListIterator<ProducerList<E>> iter = this.producerLists.listIterator(this.currentProducer);
            while (iter.hasNext()) {
                ProducerList<E> tList = iter.next();
                allElements.addAll(((ProducerList)tList).list);
            }
            return allElements.iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E o, long timeout, TimeUnit unit) throws InterruptedException {
        boolean taken = false;
        long endAt = EnvironmentEdgeManager.currentTimeMillis() + unit.toMillis(timeout);
        Object object = this.lock;
        synchronized (object) {
            long waitTime = endAt - EnvironmentEdgeManager.currentTimeMillis();
            while (!(taken = this.offer(o)) && waitTime > 0L) {
                this.lock.wait(waitTime);
                waitTime = endAt - EnvironmentEdgeManager.currentTimeMillis();
            }
        }
        return taken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E o) {
        if (o == null) {
            throw new NullPointerException();
        }
        Object producerKey = this.extractProducer(o);
        ProducerList<E> producerList = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.maxSize != -1 && this.size == this.maxSize) {
                return false;
            }
            producerList = this.producerMap.get(producerKey);
            if (producerList == null) {
                producerList = new ProducerList(producerKey);
                this.producerMap.put(producerKey, producerList);
                this.producerLists.add(this.currentProducer, producerList);
                if (!this.newProducerToFront) {
                    this.incrementCurrentProducerPointer();
                }
            }
            ((ProducerList)producerList).list.add(o);
            ++this.size;
            this.lock.notifyAll();
        }
        return true;
    }

    protected abstract Object extractProducer(E var1);

    @Override
    public void put(E o) {
        this.offer(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E take() throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            while (this.size == 0) {
                this.lock.wait();
            }
            E element = this.poll();
            assert (element != null);
            return element;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        long endAt = EnvironmentEdgeManager.currentTimeMillis() + unit.toMillis(timeout);
        Object object = this.lock;
        synchronized (object) {
            long waitTime = endAt - EnvironmentEdgeManager.currentTimeMillis();
            while (this.size == 0 && waitTime > 0L) {
                this.lock.wait(waitTime);
                waitTime = endAt - EnvironmentEdgeManager.currentTimeMillis();
            }
            return this.poll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll() {
        Object object = this.lock;
        synchronized (object) {
            ListIterator<ProducerList<E>> iter = this.producerLists.listIterator(this.currentProducer);
            while (iter.hasNext()) {
                ProducerList<E> tList = iter.next();
                if (((ProducerList)tList).list.isEmpty()) {
                    iter.remove();
                    this.producerMap.remove(((ProducerList)tList).producer);
                    this.adjustCurrentProducerPointer();
                    continue;
                }
                Object element = ((ProducerList)tList).list.removeFirst();
                --this.size;
                assert (element != null);
                if (((ProducerList)tList).list.isEmpty()) {
                    iter.remove();
                    this.producerMap.remove(((ProducerList)tList).producer);
                    this.adjustCurrentProducerPointer();
                } else {
                    this.incrementCurrentProducerPointer();
                }
                this.lock.notifyAll();
                return element;
            }
            assert (this.size == 0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected E pollProducer(Object producer) {
        Object object = this.lock;
        synchronized (object) {
            ProducerList<E> tList = this.producerMap.get(producer);
            if (tList != null && !((ProducerList)tList).list.isEmpty()) {
                Object element = ((ProducerList)tList).list.removeFirst();
                --this.size;
                if (((ProducerList)tList).list.isEmpty()) {
                    this.producerLists.remove(tList);
                    this.producerMap.remove(((ProducerList)tList).producer);
                    this.adjustCurrentProducerPointer();
                }
                this.lock.notifyAll();
                assert (element != null);
                return element;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E peek() {
        Object object = this.lock;
        synchronized (object) {
            ListIterator<ProducerList<E>> iter = this.producerLists.listIterator(this.currentProducer);
            while (iter.hasNext()) {
                ProducerList<E> tList = iter.next();
                if (((ProducerList)tList).list.isEmpty()) {
                    iter.remove();
                    this.producerMap.remove(((ProducerList)tList).producer);
                    this.adjustCurrentProducerPointer();
                    continue;
                }
                Object element = ((ProducerList)tList).list.getFirst();
                assert (element != null);
                return element;
            }
            assert (this.size == 0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super E> c) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        Object object = this.lock;
        synchronized (object) {
            int originalSize = this.size;
            int drained = this.drainTo(c, this.size);
            assert (drained == originalSize);
            assert (this.size == 0);
            assert (this.producerLists.isEmpty());
            assert (this.producerMap.isEmpty());
            return drained;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super E> c, int maxElements) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        Object object = this.lock;
        synchronized (object) {
            E element;
            int i;
            for (i = 0; i < maxElements && (element = this.poll()) != null; ++i) {
                c.add(element);
            }
            return i;
        }
    }

    @Override
    public int remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Object object = this.lock;
        synchronized (object) {
            return this.size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementCurrentProducerPointer() {
        Object object = this.lock;
        synchronized (object) {
            this.currentProducer = this.producerLists.size() == 0 ? 0 : (this.currentProducer + 1) % this.producerLists.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void adjustCurrentProducerPointer() {
        Object object = this.lock;
        synchronized (object) {
            this.currentProducer = this.producerLists.size() == 0 ? 0 : (this.currentProducer %= this.producerLists.size());
        }
    }

    private static class ProducerList<E> {
        private final Object producer;
        private final LinkedList<E> list;

        public ProducerList(Object producer) {
            this.producer = producer;
            this.list = new LinkedList();
        }
    }
}

