/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.jdbc;

import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.security.User;
import org.apache.phoenix.jdbc.ConnectionInfo;
import org.apache.phoenix.util.ReadOnlyProps;

public class ZKConnectionInfo
extends ConnectionInfo {
    public static final String ZK_REGISTRY_NAME = "org.apache.hadoop.hbase.client.ZKConnectionRegistry";
    private final Integer zkPort;
    private final String zkRootNode;
    private final String zkHosts;

    private ZKConnectionInfo(boolean isConnectionless, String principal, String keytab, User user, String haGroup, String zkHosts, Integer zkPort, String zkRootNode, ConnectionInfo.ConnectionType connectionType) {
        super(isConnectionless, principal, keytab, user, haGroup, connectionType);
        this.zkPort = zkPort;
        this.zkRootNode = zkRootNode;
        this.zkHosts = zkHosts;
    }

    public String getZkHosts() {
        return this.zkHosts;
    }

    public Integer getZkPort() {
        return this.zkPort;
    }

    public String getZkRootNode() {
        return this.zkRootNode;
    }

    @Override
    public String getZookeeperConnectionString() {
        return this.getZkHosts();
    }

    @Override
    public ReadOnlyProps asProps() {
        if (this.isConnectionless) {
            return ReadOnlyProps.EMPTY_PROPS;
        }
        Map<String, String> connectionProps = this.getCommonProps();
        connectionProps.put("hbase.client.registry.impl", ZK_REGISTRY_NAME);
        if (this.getZkHosts() != null) {
            connectionProps.put("hbase.client.zookeeper.quorum", this.getZkHosts());
            connectionProps.put("hbase.zookeeper.quorum", this.getZkHosts());
        }
        if (this.getZkRootNode() != null) {
            connectionProps.put("zookeeper.znode.parent", this.getZkRootNode());
        }
        return connectionProps.isEmpty() ? ReadOnlyProps.EMPTY_PROPS : new ReadOnlyProps(connectionProps.entrySet().iterator());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.zkHosts == null ? 0 : this.zkHosts.hashCode());
        result = 31 * result + (this.zkRootNode == null ? 0 : this.zkRootNode.hashCode());
        result = 31 * result + super.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        ZKConnectionInfo other = (ZKConnectionInfo)obj;
        if (this.zkHosts == null ? other.zkHosts != null : !this.zkHosts.equals(other.zkHosts)) {
            return false;
        }
        return !(this.zkRootNode == null ? other.zkRootNode != null : !this.zkRootNode.equals(other.zkRootNode));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.zkHosts.replaceAll(":", "\\\\:"));
        if (this.anyNotNull(this.zkPort, this.zkRootNode, this.principal, this.keytab)) {
            sb.append(this.zkPort == null ? ":" : ":" + this.zkPort);
        }
        if (this.anyNotNull(this.zkRootNode, this.principal, this.keytab)) {
            sb.append(this.zkRootNode == null ? ":" : ":" + this.zkRootNode);
        }
        if (this.anyNotNull(this.principal, this.keytab)) {
            sb.append(this.principal == null ? ":" : ":" + this.principal);
        }
        if (this.anyNotNull(this.keytab)) {
            sb.append(this.keytab == null ? ":" : ":" + this.keytab);
        }
        return sb.toString();
    }

    @Override
    public String toUrl() {
        return "jdbc:phoenix+zk:" + this.toString();
    }

    @Override
    public ConnectionInfo withPrincipal(String principal) {
        return new ZKConnectionInfo(this.isConnectionless, principal, this.keytab, this.user, this.haGroup, this.zkHosts, this.zkPort, this.zkRootNode, this.connectionType);
    }

    protected static class Builder
    extends ConnectionInfo.Builder {
        private Integer zkPort;
        private String zkRootNode;
        private String zkHosts;

        public Builder(String url, Configuration config, ReadOnlyProps props, Properties info) {
            super(url, config, props, info);
        }

        @Override
        protected ConnectionInfo create() throws SQLException {
            this.parse();
            this.normalize();
            this.handleKerberosAndLogin();
            this.setHaGroup();
            return this.build();
        }

        private boolean isMultiPortUrl(String portStr) {
            int commaIndex = portStr.indexOf(44);
            if (commaIndex > 0) {
                try {
                    Integer.parseInt(portStr.substring(0, commaIndex));
                    return true;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return false;
        }

        private void parse() throws SQLException {
            int tokenIndex;
            StringTokenizer tokenizer = this.getTokenizerWithoutProtocol();
            int nTokens = 0;
            String[] tokens = new String[5];
            String token = null;
            boolean wasDelimiter = false;
            boolean first = true;
            while (tokenizer.hasMoreTokens() && !(token = tokenizer.nextToken()).equals(";") && nTokens < tokens.length) {
                if (";:".contains(token)) {
                    if (wasDelimiter && !first) {
                        tokens[nTokens++] = "";
                    }
                    wasDelimiter = true;
                } else {
                    tokens[nTokens++] = token;
                    wasDelimiter = false;
                }
                first = false;
            }
            if (tokenizer.hasMoreTokens() && !";".equals(token)) {
                String extraToken = tokenizer.nextToken();
                if ('\\' == extraToken.charAt(0)) {
                    String prevToken = tokens[nTokens - 1];
                    tokens[nTokens - 1] = prevToken + ":" + extraToken;
                    if (tokenizer.hasMoreTokens() && !(token = tokenizer.nextToken()).equals(";")) {
                        throw ConnectionInfo.getMalFormedUrlException(this.url);
                    }
                } else {
                    throw ConnectionInfo.getMalFormedUrlException(this.url);
                }
            }
            if (nTokens > (tokenIndex = 0)) {
                this.zkHosts = tokens[tokenIndex++];
                if (nTokens > tokenIndex) {
                    block19: {
                        try {
                            this.zkPort = Integer.parseInt(tokens[tokenIndex]);
                            if (this.zkPort < 0) {
                                throw ConnectionInfo.getMalFormedUrlException(this.url);
                            }
                            ++tokenIndex;
                        }
                        catch (NumberFormatException e) {
                            if (tokens[tokenIndex].isEmpty()) {
                                ++tokenIndex;
                            }
                            if (!this.isMultiPortUrl(tokens[tokenIndex])) break block19;
                            throw ConnectionInfo.getMalFormedUrlException(this.url);
                        }
                    }
                    if (nTokens > tokenIndex) {
                        if (tokens[tokenIndex].startsWith("/") || tokens[tokenIndex].isEmpty()) {
                            this.zkRootNode = tokens[tokenIndex++];
                        }
                        if (nTokens > tokenIndex) {
                            this.principal = tokens[tokenIndex++];
                            if (nTokens > tokenIndex) {
                                String nextToken;
                                this.keytab = tokens[tokenIndex++];
                                if (tokenIndex < tokens.length && null != (nextToken = tokens[tokenIndex++]) && '\\' == nextToken.charAt(0)) {
                                    this.keytab = this.keytab + ":" + nextToken;
                                }
                            }
                        }
                    }
                }
            }
        }

        protected ConnectionInfo build() {
            return new ZKConnectionInfo(this.isConnectionless, this.principal, this.keytab, this.user, this.haGroup, this.zkHosts, this.zkPort, this.zkRootNode, this.connectionType);
        }

        @Override
        protected void normalize() throws SQLException {
            if (this.zkHosts != null && this.zkHosts.isEmpty()) {
                this.zkHosts = null;
            }
            if (this.zkRootNode != null && this.zkRootNode.isEmpty()) {
                this.zkRootNode = null;
            }
            this.isConnectionless = "none".equals(this.zkHosts);
            if (this.isConnectionless) {
                if (this.zkPort != null || this.zkRootNode != null) {
                    throw ConnectionInfo.getMalFormedUrlException(this.url);
                }
                return;
            }
            if (this.zkPort == null) {
                String zkPortString = this.get("hbase.client.zookeeper.property.clientPort");
                if (zkPortString == null) {
                    zkPortString = this.get("hbase.zookeeper.property.clientPort");
                }
                this.zkPort = zkPortString == null ? Integer.valueOf(2181) : Integer.valueOf(Integer.parseInt(zkPortString));
            }
            if (this.zkHosts == null) {
                this.zkHosts = this.get("hbase.client.zookeeper.quorum");
                if (this.zkHosts == null) {
                    this.zkHosts = this.get("hbase.zookeeper.quorum");
                }
                if (this.zkHosts == null) {
                    throw ConnectionInfo.getMalFormedUrlException("Quorum not specified and hbase.client.zookeeper.quorum is not set in configuration : " + this.url);
                }
            } else {
                this.zkHosts = this.zkHosts.replaceAll("=", ":");
            }
            this.zkHosts = this.normalizeHostsList(this.zkHosts, this.zkPort);
            this.zkPort = null;
            if (this.zkRootNode == null) {
                this.zkRootNode = this.get("zookeeper.znode.parent", "/hbase");
            }
        }

        public static boolean isZK(Configuration config, ReadOnlyProps props, Properties info) {
            return config != null && ZKConnectionInfo.ZK_REGISTRY_NAME.equals(Builder.get("hbase.client.registry.impl", config, props, info));
        }
    }
}

