/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.jdbc;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.sql.BatchUpdateException;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.text.Format;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.client.Consistency;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.call.CallRunner;
import org.apache.phoenix.compile.BaseMutationPlan;
import org.apache.phoenix.compile.CloseStatementCompiler;
import org.apache.phoenix.compile.CreateFunctionCompiler;
import org.apache.phoenix.compile.CreateIndexCompiler;
import org.apache.phoenix.compile.CreateSchemaCompiler;
import org.apache.phoenix.compile.CreateSequenceCompiler;
import org.apache.phoenix.compile.CreateTableCompiler;
import org.apache.phoenix.compile.DeclareCursorCompiler;
import org.apache.phoenix.compile.DeleteCompiler;
import org.apache.phoenix.compile.DropSequenceCompiler;
import org.apache.phoenix.compile.ExplainPlan;
import org.apache.phoenix.compile.ExplainPlanAttributes;
import org.apache.phoenix.compile.ExpressionProjector;
import org.apache.phoenix.compile.GroupByCompiler;
import org.apache.phoenix.compile.ListJarsQueryPlan;
import org.apache.phoenix.compile.MutationPlan;
import org.apache.phoenix.compile.OpenStatementCompiler;
import org.apache.phoenix.compile.OrderByCompiler;
import org.apache.phoenix.compile.QueryCompiler;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.compile.RowProjector;
import org.apache.phoenix.compile.SequenceManager;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.compile.StatementPlan;
import org.apache.phoenix.compile.TraceQueryPlan;
import org.apache.phoenix.compile.UpsertCompiler;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.exception.UpgradeRequiredException;
import org.apache.phoenix.execute.MutationState;
import org.apache.phoenix.execute.visitor.QueryPlanVisitor;
import org.apache.phoenix.expression.KeyValueColumnExpression;
import org.apache.phoenix.expression.RowKeyColumnExpression;
import org.apache.phoenix.iterate.MaterializedResultIterator;
import org.apache.phoenix.iterate.ParallelScanGrouper;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixMonitoredStatement;
import org.apache.phoenix.jdbc.PhoenixParameterMetaData;
import org.apache.phoenix.jdbc.PhoenixPreparedStatement;
import org.apache.phoenix.jdbc.PhoenixResultSet;
import org.apache.phoenix.log.ActivityLogInfo;
import org.apache.phoenix.log.AuditQueryLogger;
import org.apache.phoenix.log.LogLevel;
import org.apache.phoenix.log.QueryLogInfo;
import org.apache.phoenix.log.QueryLogger;
import org.apache.phoenix.log.QueryLoggerUtil;
import org.apache.phoenix.log.QueryStatus;
import org.apache.phoenix.monitoring.GlobalClientMetrics;
import org.apache.phoenix.monitoring.MetricType;
import org.apache.phoenix.monitoring.TableMetricsManager;
import org.apache.phoenix.optimize.Cost;
import org.apache.phoenix.parse.AddColumnStatement;
import org.apache.phoenix.parse.AddJarsStatement;
import org.apache.phoenix.parse.AliasedNode;
import org.apache.phoenix.parse.AlterIndexStatement;
import org.apache.phoenix.parse.AlterSessionStatement;
import org.apache.phoenix.parse.BindableStatement;
import org.apache.phoenix.parse.ChangePermsStatement;
import org.apache.phoenix.parse.CloseStatement;
import org.apache.phoenix.parse.ColumnDef;
import org.apache.phoenix.parse.ColumnName;
import org.apache.phoenix.parse.CreateCDCStatement;
import org.apache.phoenix.parse.CreateFunctionStatement;
import org.apache.phoenix.parse.CreateIndexStatement;
import org.apache.phoenix.parse.CreateSchemaStatement;
import org.apache.phoenix.parse.CreateSequenceStatement;
import org.apache.phoenix.parse.CreateTableStatement;
import org.apache.phoenix.parse.CursorName;
import org.apache.phoenix.parse.DMLStatement;
import org.apache.phoenix.parse.DeclareCursorStatement;
import org.apache.phoenix.parse.DeleteJarStatement;
import org.apache.phoenix.parse.DeleteStatement;
import org.apache.phoenix.parse.DropCDCStatement;
import org.apache.phoenix.parse.DropColumnStatement;
import org.apache.phoenix.parse.DropFunctionStatement;
import org.apache.phoenix.parse.DropIndexStatement;
import org.apache.phoenix.parse.DropSchemaStatement;
import org.apache.phoenix.parse.DropSequenceStatement;
import org.apache.phoenix.parse.DropTableStatement;
import org.apache.phoenix.parse.ExecuteUpgradeStatement;
import org.apache.phoenix.parse.ExplainStatement;
import org.apache.phoenix.parse.ExplainType;
import org.apache.phoenix.parse.FetchStatement;
import org.apache.phoenix.parse.FilterableStatement;
import org.apache.phoenix.parse.HintNode;
import org.apache.phoenix.parse.IndexKeyConstraint;
import org.apache.phoenix.parse.LimitNode;
import org.apache.phoenix.parse.ListJarsStatement;
import org.apache.phoenix.parse.LiteralParseNode;
import org.apache.phoenix.parse.MutableStatement;
import org.apache.phoenix.parse.NamedNode;
import org.apache.phoenix.parse.NamedTableNode;
import org.apache.phoenix.parse.OffsetNode;
import org.apache.phoenix.parse.OpenStatement;
import org.apache.phoenix.parse.OrderByNode;
import org.apache.phoenix.parse.PFunction;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.ParseNodeFactory;
import org.apache.phoenix.parse.PrimaryKeyConstraint;
import org.apache.phoenix.parse.RowReturningDMLStatement;
import org.apache.phoenix.parse.SQLParser;
import org.apache.phoenix.parse.SelectStatement;
import org.apache.phoenix.parse.ShowCreateTable;
import org.apache.phoenix.parse.ShowCreateTableStatement;
import org.apache.phoenix.parse.ShowSchemasStatement;
import org.apache.phoenix.parse.ShowTablesStatement;
import org.apache.phoenix.parse.TableName;
import org.apache.phoenix.parse.TableNode;
import org.apache.phoenix.parse.TraceStatement;
import org.apache.phoenix.parse.UDFParseNode;
import org.apache.phoenix.parse.UpdateStatisticsStatement;
import org.apache.phoenix.parse.UpsertStatement;
import org.apache.phoenix.parse.UseSchemaStatement;
import org.apache.phoenix.query.HBaseFactoryProvider;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.ExecuteQueryNotApplicableException;
import org.apache.phoenix.schema.ExecuteUpdateNotApplicableException;
import org.apache.phoenix.schema.FunctionNotFoundException;
import org.apache.phoenix.schema.MetaDataClient;
import org.apache.phoenix.schema.MetaDataEntityNotFoundException;
import org.apache.phoenix.schema.PColumnImpl;
import org.apache.phoenix.schema.PDatum;
import org.apache.phoenix.schema.PIndexState;
import org.apache.phoenix.schema.PNameFactory;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.RowKeyValueAccessor;
import org.apache.phoenix.schema.Sequence;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.schema.stats.StatisticsCollectionScope;
import org.apache.phoenix.schema.tuple.MultiKeyValueTuple;
import org.apache.phoenix.schema.tuple.ResultTuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.thirdparty.com.google.common.base.Strings;
import org.apache.phoenix.thirdparty.com.google.common.base.Throwables;
import org.apache.phoenix.thirdparty.com.google.common.collect.ListMultimap;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.thirdparty.com.google.common.math.IntMath;
import org.apache.phoenix.trace.util.Tracing;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.CDCUtil;
import org.apache.phoenix.util.ClientUtil;
import org.apache.phoenix.util.CursorUtil;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.LogUtil;
import org.apache.phoenix.util.ParseNodeUtil;
import org.apache.phoenix.util.PhoenixContextExecutor;
import org.apache.phoenix.util.PhoenixKeyValueUtil;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.SQLCloseable;
import org.apache.phoenix.util.TupleUtil;
import org.apache.phoenix.util.ValidateLastDDLTimestampUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhoenixStatement
implements PhoenixMonitoredStatement,
SQLCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PhoenixStatement.class);
    protected final PhoenixConnection connection;
    private static final int NO_UPDATE = -1;
    private static final String TABLE_UNKNOWN = "";
    private QueryPlan lastQueryPlan;
    private ResultSet lastResultSet;
    private int lastUpdateCount = -1;
    private String lastUpdateTable = "";
    private Operation lastUpdateOperation;
    private boolean isClosed = false;
    private boolean closeOnCompletion = false;
    private int maxRows;
    private int fetchSize = -1;
    private int queryTimeoutMillis;
    private boolean explainPlanLoggingEnabled;
    protected final Calendar localCalendar = Calendar.getInstance();
    private boolean validateLastDdlTimestamp;
    private long sqlQueryParsingTime = 0L;
    private static final byte[] EXPLAIN_PLAN_FAMILY = QueryConstants.SINGLE_COLUMN_FAMILY;
    private static final byte[] EXPLAIN_PLAN_COLUMN = PVarchar.INSTANCE.toBytes("Plan");
    private static final String EXPLAIN_PLAN_ALIAS = "PLAN";
    private static final String EXPLAIN_PLAN_TABLE_NAME = "PLAN_TABLE";
    private static final PDatum EXPLAIN_PLAN_DATUM = new PDatum(){

        @Override
        public boolean isNullable() {
            return true;
        }

        @Override
        public PDataType getDataType() {
            return PVarchar.INSTANCE;
        }

        @Override
        public Integer getMaxLength() {
            return null;
        }

        @Override
        public Integer getScale() {
            return null;
        }

        @Override
        public SortOrder getSortOrder() {
            return SortOrder.getDefault();
        }
    };
    private static final String EXPLAIN_PLAN_BYTES_ESTIMATE_COLUMN_NAME = "BytesEstimate";
    private static final byte[] EXPLAIN_PLAN_BYTES_ESTIMATE = PVarchar.INSTANCE.toBytes("BytesEstimate");
    public static final String EXPLAIN_PLAN_BYTES_ESTIMATE_COLUMN_ALIAS = "EST_BYTES_READ";
    private static final PColumnImpl EXPLAIN_PLAN_BYTES_ESTIMATE_COLUMN = new PColumnImpl(PNameFactory.newName(EXPLAIN_PLAN_BYTES_ESTIMATE), PNameFactory.newName(EXPLAIN_PLAN_FAMILY), PLong.INSTANCE, null, null, true, 1, SortOrder.getDefault(), 0, null, false, null, false, false, EXPLAIN_PLAN_BYTES_ESTIMATE, 0L, false);
    private static final String EXPLAIN_PLAN_ROWS_ESTIMATE_COLUMN_NAME = "RowsEstimate";
    private static final byte[] EXPLAIN_PLAN_ROWS_ESTIMATE = PVarchar.INSTANCE.toBytes("RowsEstimate");
    public static final String EXPLAIN_PLAN_ROWS_COLUMN_ALIAS = "EST_ROWS_READ";
    private static final PColumnImpl EXPLAIN_PLAN_ROWS_ESTIMATE_COLUMN = new PColumnImpl(PNameFactory.newName(EXPLAIN_PLAN_ROWS_ESTIMATE), PNameFactory.newName(EXPLAIN_PLAN_FAMILY), PLong.INSTANCE, null, null, true, 2, SortOrder.getDefault(), 0, null, false, null, false, false, EXPLAIN_PLAN_ROWS_ESTIMATE, 0L, false);
    private static final String EXPLAIN_PLAN_ESTIMATE_INFO_TS_COLUMN_NAME = "EstimateInfoTS";
    private static final byte[] EXPLAIN_PLAN_ESTIMATE_INFO_TS = PVarchar.INSTANCE.toBytes("EstimateInfoTS");
    public static final String EXPLAIN_PLAN_ESTIMATE_INFO_TS_COLUMN_ALIAS = "EST_INFO_TS";
    private static final PColumnImpl EXPLAIN_PLAN_ESTIMATE_INFO_TS_COLUMN = new PColumnImpl(PNameFactory.newName(EXPLAIN_PLAN_ESTIMATE_INFO_TS), PNameFactory.newName(EXPLAIN_PLAN_FAMILY), PLong.INSTANCE, null, null, true, 3, SortOrder.getDefault(), 0, null, false, null, false, false, EXPLAIN_PLAN_ESTIMATE_INFO_TS, 0L, false);
    private static final RowProjector EXPLAIN_PLAN_ROW_PROJECTOR_WITH_BYTE_ROW_ESTIMATES = new RowProjector(Arrays.asList(new ExpressionProjector("PLAN", "PLAN", "PLAN_TABLE", new RowKeyColumnExpression(EXPLAIN_PLAN_DATUM, new RowKeyValueAccessor(Collections.singletonList(EXPLAIN_PLAN_DATUM), 0)), false), new ExpressionProjector("EST_BYTES_READ", "EST_BYTES_READ", "PLAN_TABLE", new KeyValueColumnExpression(EXPLAIN_PLAN_BYTES_ESTIMATE_COLUMN), false), new ExpressionProjector("EST_ROWS_READ", "EST_ROWS_READ", "PLAN_TABLE", new KeyValueColumnExpression(EXPLAIN_PLAN_ROWS_ESTIMATE_COLUMN), false), new ExpressionProjector("EST_INFO_TS", "EST_INFO_TS", "PLAN_TABLE", new KeyValueColumnExpression(EXPLAIN_PLAN_ESTIMATE_INFO_TS_COLUMN), false)), 0, true);
    protected final List<PhoenixPreparedStatement> batch = Lists.newArrayList();

    public PhoenixStatement(PhoenixConnection connection) {
        this.connection = connection;
        this.queryTimeoutMillis = this.getDefaultQueryTimeoutMillis();
        this.validateLastDdlTimestamp = ValidateLastDDLTimestampUtil.getValidateLastDdlTimestampEnabled(this.connection);
        this.explainPlanLoggingEnabled = connection.getQueryServices().getProps().getBoolean("phoenix.connection.activity.logging.explain.plan.enabled", false);
    }

    private int getDefaultQueryTimeoutMillis() {
        return this.connection.getQueryServices().getProps().getInt("phoenix.query.timeoutMs", 600000);
    }

    private void setSqlQueryParsingTime(long time) {
        this.sqlQueryParsingTime = time;
    }

    private long getSqlQueryParsingTime() {
        return this.sqlQueryParsingTime;
    }

    public PhoenixResultSet newResultSet(ResultIterator iterator, RowProjector projector, StatementContext context) throws SQLException {
        return new PhoenixResultSet(iterator, projector, context);
    }

    protected QueryPlan optimizeQuery(CompilableStatement stmt) throws SQLException {
        QueryPlan plan = (QueryPlan)stmt.compilePlan(this, Sequence.ValueOp.VALIDATE_SEQUENCE);
        return this.connection.getQueryServices().getOptimizer().optimize(this, plan);
    }

    protected PhoenixResultSet executeQuery(CompilableStatement stmt, QueryLogger queryLogger) throws SQLException {
        return this.executeQuery(stmt, true, queryLogger, false, this.validateLastDdlTimestamp);
    }

    protected PhoenixResultSet executeQuery(CompilableStatement stmt, QueryLogger queryLogger, boolean noCommit) throws SQLException {
        return this.executeQuery(stmt, true, queryLogger, noCommit, this.validateLastDdlTimestamp);
    }

    private PhoenixResultSet executeQuery(final CompilableStatement stmt, final boolean doRetryOnMetaNotFoundError, final QueryLogger queryLogger, final boolean noCommit, final boolean shouldValidateLastDdlTimestamp) throws SQLException {
        GlobalClientMetrics.GLOBAL_SELECT_SQL_COUNTER.increment();
        try {
            return (PhoenixResultSet)CallRunner.run(new CallRunner.CallableThrowable<PhoenixResultSet, SQLException>(){

                /*
                 * Exception decompiling
                 */
                @Override
                public PhoenixResultSet call() throws SQLException {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }
            }, PhoenixContextExecutor.inContext());
        }
        catch (Exception e) {
            if (queryLogger.isDebugEnabled()) {
                queryLogger.log(QueryLogInfo.EXCEPTION_TRACE_I, Throwables.getStackTraceAsString((Throwable)e));
                queryLogger.log(QueryLogInfo.QUERY_STATUS_I, QueryStatus.FAILED.toString());
                queryLogger.sync(null, null);
            }
            Throwables.propagateIfInstanceOf((Throwable)e, SQLException.class);
            Throwables.propagate((Throwable)e);
            throw new IllegalStateException();
        }
    }

    public String getTargetForAudit(CompilableStatement stmt) {
        String target = null;
        try {
            if (stmt instanceof ExecutableUpsertStatement) {
                return ((ExecutableUpsertStatement)stmt).getTable().getName().toString();
            }
            if (stmt instanceof ExecutableDeleteStatement) {
                return ((ExecutableDeleteStatement)stmt).getTable().getName().toString();
            }
            if (stmt instanceof ExecutableCreateTableStatement) {
                target = ((ExecutableCreateTableStatement)stmt).getTableName().toString();
            } else if (stmt instanceof ExecutableDropTableStatement) {
                target = ((ExecutableDropTableStatement)stmt).getTableName().toString();
            } else if (stmt instanceof ExecutableAddColumnStatement) {
                target = ((ExecutableAddColumnStatement)stmt).getTable().getName().toString();
            } else {
                if (stmt instanceof ExecutableCreateSchemaStatement) {
                    return ((ExecutableCreateSchemaStatement)stmt).getSchemaName();
                }
                if (stmt instanceof ExecutableDropSchemaStatement) {
                    target = ((ExecutableDropSchemaStatement)stmt).getSchemaName();
                }
            }
        }
        catch (Exception e) {
            target = stmt.getClass().getName();
        }
        return target;
    }

    private boolean isReturningRowStatement(CompilableStatement stmt) {
        return stmt instanceof RowReturningDMLStatement && ((RowReturningDMLStatement)((Object)stmt)).isReturningRow();
    }

    protected int executeMutation(CompilableStatement stmt, AuditQueryLogger queryLogger) throws SQLException {
        return (Integer)this.executeMutation(stmt, true, queryLogger, this.isReturningRowStatement(stmt) ? MutationState.ReturnResult.NEW_ROW_ON_SUCCESS : null).getFirst();
    }

    Pair<Integer, ResultSet> executeMutation(CompilableStatement stmt, AuditQueryLogger queryLogger, MutationState.ReturnResult returnResult) throws SQLException {
        return this.executeMutation(stmt, true, queryLogger, returnResult);
    }

    private Pair<Integer, ResultSet> executeMutation(final CompilableStatement stmt, final boolean doRetryOnMetaNotFoundError, final AuditQueryLogger queryLogger, final MutationState.ReturnResult returnResult) throws SQLException {
        if (this.connection.isReadOnly()) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.READ_ONLY_CONNECTION).build().buildException();
        }
        GlobalClientMetrics.GLOBAL_MUTATION_SQL_COUNTER.increment();
        try {
            return (Pair)CallRunner.run(new CallRunner.CallableThrowable<Pair<Integer, ResultSet>, SQLException>(){

                /*
                 * Loose catch block
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public Pair<Integer, ResultSet> call() throws SQLException {
                    Pair pair;
                    boolean success = false;
                    String tableName = null;
                    boolean isUpsert = false;
                    boolean isAtomicUpsert = false;
                    boolean isDelete = false;
                    MutationState state = null;
                    MutationPlan plan = null;
                    long startExecuteMutationTime = EnvironmentEdgeManager.currentTimeMillis();
                    PhoenixStatement.this.clearResultSet();
                    try {
                        TableName tableNameVal;
                        PhoenixConnection conn = PhoenixStatement.this.getConnection();
                        if (conn.getQueryServices().isUpgradeRequired() && !conn.isRunningUpgrade() && stmt.getOperation() != Operation.UPGRADE) {
                            throw new UpgradeRequiredException();
                        }
                        state = PhoenixStatement.this.connection.getMutationState();
                        state.setMutationQueryParsingTime(PhoenixStatement.this.getSqlQueryParsingTime());
                        isUpsert = stmt instanceof ExecutableUpsertStatement;
                        isDelete = stmt instanceof ExecutableDeleteStatement;
                        plan = isDelete && PhoenixStatement.this.connection.getAutoCommit() && (returnResult == MutationState.ReturnResult.NEW_ROW_ON_SUCCESS || returnResult == MutationState.ReturnResult.OLD_ROW_ALWAYS) ? ((ExecutableDeleteStatement)stmt).compilePlan(PhoenixStatement.this, Sequence.ValueOp.VALIDATE_SEQUENCE, returnResult) : (MutationPlan)stmt.compilePlan(PhoenixStatement.this, Sequence.ValueOp.VALIDATE_SEQUENCE);
                        boolean bl = isAtomicUpsert = isUpsert && ((ExecutableUpsertStatement)stmt).getOnDupKeyPairs() != null;
                        if (plan.getTargetRef() != null && plan.getTargetRef().getTable() != null) {
                            if (!Strings.isNullOrEmpty((String)plan.getTargetRef().getTable().getPhysicalName().toString())) {
                                tableName = plan.getTargetRef().getTable().getPhysicalName().toString();
                            }
                            if (plan.getTargetRef().getTable().isTransactional()) {
                                state.startTransaction(plan.getTargetRef().getTable().getTransactionProvider());
                            }
                        }
                        Iterator<TableRef> tableRefs = plan.getSourceRefs().iterator();
                        state.sendUncommitted(tableRefs);
                        state.checkpointIfNeccessary(plan);
                        PhoenixStatement.this.checkIfDDLStatementandMutationState(stmt, state);
                        MutationState lastState = plan.execute();
                        state.join(lastState);
                        int lastUpdateCount = (int)Math.min(Integer.MAX_VALUE, lastState.getUpdateCount());
                        Result result = null;
                        if (PhoenixStatement.this.connection.getAutoCommit()) {
                            boolean singleRowUpdate = PhoenixStatement.isSingleRowUpdatePlan(isUpsert, isDelete, plan);
                            if (singleRowUpdate) {
                                state.setReturnResult(returnResult);
                            }
                            PhoenixStatement.this.connection.commit();
                            if (isAtomicUpsert) {
                                lastUpdateCount = PhoenixStatement.this.connection.getMutationState().getNumUpdatedRowsForAutoCommit();
                            }
                            result = PhoenixStatement.this.connection.getMutationState().getResult();
                            PhoenixStatement.this.connection.getMutationState().clearResult();
                            result = PhoenixStatement.this.getResult(singleRowUpdate, isDelete, plan, lastState, result);
                        }
                        PhoenixStatement.this.setLastQueryPlan(null);
                        PhoenixStatement.this.setLastUpdateCount(lastUpdateCount);
                        PhoenixStatement.this.setLastUpdateOperation(stmt.getOperation());
                        PhoenixStatement.this.setLastUpdateTable(tableName == null ? PhoenixStatement.TABLE_UNKNOWN : tableName);
                        PhoenixStatement.this.connection.incrementStatementExecutionCounter();
                        if (queryLogger.isAuditLoggingEnabled()) {
                            queryLogger.log(QueryLogInfo.TABLE_NAME_I, PhoenixStatement.this.getTargetForAudit(stmt));
                            queryLogger.log(QueryLogInfo.QUERY_STATUS_I, QueryStatus.COMPLETED.toString());
                            queryLogger.log(QueryLogInfo.NO_OF_RESULTS_ITERATED_I, lastUpdateCount);
                            queryLogger.syncAudit();
                        }
                        success = true;
                        TableName tableName2 = isUpsert ? ((ExecutableUpsertStatement)stmt).getTable().getName() : (tableNameVal = isDelete ? ((ExecutableDeleteStatement)stmt).getTable().getName() : null);
                        ResultSet rs = result == null || result.isEmpty() ? null : TupleUtil.getResultSet(new ResultTuple(result), tableNameVal, PhoenixStatement.this.connection, !PhoenixStatement.this.isReturningRowStatement(stmt));
                        PhoenixStatement.this.setLastResultSet(rs);
                        pair = new Pair((Object)lastUpdateCount, rs);
                        if (tableName == null) return pair;
                    }
                    catch (MetaDataEntityNotFoundException e) {
                        block30: {
                            Pair pair2;
                            try {
                                if (!doRetryOnMetaNotFoundError || e.getTableName() == null) break block30;
                                if (LOGGER.isDebugEnabled()) {
                                    LOGGER.debug("Reloading table {} data from server", (Object)e.getTableName());
                                }
                                if (!new MetaDataClient(PhoenixStatement.this.connection).updateCache(PhoenixStatement.this.connection.getTenantId(), e.getSchemaName(), e.getTableName(), true).wasUpdated()) break block30;
                                pair2 = PhoenixStatement.this.executeMutation(stmt, false, queryLogger, returnResult);
                                if (tableName == null) return pair2;
                            }
                            catch (Throwable throwable) {
                                if (tableName == null) throw throwable;
                                TableMetricsManager.updateMetricsMethod(tableName, MetricType.MUTATION_SQL_COUNTER, 1L);
                                if (!isUpsert) {
                                    if (!isDelete) throw throwable;
                                }
                                long executeMutationTimeSpent = EnvironmentEdgeManager.currentTimeMillis() - startExecuteMutationTime;
                                TableMetricsManager.updateMetricsMethod(tableName, isUpsert ? MetricType.UPSERT_SQL_COUNTER : MetricType.DELETE_SQL_COUNTER, 1L);
                                TableMetricsManager.updateMetricsMethod(tableName, isUpsert ? MetricType.UPSERT_SQL_QUERY_TIME : MetricType.DELETE_SQL_QUERY_TIME, executeMutationTimeSpent);
                                if (isAtomicUpsert) {
                                    TableMetricsManager.updateMetricsMethod(tableName, MetricType.ATOMIC_UPSERT_SQL_COUNTER, 1L);
                                    TableMetricsManager.updateMetricsMethod(tableName, MetricType.ATOMIC_UPSERT_SQL_QUERY_TIME, executeMutationTimeSpent);
                                }
                                if (success) {
                                    TableMetricsManager.updateMetricsMethod(tableName, isUpsert ? MetricType.UPSERT_SUCCESS_SQL_COUNTER : MetricType.DELETE_SUCCESS_SQL_COUNTER, 1L);
                                } else {
                                    TableMetricsManager.updateMetricsMethod(tableName, isUpsert ? MetricType.UPSERT_FAILED_SQL_COUNTER : MetricType.DELETE_FAILED_SQL_COUNTER, 1L);
                                    TableMetricsManager.updateMetricsMethod(tableName, isUpsert ? MetricType.UPSERT_AGGREGATE_FAILURE_SQL_COUNTER : MetricType.DELETE_AGGREGATE_FAILURE_SQL_COUNTER, 1L);
                                }
                                if (!(plan instanceof DeleteCompiler.ServerSelectDeleteMutationPlan) && !(plan instanceof UpsertCompiler.ServerUpsertSelectMutationPlan)) {
                                    state.addExecuteMutationTime(executeMutationTimeSpent, tableName);
                                    throw throwable;
                                }
                                TableMetricsManager.updateLatencyHistogramForMutations(tableName, executeMutationTimeSpent, false);
                                throw throwable;
                            }
                            TableMetricsManager.updateMetricsMethod(tableName, MetricType.MUTATION_SQL_COUNTER, 1L);
                            if (!isUpsert) {
                                if (!isDelete) return pair2;
                            }
                            long executeMutationTimeSpent = EnvironmentEdgeManager.currentTimeMillis() - startExecuteMutationTime;
                            TableMetricsManager.updateMetricsMethod(tableName, isUpsert ? MetricType.UPSERT_SQL_COUNTER : MetricType.DELETE_SQL_COUNTER, 1L);
                            TableMetricsManager.updateMetricsMethod(tableName, isUpsert ? MetricType.UPSERT_SQL_QUERY_TIME : MetricType.DELETE_SQL_QUERY_TIME, executeMutationTimeSpent);
                            if (isAtomicUpsert) {
                                TableMetricsManager.updateMetricsMethod(tableName, MetricType.ATOMIC_UPSERT_SQL_COUNTER, 1L);
                                TableMetricsManager.updateMetricsMethod(tableName, MetricType.ATOMIC_UPSERT_SQL_QUERY_TIME, executeMutationTimeSpent);
                            }
                            if (success) {
                                TableMetricsManager.updateMetricsMethod(tableName, isUpsert ? MetricType.UPSERT_SUCCESS_SQL_COUNTER : MetricType.DELETE_SUCCESS_SQL_COUNTER, 1L);
                            } else {
                                TableMetricsManager.updateMetricsMethod(tableName, isUpsert ? MetricType.UPSERT_FAILED_SQL_COUNTER : MetricType.DELETE_FAILED_SQL_COUNTER, 1L);
                                TableMetricsManager.updateMetricsMethod(tableName, isUpsert ? MetricType.UPSERT_AGGREGATE_FAILURE_SQL_COUNTER : MetricType.DELETE_AGGREGATE_FAILURE_SQL_COUNTER, 1L);
                            }
                            if (!(plan instanceof DeleteCompiler.ServerSelectDeleteMutationPlan) && !(plan instanceof UpsertCompiler.ServerUpsertSelectMutationPlan)) {
                                state.addExecuteMutationTime(executeMutationTimeSpent, tableName);
                                return pair2;
                            }
                            TableMetricsManager.updateLatencyHistogramForMutations(tableName, executeMutationTimeSpent, false);
                            return pair2;
                        }
                        throw e;
                        catch (RuntimeException e2) {
                            if (!(e2.getCause() instanceof SQLException)) throw e2;
                            throw (SQLException)e2.getCause();
                        }
                    }
                    TableMetricsManager.updateMetricsMethod(tableName, MetricType.MUTATION_SQL_COUNTER, 1L);
                    if (!isUpsert) {
                        if (!isDelete) return pair;
                    }
                    long executeMutationTimeSpent = EnvironmentEdgeManager.currentTimeMillis() - startExecuteMutationTime;
                    TableMetricsManager.updateMetricsMethod(tableName, isUpsert ? MetricType.UPSERT_SQL_COUNTER : MetricType.DELETE_SQL_COUNTER, 1L);
                    TableMetricsManager.updateMetricsMethod(tableName, isUpsert ? MetricType.UPSERT_SQL_QUERY_TIME : MetricType.DELETE_SQL_QUERY_TIME, executeMutationTimeSpent);
                    if (isAtomicUpsert) {
                        TableMetricsManager.updateMetricsMethod(tableName, MetricType.ATOMIC_UPSERT_SQL_COUNTER, 1L);
                        TableMetricsManager.updateMetricsMethod(tableName, MetricType.ATOMIC_UPSERT_SQL_QUERY_TIME, executeMutationTimeSpent);
                    }
                    if (success) {
                        TableMetricsManager.updateMetricsMethod(tableName, isUpsert ? MetricType.UPSERT_SUCCESS_SQL_COUNTER : MetricType.DELETE_SUCCESS_SQL_COUNTER, 1L);
                    } else {
                        TableMetricsManager.updateMetricsMethod(tableName, isUpsert ? MetricType.UPSERT_FAILED_SQL_COUNTER : MetricType.DELETE_FAILED_SQL_COUNTER, 1L);
                        TableMetricsManager.updateMetricsMethod(tableName, isUpsert ? MetricType.UPSERT_AGGREGATE_FAILURE_SQL_COUNTER : MetricType.DELETE_AGGREGATE_FAILURE_SQL_COUNTER, 1L);
                    }
                    if (!(plan instanceof DeleteCompiler.ServerSelectDeleteMutationPlan) && !(plan instanceof UpsertCompiler.ServerUpsertSelectMutationPlan)) {
                        state.addExecuteMutationTime(executeMutationTimeSpent, tableName);
                        return pair;
                    }
                    TableMetricsManager.updateLatencyHistogramForMutations(tableName, executeMutationTimeSpent, false);
                    return pair;
                }
            }, PhoenixContextExecutor.inContext(), Tracing.withTracing(this.connection, this.toString()));
        }
        catch (Exception e) {
            if (queryLogger.isAuditLoggingEnabled()) {
                queryLogger.log(QueryLogInfo.TABLE_NAME_I, this.getTargetForAudit(stmt));
                queryLogger.log(QueryLogInfo.EXCEPTION_TRACE_I, Throwables.getStackTraceAsString((Throwable)e));
                queryLogger.log(QueryLogInfo.QUERY_STATUS_I, QueryStatus.FAILED.toString());
                queryLogger.syncAudit();
            }
            Throwables.propagateIfInstanceOf((Throwable)e, SQLException.class);
            Throwables.propagate((Throwable)e);
            throw new IllegalStateException();
        }
    }

    private Result getResult(boolean singleRowUpdate, boolean isDelete, MutationPlan plan, MutationState mutationState, Result result) {
        if (singleRowUpdate && isDelete && plan instanceof DeleteCompiler.ServerSelectDeleteMutationPlan) {
            result = mutationState.getResult();
        }
        return result;
    }

    private static boolean isSingleRowUpdatePlan(boolean isUpsert, boolean isDelete, MutationPlan plan) {
        boolean isSingleRowUpdate = false;
        if (isUpsert) {
            isSingleRowUpdate = true;
        } else if (isDelete) {
            isSingleRowUpdate = plan.getContext().getScanRanges().getPointLookupCount() == 1;
        }
        return isSingleRowUpdate;
    }

    public Format getFormatter(PDataType type) {
        return this.connection.getFormatter(type);
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.batch.add(new PhoenixPreparedStatement(this.connection, sql));
    }

    @Override
    public void clearBatch() throws SQLException {
        this.batch.clear();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        int i = 0;
        int[] returnCodes = new int[this.batch.size()];
        Arrays.fill(returnCodes, -1);
        boolean autoCommit = this.connection.getAutoCommit();
        this.connection.setAutoCommit(false);
        try {
            Object statement;
            for (i = 0; i < returnCodes.length; ++i) {
                statement = this.batch.get(i);
                ((PhoenixPreparedStatement)statement).executeForBatch();
                returnCodes[i] = ((PhoenixStatement)statement).getUpdateCount();
            }
            this.flushIfNecessary();
            this.clearBatch();
            if (autoCommit) {
                this.connection.commit();
            }
            statement = returnCodes;
            return statement;
        }
        catch (SQLException t) {
            if (i == returnCodes.length) {
                throw new BatchUpdateException(t);
            }
            returnCodes[i] = -3;
            throw new BatchUpdateException(returnCodes, (Throwable)t);
        }
        finally {
            this.connection.setAutoCommit(autoCommit);
        }
    }

    @Override
    public void cancel() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public void close() throws SQLException {
        try {
            this.clearResultSet();
        }
        finally {
            try {
                this.connection.removeStatement(this);
            }
            finally {
                this.isClosed = true;
            }
        }
    }

    private void clearResultSet() throws SQLException {
        if (this.lastResultSet != null) {
            try {
                this.lastResultSet.close();
            }
            finally {
                this.lastResultSet = null;
            }
        }
    }

    void removeResultSet(ResultSet rs) throws SQLException {
        if (rs == this.lastResultSet) {
            this.lastResultSet = null;
            if (this.closeOnCompletion) {
                this.close();
            }
        }
    }

    public List<Object> getParameters() {
        return Collections.emptyList();
    }

    protected CompilableStatement parseStatement(String sql) throws SQLException {
        long startQueryParsingTime = EnvironmentEdgeManager.currentTimeMillis();
        PhoenixStatementParser parser = null;
        try {
            parser = new PhoenixStatementParser(sql, (ParseNodeFactory)new ExecutableNodeFactory());
        }
        catch (IOException e) {
            throw ClientUtil.parseServerException(e);
        }
        CompilableStatement statement = parser.parseStatement();
        this.setSqlQueryParsingTime(EnvironmentEdgeManager.currentTimeMillis() - startQueryParsingTime);
        return statement;
    }

    public QueryPlan optimizeQuery(String sql) throws SQLException {
        QueryPlan plan = this.compileQuery(sql);
        return this.connection.getQueryServices().getOptimizer().optimize(this, plan);
    }

    public QueryPlan compileQuery(String sql) throws SQLException {
        CompilableStatement stmt = this.parseStatement(sql);
        return this.compileQuery(stmt, sql);
    }

    public QueryPlan compileQuery(CompilableStatement stmt, String query) throws SQLException {
        if (stmt.getOperation().isMutation()) {
            throw new ExecuteQueryNotApplicableException(query);
        }
        return (QueryPlan)stmt.compilePlan(this, Sequence.ValueOp.VALIDATE_SEQUENCE);
    }

    public MutationPlan compileMutation(CompilableStatement stmt, String query) throws SQLException {
        if (!stmt.getOperation().isMutation()) {
            throw new ExecuteUpdateNotApplicableException(query);
        }
        return (MutationPlan)stmt.compilePlan(this, Sequence.ValueOp.VALIDATE_SEQUENCE);
    }

    public MutationPlan compileMutation(String sql) throws SQLException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(LogUtil.addCustomAnnotations("Execute update: " + sql, this.connection));
        }
        CompilableStatement stmt = this.parseStatement(sql);
        return this.compileMutation(stmt, sql);
    }

    public boolean isSystemTable(CompilableStatement stmt) {
        boolean systemTable = false;
        TableName tableName = null;
        if (stmt instanceof ExecutableSelectStatement) {
            TableNode from = ((ExecutableSelectStatement)stmt).getFrom();
            if (from instanceof NamedTableNode) {
                tableName = ((NamedTableNode)from).getName();
            }
        } else if (stmt instanceof ExecutableUpsertStatement) {
            tableName = ((ExecutableUpsertStatement)stmt).getTable().getName();
        } else if (stmt instanceof ExecutableDeleteStatement) {
            tableName = ((ExecutableDeleteStatement)stmt).getTable().getName();
        } else if (stmt instanceof ExecutableAddColumnStatement) {
            tableName = ((ExecutableAddColumnStatement)stmt).getTable().getName();
        }
        if (tableName != null && "SYSTEM".equals(tableName.getSchemaName())) {
            systemTable = true;
        }
        return systemTable;
    }

    public QueryLogger createQueryLogger(CompilableStatement stmt, String sql) throws SQLException {
        if (this.connection.getLogLevel() == LogLevel.OFF) {
            return QueryLogger.NO_OP_INSTANCE;
        }
        QueryLogger queryLogger = QueryLogger.getInstance(this.connection, this.isSystemTable(stmt));
        QueryLoggerUtil.logInitialDetails(queryLogger, this.connection.getTenantId(), this.connection.getQueryServices(), sql, this.getParameters());
        return queryLogger;
    }

    public AuditQueryLogger createAuditQueryLogger(CompilableStatement stmt, String sql) throws SQLException {
        if (this.connection.getAuditLogLevel() == LogLevel.OFF) {
            return AuditQueryLogger.NO_OP_INSTANCE;
        }
        AuditQueryLogger queryLogger = AuditQueryLogger.getInstance(this.connection, this.isSystemTable(stmt));
        QueryLoggerUtil.logInitialDetails(queryLogger, this.connection.getTenantId(), this.connection.getQueryServices(), sql, this.getParameters());
        return queryLogger;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        CompilableStatement stmt;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(LogUtil.addCustomAnnotations("Execute query: " + sql, this.connection));
        }
        if ((stmt = this.parseStatement(sql)).getOperation().isMutation()) {
            throw new ExecuteQueryNotApplicableException(sql);
        }
        return this.executeQuery(stmt, this.createQueryLogger(stmt, sql));
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        CompilableStatement stmt = this.preExecuteUpdate(sql);
        int updateCount = this.executeMutation(stmt, this.createAuditQueryLogger(stmt, sql));
        this.flushIfNecessary();
        return updateCount;
    }

    public Pair<Integer, ResultSet> executeAtomicUpdateReturnRow(String sql) throws SQLException {
        if (!this.connection.getAutoCommit()) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.AUTO_COMMIT_NOT_ENABLED).build().buildException();
        }
        CompilableStatement stmt = this.preExecuteUpdate(sql);
        Pair<Integer, ResultSet> result = this.executeMutation(stmt, this.createAuditQueryLogger(stmt, sql), MutationState.ReturnResult.NEW_ROW_ON_SUCCESS);
        this.flushIfNecessary();
        return result;
    }

    public Pair<Integer, ResultSet> executeAtomicUpdateReturnOldRow(String sql) throws SQLException {
        if (!this.connection.getAutoCommit()) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.AUTO_COMMIT_NOT_ENABLED).build().buildException();
        }
        CompilableStatement stmt = this.preExecuteUpdate(sql);
        Pair<Integer, ResultSet> result = this.executeMutation(stmt, this.createAuditQueryLogger(stmt, sql), MutationState.ReturnResult.OLD_ROW_ALWAYS);
        this.flushIfNecessary();
        return result;
    }

    private CompilableStatement preExecuteUpdate(String sql) throws SQLException {
        CompilableStatement stmt = this.parseStatement(sql);
        if (!stmt.getOperation().isMutation) {
            throw new ExecuteUpdateNotApplicableException(sql);
        }
        if (!this.batch.isEmpty()) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.EXECUTE_UPDATE_WITH_NON_EMPTY_BATCH).build().buildException();
        }
        return stmt;
    }

    private void flushIfNecessary() throws SQLException {
        if (this.connection.getAutoFlush()) {
            this.connection.flush();
        }
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        CompilableStatement stmt = this.parseStatement(sql);
        if (stmt.getOperation().isMutation()) {
            if (!this.batch.isEmpty()) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.EXECUTE_UPDATE_WITH_NON_EMPTY_BATCH).build().buildException();
            }
            this.executeMutation(stmt, this.createAuditQueryLogger(stmt, sql));
            this.flushIfNecessary();
            return this.isReturningRowStatement(stmt);
        }
        this.executeQuery(stmt, this.createQueryLogger(stmt, sql));
        return true;
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.execute(sql);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.execute(sql);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.execute(sql);
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.executeUpdate(sql);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.executeUpdate(sql);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.executeUpdate(sql);
    }

    @Override
    public PhoenixConnection getConnection() {
        return this.connection;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    @Override
    public int getFetchSize() throws SQLException {
        if (this.fetchSize > 0) {
            return this.fetchSize;
        }
        return this.connection.getQueryServices().getProps().getInt("hbase.client.scanner.caching", 1000);
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return false;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return false;
    }

    public QueryPlan getQueryPlan() {
        return this.getLastQueryPlan();
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        ResultSet rs = this.getLastResultSet();
        return rs;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return 1007;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 2;
    }

    @Override
    public int getResultSetType() throws SQLException {
        return 1003;
    }

    @Override
    public Operation getUpdateOperation() {
        return this.getLastUpdateOperation();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        int updateCount = this.getLastUpdateCount();
        this.setLastUpdateCount(-1);
        return updateCount;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        if (direction != 1000) {
            throw new SQLFeatureNotSupportedException();
        }
    }

    @Override
    public void setFetchSize(int fetchSize) throws SQLException {
        this.fetchSize = fetchSize;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.maxRows = max;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        if (poolable) {
            throw new SQLFeatureNotSupportedException();
        }
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.queryTimeoutMillis = seconds < 0 ? this.getDefaultQueryTimeoutMillis() : (seconds == 0 ? Integer.MAX_VALUE : seconds * 1000);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        int scaledValue;
        try {
            scaledValue = IntMath.checkedAdd((int)this.queryTimeoutMillis, (int)999);
        }
        catch (ArithmeticException e) {
            scaledValue = Integer.MAX_VALUE;
        }
        return scaledValue / 1000;
    }

    public int getQueryTimeoutInMillis() {
        return this.queryTimeoutMillis;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (!iface.isInstance(this)) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.CLASS_NOT_UNWRAPPABLE).setMessage(this.getClass().getName() + " not unwrappable from " + iface.getName()).build().buildException();
        }
        return (T)this;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.closeOnCompletion = true;
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return this.closeOnCompletion;
    }

    private ResultSet getLastResultSet() {
        return this.lastResultSet;
    }

    void setLastResultSet(ResultSet lastResultSet) {
        this.lastResultSet = lastResultSet;
    }

    private int getLastUpdateCount() {
        return this.lastUpdateCount;
    }

    private void setLastUpdateCount(int lastUpdateCount) {
        this.lastUpdateCount = lastUpdateCount;
    }

    private String getLastUpdateTable() {
        return this.lastUpdateTable;
    }

    private void setLastUpdateTable(String lastUpdateTable) {
        if (!Strings.isNullOrEmpty((String)lastUpdateTable)) {
            this.lastUpdateTable = lastUpdateTable;
        }
        if (this.getConnection().getActivityLogger().isLevelEnabled(ActivityLogInfo.TABLE_NAME.getLogLevel())) {
            this.updateActivityOnConnection(ActivityLogInfo.TABLE_NAME, this.lastUpdateTable);
        }
    }

    private Operation getLastUpdateOperation() {
        return this.lastUpdateOperation;
    }

    private void setLastUpdateOperation(Operation lastUpdateOperation) {
        this.lastUpdateOperation = lastUpdateOperation;
        if (this.getConnection().getActivityLogger().isLevelEnabled(ActivityLogInfo.OP_NAME.getLogLevel())) {
            this.updateActivityOnConnection(ActivityLogInfo.OP_NAME, this.lastUpdateOperation.toString());
        }
        if (this.getConnection().getActivityLogger().isLevelEnabled(ActivityLogInfo.OP_TIME.getLogLevel())) {
            this.updateActivityOnConnection(ActivityLogInfo.OP_TIME, String.valueOf(EnvironmentEdgeManager.currentTimeMillis()));
        }
    }

    private QueryPlan getLastQueryPlan() {
        return this.lastQueryPlan;
    }

    private void setLastQueryPlan(QueryPlan lastQueryPlan) {
        this.lastQueryPlan = lastQueryPlan;
    }

    private void updateActivityOnConnection(ActivityLogInfo item, String value) {
        this.getConnection().getActivityLogger().log(item, value);
    }

    private void throwIfUnallowedUserDefinedFunctions(Map<String, UDFParseNode> udfParseNodes) throws SQLException {
        if (!this.connection.getQueryServices().getProps().getBoolean("phoenix.functions.allowUserDefinedFunctions", false)) {
            if (udfParseNodes.isEmpty()) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.UNALLOWED_USER_DEFINED_FUNCTIONS).build().buildException();
            }
            throw new FunctionNotFoundException(udfParseNodes.keySet().toString());
        }
    }

    private void checkIfDDLStatementandMutationState(CompilableStatement stmt, MutationState state) throws SQLException {
        boolean throwUncommittedMutation = this.connection.getQueryServices().getProps().getBoolean("phoenix.pending.mutations.before.ddl.throw", false);
        if (stmt instanceof MutableStatement && !(stmt instanceof DMLStatement) && state.getNumRows() > 0) {
            if (throwUncommittedMutation) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_PERFORM_DDL_WITH_PENDING_MUTATIONS).build().buildException();
            }
            LOGGER.warn("There are Uncommitted mutations, which will be dropped on the execution of this DDL statement.");
        }
    }

    public Calendar getLocalCalendar() {
        return this.localCalendar;
    }

    private void updateExplainPlanInformation(QueryPlan plan) throws SQLException {
        if (plan == null || !this.getConnection().getActivityLogger().isLevelEnabled(ActivityLogInfo.EXPLAIN_PLAN.getLogLevel())) {
            return;
        }
        ExplainPlan explainPlan = plan.getExplainPlan();
        ExplainPlanAttributes explainPlanAttributes = explainPlan.getPlanStepsAsAttributes();
        List<HRegionLocation> location = explainPlanAttributes.getRegionLocations();
        String regionInfo = this.getRegionInfo(location);
        String sb = Stream.of(explainPlanAttributes.getExplainScanType(), regionInfo).collect(Collectors.joining(","));
        this.updateActivityOnConnection(ActivityLogInfo.EXPLAIN_PLAN, sb);
    }

    private String getRegionInfo(List<HRegionLocation> location) {
        if (location == null || location.isEmpty()) {
            return TABLE_UNKNOWN;
        }
        String regions = location.stream().map(regionLocation -> regionLocation.getRegion().getEncodedName()).collect(Collectors.joining(","));
        String hostnames = location.stream().map(HRegionLocation::getHostname).collect(Collectors.joining(","));
        return "regions={" + regions + "}," + "hostnames" + "={" + hostnames + "}";
    }

    static /* synthetic */ boolean access$300(PhoenixStatement x0) {
        return x0.explainPlanLoggingEnabled;
    }

    static /* synthetic */ void access$400(PhoenixStatement x0, QueryPlan x1) throws SQLException {
        x0.updateExplainPlanInformation(x1);
    }

    static /* synthetic */ PhoenixResultSet access$900(PhoenixStatement x0, CompilableStatement x1, boolean x2, QueryLogger x3, boolean x4, boolean x5) throws SQLException {
        return x0.executeQuery(x1, x2, x3, x4, x5);
    }

    static /* synthetic */ QueryPlan access$1000(PhoenixStatement x0) {
        return x0.lastQueryPlan;
    }

    static /* synthetic */ QueryPlan access$1100(PhoenixStatement x0) {
        return x0.getLastQueryPlan();
    }

    static class PhoenixStatementParser
    extends SQLParser {
        PhoenixStatementParser(String query, ParseNodeFactory nodeFactory) throws IOException {
            super(query, nodeFactory);
        }

        PhoenixStatementParser(Reader reader) throws IOException {
            super(reader);
        }

        @Override
        public CompilableStatement nextStatement(ParseNodeFactory nodeFactory) throws SQLException {
            return (CompilableStatement)super.nextStatement(nodeFactory);
        }

        @Override
        public CompilableStatement parseStatement() throws SQLException {
            return (CompilableStatement)super.parseStatement();
        }
    }

    protected static class ExecutableNodeFactory
    extends ParseNodeFactory {
        protected ExecutableNodeFactory() {
        }

        @Override
        public ExecutableSelectStatement select(TableNode from, HintNode hint, boolean isDistinct, List<AliasedNode> select, ParseNode where, List<ParseNode> groupBy, ParseNode having, List<OrderByNode> orderBy, LimitNode limit, OffsetNode offset, int bindCount, boolean isAggregate, boolean hasSequence, List<SelectStatement> selects, Map<String, UDFParseNode> udfParseNodes) {
            return new ExecutableSelectStatement(from, hint, isDistinct, select, where, groupBy == null ? Collections.emptyList() : groupBy, having, orderBy == null ? Collections.emptyList() : orderBy, limit, offset, bindCount, isAggregate, hasSequence, selects == null ? Collections.emptyList() : selects, udfParseNodes);
        }

        @Override
        public ExecutableUpsertStatement upsert(NamedTableNode table, HintNode hintNode, List<ColumnName> columns, List<ParseNode> values, SelectStatement select, int bindCount, Map<String, UDFParseNode> udfParseNodes, List<Pair<ColumnName, ParseNode>> onDupKeyPairs, UpsertStatement.OnDuplicateKeyType onDupKeyType, boolean returningRow) {
            return new ExecutableUpsertStatement(table, hintNode, columns, values, select, bindCount, udfParseNodes, onDupKeyPairs, onDupKeyType, returningRow);
        }

        @Override
        public ExecutableDeclareCursorStatement declareCursor(CursorName cursor, SelectStatement select) {
            return new ExecutableDeclareCursorStatement(cursor, select);
        }

        @Override
        public ExecutableFetchStatement fetch(CursorName cursor, boolean isNext, int fetchLimit) {
            return new ExecutableFetchStatement(cursor, isNext, fetchLimit);
        }

        @Override
        public ExecutableOpenStatement open(CursorName cursor) {
            return new ExecutableOpenStatement(cursor);
        }

        @Override
        public ExecutableCloseStatement close(CursorName cursor) {
            return new ExecutableCloseStatement(cursor);
        }

        @Override
        public ExecutableDeleteStatement delete(NamedTableNode table, HintNode hint, ParseNode whereNode, List<OrderByNode> orderBy, LimitNode limit, int bindCount, Map<String, UDFParseNode> udfParseNodes, boolean returningRow) {
            return new ExecutableDeleteStatement(table, hint, whereNode, orderBy, limit, bindCount, udfParseNodes, returningRow);
        }

        @Override
        public CreateTableStatement createTable(TableName tableName, ListMultimap<String, Pair<String, Object>> props, List<ColumnDef> columns, PrimaryKeyConstraint pkConstraint, List<ParseNode> splits, PTableType tableType, boolean ifNotExists, TableName baseTableName, ParseNode tableTypeIdNode, int bindCount, Boolean immutableRows, Map<String, Integer> cqCounters, boolean noVerify) {
            return new ExecutableCreateTableStatement(tableName, props, columns, pkConstraint, splits, tableType, ifNotExists, baseTableName, tableTypeIdNode, bindCount, immutableRows, cqCounters, noVerify);
        }

        @Override
        public CreateTableStatement createTable(TableName tableName, ListMultimap<String, Pair<String, Object>> props, List<ColumnDef> columns, PrimaryKeyConstraint pkConstraint, List<ParseNode> splits, PTableType tableType, boolean ifNotExists, TableName baseTableName, ParseNode tableTypeIdNode, int bindCount, Boolean immutableRows, Map<String, Integer> cqCounters) {
            return this.createTable(tableName, props, columns, pkConstraint, splits, tableType, ifNotExists, baseTableName, tableTypeIdNode, bindCount, immutableRows, cqCounters, false);
        }

        @Override
        public CreateTableStatement createTable(TableName tableName, ListMultimap<String, Pair<String, Object>> props, List<ColumnDef> columns, PrimaryKeyConstraint pkConstraint, List<ParseNode> splits, PTableType tableType, boolean ifNotExists, TableName baseTableName, ParseNode tableTypeIdNode, int bindCount, Boolean immutableRows) {
            return this.createTable(tableName, props, columns, pkConstraint, splits, tableType, ifNotExists, baseTableName, tableTypeIdNode, bindCount, immutableRows, null);
        }

        @Override
        public CreateCDCStatement createCDC(NamedNode cdcObj, TableName dataTable, Set<PTable.CDCChangeScope> includeScopes, ListMultimap<String, Pair<String, Object>> props, boolean ifNotExists, int bindCount) {
            return new ExecutableCreateCDCStatement(cdcObj, dataTable, includeScopes, props, ifNotExists, bindCount);
        }

        @Override
        public CreateSchemaStatement createSchema(String schemaName, boolean ifNotExists) {
            return new ExecutableCreateSchemaStatement(schemaName, ifNotExists);
        }

        @Override
        public CreateSequenceStatement createSequence(TableName tableName, ParseNode startsWith, ParseNode incrementBy, ParseNode cacheSize, ParseNode minValue, ParseNode maxValue, boolean cycle, boolean ifNotExists, int bindCount) {
            return new ExecutableCreateSequenceStatement(tableName, startsWith, incrementBy, cacheSize, minValue, maxValue, cycle, ifNotExists, bindCount);
        }

        @Override
        public CreateFunctionStatement createFunction(PFunction functionInfo, boolean temporary, boolean isReplace) {
            return new ExecutableCreateFunctionStatement(functionInfo, temporary, isReplace);
        }

        @Override
        public AddJarsStatement addJars(List<LiteralParseNode> jarPaths) {
            return new ExecutableAddJarsStatement(jarPaths);
        }

        @Override
        public DeleteJarStatement deleteJar(LiteralParseNode jarPath) {
            return new ExecutableDeleteJarStatement(jarPath);
        }

        @Override
        public ListJarsStatement listJars() {
            return new ExecutableListJarsStatement();
        }

        @Override
        public DropSequenceStatement dropSequence(TableName tableName, boolean ifExists, int bindCount) {
            return new ExecutableDropSequenceStatement(tableName, ifExists, bindCount);
        }

        @Override
        public CreateIndexStatement createIndex(NamedNode indexName, NamedTableNode dataTable, IndexKeyConstraint ikConstraint, List<ColumnName> includeColumns, List<ParseNode> splits, ListMultimap<String, Pair<String, Object>> props, boolean ifNotExists, PTable.IndexType indexType, boolean async, int bindCount, Map<String, UDFParseNode> udfParseNodes, ParseNode where) {
            return new ExecutableCreateIndexStatement(indexName, dataTable, ikConstraint, includeColumns, splits, props, ifNotExists, indexType, async, bindCount, udfParseNodes, where);
        }

        @Override
        public AddColumnStatement addColumn(NamedTableNode table, PTableType tableType, List<ColumnDef> columnDefs, boolean ifNotExists, ListMultimap<String, Pair<String, Object>> props, boolean cascade, List<NamedNode> indexes) {
            return new ExecutableAddColumnStatement(table, tableType, columnDefs, ifNotExists, props, cascade, indexes);
        }

        @Override
        public DropColumnStatement dropColumn(NamedTableNode table, PTableType tableType, List<ColumnName> columnNodes, boolean ifExists) {
            return new ExecutableDropColumnStatement(table, tableType, columnNodes, ifExists);
        }

        @Override
        public DropTableStatement dropTable(TableName tableName, PTableType tableType, boolean ifExists, boolean cascade) {
            return new ExecutableDropTableStatement(tableName, tableType, ifExists, cascade);
        }

        @Override
        public DropSchemaStatement dropSchema(String schemaName, boolean ifExists, boolean cascade) {
            return new ExecutableDropSchemaStatement(schemaName, ifExists, cascade);
        }

        @Override
        public UseSchemaStatement useSchema(String schemaName) {
            return new ExecutableUseSchemaStatement(schemaName);
        }

        @Override
        public DropFunctionStatement dropFunction(String functionName, boolean ifExists) {
            return new ExecutableDropFunctionStatement(functionName, ifExists);
        }

        @Override
        public DropIndexStatement dropIndex(NamedNode indexName, TableName tableName, boolean ifExists) {
            return new ExecutableDropIndexStatement(indexName, tableName, ifExists);
        }

        @Override
        public DropCDCStatement dropCDC(NamedNode cdcObjName, TableName tableName, boolean ifExists) {
            return new ExecutableDropCDCStatement(cdcObjName, tableName, ifExists);
        }

        @Override
        public AlterIndexStatement alterIndex(NamedTableNode indexTableNode, String dataTableName, boolean ifExists, PIndexState state, boolean isRebuildAll, boolean async, ListMultimap<String, Pair<String, Object>> props) {
            return new ExecutableAlterIndexStatement(indexTableNode, dataTableName, ifExists, state, isRebuildAll, async, props);
        }

        @Override
        public TraceStatement trace(boolean isTraceOn, double samplingRate) {
            return new ExecutableTraceStatement(isTraceOn, samplingRate);
        }

        @Override
        public AlterSessionStatement alterSession(Map<String, Object> props) {
            return new ExecutableAlterSessionStatement(props);
        }

        @Override
        public ExplainStatement explain(BindableStatement statement, ExplainType explainType) {
            return new ExecutableExplainStatement(statement, explainType);
        }

        @Override
        public UpdateStatisticsStatement updateStatistics(NamedTableNode table, StatisticsCollectionScope scope, Map<String, Object> props) {
            return new ExecutableUpdateStatisticsStatement(table, scope, props);
        }

        @Override
        public ExecuteUpgradeStatement executeUpgrade() {
            return new ExecutableExecuteUpgradeStatement();
        }

        @Override
        public ExecutableChangePermsStatement changePermsStatement(String permsString, boolean isSchemaName, TableName tableName, String schemaName, boolean isGroupName, LiteralParseNode userOrGroup, boolean isGrantStatement) {
            return new ExecutableChangePermsStatement(permsString, isSchemaName, tableName, schemaName, isGroupName, userOrGroup, isGrantStatement);
        }

        @Override
        public ShowTablesStatement showTablesStatement(String schema, String pattern) {
            return new ExecutableShowTablesStatement(schema, pattern);
        }

        @Override
        public ShowSchemasStatement showSchemasStatement(String pattern) {
            return new ExecutableShowSchemasStatement(pattern);
        }

        @Override
        public ShowCreateTable showCreateTable(TableName tableName) {
            return new ExecutableShowCreateTable(tableName);
        }
    }

    private static class ExecutableDropColumnStatement
    extends DropColumnStatement
    implements CompilableStatement {
        ExecutableDropColumnStatement(NamedTableNode table, PTableType tableType, List<ColumnName> columnRefs, boolean ifExists) {
            super(table, tableType, columnRefs, ifExists);
        }

        public MutationPlan compilePlan(PhoenixStatement stmt, Sequence.ValueOp seqAction) throws SQLException {
            StatementContext context = new StatementContext(stmt);
            return new BaseMutationPlan(context, this.getOperation()){

                @Override
                public ExplainPlan getExplainPlan() throws SQLException {
                    return new ExplainPlan(Collections.singletonList("ALTER " + (Object)((Object)this.getTableType()) + " DROP COLUMN"));
                }

                @Override
                public MutationState execute() throws SQLException {
                    MetaDataClient client = new MetaDataClient(this.getContext().getConnection());
                    return client.dropColumn(this);
                }
            };
        }
    }

    private static class ExecutableAddColumnStatement
    extends AddColumnStatement
    implements CompilableStatement {
        ExecutableAddColumnStatement(NamedTableNode table, PTableType tableType, List<ColumnDef> columnDefs, boolean ifNotExists, ListMultimap<String, Pair<String, Object>> props, boolean cascade, List<NamedNode> indexes) {
            super(table, tableType, columnDefs, ifNotExists, props, cascade, indexes);
        }

        public MutationPlan compilePlan(PhoenixStatement stmt, Sequence.ValueOp seqAction) throws SQLException {
            StatementContext context = new StatementContext(stmt);
            return new BaseMutationPlan(context, this.getOperation()){

                @Override
                public ExplainPlan getExplainPlan() throws SQLException {
                    return new ExplainPlan(Collections.singletonList("ALTER " + (Object)((Object)this.getTableType()) + " ADD COLUMN"));
                }

                @Override
                public MutationState execute() throws SQLException {
                    MetaDataClient client = new MetaDataClient(this.getContext().getConnection());
                    return client.addColumn(this);
                }
            };
        }
    }

    private static class ExecutableExecuteUpgradeStatement
    extends ExecuteUpgradeStatement
    implements CompilableStatement {
        private ExecutableExecuteUpgradeStatement() {
        }

        public MutationPlan compilePlan(final PhoenixStatement stmt, Sequence.ValueOp seqAction) throws SQLException {
            return new MutationPlan(){

                @Override
                public Set<TableRef> getSourceRefs() {
                    return Collections.emptySet();
                }

                @Override
                public ParameterMetaData getParameterMetaData() {
                    return PhoenixParameterMetaData.EMPTY_PARAMETER_META_DATA;
                }

                @Override
                public Operation getOperation() {
                    return Operation.UPGRADE;
                }

                @Override
                public ExplainPlan getExplainPlan() throws SQLException {
                    return new ExplainPlan(Collections.singletonList("EXECUTE UPGRADE"));
                }

                @Override
                public QueryPlan getQueryPlan() {
                    return null;
                }

                @Override
                public StatementContext getContext() {
                    return new StatementContext(stmt);
                }

                @Override
                public TableRef getTargetRef() {
                    return TableRef.EMPTY_TABLE_REF;
                }

                @Override
                public MutationState execute() throws SQLException {
                    PhoenixConnection phxConn = stmt.getConnection();
                    Properties props = new Properties();
                    phxConn.getQueryServices().upgradeSystemTables(phxConn.getURL(), props);
                    return MutationState.emptyMutationState(-1, -1L, phxConn);
                }

                @Override
                public Long getEstimatedRowsToScan() throws SQLException {
                    return 0L;
                }

                @Override
                public Long getEstimatedBytesToScan() throws SQLException {
                    return 0L;
                }

                @Override
                public Long getEstimateInfoTimestamp() throws SQLException {
                    return 0L;
                }
            };
        }
    }

    private static class ExecutableUpdateStatisticsStatement
    extends UpdateStatisticsStatement
    implements CompilableStatement {
        public ExecutableUpdateStatisticsStatement(NamedTableNode table, StatisticsCollectionScope scope, Map<String, Object> props) {
            super(table, scope, props);
        }

        public MutationPlan compilePlan(PhoenixStatement stmt, Sequence.ValueOp seqAction) throws SQLException {
            StatementContext context = new StatementContext(stmt);
            return new BaseMutationPlan(context, this.getOperation()){

                @Override
                public ExplainPlan getExplainPlan() throws SQLException {
                    return new ExplainPlan(Collections.singletonList("UPDATE STATISTICS"));
                }

                @Override
                public MutationState execute() throws SQLException {
                    MetaDataClient client = new MetaDataClient(this.getContext().getConnection());
                    return client.updateStatistics(this);
                }
            };
        }
    }

    private static class ExecutableAlterSessionStatement
    extends AlterSessionStatement
    implements CompilableStatement {
        public ExecutableAlterSessionStatement(Map<String, Object> props) {
            super(props);
        }

        public MutationPlan compilePlan(PhoenixStatement stmt, Sequence.ValueOp seqAction) throws SQLException {
            StatementContext context = new StatementContext(stmt);
            return new CustomMutationPlan(context);
        }

        private class CustomMutationPlan
        extends BaseMutationPlan {
            private final StatementContext context;

            private CustomMutationPlan(StatementContext context) {
                super(context, ExecutableAlterSessionStatement.this.getOperation());
                this.context = context;
            }

            @Override
            public StatementContext getContext() {
                return this.context;
            }

            @Override
            public ParameterMetaData getParameterMetaData() {
                return PhoenixParameterMetaData.EMPTY_PARAMETER_META_DATA;
            }

            @Override
            public ExplainPlan getExplainPlan() throws SQLException {
                return new ExplainPlan(Collections.singletonList("ALTER SESSION"));
            }

            @Override
            public MutationState execute() throws SQLException {
                Object consistency = ExecutableAlterSessionStatement.this.getProps().get("Consistency".toUpperCase());
                if (consistency != null) {
                    if (((String)consistency).equalsIgnoreCase(Consistency.TIMELINE.toString())) {
                        this.getContext().getConnection().setConsistency(Consistency.TIMELINE);
                    } else {
                        this.getContext().getConnection().setConsistency(Consistency.STRONG);
                    }
                }
                return new MutationState(0, 0L, this.context.getConnection());
            }
        }
    }

    private static class ExecutableTraceStatement
    extends TraceStatement
    implements CompilableStatement {
        public ExecutableTraceStatement(boolean isTraceOn, double samplingRate) {
            super(isTraceOn, samplingRate);
        }

        public QueryPlan compilePlan(PhoenixStatement stmt, Sequence.ValueOp seqAction) throws SQLException {
            return new TraceQueryPlan(this, stmt);
        }
    }

    private static class ExecutableAlterIndexStatement
    extends AlterIndexStatement
    implements CompilableStatement {
        public ExecutableAlterIndexStatement(NamedTableNode indexTableNode, String dataTableName, boolean ifExists, PIndexState state, boolean isRebuildAll, boolean async, ListMultimap<String, Pair<String, Object>> props) {
            super(indexTableNode, dataTableName, ifExists, state, isRebuildAll, async, props);
        }

        public MutationPlan compilePlan(PhoenixStatement stmt, Sequence.ValueOp seqAction) throws SQLException {
            StatementContext context = new StatementContext(stmt);
            return new BaseMutationPlan(context, this.getOperation()){

                @Override
                public ExplainPlan getExplainPlan() throws SQLException {
                    return new ExplainPlan(Collections.singletonList("ALTER INDEX"));
                }

                @Override
                public MutationState execute() throws SQLException {
                    MetaDataClient client = new MetaDataClient(this.getContext().getConnection());
                    return client.alterIndex(this);
                }
            };
        }
    }

    private static class ExecutableDropCDCStatement
    extends DropCDCStatement
    implements CompilableStatement {
        public ExecutableDropCDCStatement(NamedNode cdcObjName, TableName tableName, boolean ifExists) {
            super(cdcObjName, tableName, ifExists);
        }

        public MutationPlan compilePlan(PhoenixStatement stmt, Sequence.ValueOp seqAction) throws SQLException {
            StatementContext context = new StatementContext(stmt);
            return new BaseMutationPlan(context, this.getOperation()){

                @Override
                public ExplainPlan getExplainPlan() throws SQLException {
                    return new ExplainPlan(Collections.singletonList("DROP CDC"));
                }

                @Override
                public MutationState execute() throws SQLException {
                    MetaDataClient client = new MetaDataClient(this.getContext().getConnection());
                    return client.dropCDC(this);
                }
            };
        }
    }

    private static class ExecutableDropIndexStatement
    extends DropIndexStatement
    implements CompilableStatement {
        public ExecutableDropIndexStatement(NamedNode indexName, TableName tableName, boolean ifExists) {
            super(indexName, tableName, ifExists);
        }

        public MutationPlan compilePlan(PhoenixStatement stmt, Sequence.ValueOp seqAction) throws SQLException {
            StatementContext context = new StatementContext(stmt);
            return new BaseMutationPlan(context, this.getOperation()){

                @Override
                public ExplainPlan getExplainPlan() throws SQLException {
                    return new ExplainPlan(Collections.singletonList("DROP INDEX"));
                }

                @Override
                public MutationState execute() throws SQLException {
                    String indexName = this.getIndexName().getName();
                    if (CDCUtil.isCDCIndex(indexName)) {
                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_DROP_CDC_INDEX).setTableName(indexName).build().buildException();
                    }
                    MetaDataClient client = new MetaDataClient(this.getContext().getConnection());
                    return client.dropIndex(this);
                }
            };
        }
    }

    private static class ExecutableChangePermsStatement
    extends ChangePermsStatement
    implements CompilableStatement {
        public ExecutableChangePermsStatement(String permsString, boolean isSchemaName, TableName tableName, String schemaName, boolean isGroupName, LiteralParseNode userOrGroup, boolean isGrantStatement) {
            super(permsString, isSchemaName, tableName, schemaName, isGroupName, userOrGroup, isGrantStatement);
        }

        public MutationPlan compilePlan(PhoenixStatement stmt, Sequence.ValueOp seqAction) throws SQLException {
            StatementContext context = new StatementContext(stmt);
            return new BaseMutationPlan(context, this.getOperation()){

                @Override
                public ExplainPlan getExplainPlan() throws SQLException {
                    return new ExplainPlan(Collections.singletonList("GRANT PERMISSION"));
                }

                @Override
                public MutationState execute() throws SQLException {
                    MetaDataClient client = new MetaDataClient(this.getContext().getConnection());
                    return client.changePermissions(this);
                }
            };
        }
    }

    private static class ExecutableUseSchemaStatement
    extends UseSchemaStatement
    implements CompilableStatement {
        ExecutableUseSchemaStatement(String schemaName) {
            super(schemaName);
        }

        public MutationPlan compilePlan(PhoenixStatement stmt, Sequence.ValueOp seqAction) throws SQLException {
            StatementContext context = new StatementContext(stmt);
            return new BaseMutationPlan(context, this.getOperation()){

                @Override
                public ExplainPlan getExplainPlan() throws SQLException {
                    return new ExplainPlan(Collections.singletonList("USE SCHEMA"));
                }

                @Override
                public MutationState execute() throws SQLException {
                    MetaDataClient client = new MetaDataClient(this.getContext().getConnection());
                    return client.useSchema(this);
                }
            };
        }
    }

    private static class ExecutableDropSchemaStatement
    extends DropSchemaStatement
    implements CompilableStatement {
        ExecutableDropSchemaStatement(String schemaName, boolean ifExists, boolean cascade) {
            super(schemaName, ifExists, cascade);
        }

        public MutationPlan compilePlan(PhoenixStatement stmt, Sequence.ValueOp seqAction) throws SQLException {
            StatementContext context = new StatementContext(stmt);
            return new BaseMutationPlan(context, this.getOperation()){

                @Override
                public ExplainPlan getExplainPlan() throws SQLException {
                    return new ExplainPlan(Collections.singletonList("DROP SCHEMA"));
                }

                @Override
                public MutationState execute() throws SQLException {
                    MetaDataClient client = new MetaDataClient(this.getContext().getConnection());
                    return client.dropSchema(this);
                }
            };
        }
    }

    private static class ExecutableDropTableStatement
    extends DropTableStatement
    implements CompilableStatement {
        ExecutableDropTableStatement(TableName tableName, PTableType tableType, boolean ifExists, boolean cascade) {
            super(tableName, tableType, ifExists, cascade, false);
        }

        public MutationPlan compilePlan(PhoenixStatement stmt, Sequence.ValueOp seqAction) throws SQLException {
            StatementContext context = new StatementContext(stmt);
            return new BaseMutationPlan(context, this.getOperation()){

                @Override
                public ExplainPlan getExplainPlan() throws SQLException {
                    return new ExplainPlan(Collections.singletonList("DROP TABLE"));
                }

                @Override
                public MutationState execute() throws SQLException {
                    MetaDataClient client = new MetaDataClient(this.getContext().getConnection());
                    return client.dropTable(this);
                }
            };
        }
    }

    private static class ExecutableDropSequenceStatement
    extends DropSequenceStatement
    implements CompilableStatement {
        public ExecutableDropSequenceStatement(TableName sequenceName, boolean ifExists, int bindCount) {
            super(sequenceName, ifExists, bindCount);
        }

        public MutationPlan compilePlan(PhoenixStatement stmt, Sequence.ValueOp seqAction) throws SQLException {
            DropSequenceCompiler compiler = new DropSequenceCompiler(stmt, this.getOperation());
            return compiler.compile(this);
        }
    }

    private static class ExecutableCreateSequenceStatement
    extends CreateSequenceStatement
    implements CompilableStatement {
        public ExecutableCreateSequenceStatement(TableName sequenceName, ParseNode startWith, ParseNode incrementBy, ParseNode cacheSize, ParseNode minValue, ParseNode maxValue, boolean cycle, boolean ifNotExists, int bindCount) {
            super(sequenceName, startWith, incrementBy, cacheSize, minValue, maxValue, cycle, ifNotExists, bindCount);
        }

        public MutationPlan compilePlan(PhoenixStatement stmt, Sequence.ValueOp seqAction) throws SQLException {
            CreateSequenceCompiler compiler = new CreateSequenceCompiler(stmt, this.getOperation());
            return compiler.compile(this);
        }
    }

    private static class ExecutableCreateIndexStatement
    extends CreateIndexStatement
    implements CompilableStatement {
        public ExecutableCreateIndexStatement(NamedNode indexName, NamedTableNode dataTable, IndexKeyConstraint ikConstraint, List<ColumnName> includeColumns, List<ParseNode> splits, ListMultimap<String, Pair<String, Object>> props, boolean ifNotExists, PTable.IndexType indexType, boolean async, int bindCount, Map<String, UDFParseNode> udfParseNodes, ParseNode where) {
            super(indexName, dataTable, ikConstraint, includeColumns, splits, props, ifNotExists, indexType, async, bindCount, udfParseNodes, where);
        }

        public MutationPlan compilePlan(PhoenixStatement stmt, Sequence.ValueOp seqAction) throws SQLException {
            if (!this.getUdfParseNodes().isEmpty()) {
                stmt.throwIfUnallowedUserDefinedFunctions(this.getUdfParseNodes());
            }
            CreateIndexCompiler compiler = new CreateIndexCompiler(stmt, this.getOperation());
            return compiler.compile(this);
        }
    }

    private static class ExecutableShowCreateTable
    extends ShowCreateTableStatement
    implements CompilableStatement {
        public ExecutableShowCreateTable(TableName tableName) {
            super(tableName);
        }

        public QueryPlan compilePlan(PhoenixStatement stmt, Sequence.ValueOp seqAction) throws SQLException {
            PreparedStatement delegateStmt = QueryUtil.getShowCreateTableStmt(stmt.getConnection(), null, this.getTableName());
            return ((PhoenixPreparedStatement)delegateStmt).compileQuery();
        }
    }

    private static class ExecutableShowSchemasStatement
    extends ShowSchemasStatement
    implements CompilableStatement {
        public ExecutableShowSchemasStatement(String pattern) {
            super(pattern);
        }

        public QueryPlan compilePlan(PhoenixStatement stmt, Sequence.ValueOp seqAction) throws SQLException {
            PreparedStatement delegateStmt = QueryUtil.getSchemasStmt(stmt.getConnection(), null, this.getSchemaPattern());
            return ((PhoenixPreparedStatement)delegateStmt).compileQuery();
        }
    }

    private static class ExecutableShowTablesStatement
    extends ShowTablesStatement
    implements CompilableStatement {
        public ExecutableShowTablesStatement(String schema, String pattern) {
            super(schema, pattern);
        }

        public QueryPlan compilePlan(PhoenixStatement stmt, Sequence.ValueOp seqAction) throws SQLException {
            PreparedStatement delegateStmt = QueryUtil.getTablesStmt(stmt.getConnection(), null, this.getTargetSchema(), this.getDbPattern(), null);
            return ((PhoenixPreparedStatement)delegateStmt).compileQuery();
        }
    }

    private static class ExecutableListJarsStatement
    extends ListJarsStatement
    implements CompilableStatement {
        public QueryPlan compilePlan(PhoenixStatement stmt, Sequence.ValueOp seqAction) throws SQLException {
            return new ListJarsQueryPlan(stmt);
        }
    }

    private static class ExecutableDeleteJarStatement
    extends DeleteJarStatement
    implements CompilableStatement {
        public ExecutableDeleteJarStatement(LiteralParseNode jarPath) {
            super(jarPath);
        }

        public MutationPlan compilePlan(PhoenixStatement stmt, Sequence.ValueOp seqAction) throws SQLException {
            StatementContext context = new StatementContext(stmt);
            return new CustomMutationPlan(context, stmt);
        }

        private class CustomMutationPlan
        extends BaseMutationPlan {
            private final StatementContext context;
            private final PhoenixStatement stmt;

            private CustomMutationPlan(StatementContext context, PhoenixStatement stmt) {
                super(context, ExecutableDeleteJarStatement.this.getOperation());
                this.context = context;
                this.stmt = stmt;
            }

            @Override
            public ParameterMetaData getParameterMetaData() {
                return PhoenixParameterMetaData.EMPTY_PARAMETER_META_DATA;
            }

            @Override
            public ExplainPlan getExplainPlan() throws SQLException {
                return new ExplainPlan(Collections.singletonList("DELETE JAR"));
            }

            @Override
            public MutationState execute() throws SQLException {
                String dynamicJarsDir = this.stmt.getConnection().getQueryServices().getProps().get("hbase.dynamic.jars.dir");
                if (dynamicJarsDir == null) {
                    throw new SQLException("hbase.dynamic.jars.dir is not configured.");
                }
                dynamicJarsDir = dynamicJarsDir.endsWith("/") ? dynamicJarsDir : dynamicJarsDir + '/';
                Configuration conf = HBaseFactoryProvider.getConfigurationFactory().getConfiguration();
                Path dynamicJarsDirPath = new Path(dynamicJarsDir);
                try {
                    FileSystem fs = dynamicJarsDirPath.getFileSystem(conf);
                    String jarPathStr = (String)ExecutableDeleteJarStatement.this.getJarPath().getValue();
                    if (!jarPathStr.endsWith(".jar")) {
                        throw new SQLException(jarPathStr + " is not a valid jar file path.");
                    }
                    Path p = new Path(jarPathStr);
                    if (fs.exists(p)) {
                        fs.delete(p, false);
                    }
                }
                catch (IOException e) {
                    throw new SQLException(e);
                }
                return new MutationState(0, 0L, this.context.getConnection());
            }
        }
    }

    private static class ExecutableFetchStatement
    extends FetchStatement
    implements CompilableStatement {
        public ExecutableFetchStatement(CursorName cursor, boolean isNext, int fetchLimit) {
            super(cursor, isNext, fetchLimit);
        }

        public QueryPlan compilePlan(PhoenixStatement stmt, Sequence.ValueOp seqAction) throws SQLException {
            return CursorUtil.getFetchPlan(this.getCursorName().getName(), this.isNext(), this.getFetchSize());
        }
    }

    private static class ExecutableCloseStatement
    extends CloseStatement
    implements CompilableStatement {
        public ExecutableCloseStatement(CursorName cursor) {
            super(cursor);
        }

        public MutationPlan compilePlan(PhoenixStatement stmt, Sequence.ValueOp seqAction) throws SQLException {
            CloseStatementCompiler compiler = new CloseStatementCompiler(stmt, this.getOperation());
            return compiler.compile(this);
        }
    }

    private static class ExecutableOpenStatement
    extends OpenStatement
    implements CompilableStatement {
        public ExecutableOpenStatement(CursorName cursor) {
            super(cursor);
        }

        public MutationPlan compilePlan(PhoenixStatement stmt, Sequence.ValueOp seqAction) throws SQLException {
            OpenStatementCompiler compiler = new OpenStatementCompiler(stmt, this.getOperation());
            return compiler.compile(this);
        }
    }

    private static class ExecutableDeclareCursorStatement
    extends DeclareCursorStatement
    implements CompilableStatement {
        public ExecutableDeclareCursorStatement(CursorName cursor, SelectStatement select) {
            super(cursor, select);
        }

        public MutationPlan compilePlan(PhoenixStatement stmt, Sequence.ValueOp seqAction) throws SQLException {
            ExecutableSelectStatement wrappedSelect = new ExecutableSelectStatement((ExecutableSelectStatement)stmt.parseStatement(this.getQuerySQL()));
            DeclareCursorCompiler compiler = new DeclareCursorCompiler(stmt, this.getOperation(), wrappedSelect.compilePlan(stmt, seqAction));
            return compiler.compile(this);
        }
    }

    private static class ExecutableAddJarsStatement
    extends AddJarsStatement
    implements CompilableStatement {
        public ExecutableAddJarsStatement(List<LiteralParseNode> jarPaths) {
            super(jarPaths);
        }

        public MutationPlan compilePlan(PhoenixStatement stmt, Sequence.ValueOp seqAction) throws SQLException {
            StatementContext context = new StatementContext(stmt);
            return new CustomMutationPlan(context, stmt);
        }

        private class CustomMutationPlan
        extends BaseMutationPlan {
            private final StatementContext context;
            private final PhoenixStatement stmt;

            private CustomMutationPlan(StatementContext context, PhoenixStatement stmt) {
                super(context, ExecutableAddJarsStatement.this.getOperation());
                this.context = context;
                this.stmt = stmt;
            }

            @Override
            public ParameterMetaData getParameterMetaData() {
                return PhoenixParameterMetaData.EMPTY_PARAMETER_META_DATA;
            }

            @Override
            public ExplainPlan getExplainPlan() throws SQLException {
                return new ExplainPlan(Collections.singletonList("ADD JARS"));
            }

            @Override
            public MutationState execute() throws SQLException {
                String dynamicJarsDir = this.stmt.getConnection().getQueryServices().getProps().get("hbase.dynamic.jars.dir");
                if (dynamicJarsDir == null) {
                    throw new SQLException("hbase.dynamic.jars.dir is not configured for placing the jars.");
                }
                dynamicJarsDir = dynamicJarsDir.endsWith("/") ? dynamicJarsDir : dynamicJarsDir + '/';
                Configuration conf = HBaseFactoryProvider.getConfigurationFactory().getConfiguration();
                Path dynamicJarsDirPath = new Path(dynamicJarsDir);
                for (LiteralParseNode jarPath : ExecutableAddJarsStatement.this.getJarPaths()) {
                    String jarPathStr = (String)jarPath.getValue();
                    if (jarPathStr.endsWith(".jar")) continue;
                    throw new SQLException(jarPathStr + " is not a valid jar file path.");
                }
                try {
                    FileSystem fs = dynamicJarsDirPath.getFileSystem(conf);
                    List<LiteralParseNode> jarPaths = ExecutableAddJarsStatement.this.getJarPaths();
                    for (LiteralParseNode jarPath : jarPaths) {
                        File f = new File((String)jarPath.getValue());
                        fs.copyFromLocalFile(new Path(f.getAbsolutePath()), new Path(dynamicJarsDir + f.getName()));
                    }
                }
                catch (IOException e) {
                    throw new SQLException(e);
                }
                return new MutationState(0, 0L, this.context.getConnection());
            }
        }
    }

    private static class ExecutableDropFunctionStatement
    extends DropFunctionStatement
    implements CompilableStatement {
        public ExecutableDropFunctionStatement(String functionName, boolean ifNotExists) {
            super(functionName, ifNotExists);
        }

        public MutationPlan compilePlan(PhoenixStatement stmt, Sequence.ValueOp seqAction) throws SQLException {
            StatementContext context = new StatementContext(stmt);
            return new BaseMutationPlan(context, this.getOperation()){

                @Override
                public ParameterMetaData getParameterMetaData() {
                    return PhoenixParameterMetaData.EMPTY_PARAMETER_META_DATA;
                }

                @Override
                public ExplainPlan getExplainPlan() throws SQLException {
                    return new ExplainPlan(Collections.singletonList("DROP FUNCTION"));
                }

                @Override
                public MutationState execute() throws SQLException {
                    MetaDataClient client = new MetaDataClient(this.getContext().getConnection());
                    return client.dropFunction(this);
                }
            };
        }
    }

    private static class ExecutableCreateFunctionStatement
    extends CreateFunctionStatement
    implements CompilableStatement {
        public ExecutableCreateFunctionStatement(PFunction functionInfo, boolean temporary, boolean isReplace) {
            super(functionInfo, temporary, isReplace);
        }

        public MutationPlan compilePlan(PhoenixStatement stmt, Sequence.ValueOp seqAction) throws SQLException {
            stmt.throwIfUnallowedUserDefinedFunctions(Collections.EMPTY_MAP);
            CreateFunctionCompiler compiler = new CreateFunctionCompiler(stmt);
            return compiler.compile(this);
        }
    }

    private static class ExecutableCreateSchemaStatement
    extends CreateSchemaStatement
    implements CompilableStatement {
        ExecutableCreateSchemaStatement(String schemaName, boolean ifNotExists) {
            super(schemaName, ifNotExists);
        }

        public MutationPlan compilePlan(PhoenixStatement stmt, Sequence.ValueOp seqAction) throws SQLException {
            CreateSchemaCompiler compiler = new CreateSchemaCompiler(stmt);
            return compiler.compile(this);
        }
    }

    private static class ExecutableCreateCDCStatement
    extends CreateCDCStatement
    implements CompilableStatement {
        public ExecutableCreateCDCStatement(NamedNode cdcObjName, TableName dataTable, Set<PTable.CDCChangeScope> includeScopes, ListMultimap<String, Pair<String, Object>> props, boolean ifNotExists, int bindCount) {
            super(cdcObjName, dataTable, includeScopes, props, ifNotExists, bindCount);
        }

        public MutationPlan compilePlan(PhoenixStatement stmt, Sequence.ValueOp seqAction) throws SQLException {
            StatementContext context = new StatementContext(stmt);
            return new BaseMutationPlan(context, this.getOperation()){

                @Override
                public ExplainPlan getExplainPlan() throws SQLException {
                    return new ExplainPlan(Collections.singletonList("CREATE CDC"));
                }

                @Override
                public MutationState execute() throws SQLException {
                    MetaDataClient client = new MetaDataClient(this.getContext().getConnection());
                    return client.createCDC(this);
                }
            };
        }
    }

    private static class ExecutableCreateTableStatement
    extends CreateTableStatement
    implements CompilableStatement {
        ExecutableCreateTableStatement(TableName tableName, ListMultimap<String, Pair<String, Object>> props, List<ColumnDef> columnDefs, PrimaryKeyConstraint pkConstraint, List<ParseNode> splitNodes, PTableType tableType, boolean ifNotExists, TableName baseTableName, ParseNode tableTypeIdNode, int bindCount, Boolean immutableRows, Map<String, Integer> familyCounters, boolean noVerify) {
            super(tableName, props, columnDefs, pkConstraint, splitNodes, tableType, ifNotExists, baseTableName, tableTypeIdNode, bindCount, immutableRows, familyCounters, noVerify);
        }

        public MutationPlan compilePlan(PhoenixStatement stmt, Sequence.ValueOp seqAction) throws SQLException {
            CreateTableCompiler compiler = new CreateTableCompiler(stmt, this.getOperation());
            return compiler.compile(this);
        }
    }

    private static class ExecutableDeleteStatement
    extends DeleteStatement
    implements CompilableStatement {
        private ExecutableDeleteStatement(NamedTableNode table, HintNode hint, ParseNode whereNode, List<OrderByNode> orderBy, LimitNode limit, int bindCount, Map<String, UDFParseNode> udfParseNodes, boolean returningRow) {
            super(table, hint, whereNode, orderBy, limit, bindCount, udfParseNodes, returningRow);
        }

        public MutationPlan compilePlan(PhoenixStatement stmt, Sequence.ValueOp seqAction) throws SQLException {
            if (!this.getUdfParseNodes().isEmpty()) {
                stmt.throwIfUnallowedUserDefinedFunctions(this.getUdfParseNodes());
            }
            DeleteCompiler compiler = new DeleteCompiler(stmt, this.getOperation());
            MutationPlan plan = compiler.compile(this);
            plan.getContext().getSequenceManager().validateSequences(seqAction);
            return plan;
        }

        public MutationPlan compilePlan(PhoenixStatement stmt, Sequence.ValueOp seqAction, MutationState.ReturnResult returnResult) throws SQLException {
            if (!this.getUdfParseNodes().isEmpty()) {
                stmt.throwIfUnallowedUserDefinedFunctions(this.getUdfParseNodes());
            }
            DeleteCompiler compiler = new DeleteCompiler(stmt, this.getOperation());
            MutationPlan plan = compiler.compile(this, returnResult);
            plan.getContext().getSequenceManager().validateSequences(seqAction);
            return plan;
        }
    }

    private static class ExecutableUpsertStatement
    extends UpsertStatement
    implements CompilableStatement {
        private ExecutableUpsertStatement(NamedTableNode table, HintNode hintNode, List<ColumnName> columns, List<ParseNode> values, SelectStatement select, int bindCount, Map<String, UDFParseNode> udfParseNodes, List<Pair<ColumnName, ParseNode>> onDupKeyPairs, UpsertStatement.OnDuplicateKeyType onDupKeyType, boolean returningRow) {
            super(table, hintNode, columns, values, select, bindCount, udfParseNodes, onDupKeyPairs, onDupKeyType, returningRow);
        }

        public MutationPlan compilePlan(PhoenixStatement stmt, Sequence.ValueOp seqAction) throws SQLException {
            if (!this.getUdfParseNodes().isEmpty()) {
                stmt.throwIfUnallowedUserDefinedFunctions(this.getUdfParseNodes());
            }
            UpsertCompiler compiler = new UpsertCompiler(stmt, this.getOperation());
            MutationPlan plan = compiler.compile(this);
            plan.getContext().getSequenceManager().validateSequences(seqAction);
            return plan;
        }
    }

    private static class ExecutableExplainStatement
    extends ExplainStatement
    implements CompilableStatement {
        ExecutableExplainStatement(BindableStatement statement, ExplainType explainType) {
            super(statement, explainType);
        }

        @Override
        public CompilableStatement getStatement() {
            return (CompilableStatement)super.getStatement();
        }

        @Override
        public int getBindCount() {
            return this.getStatement().getBindCount();
        }

        public QueryPlan compilePlan(PhoenixStatement stmt, Sequence.ValueOp seqAction) throws SQLException {
            CompilableStatement compilableStmt = this.getStatement();
            Object compilePlan = compilableStmt.compilePlan(stmt, Sequence.ValueOp.VALIDATE_SEQUENCE);
            if (ValidateLastDDLTimestampUtil.getValidateLastDdlTimestampEnabled(stmt.getConnection())) {
                Set<TableRef> tableRefs = compilePlan.getSourceRefs();
                for (TableRef tableRef : tableRefs) {
                    new MetaDataClient(stmt.getConnection()).updateCache(stmt.getConnection().getTenantId(), tableRef.getTable().getSchemaName().getString(), tableRef.getTable().getTableName().getString(), true);
                }
                compilePlan = compilableStmt.compilePlan(stmt, Sequence.ValueOp.VALIDATE_SEQUENCE);
            }
            if (compilePlan instanceof QueryPlan) {
                QueryPlan dataPlan = (QueryPlan)compilePlan;
                compilePlan = stmt.getConnection().getQueryServices().getOptimizer().optimize(stmt, dataPlan);
            }
            Object plan = compilePlan;
            List<String> planSteps = plan.getExplainPlan().getPlanSteps();
            ExplainType explainType = this.getExplainType();
            if (explainType == ExplainType.DEFAULT) {
                ArrayList<String> updatedExplainPlanSteps = new ArrayList<String>(planSteps);
                updatedExplainPlanSteps.removeIf(planStep -> planStep != null && planStep.contains(" (region locations = "));
                planSteps = Collections.unmodifiableList(updatedExplainPlanSteps);
            }
            ArrayList tuples = Lists.newArrayListWithExpectedSize((int)planSteps.size());
            Long estimatedBytesToScan = plan.getEstimatedBytesToScan();
            Long estimatedRowsToScan = plan.getEstimatedRowsToScan();
            Long estimateInfoTimestamp = plan.getEstimateInfoTimestamp();
            for (String planStep2 : planSteps) {
                byte[] row = PVarchar.INSTANCE.toBytes(planStep2);
                ArrayList cells = Lists.newArrayListWithCapacity((int)3);
                cells.add(PhoenixKeyValueUtil.newKeyValue(row, EXPLAIN_PLAN_FAMILY, EXPLAIN_PLAN_COLUMN, 0L, ByteUtil.EMPTY_BYTE_ARRAY));
                if (estimatedBytesToScan != null) {
                    cells.add(PhoenixKeyValueUtil.newKeyValue(row, EXPLAIN_PLAN_FAMILY, EXPLAIN_PLAN_BYTES_ESTIMATE, 0L, PLong.INSTANCE.toBytes(estimatedBytesToScan)));
                }
                if (estimatedRowsToScan != null) {
                    cells.add(PhoenixKeyValueUtil.newKeyValue(row, EXPLAIN_PLAN_FAMILY, EXPLAIN_PLAN_ROWS_ESTIMATE, 0L, PLong.INSTANCE.toBytes(estimatedRowsToScan)));
                }
                if (estimateInfoTimestamp != null) {
                    cells.add(PhoenixKeyValueUtil.newKeyValue(row, EXPLAIN_PLAN_FAMILY, EXPLAIN_PLAN_ESTIMATE_INFO_TS, 0L, PLong.INSTANCE.toBytes(estimateInfoTimestamp)));
                }
                Collections.sort(cells, CellComparator.getInstance());
                MultiKeyValueTuple tuple = new MultiKeyValueTuple(cells);
                tuples.add(tuple);
            }
            Long estimatedBytes = estimatedBytesToScan;
            Long estimatedRows = estimatedRowsToScan;
            Long estimateTs = estimateInfoTimestamp;
            final MaterializedResultIterator iterator = new MaterializedResultIterator(tuples);
            return new QueryPlan((StatementPlan)plan, estimatedRows, estimatedBytes, estimateTs){
                final /* synthetic */ StatementPlan val$plan;
                final /* synthetic */ Long val$estimatedRows;
                final /* synthetic */ Long val$estimatedBytes;
                final /* synthetic */ Long val$estimateTs;
                {
                    this.val$plan = statementPlan;
                    this.val$estimatedRows = l;
                    this.val$estimatedBytes = l2;
                    this.val$estimateTs = l3;
                }

                @Override
                public ParameterMetaData getParameterMetaData() {
                    return PhoenixParameterMetaData.EMPTY_PARAMETER_META_DATA;
                }

                @Override
                public ExplainPlan getExplainPlan() throws SQLException {
                    return new ExplainPlan(Collections.singletonList("EXPLAIN PLAN"));
                }

                @Override
                public ResultIterator iterator() throws SQLException {
                    return iterator;
                }

                @Override
                public ResultIterator iterator(ParallelScanGrouper scanGrouper) throws SQLException {
                    return iterator;
                }

                @Override
                public ResultIterator iterator(ParallelScanGrouper scanGrouper, Scan scan) throws SQLException {
                    return iterator;
                }

                @Override
                public long getEstimatedSize() {
                    return 0L;
                }

                @Override
                public Cost getCost() {
                    return Cost.ZERO;
                }

                @Override
                public TableRef getTableRef() {
                    return null;
                }

                @Override
                public Set<TableRef> getSourceRefs() {
                    return Collections.emptySet();
                }

                @Override
                public RowProjector getProjector() {
                    return EXPLAIN_PLAN_ROW_PROJECTOR_WITH_BYTE_ROW_ESTIMATES;
                }

                @Override
                public Integer getLimit() {
                    return null;
                }

                @Override
                public Integer getOffset() {
                    return null;
                }

                @Override
                public OrderByCompiler.OrderBy getOrderBy() {
                    return OrderByCompiler.OrderBy.EMPTY_ORDER_BY;
                }

                @Override
                public GroupByCompiler.GroupBy getGroupBy() {
                    return GroupByCompiler.GroupBy.EMPTY_GROUP_BY;
                }

                @Override
                public List<KeyRange> getSplits() {
                    return Collections.emptyList();
                }

                @Override
                public List<List<Scan>> getScans() {
                    return Collections.emptyList();
                }

                @Override
                public StatementContext getContext() {
                    return this.val$plan.getContext();
                }

                @Override
                public FilterableStatement getStatement() {
                    return null;
                }

                @Override
                public boolean isDegenerate() {
                    return false;
                }

                @Override
                public boolean isRowKeyOrdered() {
                    return true;
                }

                @Override
                public Operation getOperation() {
                    return this.getOperation();
                }

                @Override
                public boolean useRoundRobinIterator() throws SQLException {
                    return false;
                }

                @Override
                public <T> T accept(QueryPlanVisitor<T> visitor) {
                    return visitor.defaultReturn(this);
                }

                @Override
                public Long getEstimatedRowsToScan() {
                    return this.val$estimatedRows;
                }

                @Override
                public Long getEstimatedBytesToScan() {
                    return this.val$estimatedBytes;
                }

                @Override
                public Long getEstimateInfoTimestamp() throws SQLException {
                    return this.val$estimateTs;
                }

                @Override
                public List<OrderByCompiler.OrderBy> getOutputOrderBys() {
                    return Collections.emptyList();
                }

                @Override
                public boolean isApplicable() {
                    return true;
                }
            };
        }
    }

    private static class ExecutableSelectStatement
    extends SelectStatement
    implements CompilableStatement {
        private ExecutableSelectStatement(TableNode from, HintNode hint, boolean isDistinct, List<AliasedNode> select, ParseNode where, List<ParseNode> groupBy, ParseNode having, List<OrderByNode> orderBy, LimitNode limit, OffsetNode offset, int bindCount, boolean isAggregate, boolean hasSequence, Map<String, UDFParseNode> udfParseNodes) {
            this(from, hint, isDistinct, select, where, groupBy, having, orderBy, limit, offset, bindCount, isAggregate, hasSequence, Collections.emptyList(), udfParseNodes);
        }

        private ExecutableSelectStatement(TableNode from, HintNode hint, boolean isDistinct, List<AliasedNode> select, ParseNode where, List<ParseNode> groupBy, ParseNode having, List<OrderByNode> orderBy, LimitNode limit, OffsetNode offset, int bindCount, boolean isAggregate, boolean hasSequence, List<SelectStatement> selects, Map<String, UDFParseNode> udfParseNodes) {
            super(from, hint, isDistinct, select, where, groupBy, having, orderBy, limit, offset, bindCount, isAggregate, hasSequence, selects, udfParseNodes);
        }

        private ExecutableSelectStatement(ExecutableSelectStatement select) {
            this(select.getFrom(), select.getHint(), select.isDistinct(), select.getSelect(), select.getWhere(), select.getGroupBy(), select.getHaving(), select.getOrderBy(), select.getLimit(), select.getOffset(), select.getBindCount(), select.isAggregate(), select.hasSequence(), select.getSelects(), select.getUdfParseNodes());
        }

        public QueryPlan compilePlan(PhoenixStatement phoenixStatement, Sequence.ValueOp seqAction) throws SQLException {
            if (!this.getUdfParseNodes().isEmpty()) {
                phoenixStatement.throwIfUnallowedUserDefinedFunctions(this.getUdfParseNodes());
            }
            ParseNodeUtil.RewriteResult rewriteResult = ParseNodeUtil.rewrite(this, phoenixStatement.getConnection());
            QueryPlan queryPlan = new QueryCompiler(phoenixStatement, rewriteResult.getRewrittenSelectStatement(), rewriteResult.getColumnResolver(), Collections.emptyList(), phoenixStatement.getConnection().getIteratorFactory(), new SequenceManager(phoenixStatement), true, false, null).compile();
            queryPlan.getContext().getSequenceManager().validateSequences(seqAction);
            return queryPlan;
        }
    }

    protected static interface CompilableStatement
    extends BindableStatement {
        public <T extends StatementPlan> T compilePlan(PhoenixStatement var1, Sequence.ValueOp var2) throws SQLException;
    }

    public static enum Operation {
        QUERY("queried", false),
        DELETE("deleted", true),
        UPSERT("upserted", true),
        UPGRADE("upgrade", true),
        ADMIN("admin", true);

        private final String toString;
        private final boolean isMutation;

        private Operation(String toString, boolean isMutation) {
            this.toString = toString;
            this.isMutation = isMutation;
        }

        public boolean isMutation() {
            return this.isMutation;
        }

        public String toString() {
            return this.toString;
        }
    }
}

