/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.jdbc;

import com.google.protobuf.InvalidProtocolBufferException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.Format;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.compile.ColumnProjector;
import org.apache.phoenix.compile.ExpressionProjector;
import org.apache.phoenix.compile.RowProjector;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.coprocessor.generated.DynamicColumnMetaDataProtos;
import org.apache.phoenix.coprocessor.generated.PTableProtos;
import org.apache.phoenix.coprocessorclient.ScanRegionObserverConstants;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.execute.TupleProjector;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.ProjectedColumnExpression;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.jdbc.PhoenixMonitoredResultSet;
import org.apache.phoenix.jdbc.PhoenixResultSetMetaData;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.log.QueryLogInfo;
import org.apache.phoenix.log.QueryLogger;
import org.apache.phoenix.log.QueryStatus;
import org.apache.phoenix.monitoring.MetricType;
import org.apache.phoenix.monitoring.OverAllQueryMetrics;
import org.apache.phoenix.monitoring.ReadMetricQueue;
import org.apache.phoenix.monitoring.TableMetricsManager;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PColumnImpl;
import org.apache.phoenix.schema.tuple.ResultTuple;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PBoolean;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDate;
import org.apache.phoenix.schema.types.PDecimal;
import org.apache.phoenix.schema.types.PDouble;
import org.apache.phoenix.schema.types.PFloat;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PSmallint;
import org.apache.phoenix.schema.types.PTime;
import org.apache.phoenix.schema.types.PTimestamp;
import org.apache.phoenix.schema.types.PTinyint;
import org.apache.phoenix.schema.types.PUnsignedDate;
import org.apache.phoenix.schema.types.PUnsignedTime;
import org.apache.phoenix.schema.types.PUnsignedTimestamp;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.schema.types.PVarbinaryEncoded;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.phoenix.thirdparty.com.google.common.base.Strings;
import org.apache.phoenix.thirdparty.com.google.common.base.Throwables;
import org.apache.phoenix.thirdparty.com.google.common.primitives.Bytes;
import org.apache.phoenix.util.DateUtil;
import org.apache.phoenix.util.SQLCloseable;
import org.apache.phoenix.util.SchemaUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhoenixResultSet
implements PhoenixMonitoredResultSet,
SQLCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PhoenixResultSet.class);
    private static final String STRING_FALSE = "0";
    private static final String LITERAL_STRING_FALSE = "false";
    private static final BigDecimal BIG_DECIMAL_FALSE = BigDecimal.valueOf(0L);
    private static final Integer INTEGER_FALSE = 0;
    private static final Tuple BEFORE_FIRST = ResultTuple.EMPTY_TUPLE;
    private final ResultIterator scanner;
    private final RowProjector rowProjector;
    private final PhoenixStatement statement;
    private final StatementContext context;
    private final ReadMetricQueue readMetricsQueue;
    private final OverAllQueryMetrics overAllQueryMetrics;
    private final ImmutableBytesWritable ptr = new ImmutableBytesWritable();
    private final boolean wildcardIncludesDynamicCols;
    private final List<PColumn> staticColumns;
    private final int startPositionForDynamicCols;
    private final boolean isApplyTimeZoneDisplacement;
    private RowProjector rowProjectorWithDynamicCols;
    private Tuple currentRow = BEFORE_FIRST;
    private boolean isClosed = false;
    private boolean wasNull = false;
    private boolean firstRecordRead = false;
    private QueryLogger queryLogger;
    private Long count = 0L;
    private Object exception;
    private long queryTime;
    private final Calendar localCalendar;

    public PhoenixResultSet(ResultIterator resultIterator, RowProjector rowProjector, StatementContext ctx) throws SQLException {
        this.rowProjector = rowProjector;
        this.scanner = resultIterator;
        this.context = ctx;
        this.statement = this.context.getStatement();
        this.statement.setLastResultSet(this);
        this.readMetricsQueue = this.context.getReadMetricsQueue();
        this.overAllQueryMetrics = this.context.getOverallQueryMetrics();
        this.queryLogger = this.context.getQueryLogger() != null ? this.context.getQueryLogger() : QueryLogger.NO_OP_INSTANCE;
        this.wildcardIncludesDynamicCols = this.context.getConnection().getQueryServices().getConfiguration().getBoolean("phoenix.query.wildcard.dynamicColumns", false);
        if (this.wildcardIncludesDynamicCols) {
            Pair<List<PColumn>, Integer> res = this.getStaticColsAndStartingPosForDynCols();
            this.staticColumns = (List)res.getFirst();
            this.startPositionForDynamicCols = (Integer)res.getSecond();
        } else {
            this.staticColumns = null;
            this.startPositionForDynamicCols = 0;
        }
        this.isApplyTimeZoneDisplacement = this.statement.getConnection().isApplyTimeZoneDisplacement();
        this.localCalendar = this.statement.getLocalCalendar();
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void afterLast() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void beforeFirst() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        try {
            if (this.scanner != null) {
                this.scanner.close();
            }
        }
        finally {
            this.isClosed = true;
            this.statement.removeResultSet(this);
            this.overAllQueryMetrics.endQuery();
            this.overAllQueryMetrics.stopResultSetWatch();
            if (this.context.getCurrentTable() != null && this.context.getCurrentTable().getTable() != null && !Strings.isNullOrEmpty((String)this.context.getCurrentTable().getTable().getPhysicalName().getString())) {
                boolean isPointLookup = this.context.getScanRanges().isPointLookup();
                String tableName = this.context.getCurrentTable().getTable().getPhysicalName().toString();
                this.updateTableLevelReadMetrics(tableName, isPointLookup);
            }
            if (!this.queryLogger.isSynced()) {
                if (this.exception == null) {
                    this.queryLogger.log(QueryLogInfo.QUERY_STATUS_I, QueryStatus.COMPLETED.toString());
                }
                this.queryLogger.log(QueryLogInfo.NO_OF_RESULTS_ITERATED_I, this.count);
                if (this.queryLogger.isDebugEnabled()) {
                    this.queryLogger.log(QueryLogInfo.SCAN_METRICS_JSON_I, this.readMetricsQueue.getScanMetricsHolderList().toString());
                    this.readMetricsQueue.getScanMetricsHolderList().clear();
                }
                this.queryLogger.sync(this.getReadMetrics(), this.getOverAllRequestReadMetrics());
            }
        }
    }

    @Override
    public void deleteRow() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        Integer index = this.getRowProjector().getColumnIndex(columnLabel);
        return index + 1;
    }

    @Override
    public boolean first() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        this.checkCursorState();
        ColumnProjector projector = this.getRowProjector().getColumnProjector(columnIndex - 1);
        Array value = (Array)projector.getValue(this.currentRow, projector.getExpression().getDataType(), this.ptr);
        this.wasNull = value == null;
        return value;
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        return this.getArray(this.findColumn(columnLabel));
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    private void checkOpen() throws SQLException {
        if (this.isClosed) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.RESULTSET_CLOSED).build().buildException();
        }
    }

    private void checkCursorState() throws SQLException {
        this.checkOpen();
        if (this.currentRow == BEFORE_FIRST) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.CURSOR_BEFORE_FIRST_ROW).build().buildException();
        }
        if (this.currentRow == null) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.CURSOR_PAST_LAST_ROW).build().buildException();
        }
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        this.checkCursorState();
        BigDecimal value = (BigDecimal)this.getRowProjector().getColumnProjector(columnIndex - 1).getValue(this.currentRow, PDecimal.INSTANCE, this.ptr);
        this.wasNull = value == null;
        return value;
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnLabel));
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        BigDecimal value = this.getBigDecimal(columnIndex);
        if (this.wasNull) {
            return null;
        }
        return value.setScale(scale);
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnLabel), scale);
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        this.checkCursorState();
        ColumnProjector colProjector = this.getRowProjector().getColumnProjector(columnIndex - 1);
        PDataType type = colProjector.getExpression().getDataType();
        Object value = colProjector.getValue(this.currentRow, type, this.ptr);
        boolean bl = this.wasNull = value == null;
        if (this.wasNull) {
            return false;
        }
        if (type == PBoolean.INSTANCE) {
            return Boolean.TRUE.equals(value);
        }
        if (type == PVarchar.INSTANCE) {
            return !STRING_FALSE.equals(value) && !LITERAL_STRING_FALSE.equals(value);
        }
        if (type == PInteger.INSTANCE) {
            return !INTEGER_FALSE.equals(value);
        }
        if (type == PDecimal.INSTANCE) {
            return !BIG_DECIMAL_FALSE.equals(value);
        }
        throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_CALL_METHOD_ON_TYPE).setMessage("Method: getBoolean; Type:" + type).build().buildException();
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        return this.getBoolean(this.findColumn(columnLabel));
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        this.checkCursorState();
        ColumnProjector projector = this.getRowProjector().getColumnProjector(columnIndex - 1);
        PDataType dataType = projector.getExpression().getDataType();
        byte[] value = (byte[])projector.getValue(this.currentRow, dataType == PVarbinaryEncoded.INSTANCE ? PVarbinaryEncoded.INSTANCE : PVarbinary.INSTANCE, this.ptr);
        this.wasNull = value == null;
        return value;
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        return this.getBytes(this.findColumn(columnLabel));
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        this.checkCursorState();
        Byte value = (Byte)this.getRowProjector().getColumnProjector(columnIndex - 1).getValue(this.currentRow, PTinyint.INSTANCE, this.ptr);
        boolean bl = this.wasNull = value == null;
        if (value == null) {
            return 0;
        }
        return value;
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        return this.getByte(this.findColumn(columnLabel));
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getConcurrency() throws SQLException {
        return 1007;
    }

    @Override
    public String getCursorName() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public java.sql.Date getDate(int columnIndex) throws SQLException {
        return this.getDate(columnIndex, this.localCalendar);
    }

    @Override
    public java.sql.Date getDate(String columnLabel) throws SQLException {
        return this.getDate(this.findColumn(columnLabel));
    }

    @Override
    public java.sql.Date getDate(int columnIndex, Calendar cal) throws SQLException {
        this.checkCursorState();
        java.sql.Date value = (java.sql.Date)this.getRowProjector().getColumnProjector(columnIndex - 1).getValue(this.currentRow, PDate.INSTANCE, this.ptr);
        boolean bl = this.wasNull = value == null;
        if (this.wasNull) {
            return null;
        }
        if (this.isApplyTimeZoneDisplacement) {
            return DateUtil.applyOutputDisplacement(value, cal.getTimeZone());
        }
        return value;
    }

    @Override
    public java.sql.Date getDate(String columnLabel, Calendar cal) throws SQLException {
        return this.getDate(this.findColumn(columnLabel), cal);
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        this.checkCursorState();
        Double value = (Double)this.getRowProjector().getColumnProjector(columnIndex - 1).getValue(this.currentRow, PDouble.INSTANCE, this.ptr);
        boolean bl = this.wasNull = value == null;
        if (this.wasNull) {
            return 0.0;
        }
        return value;
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        return this.getDouble(this.findColumn(columnLabel));
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.statement.getFetchSize();
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        this.checkCursorState();
        Float value = (Float)this.getRowProjector().getColumnProjector(columnIndex - 1).getValue(this.currentRow, PFloat.INSTANCE, this.ptr);
        boolean bl = this.wasNull = value == null;
        if (this.wasNull) {
            return 0.0f;
        }
        return value.floatValue();
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        return this.getFloat(this.findColumn(columnLabel));
    }

    @Override
    public int getHoldability() throws SQLException {
        return 2;
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        this.checkCursorState();
        Integer value = (Integer)this.getRowProjector().getColumnProjector(columnIndex - 1).getValue(this.currentRow, PInteger.INSTANCE, this.ptr);
        boolean bl = this.wasNull = value == null;
        if (this.wasNull) {
            return 0;
        }
        return value;
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        return this.getInt(this.findColumn(columnLabel));
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        this.checkCursorState();
        Long value = (Long)this.getRowProjector().getColumnProjector(columnIndex - 1).getValue(this.currentRow, PLong.INSTANCE, this.ptr);
        boolean bl = this.wasNull = value == null;
        if (this.wasNull) {
            return 0L;
        }
        return value;
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        return this.getLong(this.findColumn(columnLabel));
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return new PhoenixResultSetMetaData(this.statement.getConnection(), this.getRowProjector());
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        this.checkCursorState();
        ColumnProjector projector = this.getRowProjector().getColumnProjector(columnIndex - 1);
        Object value = projector.getValue(this.currentRow, projector.getExpression().getDataType(), this.ptr);
        boolean bl = this.wasNull = value == null;
        if (this.wasNull) {
            return null;
        }
        if (this.isApplyTimeZoneDisplacement) {
            PDataType type = projector.getExpression().getDataType();
            if (type == PDate.INSTANCE || type == PUnsignedDate.INSTANCE) {
                value = DateUtil.applyOutputDisplacement((java.sql.Date)value, this.localCalendar.getTimeZone());
            } else if (type == PTime.INSTANCE || type == PUnsignedTime.INSTANCE) {
                value = DateUtil.applyOutputDisplacement((Time)value, this.localCalendar.getTimeZone());
            } else if (type == PTimestamp.INSTANCE || type == PUnsignedTimestamp.INSTANCE) {
                value = DateUtil.applyOutputDisplacement((Timestamp)value, this.localCalendar.getTimeZone());
            }
        }
        return value;
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        return this.getObject(this.findColumn(columnLabel));
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        return this.getObject(columnIndex);
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        return this.getObject(this.findColumn(columnLabel), map);
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getRow() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        this.checkCursorState();
        Short value = (Short)this.getRowProjector().getColumnProjector(columnIndex - 1).getValue(this.currentRow, PSmallint.INSTANCE, this.ptr);
        boolean bl = this.wasNull = value == null;
        if (this.wasNull) {
            return 0;
        }
        return value;
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        return this.getShort(this.findColumn(columnLabel));
    }

    @Override
    public PhoenixStatement getStatement() throws SQLException {
        return this.statement;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        this.checkCursorState();
        ColumnProjector projector = this.getRowProjector().getColumnProjector(columnIndex - 1);
        PDataType type = projector.getExpression().getDataType();
        Object value = projector.getValue(this.currentRow, type, this.ptr);
        boolean bl = this.wasNull = value == null;
        if (this.wasNull) {
            return null;
        }
        Format formatter = this.statement.getFormatter(type);
        return formatter == null ? value.toString() : formatter.format(value);
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        return this.getString(this.findColumn(columnLabel));
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        return this.getTime(columnIndex, this.localCalendar);
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        return this.getTime(this.findColumn(columnLabel));
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        this.checkCursorState();
        Time value = (Time)this.getRowProjector().getColumnProjector(columnIndex - 1).getValue(this.currentRow, PTime.INSTANCE, this.ptr);
        boolean bl = this.wasNull = value == null;
        if (this.wasNull) {
            return null;
        }
        if (this.isApplyTimeZoneDisplacement) {
            return DateUtil.applyOutputDisplacement(value, cal.getTimeZone());
        }
        return value;
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        return this.getTime(this.findColumn(columnLabel), cal);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return this.getTimestamp(columnIndex, this.localCalendar);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        return this.getTimestamp(this.findColumn(columnLabel));
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        this.checkCursorState();
        Timestamp value = (Timestamp)this.getRowProjector().getColumnProjector(columnIndex - 1).getValue(this.currentRow, PTimestamp.INSTANCE, this.ptr);
        boolean bl = this.wasNull = value == null;
        if (this.wasNull) {
            return null;
        }
        if (this.isApplyTimeZoneDisplacement) {
            return DateUtil.applyOutputDisplacement(value, cal.getTimeZone());
        }
        return value;
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(columnLabel), cal);
    }

    @Override
    public int getType() throws SQLException {
        return 1003;
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        this.checkCursorState();
        String value = (String)this.getRowProjector().getColumnProjector(columnIndex - 1).getValue(this.currentRow, PVarchar.INSTANCE, this.ptr);
        boolean bl = this.wasNull = value == null;
        if (this.wasNull) {
            return null;
        }
        try {
            return new URL(value);
        }
        catch (MalformedURLException e) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.MALFORMED_URL).setRootCause(e).build().buildException();
        }
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        return this.getURL(this.findColumn(columnLabel));
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void insertRow() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.currentRow == null;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.currentRow == BEFORE_FIRST;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public boolean isFirst() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isLast() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean last() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public Tuple getCurrentRow() {
        return this.currentRow;
    }

    protected Tuple getCurrentRowImpl() throws SQLException {
        return this.scanner.next();
    }

    @Override
    public boolean next() throws SQLException {
        this.checkOpen();
        try {
            if (!this.firstRecordRead) {
                this.firstRecordRead = true;
                this.overAllQueryMetrics.startResultSetWatch();
            }
            this.currentRow = this.getCurrentRowImpl();
            if (this.currentRow != null) {
                Long l = this.count;
                Long l2 = this.count = Long.valueOf(this.count + 1L);
                if (this.rowProjectorWithDynamicCols != null) {
                    this.rowProjectorWithDynamicCols = null;
                }
                this.processDynamicColumnsIfRequired();
            }
            this.rowProjector.reset();
            if (this.rowProjectorWithDynamicCols != null) {
                this.rowProjectorWithDynamicCols.reset();
            }
        }
        catch (RuntimeException | SQLException e) {
            this.queryLogger.log(QueryLogInfo.QUERY_STATUS_I, QueryStatus.FAILED.toString());
            if (this.queryLogger.isDebugEnabled()) {
                this.queryLogger.log(QueryLogInfo.EXCEPTION_TRACE_I, Throwables.getStackTraceAsString((Throwable)e));
            }
            this.exception = e;
            if (e.getCause() instanceof SQLException) {
                throw (SQLException)e.getCause();
            }
            throw e;
        }
        finally {
            if (this.exception != null || this.currentRow == null) {
                this.overAllQueryMetrics.endQuery();
                this.overAllQueryMetrics.stopResultSetWatch();
            }
            if (this.exception != null) {
                this.queryLogger.log(QueryLogInfo.NO_OF_RESULTS_ITERATED_I, this.count);
                if (this.queryLogger.isDebugEnabled()) {
                    this.queryLogger.log(QueryLogInfo.SCAN_METRICS_JSON_I, this.readMetricsQueue.getScanMetricsHolderList().toString());
                    this.readMetricsQueue.getScanMetricsHolderList().clear();
                }
                if (this.queryLogger != null) {
                    this.queryLogger.sync(this.getReadMetrics(), this.getOverAllRequestReadMetrics());
                }
            }
            if (this.currentRow == null) {
                this.overAllQueryMetrics.endQuery();
                this.overAllQueryMetrics.stopResultSetWatch();
            }
        }
        return this.currentRow != null;
    }

    private void updateTableLevelReadMetrics(String tableName, boolean isPointLookup) {
        Map<String, Map<MetricType, Long>> readMetrics = this.getReadMetrics();
        TableMetricsManager.pushMetricsFromConnInstanceMethod(readMetrics);
        HashMap<String, Map<MetricType, Long>> metricsFromOverallQuery = new HashMap<String, Map<MetricType, Long>>();
        Map<MetricType, Long> overAllReadMetrics = this.getOverAllRequestReadMetrics();
        metricsFromOverallQuery.put(tableName, overAllReadMetrics);
        TableMetricsManager.pushMetricsFromConnInstanceMethod(metricsFromOverallQuery);
        if (readMetrics.get(tableName) != null) {
            Long scanBytes = readMetrics.get(tableName).get((Object)MetricType.SCAN_BYTES);
            if (scanBytes == null) {
                scanBytes = 0L;
            }
            TableMetricsManager.updateHistogramMetricsForQueryScanBytes(scanBytes, tableName, isPointLookup);
            Long timeSpentInRSNext = overAllReadMetrics.get((Object)MetricType.RESULT_SET_TIME_MS);
            if (timeSpentInRSNext == null) {
                timeSpentInRSNext = 0L;
            }
            timeSpentInRSNext = timeSpentInRSNext + this.queryTime;
            TableMetricsManager.updateHistogramMetricsForQueryLatency(tableName, timeSpentInRSNext, isPointLookup);
            TableMetricsManager.updateMetricsMethod(tableName, this.exception == null ? MetricType.SELECT_AGGREGATE_SUCCESS_SQL_COUNTER : MetricType.SELECT_AGGREGATE_FAILURE_SQL_COUNTER, 1L);
        }
    }

    @Override
    public boolean previous() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void refreshRow() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean rowInserted() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        if (direction != 1000) {
            throw new SQLFeatureNotSupportedException();
        }
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        LOGGER.warn("Ignoring setFetchSize(" + rows + ")");
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateArray(String columnLabel, Array x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateDate(int columnIndex, java.sql.Date x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateDate(String columnLabel, java.sql.Date x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateRow() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.wasNull;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (!iface.isInstance(this)) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.CLASS_NOT_UNWRAPPABLE).setMessage(this.getClass().getName() + " not unwrappable from " + iface.getName()).build().buildException();
        }
        return (T)this;
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        if (type.equals(String.class)) {
            return (T)this.getString(columnIndex);
        }
        if (Date.class.isAssignableFrom(type)) {
            if (Timestamp.class.isAssignableFrom(type)) {
                return (T)this.getTimestamp(columnIndex);
            }
            if (java.sql.Date.class.isAssignableFrom(type)) {
                return (T)this.getDate(columnIndex);
            }
            if (Time.class.isAssignableFrom(type)) {
                return (T)this.getTime(columnIndex);
            }
            if (Date.class.equals(type)) {
                return (T)new Date(this.getDate(columnIndex).getTime());
            }
        }
        this.checkCursorState();
        ColumnProjector projector = this.getRowProjector().getColumnProjector(columnIndex - 1);
        Object value = projector.getValue(this.currentRow, projector.getExpression().getDataType(), this.ptr, type);
        this.wasNull = value == null;
        return (T)value;
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        return this.getObject(this.findColumn(columnLabel), type);
    }

    @VisibleForTesting
    public ResultIterator getUnderlyingIterator() {
        return this.scanner;
    }

    @Override
    public Map<String, Map<MetricType, Long>> getReadMetrics() {
        ReadMetricQueue one = this.readMetricsQueue;
        if (this.context != null) {
            for (StatementContext sub : this.context.getSubStatementContexts()) {
                ReadMetricQueue subMetric = sub.getReadMetricsQueue();
                one.combineReadMetrics(subMetric);
            }
        }
        return one.aggregate();
    }

    @Override
    public Map<MetricType, Long> getOverAllRequestReadMetrics() {
        return this.overAllQueryMetrics.publish();
    }

    @Override
    public void resetMetrics() {
        this.readMetricsQueue.clearMetrics();
        this.readMetricsQueue.getScanMetricsHolderList().clear();
        this.overAllQueryMetrics.reset();
    }

    public StatementContext getContext() {
        return this.context;
    }

    public void setQueryTime(long queryTime) {
        this.queryTime = queryTime;
    }

    public RowProjector getRowProjector() {
        if (this.rowProjectorWithDynamicCols != null) {
            return this.rowProjectorWithDynamicCols;
        }
        return this.rowProjector;
    }

    private Pair<List<PColumn>, Integer> getStaticColsAndStartingPosForDynCols() {
        ArrayList<PColumn> staticCols = new ArrayList<PColumn>();
        for (ColumnProjector columnProjector : this.rowProjector.getColumnProjectors()) {
            Expression exp = columnProjector.getExpression();
            if (!(exp instanceof ProjectedColumnExpression)) continue;
            staticCols.addAll(((ProjectedColumnExpression)exp).getColumns());
            break;
        }
        int startingPosForDynCols = 0;
        for (PColumn col : staticCols) {
            if (SchemaUtil.isPKColumn(col)) continue;
            ++startingPosForDynCols;
        }
        return new Pair(staticCols, (Object)startingPosForDynCols);
    }

    private void processDynamicColumnsIfRequired() {
        if (!this.wildcardIncludesDynamicCols || this.currentRow == null || !this.rowProjector.projectDynColsInWildcardQueries()) {
            return;
        }
        List<PColumn> dynCols = this.getDynColsListAndSeparateFromActualData();
        if (dynCols == null) {
            return;
        }
        RowProjector rowProjectorWithDynamicColumns = null;
        if (this.rowProjector.getColumnCount() > 0 && dynCols.size() > 0) {
            rowProjectorWithDynamicColumns = this.mergeRowProjectorWithDynColProjectors(dynCols, this.rowProjector.getColumnProjector(0).getTableName());
        }
        if (rowProjectorWithDynamicColumns != null) {
            this.rowProjectorWithDynamicCols = rowProjectorWithDynamicColumns;
        }
    }

    private List<PColumn> getDynColsListAndSeparateFromActualData() {
        Cell base = this.currentRow.getValue(0);
        byte[] valueArray = CellUtil.cloneValue((Cell)base);
        byte[] anchor = Arrays.copyOf(ScanRegionObserverConstants.DYN_COLS_METADATA_CELL_QUALIFIER, ScanRegionObserverConstants.DYN_COLS_METADATA_CELL_QUALIFIER.length);
        ArrayUtils.reverse((byte[])valueArray);
        ArrayUtils.reverse((byte[])anchor);
        int pos = valueArray.length - Bytes.indexOf((byte[])valueArray, (byte[])anchor);
        if (pos >= valueArray.length) {
            return null;
        }
        ArrayUtils.reverse((byte[])valueArray);
        byte[] actualCellDataBytes = Arrays.copyOfRange(valueArray, 0, pos - ScanRegionObserverConstants.DYN_COLS_METADATA_CELL_QUALIFIER.length);
        ImmutableBytesWritable actualCellData = new ImmutableBytesWritable(actualCellDataBytes);
        ImmutableBytesWritable key = new ImmutableBytesWritable();
        this.currentRow.getKey(key);
        this.currentRow = new TupleProjector.ProjectedValueTuple(key.get(), key.getOffset(), key.getLength(), base.getTimestamp(), actualCellData.get(), actualCellData.getOffset(), actualCellData.getLength(), 0);
        byte[] dynColsListBytes = Arrays.copyOfRange(valueArray, pos, valueArray.length);
        ArrayList<PColumn> dynCols = new ArrayList<PColumn>();
        try {
            List<PTableProtos.PColumn> dynColsProtos = DynamicColumnMetaDataProtos.DynamicColumnMetaData.parseFrom(dynColsListBytes).getDynamicColumnsList();
            for (PTableProtos.PColumn colProto : dynColsProtos) {
                dynCols.add(PColumnImpl.createFromProto(colProto));
            }
        }
        catch (InvalidProtocolBufferException e) {
            return null;
        }
        return dynCols;
    }

    private RowProjector mergeRowProjectorWithDynColProjectors(List<PColumn> dynCols, String tableName) {
        ArrayList<? extends ColumnProjector> allColumnProjectors = new ArrayList<ColumnProjector>(this.rowProjector.getColumnProjectors());
        ArrayList<PColumn> allCols = new ArrayList<PColumn>();
        if (this.staticColumns != null) {
            allCols.addAll(this.staticColumns);
        }
        allCols.addAll(dynCols);
        int startingPos = this.startPositionForDynamicCols;
        for (PColumn currentDynCol : dynCols) {
            ProjectedColumnExpression exp = new ProjectedColumnExpression(currentDynCol, allCols, startingPos++, currentDynCol.getName().getString());
            ExpressionProjector dynColProj = new ExpressionProjector(currentDynCol.getName().getString(), currentDynCol.getName().getString(), tableName, exp, false);
            allColumnProjectors.add(dynColProj);
        }
        return new RowProjector(allColumnProjectors, this.rowProjector.getEstimatedRowByteSize(), this.rowProjector.projectEveryRow(), this.rowProjector.hasUDFs(), this.rowProjector.projectEverything(), this.rowProjector.projectDynColsInWildcardQueries());
    }
}

