/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.jdbc;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.compile.BindManager;
import org.apache.phoenix.compile.MutationPlan;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.execute.MutationState;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixMonitoredPreparedStatement;
import org.apache.phoenix.jdbc.PhoenixResultSetMetaData;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.schema.ExecuteQueryNotApplicableException;
import org.apache.phoenix.schema.ExecuteUpdateNotApplicableException;
import org.apache.phoenix.schema.Sequence;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.util.DateUtil;
import org.apache.phoenix.util.SQLCloseable;

public class PhoenixPreparedStatement
extends PhoenixStatement
implements PhoenixMonitoredPreparedStatement,
SQLCloseable {
    private final int parameterCount;
    private final List<Object> parameters;
    private final PhoenixStatement.CompilableStatement statement;
    private final String query;

    public PhoenixPreparedStatement(PhoenixConnection connection, PhoenixStatement.PhoenixStatementParser parser) throws SQLException, IOException {
        super(connection);
        this.statement = parser.nextStatement(new PhoenixStatement.ExecutableNodeFactory());
        if (this.statement == null) {
            throw new EOFException();
        }
        this.query = null;
        this.parameterCount = this.statement.getBindCount();
        this.parameters = Arrays.asList(new Object[this.statement.getBindCount()]);
        Collections.fill(this.parameters, BindManager.UNBOUND_PARAMETER);
    }

    public PhoenixPreparedStatement(PhoenixConnection connection, String query) throws SQLException {
        super(connection);
        this.query = query;
        this.statement = this.parseStatement(query);
        this.parameterCount = this.statement.getBindCount();
        this.parameters = Arrays.asList(new Object[this.statement.getBindCount()]);
        Collections.fill(this.parameters, BindManager.UNBOUND_PARAMETER);
    }

    public PhoenixPreparedStatement(PhoenixPreparedStatement statement) {
        super(statement.connection);
        this.query = statement.query;
        this.statement = statement.statement;
        this.parameterCount = statement.parameters.size();
        this.parameters = new ArrayList<Object>(statement.parameters);
    }

    @Override
    public void addBatch() throws SQLException {
        this.throwIfUnboundParameters();
        this.batch.add(new PhoenixPreparedStatement(this));
    }

    private void setParameter(int parameterIndex, Object value) throws SQLException {
        if (parameterIndex < 1 || parameterIndex > this.parameterCount) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.PARAM_INDEX_OUT_OF_BOUND).setMessage("Can't set parameter at index " + parameterIndex + ", " + this.parameterCount + " bind parameters are defined").build().buildException();
        }
        this.parameters.set(parameterIndex - 1, value);
    }

    @Override
    public void clearParameters() throws SQLException {
        Collections.fill(this.parameters, BindManager.UNBOUND_PARAMETER);
    }

    @Override
    public List<Object> getParameters() {
        return this.parameters;
    }

    private void throwIfUnboundParameters() throws SQLException {
        int i = 0;
        for (Object param : this.getParameters()) {
            if (param == BindManager.UNBOUND_PARAMETER) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.PARAM_VALUE_UNBOUND).setMessage("Parameter " + (i + 1) + " is unbound").build().buildException();
            }
            ++i;
        }
    }

    public QueryPlan compileQuery() throws SQLException {
        return this.compileQuery(this.statement, this.query);
    }

    public MutationPlan compileMutation() throws SQLException {
        return this.compileMutation(this.statement, this.query);
    }

    void executeForBatch() throws SQLException {
        this.throwIfUnboundParameters();
        if (!this.statement.getOperation().isMutation()) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.EXECUTE_BATCH_FOR_STMT_WITH_RESULT_SET).build().buildException();
        }
        this.executeMutation(this.statement, this.createAuditQueryLogger(this.statement, this.query));
    }

    @Override
    public boolean execute() throws SQLException {
        this.throwIfUnboundParameters();
        if (this.statement.getOperation().isMutation() && !this.batch.isEmpty()) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.EXECUTE_UPDATE_WITH_NON_EMPTY_BATCH).build().buildException();
        }
        if (this.statement.getOperation().isMutation()) {
            this.executeMutation(this.statement, this.createAuditQueryLogger(this.statement, this.query));
            return false;
        }
        this.executeQuery(this.statement, this.createQueryLogger(this.statement, this.query));
        return true;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.throwIfUnboundParameters();
        if (this.statement.getOperation().isMutation()) {
            throw new ExecuteQueryNotApplicableException(this.statement.getOperation());
        }
        return this.executeQuery(this.statement, this.createQueryLogger(this.statement, this.query));
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.preExecuteUpdate();
        return this.executeMutation(this.statement, this.createAuditQueryLogger(this.statement, this.query));
    }

    private void preExecuteUpdate() throws SQLException {
        this.throwIfUnboundParameters();
        if (!this.statement.getOperation().isMutation()) {
            throw new ExecuteUpdateNotApplicableException(this.statement.getOperation());
        }
        if (!this.batch.isEmpty()) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.EXECUTE_UPDATE_WITH_NON_EMPTY_BATCH).build().buildException();
        }
    }

    public Pair<Integer, ResultSet> executeAtomicUpdateReturnOldRow() throws SQLException {
        if (!this.connection.getAutoCommit()) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.AUTO_COMMIT_NOT_ENABLED).build().buildException();
        }
        this.preExecuteUpdate();
        return this.executeMutation(this.statement, this.createAuditQueryLogger(this.statement, this.query), MutationState.ReturnResult.OLD_ROW_ALWAYS);
    }

    public Pair<Integer, ResultSet> executeAtomicUpdateReturnRow() throws SQLException {
        if (!this.connection.getAutoCommit()) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.AUTO_COMMIT_NOT_ENABLED).build().buildException();
        }
        this.preExecuteUpdate();
        return this.executeMutation(this.statement, this.createAuditQueryLogger(this.statement, this.query), MutationState.ReturnResult.NEW_ROW_ON_SUCCESS);
    }

    public QueryPlan optimizeQuery() throws SQLException {
        this.throwIfUnboundParameters();
        return this.optimizeQuery(this.statement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.statement.getOperation().isMutation()) {
            return null;
        }
        int paramCount = this.statement.getBindCount();
        List<Object> params = this.getParameters();
        BitSet unsetParams = new BitSet(this.statement.getBindCount());
        for (int i = 0; i < paramCount; ++i) {
            if (params.get(i) != BindManager.UNBOUND_PARAMETER) continue;
            unsetParams.set(i);
            params.set(i, null);
        }
        try {
            QueryPlan plan = (QueryPlan)this.statement.compilePlan(this, Sequence.ValueOp.NOOP);
            PhoenixResultSetMetaData phoenixResultSetMetaData = new PhoenixResultSetMetaData(this.getConnection(), plan.getProjector());
            return phoenixResultSetMetaData;
        }
        finally {
            int lastSetBit = 0;
            while ((lastSetBit = unsetParams.nextSetBit(lastSetBit)) != -1) {
                params.set(lastSetBit, BindManager.UNBOUND_PARAMETER);
                ++lastSetBit;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        int paramCount = this.statement.getBindCount();
        List<Object> params = this.getParameters();
        BitSet unsetParams = new BitSet(this.statement.getBindCount());
        for (int i = 0; i < paramCount; ++i) {
            if (params.get(i) != BindManager.UNBOUND_PARAMETER) continue;
            unsetParams.set(i);
            params.set(i, null);
        }
        try {
            Object plan = this.statement.compilePlan(this, Sequence.ValueOp.NOOP);
            ParameterMetaData parameterMetaData = plan.getParameterMetaData();
            return parameterMetaData;
        }
        finally {
            int lastSetBit = 0;
            while ((lastSetBit = unsetParams.nextSetBit(lastSetBit)) != -1) {
                params.set(lastSetBit, BindManager.UNBOUND_PARAMETER);
                ++lastSetBit;
            }
        }
    }

    public String toString() {
        return this.query;
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.setDate(parameterIndex, x, this.localCalendar);
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.setParameter(parameterIndex, this.processDate(x, cal));
    }

    private Date processDate(Date x, Calendar cal) {
        if (x != null) {
            if (this.connection.isApplyTimeZoneDisplacement()) {
                return DateUtil.applyInputDisplacement(x, cal.getTimeZone());
            }
            return new Date(x.getTime());
        }
        return x;
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.setParameter(parameterIndex, Float.valueOf(x));
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.setParameter(parameterIndex, null);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.setParameter(parameterIndex, null);
    }

    @Override
    public void setObject(int parameterIndex, Object o) throws SQLException {
        this.setParameter(parameterIndex, this.processObject(o));
    }

    @Override
    public void setObject(int parameterIndex, Object o, int targetSqlType) throws SQLException {
        o = this.processObject(o);
        PDataType targetType = PDataType.fromTypeId(targetSqlType);
        if (o != null) {
            PDataType sourceType = PDataType.fromLiteral(o);
            o = targetType.toObject(o, sourceType);
        }
        this.setParameter(parameterIndex, o);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this.setObject(parameterIndex, x, targetSqlType);
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.setTime(parameterIndex, x, this.localCalendar);
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.setParameter(parameterIndex, this.processTime(x, cal));
    }

    private Time processTime(Time x, Calendar cal) {
        if (x != null) {
            if (this.connection.isApplyTimeZoneDisplacement()) {
                return DateUtil.applyInputDisplacement(x, cal.getTimeZone());
            }
            return new Time(x.getTime());
        }
        return x;
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.setTimestamp(parameterIndex, x, this.localCalendar);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.setParameter(parameterIndex, this.processTimestamp(x, cal));
    }

    private Timestamp processTimestamp(Timestamp x, Calendar cal) {
        if (x != null) {
            if (this.connection.isApplyTimeZoneDisplacement()) {
                return DateUtil.applyInputDisplacement(x, cal.getTimeZone());
            }
            int nanos = x.getNanos();
            x = new Timestamp(x.getTime());
            x.setNanos(nanos);
        }
        return x;
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.setParameter(parameterIndex, x.toExternalForm());
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    private Object processObject(Object o) {
        if (o instanceof Temporal) {
            if (o instanceof LocalDateTime) {
                return Timestamp.from(((LocalDateTime)o).toInstant(ZoneOffset.UTC));
            }
            if (o instanceof LocalDate) {
                return new Date(((LocalDate)o).atStartOfDay().toInstant(ZoneOffset.UTC).toEpochMilli());
            }
            if (o instanceof LocalTime) {
                return Timestamp.from(((LocalTime)o).atDate(DateUtil.LD_EPOCH).toInstant(ZoneOffset.UTC));
            }
        } else if (o instanceof java.util.Date) {
            if (o instanceof Date) {
                return this.processDate((Date)o, this.localCalendar);
            }
            if (o instanceof Timestamp) {
                return this.processTimestamp((Timestamp)o, this.localCalendar);
            }
            if (o instanceof Time) {
                return this.processTime((Time)o, this.localCalendar);
            }
            return this.processDate(new Date(((java.util.Date)o).getTime()), this.localCalendar).getTime();
        }
        return o;
    }
}

