/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.jdbc;

import java.sql.SQLException;
import java.util.List;
import org.apache.phoenix.compile.RowProjector;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.jdbc.PhoenixResultSet;
import org.apache.phoenix.schema.tuple.Tuple;

public class PhoenixPrefetchedResultSet
extends PhoenixResultSet {
    private final List<Tuple> prefetchedRows;
    private int prefetchedRowsIndex;

    public PhoenixPrefetchedResultSet(RowProjector rowProjector, StatementContext ctx, List<Tuple> prefetchedRows) throws SQLException {
        super(null, rowProjector, ctx);
        this.prefetchedRows = prefetchedRows;
        this.prefetchedRowsIndex = 0;
    }

    @Override
    protected Tuple getCurrentRowImpl() {
        return this.prefetchedRows.size() > this.prefetchedRowsIndex ? this.prefetchedRows.get(this.prefetchedRowsIndex++) : null;
    }
}

