/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.jdbc;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.apache.phoenix.jdbc.PhoenixMetricsHolder;
import org.apache.phoenix.monitoring.AtomicMetric;
import org.apache.phoenix.monitoring.Metric;
import org.apache.phoenix.monitoring.MetricType;
import org.apache.phoenix.thirdparty.com.google.common.collect.ImmutableList;

public class PhoenixHAGroupMetrics
implements PhoenixMetricsHolder {
    protected EnumMap<MetricType, Metric> map = new EnumMap(MetricType.class);

    protected PhoenixHAGroupMetrics(List<HAMetricType> types) {
        for (HAMetricType type : types) {
            for (MetricType metricType : type.metrics) {
                this.map.put(metricType, new AtomicMetric(metricType));
            }
        }
    }

    @Override
    public Metric get(MetricType type) {
        return this.map.get((Object)type);
    }

    @Override
    public void reset() {
        this.map.values().forEach(Metric::reset);
    }

    @Override
    public Map<MetricType, Metric> getAllMetrics() {
        return this.map;
    }

    public Metric get(HAMetricType type, int clusterIndex) {
        return this.map.get(type.metrics.get(clusterIndex));
    }

    public static enum HAMetricType {
        HA_PARALLEL_COUNT_FAILED_OPERATIONS((List<MetricType>)ImmutableList.of((Object)((Object)MetricType.HA_PARALLEL_COUNT_FAILED_OPERATIONS_ACTIVE_CLUSTER), (Object)((Object)MetricType.HA_PARALLEL_COUNT_FAILED_OPERATIONS_STANDBY_CLUSTER))),
        HA_PARALLEL_USED_OPERATIONS((List<MetricType>)ImmutableList.of((Object)((Object)MetricType.HA_PARALLEL_COUNT_USED_OPERATIONS_ACTIVE_CLUSTER), (Object)((Object)MetricType.HA_PARALLEL_COUNT_USED_OPERATIONS_STANDBY_CLUSTER))),
        HA_PARALLEL_COUNT_OPERATIONS((List<MetricType>)ImmutableList.of((Object)((Object)MetricType.HA_PARALLEL_COUNT_OPERATIONS_ACTIVE_CLUSTER), (Object)((Object)MetricType.HA_PARALLEL_COUNT_OPERATIONS_STANDBY_CLUSTER)));

        private final List<MetricType> metrics;

        private HAMetricType(List<MetricType> metrics) {
            this.metrics = metrics;
        }
    }
}

