/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.jdbc;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.phoenix.monitoring.GlobalClientMetrics;
import org.apache.phoenix.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.phoenix.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.phoenix.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhoenixHAExecutorServiceProvider {
    public static final String HA_MAX_POOL_SIZE = "phoenix.ha.max.pool.size";
    public static final String DEFAULT_HA_MAX_POOL_SIZE = "30";
    public static final String HA_MAX_QUEUE_SIZE = "phoenix.ha.max.queue.size";
    public static final String DEFAULT_HA_MAX_QUEUE_SIZE = "300";
    public static final String HA_THREADPOOL_QUEUE_BACKOFF_THRESHOLD = "phoenix.ha.threadpool.queue.backoff.threshold";
    public static final String DEFAULT_HA_THREADPOOL_QUEUE_BACKOFF_THRESHOLD = "0.9";
    public static final String HA_CLOSE_MAX_POOL_SIZE = "phoenix.ha.close.max.pool.size";
    public static final String DEFAULT_HA_CLOSE_MAX_POOL_SIZE = "15";
    public static final String HA_CLOSE_MAX_QUEUE_SIZE = "phoenix.ha.close.max.queue.size";
    public static final String DEFAULT_HA_CLOSE_MAX_QUEUE_SIZE = "150";
    private static final Logger LOGGER = LoggerFactory.getLogger(PhoenixHAExecutorServiceProvider.class);
    private static final int KEEP_ALIVE_TIME_SECONDS = 120;
    private static volatile List<PhoenixHAClusterExecutorServices> INSTANCE = null;

    private PhoenixHAExecutorServiceProvider() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<PhoenixHAClusterExecutorServices> get(Properties properties) {
        if (INSTANCE != null) return INSTANCE;
        Class<PhoenixHAExecutorServiceProvider> clazz = PhoenixHAExecutorServiceProvider.class;
        synchronized (PhoenixHAExecutorServiceProvider.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = PhoenixHAExecutorServiceProvider.initThreadPool(properties);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return INSTANCE;
        }
    }

    @VisibleForTesting
    static synchronized void resetExecutor() {
        INSTANCE = null;
    }

    public static List<Boolean> hasCapacity(Properties properties) {
        if (INSTANCE == null) {
            return ImmutableList.of((Object)Boolean.TRUE, (Object)Boolean.TRUE);
        }
        double backoffThreshold = Double.parseDouble(properties.getProperty(HA_THREADPOOL_QUEUE_BACKOFF_THRESHOLD, DEFAULT_HA_THREADPOOL_QUEUE_BACKOFF_THRESHOLD));
        int i = 0;
        ArrayList<Boolean> executorCapacities = new ArrayList<Boolean>();
        ImmutableList executorServicesList = ImmutableList.of((Object)INSTANCE.get(0).getExecutorService(), (Object)INSTANCE.get(1).getExecutorService());
        for (ExecutorService executor : executorServicesList) {
            double queueRemainingCapacity;
            double queueCapacity;
            boolean hasCapacity;
            double queueSize = ((ThreadPoolExecutor)executor).getQueue().size();
            boolean bl = hasCapacity = queueSize / (queueCapacity = queueSize + (queueRemainingCapacity = (double)((ThreadPoolExecutor)executor).getQueue().remainingCapacity())) < backoffThreshold;
            if (!hasCapacity) {
                LOGGER.warn("PhoenixHAExecutorServiceProvider ThreadPoolExecutor[" + i + "] hasCapacity: false queueSize:" + queueSize + " queueCapacity:" + queueCapacity + " backoffThreshold:" + backoffThreshold);
            }
            ++i;
            executorCapacities.add(hasCapacity);
        }
        return executorCapacities;
    }

    private static List<PhoenixHAClusterExecutorServices> initThreadPool(Properties properties) {
        int maxPoolSize = Integer.parseInt(properties.getProperty(HA_MAX_POOL_SIZE, DEFAULT_HA_MAX_POOL_SIZE));
        int maxQueueSize = Integer.parseInt(properties.getProperty(HA_MAX_QUEUE_SIZE, DEFAULT_HA_MAX_QUEUE_SIZE));
        ThreadPoolExecutor pool1 = PhoenixHAExecutorServiceProvider.createThreadPool(maxPoolSize, maxQueueSize, "phoenixha1", PhoenixHAExecutorServiceProvider.getGlobalExecutorMetricsForPool1());
        ThreadPoolExecutor pool2 = PhoenixHAExecutorServiceProvider.createThreadPool(maxPoolSize, maxQueueSize, "phoenixha2", PhoenixHAExecutorServiceProvider.getGlobalExecutorMetricsForPool2());
        maxPoolSize = Integer.parseInt(properties.getProperty(HA_CLOSE_MAX_POOL_SIZE, DEFAULT_HA_CLOSE_MAX_POOL_SIZE));
        maxQueueSize = Integer.parseInt(properties.getProperty(HA_CLOSE_MAX_QUEUE_SIZE, DEFAULT_HA_CLOSE_MAX_QUEUE_SIZE));
        ThreadPoolExecutor closePool1 = PhoenixHAExecutorServiceProvider.createThreadPool(maxPoolSize, maxQueueSize, "phoenixha1close");
        ThreadPoolExecutor closePool2 = PhoenixHAExecutorServiceProvider.createThreadPool(maxPoolSize, maxQueueSize, "phoenixha2close");
        closePool1.allowCoreThreadTimeOut(true);
        closePool2.allowCoreThreadTimeOut(true);
        return ImmutableList.of((Object)new PhoenixHAClusterExecutorServices(pool1, closePool1), (Object)new PhoenixHAClusterExecutorServices(pool2, closePool2));
    }

    private static ThreadPoolExecutor createThreadPool(int maxPoolSize, int maxQueueSize, String threadPoolNamePrefix) {
        return PhoenixHAExecutorServiceProvider.createThreadPool(maxPoolSize, maxQueueSize, threadPoolNamePrefix, null);
    }

    private static ThreadPoolExecutor createThreadPool(int maxPoolSize, int maxQueueSize, String threadPoolNamePrefix, @Nullable GlobalExecutorMetrics metrics) {
        LinkedBlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>(maxQueueSize);
        ThreadPoolExecutor.CallerRunsPolicy handler = metrics != null ? new MonitoredCallerRunsPolicy(threadPoolNamePrefix, metrics) : new ThreadPoolExecutor.CallerRunsPolicy();
        PhoenixHAThreadPoolExecutor pool = new PhoenixHAThreadPoolExecutor(maxPoolSize, maxPoolSize, 120L, TimeUnit.SECONDS, queue, new ThreadFactoryBuilder().setDaemon(true).setNameFormat(threadPoolNamePrefix + "-%d").build(), handler, metrics);
        pool.allowCoreThreadTimeOut(true);
        return pool;
    }

    private static GlobalExecutorMetrics getGlobalExecutorMetricsForPool1() {
        return new GlobalExecutorMetrics(GlobalClientMetrics.GLOBAL_HA_PARALLEL_POOL1_TASK_REJECTED_COUNTER, GlobalClientMetrics.GLOBAL_HA_PARALLEL_POOL1_TASK_EXECUTED_COUNTER, GlobalClientMetrics.GLOBAL_HA_PARALLEL_POOL1_TASK_QUEUE_WAIT_TIME, GlobalClientMetrics.GLOBAL_HA_PARALLEL_POOL1_TASK_EXECUTION_TIME, GlobalClientMetrics.GLOBAL_HA_PARALLEL_POOL1_TASK_END_TO_END_TIME);
    }

    private static GlobalExecutorMetrics getGlobalExecutorMetricsForPool2() {
        return new GlobalExecutorMetrics(GlobalClientMetrics.GLOBAL_HA_PARALLEL_POOL2_TASK_REJECTED_COUNTER, GlobalClientMetrics.GLOBAL_HA_PARALLEL_POOL2_TASK_EXECUTED_COUNTER, GlobalClientMetrics.GLOBAL_HA_PARALLEL_POOL2_TASK_QUEUE_WAIT_TIME, GlobalClientMetrics.GLOBAL_HA_PARALLEL_POOL2_TASK_EXECUTION_TIME, GlobalClientMetrics.GLOBAL_HA_PARALLEL_POOL2_TASK_END_TO_END_TIME);
    }

    private static class GlobalExecutorMetrics {
        private final GlobalClientMetrics taskRejectedCounter;
        private final GlobalClientMetrics taskExecutedCounter;
        private final GlobalClientMetrics taskQueueWaitTime;
        private final GlobalClientMetrics taskExecutionTime;
        private final GlobalClientMetrics taskEndToEndCounter;

        public GlobalExecutorMetrics(GlobalClientMetrics taskRejectedCounter, GlobalClientMetrics taskExecutedCounter, GlobalClientMetrics taskQueueWaitTime, GlobalClientMetrics taskExecutionTime, GlobalClientMetrics taskEndToEndCounter) {
            this.taskRejectedCounter = taskRejectedCounter;
            this.taskExecutedCounter = taskExecutedCounter;
            this.taskQueueWaitTime = taskQueueWaitTime;
            this.taskExecutionTime = taskExecutionTime;
            this.taskEndToEndCounter = taskEndToEndCounter;
        }

        GlobalClientMetrics getTaskRejectedCounter() {
            return this.taskRejectedCounter;
        }

        GlobalClientMetrics getTaskExecutedCounter() {
            return this.taskExecutedCounter;
        }

        GlobalClientMetrics getTaskQueueWaitTime() {
            return this.taskQueueWaitTime;
        }

        GlobalClientMetrics getTaskExecutionTime() {
            return this.taskExecutionTime;
        }

        GlobalClientMetrics getTaskEndToEndCounter() {
            return this.taskEndToEndCounter;
        }
    }

    private static class MonitoredRunnable<V>
    extends FutureTask<V> {
        private final long taskSubmitTime = EnvironmentEdgeManager.currentTime();
        private long taskBeginTime;
        private long taskEndTime;

        public MonitoredRunnable(Runnable runnable, V result) {
            super(runnable, result);
        }
    }

    private static class PhoenixHAThreadPoolExecutor
    extends ThreadPoolExecutor {
        private final GlobalExecutorMetrics metrics;

        public PhoenixHAThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler, GlobalExecutorMetrics metrics) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
            this.metrics = metrics;
        }

        @Override
        public void execute(Runnable r) {
            if (this.metrics != null) {
                super.execute(new MonitoredRunnable<Object>(r, null));
                this.metrics.getTaskExecutedCounter().increment();
            } else {
                super.execute(r);
            }
        }

        @Override
        protected void beforeExecute(Thread t, Runnable r) {
            if (r instanceof MonitoredRunnable && this.metrics != null) {
                MonitoredRunnable mr = (MonitoredRunnable)r;
                mr.taskBeginTime = EnvironmentEdgeManager.currentTime();
                long taskQueueWaitTime = mr.taskBeginTime - mr.taskSubmitTime;
                this.metrics.getTaskQueueWaitTime().update(taskQueueWaitTime);
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace(String.format("%s waited %d ms", ((Object)mr).toString(), taskQueueWaitTime));
                }
            }
            super.beforeExecute(t, r);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void afterExecute(Runnable r, Throwable t) {
            try {
                super.afterExecute(r, t);
            }
            catch (Throwable throwable) {
                if (r instanceof MonitoredRunnable && this.metrics != null) {
                    MonitoredRunnable mr = (MonitoredRunnable)r;
                    mr.taskEndTime = EnvironmentEdgeManager.currentTime();
                    long taskExecutionTime = mr.taskEndTime - mr.taskBeginTime;
                    long taskEndToEndTime = mr.taskEndTime - mr.taskSubmitTime;
                    this.metrics.getTaskExecutionTime().update(taskExecutionTime);
                    this.metrics.getTaskEndToEndCounter().update(taskEndToEndTime);
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace(String.format("%s executed in %d ms with end to end time of %d", ((Object)mr).toString(), taskExecutionTime, taskEndToEndTime));
                    }
                }
                throw throwable;
            }
            if (r instanceof MonitoredRunnable && this.metrics != null) {
                MonitoredRunnable mr = (MonitoredRunnable)r;
                mr.taskEndTime = EnvironmentEdgeManager.currentTime();
                long taskExecutionTime = mr.taskEndTime - mr.taskBeginTime;
                long taskEndToEndTime = mr.taskEndTime - mr.taskSubmitTime;
                this.metrics.getTaskExecutionTime().update(taskExecutionTime);
                this.metrics.getTaskEndToEndCounter().update(taskEndToEndTime);
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace(String.format("%s executed in %d ms with end to end time of %d", ((Object)mr).toString(), taskExecutionTime, taskEndToEndTime));
                }
            }
        }
    }

    private static class MonitoredCallerRunsPolicy
    extends ThreadPoolExecutor.CallerRunsPolicy {
        private final String threadPoolName;
        private final GlobalExecutorMetrics metrics;

        public MonitoredCallerRunsPolicy(String threadPoolName, GlobalExecutorMetrics metrics) {
            this.threadPoolName = threadPoolName;
            this.metrics = metrics;
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
            super.rejectedExecution(r, e);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Task was rejected by " + this.threadPoolName + " and executed in caller's thread");
            }
            this.metrics.getTaskRejectedCounter().increment();
        }
    }

    public static class PhoenixHAClusterExecutorServices {
        private final ExecutorService executorService;
        private final ExecutorService closeExecutorService;

        PhoenixHAClusterExecutorServices(ExecutorService executorService, ExecutorService closeExecutorService) {
            this.executorService = executorService;
            this.closeExecutorService = closeExecutorService;
        }

        public ExecutorService getExecutorService() {
            return this.executorService;
        }

        public ExecutorService getCloseExecutorService() {
            return this.closeExecutorService;
        }
    }
}

