/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.jdbc;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.logging.Logger;
import javax.annotation.concurrent.Immutable;
import org.apache.phoenix.jdbc.HAURLInfo;
import org.apache.phoenix.jdbc.HighAvailabilityGroup;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.query.QueryServices;
import org.apache.phoenix.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.SQLCloseable;

@Immutable
public abstract class PhoenixEmbeddedDriver
implements Driver,
SQLCloseable {
    private static final String DNC_JDBC_PROTOCOL_SUFFIX = "//";
    private static final String DRIVER_NAME = "PhoenixEmbeddedDriver";
    private static final String TEST_URL_AT_END = ";test=true";
    private static final String TEST_URL_IN_MIDDLE = ";test=true;";
    private static final String[] SUPPORTED_PROTOCOLS = new String[]{"jdbc:phoenix", "jdbc:phoenix+zk", "jdbc:phoenix+master", "jdbc:phoenix+rpc"};
    private static final DriverPropertyInfo[] EMPTY_INFO = new DriverPropertyInfo[0];
    public static final String MAJOR_VERSION_PROP = "DriverMajorVersion";
    public static final String MINOR_VERSION_PROP = "DriverMinorVersion";
    public static final String DRIVER_NAME_PROP = "DriverName";
    public static final ReadOnlyProps DEFAULT_PROPS = new ReadOnlyProps((Map<String, String>)ImmutableMap.of((Object)"DriverMajorVersion", (Object)Integer.toString(5), (Object)"DriverMinorVersion", (Object)Integer.toString(3), (Object)"DriverName", (Object)"PhoenixEmbeddedDriver"));

    PhoenixEmbeddedDriver() {
    }

    protected ReadOnlyProps getDefaultProps() {
        return DEFAULT_PROPS;
    }

    public abstract QueryServices getQueryServices() throws SQLException;

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        if (url.startsWith("jdbc:phoenix")) {
            for (String protocol : SUPPORTED_PROTOCOLS) {
                if (!url.startsWith(protocol)) continue;
                if (url.length() == protocol.length()) {
                    return true;
                }
                if (';' == url.charAt(protocol.length())) {
                    return true;
                }
                if (':' != url.charAt(protocol.length())) continue;
                int protoLength = protocol.length() + 1;
                if (url.length() == protoLength) {
                    return true;
                }
                if (url.startsWith("jdbc:phoenix:thin")) {
                    return false;
                }
                if (url.startsWith(DNC_JDBC_PROTOCOL_SUFFIX, protoLength)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (!this.acceptsURL(url)) {
            return null;
        }
        return this.createConnection(url, info);
    }

    protected final Connection createConnection(String url, Properties info) throws SQLException {
        Properties augmentedInfo = PropertiesUtil.deepCopy(info);
        augmentedInfo.putAll(this.getDefaultProps().asMap());
        if (url.contains("|")) {
            HAURLInfo haurlInfo = HighAvailabilityGroup.getUrlInfo(url, augmentedInfo);
            Optional<HighAvailabilityGroup> haGroup = HighAvailabilityGroup.get(url, augmentedInfo);
            if (haGroup.isPresent()) {
                return haGroup.get().connect(augmentedInfo, haurlInfo);
            }
            url = HighAvailabilityGroup.getFallbackCluster(url, info).orElseThrow(() -> new SQLException("HA group can not be initialized, fallback to single cluster"));
        }
        ConnectionQueryServices cqs = this.getConnectionQueryServices(url, augmentedInfo);
        return cqs.connect(url, augmentedInfo);
    }

    protected abstract ConnectionQueryServices getConnectionQueryServices(String var1, Properties var2) throws SQLException;

    @Override
    public int getMajorVersion() {
        return 5;
    }

    @Override
    public int getMinorVersion() {
        return 3;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return EMPTY_INFO;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }

    @Override
    public void close() throws SQLException {
    }

    public static boolean isTestUrl(String url) {
        return url.endsWith(TEST_URL_AT_END) || url.contains(TEST_URL_IN_MIDDLE);
    }
}

